import { Mode, THEME_LIGHT } from '@/theme/ThemeContext';

export const ShieldWarningSolidIcon = ({ theme }: { theme: Mode }) => {
  return (
    <svg
      width="100%"
      height="100%"
      viewBox="0 0 25 24"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M21.3337 4.93333C19.823 4.53014 18.3471 4.00623 16.9203 3.36667C15.5166 2.75774 14.1616 2.04232 12.867 1.22667L12.5003 1L12.1403 1.23333C10.8458 2.04899 9.4907 2.76441 8.08699 3.37333C6.65785 4.01096 5.17976 4.53264 3.66699 4.93333L3.16699 5.06V10.62C3.16699 19.5467 12.187 22.8867 12.2737 22.92L12.5003 23L12.727 22.92C12.8203 22.92 21.8337 19.5533 21.8337 10.62V5.06L21.3337 4.93333Z"
        fill="currentColor"
      />
      <path
        d="M11.4736 8.49353C11.4736 7.94125 11.9213 7.49353 12.4736 7.49353C13.0259 7.49353 13.4736 7.94125 13.4736 8.49353V13.0869C13.4736 13.6391 13.0259 14.0869 12.4736 14.0869C11.9213 14.0869 11.4736 13.6391 11.4736 13.0869L11.4736 8.49353Z"
        fill={theme === THEME_LIGHT ? 'white' : 'black'}
      />
      <path
        d="M12.5002 17.5C11.8669 17.5 11.3535 16.9866 11.3535 16.3533C11.3535 15.72 11.8669 15.2067 12.5002 15.2067C13.1335 15.2067 13.6468 15.72 13.6468 16.3533C13.6468 16.9866 13.1335 17.5 12.5002 17.5Z"
        fill={theme === THEME_LIGHT ? 'white' : 'black'}
      />
    </svg>
  );
};
