export const LinuxIcon = () => {
  return (
    <svg
      width="100%"
      height="100%"
      viewBox="0 0 40 40"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
        fill="#020204"
      />
      <path
        d="M16.4094 12.4064C16.2859 12.5653 16.2063 12.7566 16.1568 12.9535C16.1088 13.1503 16.091 13.3542 16.0827 13.5581C16.0676 13.9646 16.0923 14.378 15.9867 14.7703C15.8741 15.1894 15.6229 15.5536 15.3772 15.9066C14.9504 16.5197 14.5194 17.1497 14.3094 17.8711C14.1817 18.3071 14.1392 18.7697 14.1845 19.2239C13.7082 19.9411 13.2951 20.7047 12.9519 21.4992C12.4331 22.7044 12.0776 23.9869 11.9527 25.2975C11.799 26.9021 11.9994 28.553 12.6184 30.0352C13.0645 31.1081 13.7316 32.0883 14.5921 32.8533C15.0286 33.2414 15.5145 33.5719 16.0333 33.8335C17.8327 34.7405 20.0563 34.7419 21.8255 33.7758C22.7506 33.271 23.5316 32.5327 24.2837 31.786C24.7367 31.336 25.1882 30.8747 25.5341 30.3347C26.1998 29.2927 26.4317 28.0271 26.5759 26.791C26.827 24.631 26.8353 22.3472 25.9102 20.3883C25.5917 19.7133 25.1676 19.0917 24.6584 18.5531C24.5239 17.611 24.2563 16.6871 23.8678 15.8222C23.5865 15.1964 23.2447 14.6016 22.9839 13.9688C22.8768 13.7086 22.7835 13.4414 22.6655 13.1869C22.5461 12.9324 22.4006 12.6877 22.2002 12.4922C21.997 12.2925 21.7431 12.1505 21.4755 12.0605C21.2078 11.9691 20.9251 11.9283 20.6437 11.9142C20.0796 11.8847 19.5155 11.9606 18.9514 11.9367C18.5025 11.9185 18.0551 11.8383 17.6063 11.865C17.3825 11.8791 17.1588 11.9199 16.9502 12.0071C16.7416 12.0928 16.5494 12.2264 16.4094 12.4064Z"
        fill="#FDFDFB"
      />
      <mask
        id="mask0_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask0_11490_5620)">
        <g opacity="0.25" filter="url(#filter0_f_11490_5620)">
          <path
            d="M14.4252 18.1974C14.5446 18.3816 14.3497 19.0187 17.1511 18.6108C17.1511 18.6108 16.6583 18.6657 16.1738 18.781C15.4203 19.0397 14.7642 19.328 14.2564 19.7105C13.7554 20.0902 13.3875 20.5838 12.9277 21.0071C12.9277 21.0071 13.673 19.6121 13.8583 19.1916C14.045 18.7712 13.8281 18.7908 13.975 18.1721C14.1219 17.5533 14.4815 16.9585 14.4815 16.9585C14.4815 16.9585 14.1877 17.8332 14.4252 18.1974Z"
            fill="url(#paint0_radial_11490_5620)"
          />
        </g>
      </g>
      <mask
        id="mask1_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask1_11490_5620)">
        <g opacity="0.42" filter="url(#filter1_f_11490_5620)">
          <path
            d="M23.4309 18.03C22.8599 18.4378 22.525 18.39 21.8333 18.4688C21.1401 18.5489 19.2666 18.5194 19.2666 18.5194C19.2666 18.5194 19.537 18.5152 20.1395 18.6291C20.7407 18.7444 21.9664 18.8541 22.6568 19.1227C23.3486 19.3927 23.5997 19.47 24.0197 19.7414C24.6168 20.1281 25.056 20.7342 25.627 21.1589C25.627 21.1589 25.6544 20.5964 25.4239 20.1759C25.1933 19.7555 24.5729 19.0931 24.3903 18.4744C24.2092 17.8556 24.1213 16.6406 24.1213 16.6406C24.1213 16.6406 24.0005 17.6236 23.4309 18.03Z"
            fill="url(#paint1_radial_11490_5620)"
          />
        </g>
      </g>
      <mask
        id="mask2_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask2_11490_5620)">
        <g opacity="0.2" filter="url(#filter2_f_11490_5620)">
          <path
            d="M18.0626 17.1606C18.0406 17.3364 18.0132 17.5122 17.9802 17.6866C17.9638 17.7724 17.9445 17.8581 17.9143 17.9397C17.8828 18.0213 17.8375 18.1 17.7743 18.1577C17.7181 18.2097 17.6508 18.2449 17.5822 18.2772C17.3159 18.401 17.0318 18.4839 16.7422 18.5219C16.8575 18.5303 16.9728 18.5416 17.0894 18.5542C17.1622 18.5627 17.2349 18.5711 17.3049 18.5894C17.3763 18.6091 17.4463 18.6372 17.5053 18.6808C17.5698 18.73 17.6206 18.7961 17.6591 18.8692C17.7345 19.0127 17.7592 19.1786 17.773 19.3431C17.7908 19.5513 17.7922 19.7622 17.7771 19.9703C17.7908 19.8311 17.8196 19.6919 17.8622 19.5597C17.9404 19.3178 18.064 19.0928 18.2314 18.9058C18.2987 18.8327 18.3714 18.7638 18.451 18.7061C18.6967 18.5289 19.0096 18.4516 19.3075 18.4938C19.0041 18.5064 18.6981 18.4094 18.4565 18.2224C18.333 18.1267 18.2259 18.0086 18.1518 17.8708C18.0365 17.6571 18.0036 17.3969 18.0626 17.1606Z"
            fill="url(#paint2_radial_11490_5620)"
          />
        </g>
      </g>
      <mask
        id="mask3_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask3_11490_5620)">
        <g opacity="0.11" filter="url(#filter3_f_11490_5620)">
          <path
            d="M17.3326 21.2852C17.1871 21.8519 17.0869 22.4312 17.0347 23.0162C16.9592 23.8417 16.9771 24.6728 16.9332 25.5011C16.8975 26.2028 16.8165 26.913 16.9359 27.6062C16.9922 27.9367 17.0937 28.2587 17.2379 28.5597C17.2598 28.4444 17.2777 28.3291 17.2873 28.2123C17.3381 27.6498 17.2461 27.0859 17.2145 26.5234C17.1596 25.5363 17.2928 24.5491 17.3477 23.5619C17.3888 22.8039 17.3847 22.0431 17.3326 21.2852Z"
            fill="black"
          />
        </g>
      </g>
      <mask
        id="mask4_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask4_11490_5620)">
        <g opacity="0.75" filter="url(#filter4_f_11490_5620)">
          <path
            d="M26.9721 20.4543C27.1135 20.4318 27.9795 21.187 27.8615 21.4683C27.7435 21.7481 27.5197 21.5794 27.3605 21.5808C27.2013 21.5836 26.7662 21.7861 26.6935 21.6581C26.6193 21.5301 26.8856 21.232 27.0242 20.9817C27.1368 20.7806 26.8321 20.4768 26.9721 20.4543Z"
            fill="#7C7C7C"
          />
        </g>
      </g>
      <mask
        id="mask5_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask5_11490_5620)">
        <g filter="url(#filter5_f_11490_5620)">
          <path
            d="M21.6789 3.56378C21.3755 3.78316 21.5073 4.05738 21.6377 4.3316C21.7681 4.60722 21.3508 5.39894 21.3467 5.43269C21.3426 5.46644 22.1675 5.03191 22.3926 4.74785C22.6589 4.41457 23.33 5.20066 23.293 5.08113C23.2943 4.86738 21.9822 3.34581 21.6789 3.56378Z"
            fill="#7C7C7C"
          />
        </g>
      </g>
      <mask
        id="mask6_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask6_11490_5620)">
        <g filter="url(#filter6_f_11490_5620)">
          <path
            d="M23.9788 12.7763C23.7235 13.0153 24.0996 13.3739 24.2766 13.7944C24.3878 14.056 24.6939 14.4258 24.9903 14.3667C25.2141 14.3217 25.3513 13.9927 25.3307 13.762C25.2896 13.3149 24.9217 13.2094 24.6541 13.0561C24.4427 12.9352 24.1586 12.6089 23.9788 12.7763Z"
            fill="#838384"
          />
        </g>
      </g>
      <path
        d="M13.7818 16.1905C12.9446 17.1636 12.084 18.1072 11.6118 19.1605C11.3771 19.6949 11.2673 20.2757 11.1067 20.8382C10.9256 21.4766 10.6785 22.0954 10.4012 22.6972C10.1446 23.2527 9.86184 23.7955 9.58047 24.3369C9.37458 24.7321 9.16596 25.1343 9.09458 25.5758C9.03831 25.9246 9.06988 26.2846 9.15772 26.6263C9.24419 26.968 9.38282 27.2943 9.54066 27.6079C10.2105 28.9508 11.2165 30.1068 12.4079 30.9927C12.9487 31.3935 13.5265 31.7408 14.1346 32.0263C14.464 32.1796 14.8099 32.3174 15.1722 32.323C15.3534 32.3272 15.536 32.2963 15.702 32.2218C15.8667 32.1472 16.015 32.0277 16.1138 31.8716C16.2346 31.6804 16.2758 31.4427 16.2511 31.2163C16.2263 30.9899 16.1399 30.7733 16.0246 30.5793C15.7418 30.1039 15.2958 29.7594 14.8662 29.4191C13.9383 28.6836 13.042 27.906 12.1828 27.0875C11.9413 26.8555 11.6983 26.6179 11.5295 26.3254C11.3648 26.0413 11.2756 25.7179 11.2152 25.393C11.0491 24.5029 11.0916 23.5663 11.3867 22.7113C11.5034 22.3766 11.6558 22.0574 11.804 21.7368C12.0593 21.1813 12.3009 20.6146 12.6371 20.1055C13.0558 19.4713 13.6158 18.9341 13.9562 18.2535C14.2444 17.6783 14.3611 17.0329 14.4722 16.3972C14.5601 15.8994 14.7262 15.4129 14.8113 14.915C14.6452 15.2385 14.1099 15.7686 13.7818 16.1905Z"
        fill="#020204"
      />
      <mask
        id="mask7_11490_5620"
        maskUnits="userSpaceOnUse"
        x="9"
        y="14"
        width="8"
        height="19"
      >
        <path
          d="M13.7818 16.1905C12.9446 17.1636 12.084 18.1072 11.6118 19.1605C11.3771 19.6949 11.2673 20.2757 11.1067 20.8382C10.9256 21.4766 10.6785 22.0954 10.4012 22.6972C10.1446 23.2527 9.86184 23.7955 9.58047 24.3369C9.37458 24.7321 9.16596 25.1343 9.09458 25.5758C9.03831 25.9246 9.06988 26.2846 9.15772 26.6263C9.24419 26.968 9.38282 27.2943 9.54066 27.6079C10.2105 28.9508 11.2165 30.1068 12.4079 30.9927C12.9487 31.3935 13.5265 31.7408 14.1346 32.0263C14.464 32.1796 14.8099 32.3174 15.1722 32.323C15.3534 32.3272 15.536 32.2963 15.702 32.2218C15.8667 32.1472 16.015 32.0277 16.1138 31.8716C16.2346 31.6804 16.2758 31.4427 16.2511 31.2163C16.2263 30.9899 16.1399 30.7733 16.0246 30.5793C15.7418 30.1039 15.2958 29.7594 14.8662 29.4191C13.9383 28.6836 13.042 27.906 12.1828 27.0875C11.9413 26.8555 11.6983 26.6179 11.5295 26.3254C11.3648 26.0413 11.2756 25.7179 11.2152 25.393C11.0491 24.5029 11.0916 23.5663 11.3867 22.7113C11.5034 22.3766 11.6558 22.0574 11.804 21.7368C12.0593 21.1813 12.3009 20.6146 12.6371 20.1055C13.0558 19.4713 13.6158 18.9341 13.9562 18.2535C14.2444 17.6783 14.3611 17.0329 14.4722 16.3972C14.5601 15.8994 14.7262 15.4129 14.8113 14.915C14.6452 15.2385 14.1099 15.7686 13.7818 16.1905Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask7_11490_5620)">
        <g opacity="0.95" filter="url(#filter7_f_11490_5620)">
          <path
            d="M12.8182 19.7328C12.5437 19.9915 12.3063 20.291 12.1141 20.6201C11.7984 21.1601 11.6131 21.7676 11.3826 22.3512C11.2124 22.7857 11.0133 23.2231 10.99 23.6914C10.9776 23.9318 11.012 24.1723 11.0202 24.4128C11.0284 24.6532 11.0065 24.9035 10.8912 25.1131C10.7951 25.2889 10.6345 25.4267 10.4492 25.4942C10.7004 25.5799 10.9227 25.7459 11.0806 25.9624C11.2124 26.1453 11.2975 26.3576 11.4114 26.5503C11.5047 26.7078 11.6186 26.854 11.76 26.9679C11.9 27.0832 12.0688 27.1648 12.2459 27.1873C12.4916 27.2196 12.7469 27.1367 12.928 26.9651C12.7002 24.7784 12.9088 22.5467 13.5375 20.4443C13.5773 20.3121 13.6184 20.1785 13.6294 20.0407C13.639 19.9015 13.6129 19.7553 13.5306 19.6456C13.488 19.5865 13.429 19.5401 13.3618 19.5106C13.2959 19.4824 13.2218 19.4712 13.1504 19.481C13.079 19.4895 13.009 19.5176 12.9514 19.5612C12.8937 19.6062 12.8471 19.6653 12.8182 19.7328Z"
            fill="#7C7C7C"
          />
        </g>
      </g>
      <path
        d="M27.3404 19.8762C28.0596 20.4696 28.5167 21.3654 28.6581 22.3006C28.7679 23.029 28.6965 23.7785 28.5359 24.4971C28.3753 25.2171 28.1283 25.9118 27.8812 26.6065C27.7837 26.8821 27.6849 27.162 27.6465 27.4531C27.6067 27.7456 27.6314 28.0535 27.7686 28.3123C27.9265 28.609 28.2202 28.8129 28.5359 28.9085C28.8475 29.0042 29.1837 29.0013 29.4994 28.9212C29.8151 28.841 30.3463 28.737 30.603 28.5317C31.2549 28.0128 31.41 27.1113 31.5651 26.321C31.7257 25.4956 31.6475 24.6307 31.5061 23.7968C31.3126 22.6592 30.9873 21.5482 30.5741 20.4753C30.2694 19.6849 29.8796 18.9312 29.4157 18.2309C28.96 17.5432 28.3149 17.0074 27.8373 16.3353C27.6712 16.1018 27.4722 15.8599 27.3102 15.6237C26.9588 15.1146 27.0385 15.2103 26.8202 14.8798C26.6624 14.6407 26.4126 14.5592 26.1504 14.4551C25.8869 14.351 25.5932 14.3201 25.3214 14.3974C24.9645 14.5001 24.6722 14.7898 24.5171 15.1343C24.362 15.4803 24.3345 15.8768 24.3949 16.2523C24.4732 16.736 24.6886 17.186 24.933 17.6079C25.2075 18.0846 25.5259 18.5445 25.9418 18.8988C26.3755 19.2687 26.8998 19.5134 27.3404 19.8762Z"
        fill="#020204"
      />
      <mask
        id="mask8_11490_5620"
        maskUnits="userSpaceOnUse"
        x="24"
        y="14"
        width="8"
        height="15"
      >
        <path
          d="M27.3404 19.8762C28.0596 20.4696 28.5167 21.3654 28.6581 22.3006C28.7679 23.029 28.6965 23.7785 28.5359 24.4971C28.3753 25.2171 28.1283 25.9118 27.8812 26.6065C27.7837 26.8821 27.6849 27.162 27.6465 27.4531C27.6067 27.7456 27.6314 28.0535 27.7686 28.3123C27.9265 28.609 28.2202 28.8129 28.5359 28.9085C28.8475 29.0042 29.1837 29.0013 29.4994 28.9212C29.8151 28.841 30.3463 28.737 30.603 28.5317C31.2549 28.0128 31.41 27.1113 31.5651 26.321C31.7257 25.4956 31.6475 24.6307 31.5061 23.7968C31.3126 22.6592 30.9873 21.5482 30.5741 20.4753C30.2694 19.6849 29.8796 18.9312 29.4157 18.2309C28.96 17.5432 28.3149 17.0074 27.8373 16.3353C27.6712 16.1018 27.4722 15.8599 27.3102 15.6237C26.9588 15.1146 27.0385 15.2103 26.8202 14.8798C26.6624 14.6407 26.4126 14.5592 26.1504 14.4551C25.8869 14.351 25.5932 14.3201 25.3214 14.3974C24.9645 14.5001 24.6722 14.7898 24.5171 15.1343C24.362 15.4803 24.3345 15.8768 24.3949 16.2523C24.4732 16.736 24.6886 17.186 24.933 17.6079C25.2075 18.0846 25.5259 18.5445 25.9418 18.8988C26.3755 19.2687 26.8998 19.5134 27.3404 19.8762Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask8_11490_5620)">
        <g filter="url(#filter8_f_11490_5620)">
          <path
            d="M25.6465 18.7332C25.7041 18.7894 25.7645 18.8471 25.8263 18.9005C26.2682 19.2703 26.503 19.6852 26.9518 20.048C27.6847 20.6414 28.4273 21.6652 28.5714 22.6003C28.6839 23.3302 28.5357 23.7267 28.3545 24.586C28.1733 25.4466 27.66 26.6644 27.3814 27.4941C27.2716 27.8246 27.6065 27.6882 27.5626 28.0369C27.5406 28.2085 27.5379 28.3814 27.5584 28.553C27.5612 28.5207 27.5626 28.4855 27.5667 28.4532C27.6202 27.9778 27.7616 27.5208 27.9167 27.0722C28.2145 26.2102 28.5563 25.3636 28.7924 24.4777C29.0284 23.5932 29.0024 22.9561 28.8788 22.1953C28.7237 21.2377 28.1802 20.3546 27.4116 19.771C26.8667 19.3589 26.2257 19.0946 25.6465 18.7332Z"
            fill="#838384"
          />
        </g>
      </g>
      <path
        d="M9.80118 26.6558C9.99059 26.5756 10.2033 26.5602 10.4037 26.5981C10.6055 26.6361 10.7963 26.7261 10.9651 26.8428C11.3041 27.0791 11.5553 27.4222 11.7955 27.7625C12.3486 28.5416 12.8798 29.3375 13.3629 30.1644C13.7541 30.8366 14.1124 31.5298 14.5653 32.1584C14.8604 32.5705 15.1925 32.9516 15.489 33.3608C15.7855 33.7714 16.0476 34.2158 16.1794 34.708C16.351 35.3478 16.2837 36.0523 15.9873 36.6416C15.7786 37.0564 15.4575 37.4122 15.0676 37.6527C14.6778 37.8931 14.2675 38 13.8118 38C13.0884 38 12.3816 37.602 11.709 37.3278C10.3392 36.7681 8.85137 36.5937 7.43902 36.1578C7.00529 36.0242 6.57843 35.8653 6.14196 35.743C5.94706 35.6881 5.75078 35.6403 5.56686 35.5545C5.38294 35.4702 5.21137 35.3422 5.1098 35.165C5.03157 35.0272 5 34.8655 5 34.7066C5 34.5462 5.03843 34.3887 5.09196 34.2397C5.19765 33.9402 5.36922 33.6687 5.48451 33.372C5.67255 32.8883 5.70686 32.3553 5.68078 31.835C5.65608 31.3161 5.57373 30.8 5.53941 30.2811C5.52294 30.0491 5.51745 29.8142 5.56137 29.585C5.60392 29.3572 5.7 29.1336 5.86333 28.9733C6.01431 28.8242 6.21333 28.7356 6.41922 28.692C6.62373 28.6484 6.8351 28.647 7.04373 28.6513C7.25235 28.6555 7.46235 28.6681 7.67098 28.6498C7.87961 28.633 8.08961 28.5852 8.27078 28.4783C8.44373 28.377 8.5851 28.2266 8.70176 28.062C8.81843 27.8975 8.91314 27.7175 9.01059 27.5389C9.10667 27.3617 9.20686 27.1845 9.33451 27.027C9.46078 26.8695 9.61726 26.7331 9.80118 26.6558Z"
        fill="url(#paint3_linear_11490_5620)"
      />
      <mask
        id="mask9_11490_5620"
        maskUnits="userSpaceOnUse"
        x="5"
        y="26"
        width="12"
        height="12"
      >
        <path
          d="M9.80118 26.6558C9.99059 26.5756 10.2033 26.5602 10.4037 26.5981C10.6055 26.6361 10.7963 26.7261 10.9651 26.8428C11.3041 27.0791 11.5553 27.4222 11.7955 27.7625C12.3486 28.5416 12.8798 29.3375 13.3629 30.1644C13.7541 30.8366 14.1124 31.5298 14.5653 32.1584C14.8604 32.5705 15.1925 32.9516 15.489 33.3608C15.7855 33.7714 16.0476 34.2158 16.1794 34.708C16.351 35.3478 16.2837 36.0523 15.9873 36.6416C15.7786 37.0564 15.4575 37.4122 15.0676 37.6527C14.6778 37.8931 14.2675 38 13.8118 38C13.0884 38 12.3816 37.602 11.709 37.3278C10.3392 36.7681 8.85137 36.5937 7.43902 36.1578C7.00529 36.0242 6.57843 35.8653 6.14196 35.743C5.94706 35.6881 5.75078 35.6403 5.56686 35.5545C5.38294 35.4702 5.21137 35.3422 5.1098 35.165C5.03157 35.0272 5 34.8655 5 34.7066C5 34.5462 5.03843 34.3887 5.09196 34.2397C5.19765 33.9402 5.36922 33.6687 5.48451 33.372C5.67255 32.8883 5.70686 32.3553 5.68078 31.835C5.65608 31.3161 5.57373 30.8 5.53941 30.2811C5.52294 30.0491 5.51745 29.8142 5.56137 29.585C5.60392 29.3572 5.7 29.1336 5.86333 28.9733C6.01431 28.8242 6.21333 28.7356 6.41922 28.692C6.62373 28.6484 6.8351 28.647 7.04373 28.6513C7.25235 28.6555 7.46235 28.6681 7.67098 28.6498C7.87961 28.633 8.08961 28.5852 8.27078 28.4783C8.44373 28.377 8.5851 28.2266 8.70176 28.062C8.81843 27.8975 8.91314 27.7175 9.01059 27.5389C9.10667 27.3617 9.20686 27.1845 9.33451 27.027C9.46078 26.8695 9.61726 26.7331 9.80118 26.6558Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask9_11490_5620)">
        <g filter="url(#filter9_f_11490_5620)">
          <path
            d="M10.1008 26.9892C10.2723 26.9189 10.4672 26.9104 10.647 26.9526C10.8282 26.9948 10.997 27.0848 11.1425 27.2015C11.4363 27.4335 11.6394 27.7598 11.8357 28.0818C12.3051 28.8609 12.7635 29.6498 13.1972 30.4528C13.5266 31.0589 13.8396 31.6762 14.2431 32.2317C14.5108 32.6001 14.8168 32.939 15.09 33.3032C15.3631 33.6675 15.6061 34.064 15.7268 34.507C15.8833 35.0765 15.8202 35.7079 15.5512 36.231C15.3563 36.6079 15.0598 36.9285 14.7002 37.1423C14.3419 37.356 13.9219 37.4629 13.5074 37.4432C12.8459 37.4123 12.2406 37.0734 11.6174 36.8442C10.4219 36.3998 9.12762 36.3393 7.90056 35.9934C7.46135 35.871 7.03311 35.7079 6.59252 35.594C6.39625 35.5434 6.19723 35.5012 6.01194 35.421C5.82664 35.3409 5.65233 35.2171 5.55076 35.0385C5.47664 34.905 5.44645 34.7489 5.45056 34.5956C5.45605 34.4423 5.49311 34.2904 5.54664 34.147C5.6537 33.8601 5.82115 33.6014 5.92821 33.3145C6.09154 32.8814 6.11213 32.4046 6.08194 31.942C6.05174 31.4793 5.97213 31.0195 5.94468 30.5568C5.9337 30.3487 5.93096 30.1392 5.97213 29.9367C6.01331 29.7328 6.09978 29.5359 6.2439 29.3896C6.40037 29.2307 6.61449 29.145 6.83272 29.1098C7.04958 29.076 7.27056 29.0915 7.4888 29.1112C7.70841 29.1309 7.92801 29.1562 8.14762 29.1435C8.36723 29.1295 8.58958 29.0746 8.77076 28.9481C8.93547 28.8342 9.059 28.6668 9.1537 28.4882C9.24841 28.3096 9.31566 28.117 9.38841 27.9285C9.45978 27.7387 9.53802 27.5503 9.65056 27.3815C9.76311 27.2142 9.91547 27.0665 10.1008 26.9892Z"
            fill="#D99A03"
          />
        </g>
      </g>
      <mask
        id="mask10_11490_5620"
        maskUnits="userSpaceOnUse"
        x="5"
        y="26"
        width="12"
        height="12"
      >
        <path
          d="M9.80118 26.6558C9.99059 26.5756 10.2033 26.5602 10.4037 26.5981C10.6055 26.6361 10.7963 26.7261 10.9651 26.8428C11.3041 27.0791 11.5553 27.4222 11.7955 27.7625C12.3486 28.5416 12.8798 29.3375 13.3629 30.1644C13.7541 30.8366 14.1124 31.5298 14.5653 32.1584C14.8604 32.5705 15.1925 32.9516 15.489 33.3608C15.7855 33.7714 16.0476 34.2158 16.1794 34.708C16.351 35.3478 16.2837 36.0523 15.9873 36.6416C15.7786 37.0564 15.4575 37.4122 15.0676 37.6527C14.6778 37.8931 14.2675 38 13.8118 38C13.0884 38 12.3816 37.602 11.709 37.3278C10.3392 36.7681 8.85137 36.5937 7.43902 36.1578C7.00529 36.0242 6.57843 35.8653 6.14196 35.743C5.94706 35.6881 5.75078 35.6403 5.56686 35.5545C5.38294 35.4702 5.21137 35.3422 5.1098 35.165C5.03157 35.0272 5 34.8655 5 34.7066C5 34.5462 5.03843 34.3887 5.09196 34.2397C5.19765 33.9402 5.36922 33.6687 5.48451 33.372C5.67255 32.8883 5.70686 32.3553 5.68078 31.835C5.65608 31.3161 5.57373 30.8 5.53941 30.2811C5.52294 30.0491 5.51745 29.8142 5.56137 29.585C5.60392 29.3572 5.7 29.1336 5.86333 28.9733C6.01431 28.8242 6.21333 28.7356 6.41922 28.692C6.62373 28.6484 6.8351 28.647 7.04373 28.6513C7.25235 28.6555 7.46235 28.6681 7.67098 28.6498C7.87961 28.633 8.08961 28.5852 8.27078 28.4783C8.44373 28.377 8.5851 28.2266 8.70176 28.062C8.81843 27.8975 8.91314 27.7175 9.01059 27.5389C9.10667 27.3617 9.20686 27.1845 9.33451 27.027C9.46078 26.8695 9.61726 26.7331 9.80118 26.6558Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask10_11490_5620)">
        <g filter="url(#filter10_f_11490_5620)">
          <path
            d="M9.93977 26.5493C10.1072 26.4649 10.3035 26.448 10.486 26.486C10.6686 26.524 10.8388 26.6154 10.9829 26.7349C11.2698 26.974 11.4537 27.3157 11.6239 27.6504C12.0137 28.4182 12.3788 29.2029 12.8455 29.9271C13.1859 30.4516 13.577 30.9396 13.9202 31.4627C14.3855 32.1701 14.7643 32.9491 14.9208 33.783C15.0251 34.3455 15.0223 34.9516 14.7588 35.4565C14.5845 35.7898 14.3031 36.0626 13.9696 36.2327C13.6374 36.4043 13.2545 36.4732 12.8825 36.4395C12.2964 36.3874 11.7653 36.0921 11.2135 35.8854C10.2349 35.5212 9.17664 35.4326 8.16918 35.157C7.74507 35.0416 7.32781 34.8912 6.8982 34.7998C6.70742 34.759 6.51389 34.7295 6.33271 34.6591C6.15154 34.5888 5.97997 34.4721 5.88664 34.3005C5.82213 34.1796 5.80017 34.039 5.80977 33.9012C5.81938 33.7648 5.85918 33.6312 5.91134 33.5032C6.01703 33.2501 6.17213 33.0166 6.25311 32.7551C6.37389 32.3684 6.32448 31.9507 6.23389 31.5555C6.14467 31.1618 6.01428 30.7751 5.97448 30.3729C5.95664 30.1943 5.95664 30.0115 5.99781 29.8357C6.03762 29.6599 6.1186 29.4912 6.24624 29.366C6.41095 29.2043 6.64154 29.1227 6.87213 29.1002C7.10134 29.0777 7.33193 29.1087 7.55977 29.1424C7.78762 29.1762 8.0182 29.2127 8.24742 29.2015C8.47801 29.1916 8.71271 29.1298 8.89252 28.9849C9.07095 28.8415 9.1835 28.6291 9.24801 28.4098C9.31252 28.189 9.33311 27.9598 9.35918 27.732C9.38526 27.5041 9.4182 27.2735 9.50468 27.0612C9.59115 26.8488 9.73664 26.6534 9.93977 26.5493Z"
            fill="#F5BD0C"
          />
        </g>
      </g>
      <mask
        id="mask11_11490_5620"
        maskUnits="userSpaceOnUse"
        x="5"
        y="26"
        width="12"
        height="12"
      >
        <path
          d="M9.80118 26.6558C9.99059 26.5756 10.2033 26.5602 10.4037 26.5981C10.6055 26.6361 10.7963 26.7261 10.9651 26.8428C11.3041 27.0791 11.5553 27.4222 11.7955 27.7625C12.3486 28.5416 12.8798 29.3375 13.3629 30.1644C13.7541 30.8366 14.1124 31.5298 14.5653 32.1584C14.8604 32.5705 15.1925 32.9516 15.489 33.3608C15.7855 33.7714 16.0476 34.2158 16.1794 34.708C16.351 35.3478 16.2837 36.0523 15.9873 36.6416C15.7786 37.0564 15.4575 37.4122 15.0676 37.6527C14.6778 37.8931 14.2675 38 13.8118 38C13.0884 38 12.3816 37.602 11.709 37.3278C10.3392 36.7681 8.85137 36.5937 7.43902 36.1578C7.00529 36.0242 6.57843 35.8653 6.14196 35.743C5.94706 35.6881 5.75078 35.6403 5.56686 35.5545C5.38294 35.4702 5.21137 35.3422 5.1098 35.165C5.03157 35.0272 5 34.8655 5 34.7066C5 34.5462 5.03843 34.3887 5.09196 34.2397C5.19765 33.9402 5.36922 33.6687 5.48451 33.372C5.67255 32.8883 5.70686 32.3553 5.68078 31.835C5.65608 31.3161 5.57373 30.8 5.53941 30.2811C5.52294 30.0491 5.51745 29.8142 5.56137 29.585C5.60392 29.3572 5.7 29.1336 5.86333 28.9733C6.01431 28.8242 6.21333 28.7356 6.41922 28.692C6.62373 28.6484 6.8351 28.647 7.04373 28.6513C7.25235 28.6555 7.46235 28.6681 7.67098 28.6498C7.87961 28.633 8.08961 28.5852 8.27078 28.4783C8.44373 28.377 8.5851 28.2266 8.70176 28.062C8.81843 27.8975 8.91314 27.7175 9.01059 27.5389C9.10667 27.3617 9.20686 27.1845 9.33451 27.027C9.46078 26.8695 9.61726 26.7331 9.80118 26.6558Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask11_11490_5620)">
        <g filter="url(#filter11_f_11490_5620)">
          <path
            d="M12.0273 28.467C12.3362 29.038 12.5242 29.6933 12.8303 30.2699C13.1117 30.8 13.4315 31.3456 13.717 31.8336C13.8446 32.0516 14.1411 32.3863 14.4403 32.9052C14.712 33.3749 14.9866 34.0316 15.1403 34.2524C15.0524 33.9936 14.8713 33.3003 14.6544 32.8067C14.4526 32.3455 14.2166 32.0825 14.0724 31.8336C13.787 31.3456 13.4781 30.9055 13.1844 30.44C12.7795 29.7974 12.4707 29.0788 12.0273 28.467Z"
            fill="url(#paint4_linear_11490_5620)"
          />
        </g>
      </g>
      <mask
        id="mask12_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask12_11490_5620)">
        <g opacity="0.2" filter="url(#filter12_f_11490_5620)">
          <path
            d="M32.2721 32.32C32.2172 32.507 32.1321 32.6884 32.0236 32.8543C31.7834 33.2186 31.4334 33.4942 31.0848 33.7473C30.4905 34.179 29.8701 34.5756 29.3156 35.0664C28.945 35.3954 28.606 35.7653 28.293 36.1534C28.0254 36.4853 27.7729 36.834 27.4668 37.1293C27.1579 37.4275 26.7956 37.6693 26.4044 37.8001C25.9281 37.959 25.4258 37.952 24.9674 37.8311C24.6462 37.7467 24.3319 37.6004 24.1328 37.3347C23.9338 37.0689 23.8693 36.7103 23.846 36.3587C23.8048 35.7372 23.8776 35.1029 23.9434 34.4715C23.9983 33.947 24.0491 33.4225 24.0697 32.8993C24.1068 31.9473 24.045 31.0051 23.9201 30.0798C23.8981 29.9237 23.8762 29.7676 23.8885 29.6087C23.9009 29.4484 23.953 29.2825 24.0629 29.1587C24.1644 29.0448 24.3058 28.9773 24.4458 28.945C24.5858 28.9112 24.7285 28.9098 24.8699 28.9056C25.2034 28.8972 25.537 28.8761 25.865 28.907C26.0723 28.9253 26.2754 28.9647 26.4813 28.9843C26.8258 29.0181 27.184 29.0012 27.5299 28.8972C27.9019 28.7847 28.256 28.5751 28.6348 28.5175C28.7899 28.4936 28.945 28.4964 29.096 28.5189C29.2497 28.54 29.4034 28.5836 29.5215 28.6806C29.6121 28.7537 29.6779 28.8536 29.7287 28.9604C29.8056 29.1207 29.8523 29.2965 29.8797 29.4779C29.903 29.6382 29.9127 29.8028 29.9525 29.9575C30.0183 30.212 30.1693 30.4286 30.3491 30.6043C30.5303 30.7801 30.7403 30.9193 30.9517 31.0572C31.1617 31.1936 31.373 31.3286 31.5968 31.4411C31.7025 31.4945 31.8109 31.5423 31.9111 31.6028C32.0127 31.6647 32.106 31.7392 32.1732 31.8376C32.2638 31.9712 32.2995 32.147 32.2721 32.32Z"
            fill="url(#paint5_linear_11490_5620)"
          />
        </g>
      </g>
      <path
        d="M34.3003 33.3479C33.9901 33.7248 33.5591 33.9737 33.1295 34.1987C32.398 34.5798 31.6389 34.9159 30.9513 35.3757C30.4901 35.6837 30.0646 36.0451 29.6666 36.4346C29.3262 36.7679 29.0036 37.1237 28.6221 37.4064C28.2364 37.6918 27.7917 37.8985 27.3209 37.9703C27.1905 37.99 27.0601 37.9998 26.9283 37.9998C26.4836 37.9998 26.0389 37.8901 25.6299 37.7073C25.2593 37.5428 24.9025 37.3051 24.6883 36.9535C24.4742 36.5992 24.4248 36.1675 24.4248 35.7498C24.4234 35.0143 24.5566 34.2859 24.6815 33.5603C24.7858 32.957 24.8846 32.3537 24.9491 31.7448C25.0658 30.6395 25.0644 29.5215 24.9876 28.4106C24.9738 28.225 24.9587 28.0379 24.9862 27.8537C25.0136 27.6695 25.0878 27.4853 25.225 27.3643C25.3527 27.2518 25.5229 27.2012 25.6917 27.1928C25.8591 27.1829 26.0266 27.2096 26.1927 27.235C26.5838 27.294 26.9791 27.339 27.3621 27.4431C27.6036 27.5078 27.8397 27.595 28.0799 27.6625C28.4834 27.7735 28.9048 27.827 29.318 27.7778C29.764 27.7243 30.1978 27.5528 30.6466 27.564C30.8305 27.5682 31.013 27.6034 31.1887 27.661C31.3672 27.7187 31.5442 27.8017 31.676 27.9395C31.7762 28.0435 31.8462 28.1743 31.8983 28.3107C31.9766 28.5132 32.0191 28.7298 32.037 28.9464C32.0521 29.139 32.0493 29.3345 32.085 29.5243C32.144 29.8351 32.3046 30.1206 32.5023 30.3639C32.7013 30.6085 32.9387 30.8153 33.1762 31.0192C33.4136 31.2231 33.6511 31.4256 33.9064 31.6042C34.0258 31.6885 34.1493 31.7673 34.2632 31.8587C34.3772 31.9515 34.4815 32.0584 34.5529 32.1878C34.6146 32.3017 34.6476 32.4296 34.6476 32.5604C34.6476 32.6335 34.638 32.7067 34.616 32.7798C34.5542 32.9809 34.4403 33.1764 34.3003 33.3479Z"
        fill="url(#paint6_linear_11490_5620)"
      />
      <mask
        id="mask13_11490_5620"
        maskUnits="userSpaceOnUse"
        x="24"
        y="27"
        width="11"
        height="11"
      >
        <path
          d="M34.3003 33.3479C33.9901 33.7248 33.5591 33.9737 33.1295 34.1987C32.398 34.5798 31.6389 34.9159 30.9513 35.3757C30.4901 35.6837 30.0646 36.0451 29.6666 36.4346C29.3262 36.7679 29.0036 37.1237 28.6221 37.4064C28.2364 37.6918 27.7917 37.8985 27.3209 37.9703C27.1905 37.99 27.0601 37.9998 26.9283 37.9998C26.4836 37.9998 26.0389 37.8901 25.6299 37.7073C25.2593 37.5428 24.9025 37.3051 24.6883 36.9535C24.4742 36.5992 24.4248 36.1675 24.4248 35.7498C24.4234 35.0143 24.5566 34.2859 24.6815 33.5603C24.7858 32.957 24.8846 32.3537 24.9491 31.7448C25.0658 30.6395 25.0644 29.5215 24.9876 28.4106C24.9738 28.225 24.9587 28.0379 24.9862 27.8537C25.0136 27.6695 25.0878 27.4853 25.225 27.3643C25.3527 27.2518 25.5229 27.2012 25.6917 27.1928C25.8591 27.1829 26.0266 27.2096 26.1927 27.235C26.5838 27.294 26.9791 27.339 27.3621 27.4431C27.6036 27.5078 27.8397 27.595 28.0799 27.6625C28.4834 27.7735 28.9048 27.827 29.318 27.7778C29.764 27.7243 30.1978 27.5528 30.6466 27.564C30.8305 27.5682 31.013 27.6034 31.1887 27.661C31.3672 27.7187 31.5442 27.8017 31.676 27.9395C31.7762 28.0435 31.8462 28.1743 31.8983 28.3107C31.9766 28.5132 32.0191 28.7298 32.037 28.9464C32.0521 29.139 32.0493 29.3345 32.085 29.5243C32.144 29.8351 32.3046 30.1206 32.5023 30.3639C32.7013 30.6085 32.9387 30.8153 33.1762 31.0192C33.4136 31.2231 33.6511 31.4256 33.9064 31.6042C34.0258 31.6885 34.1493 31.7673 34.2632 31.8587C34.3772 31.9515 34.4815 32.0584 34.5529 32.1878C34.6146 32.3017 34.6476 32.4296 34.6476 32.5604C34.6476 32.6335 34.638 32.7067 34.616 32.7798C34.5542 32.9809 34.4403 33.1764 34.3003 33.3479Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask13_11490_5620)">
        <g filter="url(#filter13_f_11490_5620)">
          <path
            d="M34.2648 32.3917C34.192 32.5787 34.0891 32.7545 33.9601 32.9078C33.676 33.2481 33.2834 33.4717 32.8922 33.6728C32.2224 34.0159 31.5307 34.3168 30.902 34.7303C30.482 35.0073 30.0922 35.3321 29.7285 35.6837C29.4183 35.9832 29.1232 36.3039 28.7746 36.557C28.4218 36.8143 28.0156 36.9985 27.5873 37.0632C27.0658 37.142 26.5277 37.0407 26.0432 36.8284C25.7056 36.6793 25.3789 36.4684 25.1826 36.1492C24.9877 35.8314 24.9424 35.4432 24.9424 35.0678C24.9397 34.4054 25.0618 33.7501 25.1771 33.099C25.2732 32.5576 25.3638 32.0148 25.4214 31.4678C25.5258 30.4721 25.5216 29.4681 25.4558 28.4696C25.4448 28.3023 25.4324 28.1335 25.4571 27.9676C25.4818 27.8017 25.5491 27.6371 25.6726 27.5274C25.7893 27.4248 25.9458 27.3798 26.0995 27.3728C26.2518 27.3643 26.4042 27.3896 26.5565 27.4121C26.9148 27.4656 27.2744 27.5063 27.6244 27.5992C27.8454 27.6582 28.0609 27.737 28.2805 27.796C28.6483 27.8973 29.034 27.9451 29.4114 27.9001C29.8191 27.8523 30.2144 27.6976 30.6234 27.7074C30.7922 27.7117 30.9583 27.744 31.1189 27.7946C31.2822 27.8467 31.4442 27.9212 31.565 28.0449C31.6556 28.1392 31.7173 28.2573 31.7681 28.3796C31.8409 28.561 31.8903 28.7551 31.893 28.952C31.8971 29.1573 31.8546 29.3626 31.8807 29.5665C31.9026 29.731 31.9713 29.8871 32.0591 30.0278C32.1456 30.1684 32.2513 30.2964 32.3569 30.4229C32.5601 30.669 32.7632 30.9193 33.0185 31.1078C33.3081 31.3229 33.6526 31.4495 33.9518 31.6492C34.0411 31.7096 34.1275 31.7771 34.1907 31.8657C34.2977 32.0148 34.3252 32.2173 34.2648 32.3917Z"
            fill="#CD8907"
          />
        </g>
      </g>
      <mask
        id="mask14_11490_5620"
        maskUnits="userSpaceOnUse"
        x="24"
        y="27"
        width="11"
        height="11"
      >
        <path
          d="M34.3003 33.3479C33.9901 33.7248 33.5591 33.9737 33.1295 34.1987C32.398 34.5798 31.6389 34.9159 30.9513 35.3757C30.4901 35.6837 30.0646 36.0451 29.6666 36.4346C29.3262 36.7679 29.0036 37.1237 28.6221 37.4064C28.2364 37.6918 27.7917 37.8985 27.3209 37.9703C27.1905 37.99 27.0601 37.9998 26.9283 37.9998C26.4836 37.9998 26.0389 37.8901 25.6299 37.7073C25.2593 37.5428 24.9025 37.3051 24.6883 36.9535C24.4742 36.5992 24.4248 36.1675 24.4248 35.7498C24.4234 35.0143 24.5566 34.2859 24.6815 33.5603C24.7858 32.957 24.8846 32.3537 24.9491 31.7448C25.0658 30.6395 25.0644 29.5215 24.9876 28.4106C24.9738 28.225 24.9587 28.0379 24.9862 27.8537C25.0136 27.6695 25.0878 27.4853 25.225 27.3643C25.3527 27.2518 25.5229 27.2012 25.6917 27.1928C25.8591 27.1829 26.0266 27.2096 26.1927 27.235C26.5838 27.294 26.9791 27.339 27.3621 27.4431C27.6036 27.5078 27.8397 27.595 28.0799 27.6625C28.4834 27.7735 28.9048 27.827 29.318 27.7778C29.764 27.7243 30.1978 27.5528 30.6466 27.564C30.8305 27.5682 31.013 27.6034 31.1887 27.661C31.3672 27.7187 31.5442 27.8017 31.676 27.9395C31.7762 28.0435 31.8462 28.1743 31.8983 28.3107C31.9766 28.5132 32.0191 28.7298 32.037 28.9464C32.0521 29.139 32.0493 29.3345 32.085 29.5243C32.144 29.8351 32.3046 30.1206 32.5023 30.3639C32.7013 30.6085 32.9387 30.8153 33.1762 31.0192C33.4136 31.2231 33.6511 31.4256 33.9064 31.6042C34.0258 31.6885 34.1493 31.7673 34.2632 31.8587C34.3772 31.9515 34.4815 32.0584 34.5529 32.1878C34.6146 32.3017 34.6476 32.4296 34.6476 32.5604C34.6476 32.6335 34.638 32.7067 34.616 32.7798C34.5542 32.9809 34.4403 33.1764 34.3003 33.3479Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask14_11490_5620)">
        <g filter="url(#filter14_f_11490_5620)">
          <path
            d="M34.2239 32.1794C34.1415 32.3692 34.0358 32.545 33.9109 32.7011C33.6199 33.0639 33.226 33.3128 32.8129 33.4731C32.1307 33.7375 31.3868 33.7726 30.7184 34.0736C30.3107 34.2564 29.9429 34.532 29.5709 34.7936C29.2717 35.0031 28.9643 35.207 28.6348 35.3533C28.2615 35.5206 27.8662 35.6134 27.4682 35.6795C27.2156 35.7203 26.959 35.7512 26.7037 35.7372C26.4484 35.7231 26.1931 35.6612 25.9666 35.5276C25.7964 35.4264 25.6427 35.2816 25.5507 35.0917C25.4505 34.8822 25.4327 34.6361 25.4341 34.397C25.4409 33.7642 25.5741 33.137 25.5699 32.5028C25.5658 31.9501 25.4588 31.4059 25.4286 30.8547C25.3695 29.7944 25.5919 28.7172 25.3956 27.678C25.3654 27.5106 25.3229 27.3447 25.3243 27.1745C25.3256 27.0901 25.338 27.0044 25.3668 26.9256C25.397 26.8483 25.4437 26.7766 25.5054 26.7259C25.559 26.6851 25.6207 26.6598 25.6852 26.6472C25.7484 26.6359 25.8143 26.6387 25.8788 26.6486C26.0064 26.6697 26.1286 26.7203 26.2535 26.7583C26.6103 26.868 26.9878 26.8651 27.3515 26.9481C27.5793 26.9987 27.799 27.0845 28.0254 27.1464C28.4029 27.2533 28.7982 27.2983 29.1866 27.2519C29.6039 27.2012 30.0115 27.0466 30.4315 27.0578C30.6044 27.062 30.7746 27.0944 30.9407 27.145C31.1068 27.1956 31.2729 27.2673 31.3992 27.3981C31.4884 27.4923 31.5542 27.6119 31.6064 27.7356C31.6846 27.917 31.7382 28.1139 31.7368 28.3136C31.7354 28.4176 31.7203 28.5203 31.7107 28.6244C31.7025 28.7284 31.6997 28.8339 31.7231 28.9337C31.7478 29.035 31.7986 29.1264 31.8562 29.2094C31.9139 29.2923 31.9797 29.3669 32.0401 29.4484C32.2076 29.6748 32.3284 29.9392 32.4588 30.1937C32.5892 30.4483 32.736 30.7 32.9433 30.8842C33.2246 31.1331 33.5884 31.233 33.9027 31.4312C33.9946 31.4889 34.0825 31.5564 34.147 31.6492C34.1992 31.7223 34.2335 31.8109 34.2472 31.9037C34.2595 31.9951 34.2513 32.0922 34.2239 32.1794Z"
            fill="#F5C021"
          />
        </g>
      </g>
      <mask
        id="mask15_11490_5620"
        maskUnits="userSpaceOnUse"
        x="24"
        y="27"
        width="11"
        height="11"
      >
        <path
          d="M34.3003 33.3479C33.9901 33.7248 33.5591 33.9737 33.1295 34.1987C32.398 34.5798 31.6389 34.9159 30.9513 35.3757C30.4901 35.6837 30.0646 36.0451 29.6666 36.4346C29.3262 36.7679 29.0036 37.1237 28.6221 37.4064C28.2364 37.6918 27.7917 37.8985 27.3209 37.9703C27.1905 37.99 27.0601 37.9998 26.9283 37.9998C26.4836 37.9998 26.0389 37.8901 25.6299 37.7073C25.2593 37.5428 24.9025 37.3051 24.6883 36.9535C24.4742 36.5992 24.4248 36.1675 24.4248 35.7498C24.4234 35.0143 24.5566 34.2859 24.6815 33.5603C24.7858 32.957 24.8846 32.3537 24.9491 31.7448C25.0658 30.6395 25.0644 29.5215 24.9876 28.4106C24.9738 28.225 24.9587 28.0379 24.9862 27.8537C25.0136 27.6695 25.0878 27.4853 25.225 27.3643C25.3527 27.2518 25.5229 27.2012 25.6917 27.1928C25.8591 27.1829 26.0266 27.2096 26.1927 27.235C26.5838 27.294 26.9791 27.339 27.3621 27.4431C27.6036 27.5078 27.8397 27.595 28.0799 27.6625C28.4834 27.7735 28.9048 27.827 29.318 27.7778C29.764 27.7243 30.1978 27.5528 30.6466 27.564C30.8305 27.5682 31.013 27.6034 31.1887 27.661C31.3672 27.7187 31.5442 27.8017 31.676 27.9395C31.7762 28.0435 31.8462 28.1743 31.8983 28.3107C31.9766 28.5132 32.0191 28.7298 32.037 28.9464C32.0521 29.139 32.0493 29.3345 32.085 29.5243C32.144 29.8351 32.3046 30.1206 32.5023 30.3639C32.7013 30.6085 32.9387 30.8153 33.1762 31.0192C33.4136 31.2231 33.6511 31.4256 33.9064 31.6042C34.0258 31.6885 34.1493 31.7673 34.2632 31.8587C34.3772 31.9515 34.4815 32.0584 34.5529 32.1878C34.6146 32.3017 34.6476 32.4296 34.6476 32.5604C34.6476 32.6335 34.638 32.7067 34.616 32.7798C34.5542 32.9809 34.4403 33.1764 34.3003 33.3479Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask15_11490_5620)">
        <g filter="url(#filter15_f_11490_5620)">
          <path
            d="M25.3254 27.5347C25.7125 27.4279 26.0419 27.7288 26.3233 27.9552C26.5044 28.1141 26.768 28.0747 26.9903 28.0818C27.3595 28.0691 27.726 28.1451 28.0952 28.0986C28.8227 28.0354 29.535 27.8526 30.2652 27.8216C30.6138 27.7991 31.0064 27.778 31.307 27.9861C31.4291 28.0733 31.6089 28.4404 31.7284 28.3026C31.6789 27.9172 31.4003 27.5446 31.027 27.4419C30.7333 27.3941 30.4368 27.4771 30.1403 27.4504C29.2633 27.4293 28.3903 27.2619 27.5105 27.3097C26.8984 27.3154 26.2876 27.2858 25.6754 27.2619C25.4352 27.2113 25.3501 27.4293 25.2197 27.5136C25.254 27.5404 25.2664 27.5488 25.3254 27.5347Z"
            fill="url(#paint7_linear_11490_5620)"
          />
        </g>
      </g>
      <mask
        id="mask16_11490_5620"
        maskUnits="userSpaceOnUse"
        x="24"
        y="27"
        width="11"
        height="11"
      >
        <path
          d="M34.3003 33.3479C33.9901 33.7248 33.5591 33.9737 33.1295 34.1987C32.398 34.5798 31.6389 34.9159 30.9513 35.3757C30.4901 35.6837 30.0646 36.0451 29.6666 36.4346C29.3262 36.7679 29.0036 37.1237 28.6221 37.4064C28.2364 37.6918 27.7917 37.8985 27.3209 37.9703C27.1905 37.99 27.0601 37.9998 26.9283 37.9998C26.4836 37.9998 26.0389 37.8901 25.6299 37.7073C25.2593 37.5428 24.9025 37.3051 24.6883 36.9535C24.4742 36.5992 24.4248 36.1675 24.4248 35.7498C24.4234 35.0143 24.5566 34.2859 24.6815 33.5603C24.7858 32.957 24.8846 32.3537 24.9491 31.7448C25.0658 30.6395 25.0644 29.5215 24.9876 28.4106C24.9738 28.225 24.9587 28.0379 24.9862 27.8537C25.0136 27.6695 25.0878 27.4853 25.225 27.3643C25.3527 27.2518 25.5229 27.2012 25.6917 27.1928C25.8591 27.1829 26.0266 27.2096 26.1927 27.235C26.5838 27.294 26.9791 27.339 27.3621 27.4431C27.6036 27.5078 27.8397 27.595 28.0799 27.6625C28.4834 27.7735 28.9048 27.827 29.318 27.7778C29.764 27.7243 30.1978 27.5528 30.6466 27.564C30.8305 27.5682 31.013 27.6034 31.1887 27.661C31.3672 27.7187 31.5442 27.8017 31.676 27.9395C31.7762 28.0435 31.8462 28.1743 31.8983 28.3107C31.9766 28.5132 32.0191 28.7298 32.037 28.9464C32.0521 29.139 32.0493 29.3345 32.085 29.5243C32.144 29.8351 32.3046 30.1206 32.5023 30.3639C32.7013 30.6085 32.9387 30.8153 33.1762 31.0192C33.4136 31.2231 33.6511 31.4256 33.9064 31.6042C34.0258 31.6885 34.1493 31.7673 34.2632 31.8587C34.3772 31.9515 34.4815 32.0584 34.5529 32.1878C34.6146 32.3017 34.6476 32.4296 34.6476 32.5604C34.6476 32.6335 34.638 32.7067 34.616 32.7798C34.5542 32.9809 34.4403 33.1764 34.3003 33.3479Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask16_11490_5620)">
        <g opacity="0.35" filter="url(#filter16_f_11490_5620)">
          <path
            d="M30.4599 28.3827C30.394 28.2491 30.2733 28.1493 30.1374 28.0916C30.0029 28.034 29.8546 28.0143 29.7078 28.0157C29.4154 28.0185 29.1244 28.0959 28.8321 28.0706C28.5864 28.0481 28.3531 27.9538 28.1129 27.8934C27.8644 27.8315 27.6009 27.8076 27.3552 27.8765C27.0917 27.9496 26.8597 28.131 26.7142 28.3673C26.5852 28.5754 26.5248 28.8215 26.5056 29.0676C26.4864 29.3137 26.507 29.5598 26.5317 29.8059C26.5482 29.9831 26.5688 30.1602 26.6099 30.3332C26.6525 30.5062 26.717 30.6749 26.8186 30.8198C26.9654 31.0279 27.1837 31.177 27.4184 31.2656C27.8027 31.4104 28.2391 31.4034 28.6166 31.2445C29.2864 30.9463 29.8533 30.412 30.1978 29.7538C30.3227 29.5176 30.4187 29.2659 30.4805 29.0071C30.5052 28.9031 30.5244 28.7976 30.5244 28.6907C30.5258 28.5852 30.508 28.477 30.4599 28.3827Z"
            fill="url(#paint8_radial_11490_5620)"
          />
        </g>
      </g>
      <mask
        id="mask17_11490_5620"
        maskUnits="userSpaceOnUse"
        x="24"
        y="27"
        width="11"
        height="11"
      >
        <path
          d="M34.3003 33.3479C33.9901 33.7248 33.5591 33.9737 33.1295 34.1987C32.398 34.5798 31.6389 34.9159 30.9513 35.3757C30.4901 35.6837 30.0646 36.0451 29.6666 36.4346C29.3262 36.7679 29.0036 37.1237 28.6221 37.4064C28.2364 37.6918 27.7917 37.8985 27.3209 37.9703C27.1905 37.99 27.0601 37.9998 26.9283 37.9998C26.4836 37.9998 26.0389 37.8901 25.6299 37.7073C25.2593 37.5428 24.9025 37.3051 24.6883 36.9535C24.4742 36.5992 24.4248 36.1675 24.4248 35.7498C24.4234 35.0143 24.5566 34.2859 24.6815 33.5603C24.7858 32.957 24.8846 32.3537 24.9491 31.7448C25.0658 30.6395 25.0644 29.5215 24.9876 28.4106C24.9738 28.225 24.9587 28.0379 24.9862 27.8537C25.0136 27.6695 25.0878 27.4853 25.225 27.3643C25.3527 27.2518 25.5229 27.2012 25.6917 27.1928C25.8591 27.1829 26.0266 27.2096 26.1927 27.235C26.5838 27.294 26.9791 27.339 27.3621 27.4431C27.6036 27.5078 27.8397 27.595 28.0799 27.6625C28.4834 27.7735 28.9048 27.827 29.318 27.7778C29.764 27.7243 30.1978 27.5528 30.6466 27.564C30.8305 27.5682 31.013 27.6034 31.1887 27.661C31.3672 27.7187 31.5442 27.8017 31.676 27.9395C31.7762 28.0435 31.8462 28.1743 31.8983 28.3107C31.9766 28.5132 32.0191 28.7298 32.037 28.9464C32.0521 29.139 32.0493 29.3345 32.085 29.5243C32.144 29.8351 32.3046 30.1206 32.5023 30.3639C32.7013 30.6085 32.9387 30.8153 33.1762 31.0192C33.4136 31.2231 33.6511 31.4256 33.9064 31.6042C34.0258 31.6885 34.1493 31.7673 34.2632 31.8587C34.3772 31.9515 34.4815 32.0584 34.5529 32.1878C34.6146 32.3017 34.6476 32.4296 34.6476 32.5604C34.6476 32.6335 34.638 32.7067 34.616 32.7798C34.5542 32.9809 34.4403 33.1764 34.3003 33.3479Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask17_11490_5620)">
        <g opacity="0.35" filter="url(#filter17_f_11490_5620)">
          <path
            d="M30.4599 28.0001C30.394 27.903 30.2733 27.8313 30.1374 27.7891C30.0029 27.747 29.8546 27.7343 29.7078 27.7343C29.4154 27.7371 29.1244 27.7934 28.8321 27.7737C28.5864 27.7582 28.3531 27.6893 28.1129 27.6471C27.8644 27.6021 27.6009 27.5838 27.3552 27.6345C27.0917 27.6865 26.8597 27.8173 26.7142 27.9888C26.5852 28.1393 26.5248 28.3179 26.5056 28.4951C26.4864 28.6723 26.507 28.8509 26.5317 29.028C26.5482 29.156 26.5688 29.2854 26.6099 29.4105C26.6525 29.5357 26.717 29.658 26.8186 29.7621C26.9654 29.9126 27.1837 30.0195 27.4184 30.0841C27.8027 30.1896 28.2391 30.184 28.6166 30.0687C29.2864 29.8535 29.8533 29.4668 30.1978 28.9915C30.3227 28.8199 30.4187 28.6385 30.4805 28.4515C30.5052 28.3755 30.5244 28.2996 30.5244 28.2237C30.5258 28.1463 30.508 28.0676 30.4599 28.0001Z"
            fill="url(#paint9_radial_11490_5620)"
          />
        </g>
      </g>
      <path
        d="M31.0173 27.1329C30.9693 26.9993 30.8842 26.8811 30.7812 26.7855C30.6783 26.6899 30.5561 26.6168 30.4285 26.5605C30.1732 26.4494 29.8946 26.4072 29.6201 26.3552C29.3634 26.306 29.1067 26.2455 28.8487 26.2005C28.5797 26.1541 28.3024 26.1232 28.0361 26.185C27.8042 26.2385 27.5887 26.3622 27.413 26.5268C27.2373 26.6913 27.1001 26.8966 27.0012 27.1188C26.8269 27.5111 26.772 27.9513 26.805 28.3802C26.8297 28.6994 26.9093 29.0285 27.1138 29.2689C27.2799 29.4644 27.5146 29.5868 27.7561 29.6599C28.1734 29.7864 28.6277 29.7794 29.0408 29.6416C29.723 29.4068 30.3269 28.9413 30.7359 28.3352C30.8705 28.1341 30.9857 27.9161 31.0379 27.6799C31.0777 27.4999 31.0791 27.3058 31.0173 27.1329Z"
        fill="#020204"
      />
      <mask
        id="mask18_11490_5620"
        maskUnits="userSpaceOnUse"
        x="26"
        y="26"
        width="6"
        height="4"
      >
        <path
          d="M31.0173 27.1329C30.9693 26.9993 30.8842 26.8811 30.7812 26.7855C30.6783 26.6899 30.5561 26.6168 30.4285 26.5605C30.1732 26.4494 29.8946 26.4072 29.6201 26.3552C29.3634 26.306 29.1067 26.2455 28.8487 26.2005C28.5797 26.1541 28.3024 26.1232 28.0361 26.185C27.8042 26.2385 27.5887 26.3622 27.413 26.5268C27.2373 26.6913 27.1001 26.8966 27.0012 27.1188C26.8269 27.5111 26.772 27.9513 26.805 28.3802C26.8297 28.6994 26.9093 29.0285 27.1138 29.2689C27.2799 29.4644 27.5146 29.5868 27.7561 29.6599C28.1734 29.7864 28.6277 29.7794 29.0408 29.6416C29.723 29.4068 30.3269 28.9413 30.7359 28.3352C30.8705 28.1341 30.9857 27.9161 31.0379 27.6799C31.0777 27.4999 31.0791 27.3058 31.0173 27.1329Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask18_11490_5620)">
        <g filter="url(#filter18_f_11490_5620)">
          <path
            d="M28.1819 26.0571C28.1174 26.0613 28.0542 26.0683 27.9897 26.081C27.5793 26.1555 27.2033 26.4213 26.9919 26.7883C26.8423 27.0485 26.775 27.355 26.7956 27.656C26.8052 27.445 26.8588 27.2383 26.959 27.0541C27.1278 26.7405 27.4352 26.5042 27.7797 26.4396C27.9911 26.4002 28.2093 26.4241 28.4221 26.4508C28.628 26.4775 28.8339 26.5057 29.0356 26.5492C29.3486 26.6196 29.6574 26.7264 29.9195 26.9135C29.9799 26.9571 30.0376 27.0063 30.0856 27.0653C30.1337 27.123 30.1707 27.1905 30.1858 27.265C30.2064 27.3747 30.1762 27.49 30.1227 27.5871C30.0692 27.6855 29.9964 27.7699 29.9195 27.8486C29.8564 27.9133 29.7905 27.9738 29.7233 28.0342C30.0266 27.9738 30.3327 27.8894 30.5852 27.7094C30.6909 27.6321 30.7884 27.5407 30.8515 27.4253C30.9146 27.3086 30.9407 27.168 30.9105 27.0386C30.8886 26.9514 30.8419 26.8713 30.7842 26.8038C30.7266 26.7363 30.6566 26.6814 30.5852 26.6294C30.2682 26.4016 29.8976 26.2567 29.5133 26.2089C29.2662 26.1625 29.0178 26.1232 28.7693 26.0922C28.5758 26.0669 28.3768 26.0458 28.1819 26.0571Z"
            fill="url(#paint10_radial_11490_5620)"
          />
        </g>
      </g>
      <mask
        id="mask19_11490_5620"
        maskUnits="userSpaceOnUse"
        x="26"
        y="26"
        width="6"
        height="4"
      >
        <path
          d="M31.0173 27.1329C30.9693 26.9993 30.8842 26.8811 30.7812 26.7855C30.6783 26.6899 30.5561 26.6168 30.4285 26.5605C30.1732 26.4494 29.8946 26.4072 29.6201 26.3552C29.3634 26.306 29.1067 26.2455 28.8487 26.2005C28.5797 26.1541 28.3024 26.1232 28.0361 26.185C27.8042 26.2385 27.5887 26.3622 27.413 26.5268C27.2373 26.6913 27.1001 26.8966 27.0012 27.1188C26.8269 27.5111 26.772 27.9513 26.805 28.3802C26.8297 28.6994 26.9093 29.0285 27.1138 29.2689C27.2799 29.4644 27.5146 29.5868 27.7561 29.6599C28.1734 29.7864 28.6277 29.7794 29.0408 29.6416C29.723 29.4068 30.3269 28.9413 30.7359 28.3352C30.8705 28.1341 30.9857 27.9161 31.0379 27.6799C31.0777 27.4999 31.0791 27.3058 31.0173 27.1329Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask19_11490_5620)">
        <g filter="url(#filter19_f_11490_5620)">
          <path
            d="M28.1819 26.0571C28.1174 26.0613 28.0542 26.0683 27.9897 26.081C27.5793 26.1555 27.2033 26.4213 26.9919 26.7883C26.8423 27.0485 26.775 27.355 26.7956 27.656C26.8052 27.445 26.8588 27.2383 26.959 27.0541C27.1278 26.7405 27.4352 26.5042 27.7797 26.4396C27.9911 26.4002 28.2093 26.4241 28.4221 26.4508C28.628 26.4775 28.8339 26.5057 29.0356 26.5492C29.3486 26.6196 29.6574 26.7264 29.9195 26.9135C29.9799 26.9571 30.0376 27.0063 30.0856 27.0653C30.1337 27.123 30.1707 27.1905 30.1858 27.265C30.2064 27.3747 30.1762 27.49 30.1227 27.5871C30.0692 27.6855 29.9964 27.7699 29.9195 27.8486C29.8564 27.9133 29.7905 27.9738 29.7233 28.0342C30.0266 27.9738 30.3327 27.8894 30.5852 27.7094C30.6909 27.6321 30.7884 27.5407 30.8515 27.4253C30.9146 27.3086 30.9407 27.168 30.9105 27.0386C30.8886 26.9514 30.8419 26.8713 30.7842 26.8038C30.7266 26.7363 30.6566 26.6814 30.5852 26.6294C30.2682 26.4016 29.8976 26.2567 29.5133 26.2089C29.2662 26.1625 29.0178 26.1232 28.7693 26.0922C28.5758 26.0669 28.3768 26.0458 28.1819 26.0571Z"
            fill="url(#paint11_linear_11490_5620)"
          />
        </g>
      </g>
      <path
        d="M16.5917 7.38318C16.3817 7.39443 16.1799 7.49427 16.0262 7.64193C15.8711 7.78958 15.7626 7.98365 15.6954 8.18755C15.5623 8.59818 15.5925 9.04255 15.6226 9.47427C15.6501 9.8638 15.6789 10.2618 15.8217 10.6246C15.893 10.8074 15.9932 10.9776 16.1264 11.1182C16.2595 11.2574 16.4283 11.3657 16.6136 11.4121C16.7866 11.4571 16.9732 11.4486 17.1434 11.3938C17.315 11.3376 17.4701 11.2377 17.5991 11.1097C17.7858 10.9227 17.9107 10.678 17.9834 10.4207C18.0562 10.1633 18.0768 9.89333 18.0726 9.62474C18.0672 9.29005 18.0246 8.95396 17.923 8.63615C17.8201 8.31833 17.6568 8.0174 17.4289 7.77693C17.3191 7.66021 17.1928 7.55896 17.0515 7.48724C16.9087 7.41552 16.7495 7.37474 16.5917 7.38318Z"
        fill="url(#paint12_radial_11490_5620)"
      />
      <path
        d="M16.0839 9.17046C16.0399 9.44328 16.0386 9.72874 16.1291 9.98749C16.1895 10.1591 16.2897 10.3152 16.4105 10.4487C16.4888 10.5359 16.5793 10.6147 16.6837 10.6667C16.7893 10.7187 16.9101 10.7398 17.0241 10.7117C17.1284 10.685 17.219 10.6161 17.2862 10.5303C17.3535 10.4445 17.3988 10.3419 17.4303 10.2364C17.525 9.92562 17.5099 9.58671 17.4152 9.27593C17.348 9.04953 17.2341 8.83156 17.0584 8.67968C16.9733 8.60656 16.8744 8.5489 16.7674 8.52359C16.6603 8.49687 16.5437 8.5039 16.4435 8.55031C16.3323 8.60234 16.2458 8.70078 16.1895 8.81187C16.1333 8.92296 16.1044 9.04671 16.0839 9.17046Z"
        fill="#020204"
      />
      <mask
        id="mask20_11490_5620"
        maskUnits="userSpaceOnUse"
        x="16"
        y="8"
        width="2"
        height="3"
      >
        <path
          d="M16.0839 9.17046C16.0399 9.44328 16.0386 9.72874 16.1291 9.98749C16.1895 10.1591 16.2897 10.3152 16.4105 10.4487C16.4888 10.5359 16.5793 10.6147 16.6837 10.6667C16.7893 10.7187 16.9101 10.7398 17.0241 10.7117C17.1284 10.685 17.219 10.6161 17.2862 10.5303C17.3535 10.4445 17.3988 10.3419 17.4303 10.2364C17.525 9.92562 17.5099 9.58671 17.4152 9.27593C17.348 9.04953 17.2341 8.83156 17.0584 8.67968C16.9733 8.60656 16.8744 8.5489 16.7674 8.52359C16.6603 8.49687 16.5437 8.5039 16.4435 8.55031C16.3323 8.60234 16.2458 8.70078 16.1895 8.81187C16.1333 8.92296 16.1044 9.04671 16.0839 9.17046Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask20_11490_5620)">
        <g filter="url(#filter20_f_11490_5620)">
          <path
            d="M16.6451 8.97356C16.6739 9.0509 16.77 9.07902 16.8235 9.1409C16.8743 9.19996 16.9278 9.26324 16.9567 9.33777C17.0102 9.47981 16.9031 9.69074 17.0157 9.79199C17.05 9.82293 17.1214 9.82434 17.1557 9.79199C17.2916 9.66543 17.2614 9.4109 17.2078 9.2309C17.1584 9.06918 17.039 8.91449 16.8908 8.83715C16.8221 8.80059 16.7192 8.77106 16.6602 8.82168C16.6231 8.85543 16.6272 8.92574 16.6451 8.97356Z"
            fill="url(#paint13_linear_11490_5620)"
          />
        </g>
      </g>
      <mask
        id="mask21_11490_5620"
        maskUnits="userSpaceOnUse"
        x="15"
        y="7"
        width="4"
        height="5"
      >
        <path
          d="M16.5917 7.38318C16.3817 7.39443 16.1799 7.49427 16.0262 7.64193C15.8711 7.78958 15.7626 7.98365 15.6954 8.18755C15.5623 8.59818 15.5925 9.04255 15.6226 9.47427C15.6501 9.8638 15.6789 10.2618 15.8217 10.6246C15.893 10.8074 15.9932 10.9776 16.1264 11.1182C16.2595 11.2574 16.4283 11.3657 16.6136 11.4121C16.7866 11.4571 16.9732 11.4486 17.1434 11.3938C17.315 11.3376 17.4701 11.2377 17.5991 11.1097C17.7858 10.9227 17.9107 10.678 17.9834 10.4207C18.0562 10.1633 18.0768 9.89333 18.0726 9.62474C18.0672 9.29005 18.0246 8.95396 17.923 8.63615C17.8201 8.31833 17.6568 8.0174 17.4289 7.77693C17.3191 7.66021 17.1928 7.55896 17.0515 7.48724C16.9087 7.41552 16.7495 7.37474 16.5917 7.38318Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask21_11490_5620)">
        <path
          d="M16.1376 8.2523C16.456 8.05824 16.8417 8.01324 17.2109 8.04839C17.5788 8.08496 17.9343 8.19464 18.2911 8.29449C18.5533 8.36761 18.8182 8.43511 19.0639 8.55324C19.3082 8.67136 19.536 8.84574 19.6719 9.08761C19.6939 9.12558 19.7117 9.16636 19.7351 9.20433C19.7584 9.2423 19.7858 9.27746 19.8202 9.30417C19.8545 9.33089 19.8984 9.34918 19.9409 9.34636C19.9629 9.34496 19.9849 9.33933 20.0027 9.32808C20.0219 9.31683 20.0384 9.29996 20.048 9.28027C20.059 9.25777 20.0631 9.23105 20.0617 9.20574C20.0604 9.18043 20.0549 9.15511 20.048 9.1298C19.9588 8.79652 19.7474 8.51386 19.5882 8.20871C19.4921 8.02589 19.4125 7.83464 19.3164 7.65183C18.9829 7.02605 18.4353 6.53527 17.8135 6.21605C17.1917 5.89683 16.4972 5.74355 15.8027 5.70277C14.9984 5.65355 14.1927 5.75199 13.3994 5.89542C13.0549 5.9573 12.7049 6.03042 12.4015 6.20621C12.2492 6.29339 12.1092 6.40589 12.0007 6.54652C11.8909 6.68574 11.8141 6.85308 11.788 7.03027C11.7647 7.20183 11.7894 7.37761 11.8484 7.53933C11.906 7.70105 11.9966 7.84871 12.1037 7.9823C12.3151 8.25089 12.5882 8.45902 12.8394 8.68964C13.0906 8.91886 13.3225 9.17339 13.6039 9.36324C13.7439 9.45886 13.8962 9.53761 14.0582 9.58402C14.2202 9.63042 14.3931 9.64308 14.5578 9.60792C14.728 9.57277 14.8872 9.48699 15.0258 9.3773C15.1645 9.26902 15.2839 9.13824 15.3978 9.00324C15.6257 8.73183 15.8384 8.43511 16.1376 8.2523Z"
          fill="url(#paint14_radial_11490_5620)"
        />
      </g>
      <g filter="url(#filter21_f_11490_5620)">
        <path
          d="M17.4596 7.14267C17.7561 7.42673 17.9757 7.77829 18.1253 8.14954C18.0594 7.74032 17.9565 7.40986 17.6957 7.14267C17.5365 6.98939 17.3539 6.85439 17.1494 6.76017C16.9683 6.6772 16.7692 6.62517 16.6539 6.62376C16.54 6.62095 16.5126 6.62376 16.4892 6.62517C16.4645 6.62657 16.4467 6.62657 16.5208 6.63642C16.5949 6.64486 16.761 6.69126 16.9394 6.77282C17.1179 6.85439 17.299 6.98939 17.4596 7.14267Z"
          fill="url(#paint15_linear_11490_5620)"
        />
      </g>
      <path
        d="M20.3201 7.38331C19.9921 7.61534 19.7162 7.93737 19.5817 8.32269C19.4115 8.80784 19.476 9.35065 19.6407 9.83722C19.8082 10.3364 20.0895 10.8117 20.5137 11.1113C20.725 11.2617 20.9707 11.3644 21.226 11.3953C21.4827 11.4263 21.7476 11.3827 21.9768 11.2617C22.254 11.1127 22.4668 10.8525 22.5986 10.5614C22.7303 10.2689 22.7866 9.94691 22.8044 9.62487C22.8264 9.21706 22.788 8.80081 22.6562 8.41409C22.5135 7.99362 22.2554 7.6055 21.8903 7.36362C21.7091 7.24269 21.5019 7.15972 21.2864 7.12878C21.0709 7.09784 20.8486 7.12175 20.6454 7.20191C20.5301 7.24831 20.4231 7.31159 20.3201 7.38331Z"
        fill="url(#paint16_radial_11490_5620)"
      />
      <path
        d="M21.0785 8.40125C20.955 8.40969 20.8342 8.45328 20.7285 8.52078C20.6242 8.58828 20.535 8.67969 20.465 8.78516C20.3236 8.99469 20.2618 9.25063 20.2522 9.50516C20.2454 9.695 20.266 9.88766 20.3277 10.0677C20.3895 10.2477 20.4924 10.415 20.6366 10.5359C20.7834 10.6611 20.9687 10.7356 21.1595 10.7455C21.3503 10.7539 21.5424 10.6977 21.6989 10.5866C21.8238 10.498 21.924 10.3756 21.9954 10.2378C22.0667 10.1014 22.1107 9.94953 22.1299 9.79485C22.1642 9.52344 22.1258 9.23938 22.0022 8.99469C21.8801 8.75 21.6715 8.54891 21.4203 8.45469C21.3105 8.41391 21.1938 8.39281 21.0785 8.40125Z"
        fill="#020204"
      />
      <mask
        id="mask22_11490_5620"
        maskUnits="userSpaceOnUse"
        x="20"
        y="8"
        width="3"
        height="3"
      >
        <path
          d="M21.0785 8.40125C20.955 8.40969 20.8342 8.45328 20.7285 8.52078C20.6242 8.58828 20.535 8.67969 20.465 8.78516C20.3236 8.99469 20.2618 9.25063 20.2522 9.50516C20.2454 9.695 20.266 9.88766 20.3277 10.0677C20.3895 10.2477 20.4924 10.415 20.6366 10.5359C20.7834 10.6611 20.9687 10.7356 21.1595 10.7455C21.3503 10.7539 21.5424 10.6977 21.6989 10.5866C21.8238 10.498 21.924 10.3756 21.9954 10.2378C22.0667 10.1014 22.1107 9.94953 22.1299 9.79485C22.1642 9.52344 22.1258 9.23938 22.0022 8.99469C21.8801 8.75 21.6715 8.54891 21.4203 8.45469C21.3105 8.41391 21.1938 8.39281 21.0785 8.40125Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask22_11490_5620)">
        <g filter="url(#filter22_f_11490_5620)">
          <path
            d="M21.8438 9.50374C21.9811 9.36311 21.7464 8.99045 21.5624 8.83717C21.4293 8.72748 21.0436 8.61077 21.0601 8.7317C21.0766 8.85123 21.2509 9.00592 21.3662 9.12405C21.5103 9.26889 21.7779 9.57124 21.8438 9.50374Z"
            fill="url(#paint17_linear_11490_5620)"
          />
        </g>
      </g>
      <mask
        id="mask23_11490_5620"
        maskUnits="userSpaceOnUse"
        x="19"
        y="7"
        width="4"
        height="5"
      >
        <path
          d="M20.3201 7.38331C19.9921 7.61534 19.7162 7.93737 19.5817 8.32269C19.4115 8.80784 19.476 9.35065 19.6407 9.83722C19.8082 10.3364 20.0895 10.8117 20.5137 11.1113C20.725 11.2617 20.9707 11.3644 21.226 11.3953C21.4827 11.4263 21.7476 11.3827 21.9768 11.2617C22.254 11.1127 22.4668 10.8525 22.5986 10.5614C22.7303 10.2689 22.7866 9.94691 22.8044 9.62487C22.8264 9.21706 22.788 8.80081 22.6562 8.41409C22.5135 7.99362 22.2554 7.6055 21.8903 7.36362C21.7091 7.24269 21.5019 7.15972 21.2864 7.12878C21.0709 7.09784 20.8486 7.12175 20.6454 7.20191C20.5301 7.24831 20.4231 7.31159 20.3201 7.38331Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask23_11490_5620)">
        <path
          d="M19.0782 8.61065C19.3609 8.37018 19.6889 8.18737 20.0389 8.07627C20.7595 7.84846 21.5762 7.93846 22.2131 8.3533C22.4327 8.49533 22.6289 8.67252 22.8335 8.83846C23.0366 9.00299 23.2535 9.15768 23.4991 9.24627C23.6323 9.29408 23.7737 9.32221 23.9137 9.30674C24.0399 9.29408 24.1621 9.24487 24.2664 9.17174C24.3707 9.09721 24.4586 8.99877 24.5244 8.88768C24.6562 8.66549 24.6988 8.39549 24.6754 8.13674C24.6301 7.61783 24.3446 7.1608 24.1058 6.70096C24.0303 6.55752 23.9589 6.41127 23.8684 6.27768C23.5925 5.86565 23.1505 5.59424 22.688 5.43533C22.2254 5.27643 21.7368 5.21877 21.2523 5.1569C21.0354 5.12877 20.8172 5.09924 20.6017 5.12596C20.3533 5.1569 20.1199 5.25955 19.877 5.32283C19.7617 5.35377 19.645 5.37487 19.5311 5.40862C19.4172 5.44237 19.3046 5.48877 19.2113 5.56471C19.0768 5.6758 18.9917 5.84315 18.9546 6.01612C18.9176 6.19049 18.9258 6.37049 18.9533 6.54627C19.0068 6.89783 19.1358 7.23955 19.1235 7.59533C19.1152 7.83862 19.0397 8.07908 19.0493 8.32237C19.0521 8.39408 19.0658 8.54033 19.0782 8.61065Z"
          fill="url(#paint18_linear_11490_5620)"
        />
      </g>
      <g filter="url(#filter23_f_11490_5620)">
        <path
          d="M21.4613 6.38477C21.405 6.45789 21.3543 6.53664 21.3145 6.62383C21.5684 6.68008 21.8099 6.78695 22.0268 6.93461C22.4468 7.22008 22.7652 7.63633 22.989 8.10039C23.0411 8.04133 23.0878 7.97805 23.129 7.90773C22.9039 7.42398 22.5799 6.98664 22.1462 6.69133C21.9376 6.5507 21.7056 6.44242 21.4613 6.38477Z"
          fill="url(#paint19_linear_11490_5620)"
        />
      </g>
      <mask
        id="mask24_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask24_11490_5620)">
        <g filter="url(#filter24_f_11490_5620)">
          <path
            d="M16.1339 14.5622C16.3357 15.1612 16.7406 15.6717 17.221 16.0697C17.3802 16.2033 17.549 16.3256 17.7371 16.4114C17.9237 16.4986 18.131 16.5478 18.3355 16.5295C18.5359 16.5126 18.7267 16.4311 18.9024 16.3298C19.078 16.2286 19.24 16.1062 19.4102 15.9965C19.7012 15.8067 20.0127 15.6534 20.3161 15.4847C20.6798 15.2808 21.0339 15.0487 21.34 14.7618C21.4814 14.6311 21.6118 14.4876 21.7669 14.3751C21.922 14.2612 22.1086 14.1797 22.298 14.1937C22.4408 14.2036 22.5739 14.2654 22.7139 14.2964C22.7839 14.3118 22.8553 14.3189 22.9267 14.3076C22.9967 14.2964 23.0653 14.2668 23.1147 14.2134C23.1751 14.1487 23.2025 14.0559 23.1984 13.9659C23.1957 13.8773 23.1655 13.7901 23.1243 13.7114C23.0433 13.5525 22.9198 13.4161 22.8649 13.2459C22.8155 13.094 22.8251 12.9309 22.8292 12.772C22.8333 12.6117 22.8306 12.4457 22.7592 12.3037C22.7043 12.1968 22.6124 12.1111 22.508 12.0548C22.4037 11.9972 22.2857 11.9676 22.1676 11.9564C21.9316 11.9339 21.6955 11.9817 21.458 11.9943C21.1451 12.0126 20.8294 11.9733 20.5151 11.9915C20.1239 12.0168 19.7396 12.1322 19.3471 12.1336C18.8996 12.135 18.4522 11.9845 18.0102 12.0562C17.8194 12.0872 17.6382 12.1575 17.4571 12.2193C17.2745 12.2826 17.0865 12.3375 16.8943 12.3347C16.6761 12.3304 16.4647 12.2531 16.2465 12.2376C16.138 12.2292 16.0269 12.2376 15.9239 12.277C15.8224 12.3164 15.7304 12.3881 15.6796 12.4879C15.6508 12.5442 15.6371 12.6089 15.6343 12.6722C15.6316 12.7368 15.6398 12.8001 15.6549 12.8634C15.6851 12.9872 15.7414 13.1039 15.7867 13.222C15.9514 13.6537 15.9871 14.1248 16.1339 14.5622Z"
            fill="black"
            fillOpacity="0.258824"
          />
        </g>
      </g>
      <mask
        id="mask25_11490_5620"
        maskUnits="userSpaceOnUse"
        x="10"
        y="2"
        width="20"
        height="36"
      >
        <path
          d="M19.6792 2C18.8556 2 18.0294 2.16594 17.2827 2.57937C16.4894 3.01672 15.8388 3.71703 15.4394 4.54391C15.0386 5.37078 14.8821 6.25391 14.8574 7.22703C14.8121 9.07484 14.8986 11.0127 15.0345 12.7691C15.0702 13.3034 15.136 13.6156 15.0688 14.1655C14.8464 15.3327 13.85 16.1173 13.3174 17.1425C12.7313 18.2731 12.4843 19.5514 12.0423 20.7495C11.6374 21.845 11.0692 22.873 10.6862 23.9769C10.1496 25.5195 9.98898 27.2155 10.3431 28.813C10.6135 30.0308 11.1776 31.1727 11.938 32.15C11.8282 32.3525 11.7211 32.5592 11.6086 32.7603C11.2558 33.3833 10.8249 33.9753 10.6245 34.6658C10.5243 35.0103 10.4845 35.3787 10.549 35.7331C10.6135 36.0875 10.7892 36.4264 11.0637 36.6514C11.2435 36.7977 11.4617 36.8933 11.6855 36.9467C11.9092 36.9987 12.1411 37.0114 12.3717 37.0072C13.246 36.9875 14.0943 36.7161 14.9398 36.4883C15.4421 36.3533 15.9472 36.2337 16.4537 36.1255C18.2572 35.7472 20.2694 35.8991 21.9425 36.1466C22.5094 36.2352 23.0721 36.3491 23.6294 36.4883C24.5023 36.7048 25.3711 36.9805 26.2688 37.0072C26.5049 37.0142 26.7437 37.003 26.9743 36.9509C27.2049 36.8975 27.4286 36.8019 27.6125 36.6514C27.8884 36.4264 28.0641 36.0861 28.1286 35.7317C28.1931 35.3773 28.1533 35.0075 28.0517 34.6616C27.8486 33.9697 27.4135 33.3805 27.0539 32.7603C26.9111 32.5142 26.7794 32.2639 26.638 32.0178C27.7223 30.7705 28.5953 29.3277 29.1004 27.7428C29.6507 26.0131 29.7523 24.1498 29.5204 22.3456C29.2884 20.5414 28.7298 18.792 27.9954 17.1355C27.0731 15.0598 26.2976 14.3089 25.7349 12.485C25.1282 10.5134 25.6292 8.18047 25.1776 6.39313C25.017 5.78562 24.7604 5.20484 24.4296 4.67328C24.0425 4.05031 23.5511 3.49344 22.9678 3.06031C22.0372 2.36844 20.8678 2 19.6792 2Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask25_11490_5620)">
        <g opacity="0.3" filter="url(#filter25_f_11490_5620)">
          <path
            d="M15.5726 12.8561C15.9638 13.1036 16.3152 13.4088 16.6103 13.7547C16.8834 14.0768 17.1154 14.4424 17.4736 14.68C17.7248 14.8488 18.0281 14.943 18.3356 14.9725C18.6965 15.0063 19.0616 14.9515 19.4103 14.8544C19.7328 14.7658 20.0444 14.6393 20.3299 14.4733C20.8748 14.1569 21.3291 13.6929 21.9289 13.4847C22.0593 13.4383 22.1952 13.406 22.3214 13.3497C22.4477 13.2949 22.5671 13.2105 22.6275 13.0924C22.6852 12.9771 22.6824 12.8463 22.7016 12.7211C22.7222 12.5861 22.7675 12.4568 22.7922 12.3232C22.8169 12.1896 22.8197 12.0475 22.7593 11.9252C22.7085 11.824 22.6165 11.7438 22.5109 11.6918C22.4052 11.6411 22.2858 11.6186 22.1663 11.613C21.9303 11.6018 21.6956 11.6594 21.4581 11.6791C21.1452 11.7058 20.8295 11.6679 20.5152 11.6777C20.124 11.689 19.7383 11.7719 19.3471 11.7902C18.9011 11.8099 18.4563 11.7424 18.0103 11.7283C17.8167 11.7213 17.6218 11.7241 17.4324 11.7565C17.2416 11.7874 17.055 11.8479 16.8944 11.9491C16.7379 12.0461 16.6103 12.1797 16.4675 12.2936C16.3962 12.3513 16.3193 12.4033 16.2369 12.4441C16.1532 12.4835 16.0613 12.5116 15.9679 12.5158C15.9199 12.5172 15.8705 12.5144 15.8238 12.5215C15.7428 12.5327 15.6687 12.5763 15.622 12.6382C15.5754 12.7015 15.5575 12.7816 15.5726 12.8561Z"
            fill="black"
          />
        </g>
      </g>
      <path
        d="M17.5815 10.2309C17.7915 9.99044 17.9343 9.69654 18.1347 9.44904C18.2349 9.32529 18.3515 9.21138 18.4874 9.13123C18.6233 9.05107 18.7825 9.00607 18.939 9.02013C19.1133 9.0356 19.2766 9.12419 19.4043 9.24654C19.5319 9.36888 19.6266 9.52357 19.7021 9.68529C19.7749 9.84138 19.8325 10.0059 19.9368 10.1409C20.048 10.2843 20.2031 10.3814 20.3445 10.4953C20.4145 10.5515 20.4831 10.612 20.538 10.6837C20.5943 10.7554 20.6368 10.8384 20.656 10.9284C20.6739 11.0198 20.6643 11.1154 20.6341 11.2026C20.6025 11.2898 20.5503 11.3686 20.4845 11.4333C20.3541 11.5626 20.1756 11.6329 19.9958 11.6583C19.6362 11.7103 19.2725 11.6006 18.9088 11.6104C18.5423 11.6217 18.1827 11.7539 17.8149 11.7412C17.6323 11.7342 17.4456 11.6878 17.2947 11.5809C17.2192 11.5261 17.1533 11.4572 17.1052 11.377C17.0586 11.2968 17.0298 11.204 17.0256 11.1098C17.0229 11.0198 17.0435 10.9298 17.0792 10.8483C17.1135 10.7653 17.1629 10.6908 17.2178 10.6204C17.329 10.4812 17.4649 10.3659 17.5815 10.2309Z"
        fill="url(#paint20_radial_11490_5620)"
      />
      <path
        d="M15.5879 12.554C15.5961 12.5906 15.6085 12.6243 15.6263 12.6567C15.6579 12.7101 15.7046 12.7537 15.754 12.7903C15.8034 12.8282 15.8569 12.8592 15.9091 12.8915C16.1849 13.0701 16.41 13.319 16.6104 13.5834C16.8781 13.9378 17.1155 14.3301 17.4738 14.5875C17.7263 14.7703 18.0283 14.8729 18.3357 14.9053C18.6967 14.9418 19.0618 14.8828 19.4104 14.7773C19.733 14.6803 20.0446 14.5439 20.33 14.3625C20.8749 14.0193 21.3293 13.5159 21.9291 13.2895C22.0595 13.2403 22.1953 13.2051 22.3216 13.1446C22.4479 13.0828 22.5673 12.9928 22.6277 12.8634C22.6853 12.7396 22.6826 12.5962 22.7018 12.4598C22.7224 12.315 22.7677 12.1743 22.7924 12.0295C22.8171 11.8846 22.8199 11.73 22.7595 11.5964C22.7087 11.4867 22.6167 11.3995 22.511 11.3446C22.4053 11.2884 22.2859 11.2631 22.1665 11.2575C21.9304 11.2462 21.6957 11.3081 21.4583 11.3306C21.1453 11.3601 20.8297 11.3179 20.5153 11.3278C20.1242 11.3404 19.7385 11.4304 19.3473 11.4501C18.9012 11.4712 18.4565 11.4009 18.0104 11.3826C17.8169 11.3742 17.622 11.377 17.4312 11.4107C17.2404 11.4431 17.0538 11.5106 16.8946 11.6231C16.7395 11.7328 16.6159 11.8818 16.4732 12.0084C16.4018 12.0717 16.3249 12.1293 16.2399 12.1715C16.1561 12.2137 16.0628 12.2404 15.9681 12.2376C15.92 12.2362 15.8693 12.2292 15.824 12.2432C15.7951 12.2531 15.7691 12.2714 15.7471 12.2925C15.7251 12.315 15.7073 12.3403 15.6908 12.3656C15.651 12.4246 15.6167 12.4879 15.5879 12.554Z"
        fill="url(#paint21_radial_11490_5620)"
      />
      <mask
        id="mask26_11490_5620"
        maskUnits="userSpaceOnUse"
        x="15"
        y="11"
        width="8"
        height="4"
      >
        <path
          d="M15.5879 12.554C15.5961 12.5906 15.6085 12.6243 15.6263 12.6567C15.6579 12.7101 15.7046 12.7537 15.754 12.7903C15.8034 12.8282 15.8569 12.8592 15.9091 12.8915C16.1849 13.0701 16.41 13.319 16.6104 13.5834C16.8781 13.9378 17.1155 14.3301 17.4738 14.5875C17.7263 14.7703 18.0283 14.8729 18.3357 14.9053C18.6967 14.9418 19.0618 14.8828 19.4104 14.7773C19.733 14.6803 20.0446 14.5439 20.33 14.3625C20.8749 14.0193 21.3293 13.5159 21.9291 13.2895C22.0595 13.2403 22.1953 13.2051 22.3216 13.1446C22.4479 13.0828 22.5673 12.9928 22.6277 12.8634C22.6853 12.7396 22.6826 12.5962 22.7018 12.4598C22.7224 12.315 22.7677 12.1743 22.7924 12.0295C22.8171 11.8846 22.8199 11.73 22.7595 11.5964C22.7087 11.4867 22.6167 11.3995 22.511 11.3446C22.4053 11.2884 22.2859 11.2631 22.1665 11.2575C21.9304 11.2462 21.6957 11.3081 21.4583 11.3306C21.1453 11.3601 20.8297 11.3179 20.5153 11.3278C20.1242 11.3404 19.7385 11.4304 19.3473 11.4501C18.9012 11.4712 18.4565 11.4009 18.0104 11.3826C17.8169 11.3742 17.622 11.377 17.4312 11.4107C17.2404 11.4431 17.0538 11.5106 16.8946 11.6231C16.7395 11.7328 16.6159 11.8818 16.4732 12.0084C16.4018 12.0717 16.3249 12.1293 16.2399 12.1715C16.1561 12.2137 16.0628 12.2404 15.9681 12.2376C15.92 12.2362 15.8693 12.2292 15.824 12.2432C15.7951 12.2531 15.7691 12.2714 15.7471 12.2925C15.7251 12.315 15.7073 12.3403 15.6908 12.3656C15.651 12.4246 15.6167 12.4879 15.5879 12.554Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask26_11490_5620)">
        <g filter="url(#filter26_f_11490_5620)">
          <path
            d="M17.3397 13.0475C17.2944 13.2402 17.3218 13.4511 17.4165 13.6255C17.5099 13.7998 17.6691 13.9348 17.8544 13.9981C18.0877 14.0783 18.3512 14.0389 18.5695 13.9222C18.6971 13.8547 18.8124 13.7591 18.8852 13.6325C18.9222 13.5706 18.9483 13.5003 18.9579 13.4272C18.9662 13.3555 18.9607 13.2795 18.936 13.2106C18.9085 13.1361 18.8591 13.07 18.8001 13.018C18.7397 12.9659 18.6697 12.928 18.5942 12.9027C18.446 12.852 18.214 12.8098 18.0575 12.807C17.7803 12.8014 17.385 12.8548 17.3397 13.0475Z"
            fill="#D9B30D"
          />
        </g>
      </g>
      <mask
        id="mask27_11490_5620"
        maskUnits="userSpaceOnUse"
        x="15"
        y="11"
        width="8"
        height="4"
      >
        <path
          d="M15.5869 12.554C15.5951 12.5906 15.6075 12.6243 15.6253 12.6567C15.6569 12.7101 15.7036 12.7537 15.753 12.7903C15.8024 12.8282 15.8559 12.8592 15.9081 12.8915C16.184 13.0701 16.4091 13.319 16.6095 13.5834C16.8771 13.9378 17.1146 14.3301 17.4728 14.5875C17.7253 14.7703 18.0273 14.8729 18.3348 14.9053C18.6957 14.9418 19.0608 14.8828 19.4095 14.7773C19.732 14.6803 20.0436 14.5439 20.3291 14.3625C20.874 14.0193 21.3283 13.5159 21.9281 13.2895C22.0585 13.2403 22.1944 13.2051 22.3206 13.1446C22.4469 13.0828 22.5663 12.9928 22.6267 12.8634C22.6844 12.7396 22.6816 12.5962 22.7008 12.4598C22.7214 12.315 22.7667 12.1743 22.7914 12.0295C22.8161 11.8846 22.8189 11.73 22.7585 11.5964C22.7077 11.4867 22.6157 11.3995 22.5101 11.3446C22.4044 11.2884 22.285 11.2631 22.1655 11.2575C21.9295 11.2462 21.6948 11.3081 21.4573 11.3306C21.1444 11.3601 20.8287 11.3179 20.5144 11.3278C20.1232 11.3404 19.7375 11.4304 19.3463 11.4501C18.9002 11.4712 18.4555 11.4009 18.0095 11.3826C17.8159 11.3742 17.621 11.377 17.4302 11.4107C17.2395 11.4431 17.0528 11.5106 16.8936 11.6231C16.7385 11.7328 16.615 11.8818 16.4722 12.0084C16.4008 12.0717 16.324 12.1293 16.2389 12.1715C16.1551 12.2137 16.0618 12.2404 15.9671 12.2376C15.9191 12.2362 15.8683 12.2292 15.823 12.2432C15.7942 12.2531 15.7681 12.2714 15.7461 12.2925C15.7242 12.315 15.7063 12.3403 15.6899 12.3656C15.6501 12.4246 15.6157 12.4879 15.5869 12.554Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask27_11490_5620)">
        <g filter="url(#filter27_f_11490_5620)">
          <path
            d="M16.5711 11.5429C16.4119 11.6385 16.2595 11.744 16.1099 11.8523C16.0317 11.9099 15.9521 11.9704 15.9109 12.059C15.8821 12.1209 15.8752 12.1912 15.8738 12.2601C15.8738 12.3304 15.878 12.3993 15.8683 12.4682C15.8629 12.5146 15.8505 12.561 15.8491 12.6074C15.8478 12.6314 15.8491 12.6553 15.8546 12.6778C15.8615 12.7003 15.8725 12.7228 15.8876 12.7396C15.9081 12.7621 15.9356 12.7762 15.9644 12.7846C15.9932 12.7931 16.0221 12.7973 16.0523 12.8043C16.1909 12.8381 16.3117 12.9253 16.4174 13.0237C16.523 13.1207 16.6191 13.2318 16.7303 13.3232C17.0295 13.5735 17.4262 13.6776 17.8132 13.6832C18.2003 13.6903 18.5832 13.6073 18.9607 13.5201C19.2572 13.4512 19.5536 13.3809 19.8378 13.2726C20.277 13.1067 20.6832 12.8564 21.0346 12.5428C21.1952 12.4007 21.3448 12.2446 21.5246 12.1293C21.6825 12.0267 21.8595 11.9592 22.0215 11.8621C22.0366 11.8537 22.0503 11.8439 22.0627 11.834C22.0764 11.8228 22.0874 11.8087 22.0956 11.7946C22.1079 11.7679 22.1079 11.7356 22.0997 11.7074C22.0915 11.6793 22.075 11.654 22.0572 11.6301C22.0366 11.6048 22.0146 11.5823 21.9899 11.5598C21.8211 11.4121 21.5932 11.3587 21.3709 11.3404C21.1499 11.3235 20.9262 11.3362 20.708 11.2982C20.5021 11.2631 20.3072 11.1843 20.1081 11.1196C19.8995 11.0507 19.6868 10.9973 19.4713 10.9607C18.9621 10.8749 18.4391 10.8918 17.9354 10.9987C17.4564 11.1014 16.9925 11.287 16.5711 11.5429Z"
            fill="#604405"
          />
        </g>
      </g>
      <path
        d="M16.5206 10.9933C16.2928 11.1508 16.0869 11.3434 15.9126 11.5614C15.8137 11.6865 15.7232 11.823 15.6737 11.9748C15.6339 12.0958 15.6202 12.2223 15.5955 12.3475C15.5859 12.3939 15.5749 12.4403 15.5763 12.4881C15.5763 12.5106 15.579 12.5345 15.5859 12.5584C15.5928 12.5809 15.6051 12.602 15.6202 12.6189C15.6477 12.647 15.6847 12.6625 15.7218 12.6709C15.7602 12.678 15.7986 12.6794 15.8371 12.6836C16.0086 12.7047 16.1665 12.789 16.3092 12.8903C16.452 12.9901 16.5837 13.1083 16.7306 13.2025C17.0532 13.412 17.4388 13.5048 17.8218 13.5203C18.2033 13.5358 18.5849 13.4767 18.961 13.3994C19.2588 13.3389 19.5553 13.2658 19.8381 13.1519C20.2718 12.9761 20.663 12.7075 21.0349 12.422C21.2051 12.2926 21.3726 12.159 21.5249 12.0086C21.5757 11.9565 21.6265 11.9045 21.6814 11.8567C21.7363 11.8103 21.7981 11.7695 21.8667 11.747C21.971 11.7133 22.0835 11.7231 22.192 11.7414C22.273 11.7555 22.3539 11.7737 22.4363 11.7709C22.4775 11.7681 22.5186 11.7611 22.5571 11.7456C22.5955 11.7301 22.6312 11.7062 22.6573 11.6725C22.6916 11.6303 22.7094 11.574 22.7094 11.5192C22.7094 11.463 22.693 11.4081 22.6655 11.3603C22.6106 11.2647 22.5159 11.2 22.4171 11.155C22.2812 11.0931 22.1343 11.0636 21.9902 11.027C21.5469 10.9173 21.1159 10.7556 20.7082 10.5475C20.5051 10.4448 20.3075 10.3309 20.1084 10.2212C19.9026 10.1087 19.6939 10.0005 19.4716 9.93014C18.972 9.77545 18.4284 9.82608 17.9357 10.0019C17.3894 10.1959 16.8953 10.5419 16.5206 10.9933Z"
        fill="url(#paint22_linear_11490_5620)"
      />
      <mask
        id="mask28_11490_5620"
        maskUnits="userSpaceOnUse"
        x="15"
        y="9"
        width="8"
        height="5"
      >
        <path
          d="M16.5206 10.9933C16.2928 11.1508 16.0869 11.3434 15.9126 11.5614C15.8137 11.6865 15.7232 11.823 15.6737 11.9748C15.6339 12.0958 15.6202 12.2223 15.5955 12.3475C15.5859 12.3939 15.5749 12.4403 15.5763 12.4881C15.5763 12.5106 15.579 12.5345 15.5859 12.5584C15.5928 12.5809 15.6051 12.602 15.6202 12.6189C15.6477 12.647 15.6847 12.6625 15.7218 12.6709C15.7602 12.678 15.7986 12.6794 15.8371 12.6836C16.0086 12.7047 16.1665 12.789 16.3092 12.8903C16.452 12.9901 16.5837 13.1083 16.7306 13.2025C17.0532 13.412 17.4388 13.5048 17.8218 13.5203C18.2033 13.5358 18.5849 13.4767 18.961 13.3994C19.2588 13.3389 19.5553 13.2658 19.8381 13.1519C20.2718 12.9761 20.663 12.7075 21.0349 12.422C21.2051 12.2926 21.3726 12.159 21.5249 12.0086C21.5757 11.9565 21.6265 11.9045 21.6814 11.8567C21.7363 11.8103 21.7981 11.7695 21.8667 11.747C21.971 11.7133 22.0835 11.7231 22.192 11.7414C22.273 11.7555 22.3539 11.7737 22.4363 11.7709C22.4775 11.7681 22.5186 11.7611 22.5571 11.7456C22.5955 11.7301 22.6312 11.7062 22.6573 11.6725C22.6916 11.6303 22.7094 11.574 22.7094 11.5192C22.7094 11.463 22.693 11.4081 22.6655 11.3603C22.6106 11.2647 22.5159 11.2 22.4171 11.155C22.2812 11.0931 22.1343 11.0636 21.9902 11.027C21.5469 10.9173 21.1159 10.7556 20.7082 10.5475C20.5051 10.4448 20.3075 10.3309 20.1084 10.2212C19.9026 10.1087 19.6939 10.0005 19.4716 9.93014C18.972 9.77545 18.4284 9.82608 17.9357 10.0019C17.3894 10.1959 16.8953 10.5419 16.5206 10.9933Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask28_11490_5620)">
        <g filter="url(#filter28_f_11490_5620)">
          <path
            d="M20.0225 11.1053C19.995 11.0715 19.9566 11.0462 19.9154 11.0335C19.8743 11.0209 19.8303 11.0209 19.7878 11.0279C19.7027 11.0434 19.6258 11.0898 19.5544 11.1404C19.3527 11.2824 19.1742 11.4582 19.0178 11.6523C18.8119 11.9096 18.6417 12.2064 18.5841 12.534C18.5744 12.5889 18.569 12.6465 18.5744 12.7014C18.5813 12.7576 18.6019 12.8124 18.6417 12.8518C18.6746 12.887 18.7213 12.9081 18.768 12.9151C18.816 12.9221 18.8654 12.9151 18.9107 12.8996C19.0013 12.8687 19.0768 12.8026 19.1495 12.7379C19.5435 12.3751 19.9003 11.942 20.0431 11.4189C20.0568 11.3668 20.0692 11.3134 20.0692 11.2585C20.0692 11.2037 20.0554 11.1489 20.0225 11.1053Z"
            fill="#F6DA4A"
          />
        </g>
      </g>
      <g opacity="0.8" filter="url(#filter29_f_11490_5620)">
        <path
          d="M17.7255 10.3053C17.6198 10.2702 17.4469 10.46 17.5032 10.557C17.5183 10.5837 17.5663 10.6175 17.5993 10.5992C17.6473 10.5725 17.6871 10.4741 17.7393 10.4361C17.7736 10.4108 17.7667 10.318 17.7255 10.3053Z"
          fill="url(#paint23_radial_11490_5620)"
        />
      </g>
      <g opacity="0.8" filter="url(#filter30_f_11490_5620)">
        <path
          d="M19.0766 10.3559C19.1041 10.4459 19.2455 10.4304 19.3278 10.474C19.3992 10.512 19.4568 10.5949 19.5378 10.5977C19.6147 10.5991 19.7355 10.5696 19.7451 10.4909C19.7574 10.3882 19.6106 10.3221 19.5158 10.2841C19.3937 10.2363 19.2372 10.211 19.1233 10.2757C19.0972 10.2912 19.0684 10.3263 19.0766 10.3559Z"
          fill="url(#paint24_radial_11490_5620)"
        />
      </g>
      <mask
        id="mask29_11490_5620"
        maskUnits="userSpaceOnUse"
        x="15"
        y="9"
        width="8"
        height="6"
      >
        <path
          d="M15.5869 12.554C15.5951 12.5906 15.6075 12.6243 15.6253 12.6567C15.6569 12.7101 15.7036 12.7537 15.753 12.7903C15.8024 12.8282 15.8559 12.8592 15.9081 12.8915C16.184 13.0701 16.4091 13.319 16.6095 13.5834C16.8771 13.9378 17.1146 14.3301 17.4728 14.5875C17.7253 14.7703 18.0273 14.8729 18.3348 14.9053C18.6957 14.9418 19.0608 14.8828 19.4095 14.7773C19.732 14.6803 20.0436 14.5439 20.3291 14.3625C20.874 14.0193 21.3283 13.5159 21.9281 13.2895C22.0585 13.2403 22.1944 13.2051 22.3206 13.1446C22.4469 13.0828 22.5663 12.9928 22.6267 12.8634C22.6844 12.7396 22.6816 12.5962 22.7008 12.4598C22.7214 12.315 22.7667 12.1743 22.7914 12.0295C22.8161 11.8846 22.8189 11.73 22.7585 11.5964C22.7077 11.4867 22.6157 11.3995 22.5101 11.3446C22.4044 11.2884 22.285 11.2631 22.1655 11.2575C21.9295 11.2462 21.6948 11.3081 21.4573 11.3306C21.1444 11.3601 20.8287 11.3179 20.5144 11.3278C20.1232 11.3404 19.7375 11.4304 19.3463 11.4501C18.9002 11.4712 18.4555 11.4009 18.0095 11.3826C17.8159 11.3742 17.621 11.377 17.4302 11.4107C17.2395 11.4431 17.0528 11.5106 16.8936 11.6231C16.7385 11.7328 16.615 11.8818 16.4722 12.0084C16.4008 12.0717 16.324 12.1293 16.2389 12.1715C16.1551 12.2137 16.0618 12.2404 15.9671 12.2376C15.9191 12.2362 15.8683 12.2292 15.823 12.2432C15.7942 12.2531 15.7681 12.2714 15.7461 12.2925C15.7242 12.315 15.7063 12.3403 15.6899 12.3656C15.6501 12.4246 15.6157 12.4879 15.5869 12.554Z"
          fill="white"
        />
        <path
          d="M16.5206 10.9933C16.2928 11.1508 16.0869 11.3434 15.9126 11.5614C15.8137 11.6865 15.7232 11.823 15.6737 11.9748C15.6339 12.0958 15.6202 12.2223 15.5955 12.3475C15.5859 12.3939 15.5749 12.4403 15.5763 12.4881C15.5763 12.5106 15.579 12.5345 15.5859 12.5584C15.5928 12.5809 15.6051 12.602 15.6202 12.6189C15.6477 12.647 15.6847 12.6625 15.7218 12.6709C15.7602 12.678 15.7986 12.6794 15.8371 12.6836C16.0086 12.7047 16.1665 12.789 16.3092 12.8903C16.452 12.9901 16.5837 13.1083 16.7306 13.2025C17.0532 13.412 17.4388 13.5048 17.8218 13.5203C18.2033 13.5358 18.5849 13.4767 18.961 13.3994C19.2588 13.3389 19.5553 13.2658 19.8381 13.1519C20.2718 12.9761 20.663 12.7075 21.0349 12.422C21.2051 12.2926 21.3726 12.159 21.5249 12.0086C21.5757 11.9565 21.6265 11.9045 21.6814 11.8567C21.7363 11.8103 21.7981 11.7695 21.8667 11.747C21.971 11.7133 22.0835 11.7231 22.192 11.7414C22.273 11.7555 22.3539 11.7737 22.4363 11.7709C22.4775 11.7681 22.5186 11.7611 22.5571 11.7456C22.5955 11.7301 22.6312 11.7062 22.6573 11.6725C22.6916 11.6303 22.7094 11.574 22.7094 11.5192C22.7094 11.463 22.693 11.4081 22.6655 11.3603C22.6106 11.2647 22.5159 11.2 22.4171 11.155C22.2812 11.0931 22.1343 11.0636 21.9902 11.027C21.5469 10.9173 21.1159 10.7556 20.7082 10.5475C20.5051 10.4448 20.3075 10.3309 20.1084 10.2212C19.9026 10.1087 19.6939 10.0005 19.4716 9.93014C18.972 9.77545 18.4284 9.82608 17.9357 10.0019C17.3894 10.1959 16.8953 10.5419 16.5206 10.9933Z"
          fill="white"
        />
      </mask>
      <g mask="url(#mask29_11490_5620)">
        <g filter="url(#filter31_f_11490_5620)">
          <path
            d="M22.7423 11.7241C22.7296 11.8378 22.6818 11.9467 22.6095 12.0268C22.5371 12.107 22.4462 12.1519 22.3566 12.1516C22.2672 12.1516 22.1863 12.1066 22.1317 12.0265C22.0772 11.9464 22.0534 11.8376 22.0656 11.7241C22.0718 11.6677 22.0867 11.6118 22.1094 11.5597C22.1322 11.5076 22.1623 11.4603 22.1981 11.4205C22.234 11.3806 22.2748 11.3491 22.3182 11.3275C22.3617 11.306 22.4069 11.295 22.4513 11.2952C22.4957 11.2951 22.5385 11.3062 22.5772 11.3277C22.6158 11.3492 22.6497 11.3808 22.6767 11.4207C22.7037 11.4605 22.7234 11.5078 22.7347 11.5599C22.7459 11.6119 22.7485 11.6677 22.7423 11.7241Z"
            fill="url(#paint25_linear_11490_5620)"
          />
        </g>
      </g>
      <defs>
        <filter
          id="filter0_f_11490_5620"
          x="11.6477"
          y="15.6785"
          width="6.78363"
          height="6.60858"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.64"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter1_f_11490_5620"
          x="17.3066"
          y="14.6806"
          width="10.2813"
          height="8.43831"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.98"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter2_f_11490_5620"
          x="15.3822"
          y="15.8006"
          width="5.28543"
          height="5.52957"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.68"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter3_f_11490_5620"
          x="14.373"
          y="18.7852"
          width="5.50195"
          height="12.2744"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="1.25"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter4_f_11490_5620"
          x="23.1207"
          y="16.8939"
          width="8.31141"
          height="8.36658"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="1.78"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter5_f_11490_5620"
          x="17.8867"
          y="0.0824804"
          width="8.86824"
          height="8.81209"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="1.73"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter6_f_11490_5620"
          x="22.3326"
          y="11.1695"
          width="4.56043"
          height="4.76355"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.78"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter7_f_11490_5620"
          x="8.48922"
          y="17.5175"
          width="7.10164"
          height="11.6366"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.98"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter8_f_11490_5620"
          x="23.2665"
          y="16.3532"
          width="8.0852"
          height="14.5798"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="1.19"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter9_f_11490_5620"
          x="-1.3098"
          y="20.167"
          width="23.8813"
          height="24.0386"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="3.38"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter10_f_11490_5620"
          x="1.60762"
          y="22.2668"
          width="17.5768"
          height="18.381"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur stdDeviation="2.1" result="effect1_foregroundBlur_11490_5620" />
        </filter>
        <filter
          id="filter11_f_11490_5620"
          x="11.3873"
          y="27.827"
          width="4.39328"
          height="7.0654"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.32"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter12_f_11490_5620"
          x="19.934"
          y="24.6007"
          width="16.2473"
          height="17.2199"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="1.95"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter13_f_11490_5620"
          x="16.7024"
          y="19.1311"
          width="25.8335"
          height="26.1987"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="4.12"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter14_f_11490_5620"
          x="19.0842"
          y="20.3999"
          width="21.4087"
          height="21.5808"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="3.12"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter15_f_11490_5620"
          x="24.3997"
          y="26.4344"
          width="8.14879"
          height="2.71886"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.41"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter16_f_11490_5620"
          x="21.598"
          y="22.9347"
          width="13.8264"
          height="13.3344"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="2.45"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter17_f_11490_5620"
          x="24.258"
          y="25.364"
          width="8.50637"
          height="7.03542"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="1.12"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter18_f_11490_5620"
          x="25.032"
          y="24.294"
          width="7.65086"
          height="5.50022"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.88"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter19_f_11490_5620"
          x="25.032"
          y="24.294"
          width="7.65086"
          height="5.50022"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.88"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter20_f_11490_5620"
          x="15.7518"
          y="7.91468"
          width="2.38109"
          height="2.781"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.44"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter21_f_11490_5620"
          x="16.2278"
          y="6.38256"
          width="2.13723"
          height="2.0071"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.12"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter22_f_11490_5620"
          x="20.1596"
          y="7.78042"
          width="2.6252"
          height="2.63301"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.45"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter23_f_11490_5620"
          x="21.0545"
          y="6.12477"
          width="2.33445"
          height="2.23558"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.13"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter24_f_11490_5620"
          x="12.1338"
          y="8.45044"
          width="14.5654"
          height="11.5828"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="1.75"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter25_f_11490_5620"
          x="13.9674"
          y="10.0116"
          width="10.4412"
          height="6.57085"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur stdDeviation="0.8" result="effect1_foregroundBlur_11490_5620" />
        </filter>
        <filter
          id="filter26_f_11490_5620"
          x="15.7784"
          y="11.2666"
          width="4.72355"
          height="4.31364"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.77"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter27_f_11490_5620"
          x="14.5486"
          y="9.60601"
          width="8.85684"
          height="5.37759"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.65"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter28_f_11490_5620"
          x="17.1123"
          y="9.56319"
          width="4.41707"
          height="4.81453"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.73"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <filter
          id="filter29_f_11490_5620"
          x="17.2922"
          y="10.101"
          width="0.668555"
          height="0.703467"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur stdDeviation="0.1" result="effect1_foregroundBlur_11490_5620" />
        </filter>
        <filter
          id="filter30_f_11490_5620"
          x="18.8752"
          y="10.0368"
          width="1.0709"
          height="0.761084"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur stdDeviation="0.1" result="effect1_foregroundBlur_11490_5620" />
        </filter>
        <filter
          id="filter31_f_11490_5620"
          x="21.6025"
          y="10.8352"
          width="1.60359"
          height="1.77645"
          filterUnits="userSpaceOnUse"
          colorInterpolationFilters="sRGB"
        >
          <feFlood floodOpacity="0" result="BackgroundImageFix" />
          <feBlend
            mode="normal"
            in="SourceGraphic"
            in2="BackgroundImageFix"
            result="shape"
          />
          <feGaussianBlur
            stdDeviation="0.23"
            result="effect1_foregroundBlur_11490_5620"
          />
        </filter>
        <radialGradient
          id="paint0_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(13.3971 19.0426) scale(2.60784 2.53125)"
        >
          <stop />
          <stop offset="1" stopOpacity="0.25" />
        </radialGradient>
        <radialGradient
          id="paint1_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(22.2588 20.5064) scale(3.23922 2.53125)"
        >
          <stop />
          <stop offset="1" stopOpacity="0.25" />
        </radialGradient>
        <radialGradient
          id="paint2_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(17.9308 19.9253) scale(1.28333 1.40625)"
        >
          <stop />
          <stop offset="1" stopOpacity="0.25" />
        </radialGradient>
        <linearGradient
          id="paint3_linear_11490_5620"
          x1="8.18157"
          y1="29.142"
          x2="14.0313"
          y2="38.7217"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#B98309" />
          <stop offset="1" stopColor="#382605" />
        </linearGradient>
        <linearGradient
          id="paint4_linear_11490_5620"
          x1="13.8487"
          y1="31.648"
          x2="15.6929"
          y2="35.0394"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#EBC40C" />
          <stop offset="1" stopColor="#EBC40C" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          id="paint5_linear_11490_5620"
          x1="25.1664"
          y1="31.8067"
          x2="25.6371"
          y2="35.1463"
          gradientUnits="userSpaceOnUse"
        >
          <stop />
          <stop offset="1" stopOpacity="0" />
        </linearGradient>
        <linearGradient
          id="paint6_linear_11490_5620"
          x1="25.7946"
          y1="37.5807"
          x2="31.6845"
          y2="28.2612"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#3E2A06" />
          <stop offset="1" stopColor="#AD780A" />
        </linearGradient>
        <linearGradient
          id="paint7_linear_11490_5620"
          x1="27.3472"
          y1="27.4068"
          x2="27.1715"
          y2="28.9485"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#F3CD0C" />
          <stop offset="1" stopColor="#F3CD0C" stopOpacity="0" />
        </linearGradient>
        <radialGradient
          id="paint8_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(28.294 29.3559) rotate(15.3511) scale(2.70292 2.89768)"
        >
          <stop stopColor="#110800" />
          <stop offset="0.59" stopColor="#A65A00" stopOpacity="0.8" />
          <stop offset="1" stopColor="#FF921E" stopOpacity="0" />
        </radialGradient>
        <radialGradient
          id="paint9_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(28.294 28.7032) rotate(-2.47935) scale(2.70953 2.0896)"
        >
          <stop stopColor="#110800" />
          <stop offset="0.59" stopColor="#A65A00" stopOpacity="0.8" />
          <stop offset="1" stopColor="#FF921E" stopOpacity="0" />
        </radialGradient>
        <radialGradient
          id="paint10_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(30.345 26.8375) rotate(24.0124) scale(0.957684 0.449633)"
        >
          <stop stopColor="#7C7C7C" />
          <stop offset="1" stopColor="#7C7C7C" stopOpacity="0.33" />
        </radialGradient>
        <linearGradient
          id="paint11_linear_11490_5620"
          x1="27.7427"
          y1="26.41"
          x2="28.0968"
          y2="26.3953"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#7C7C7C" />
          <stop offset="1" stopColor="#7C7C7C" stopOpacity="0.33" />
        </linearGradient>
        <radialGradient
          id="paint12_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(16.8717 9.22958) rotate(-0.614731) scale(1.40549 2.20499)"
        >
          <stop stopColor="#FEFEFC" />
          <stop offset="0.75" stopColor="#FEFEFC" />
          <stop offset="1" stopColor="#D4D4D4" />
        </radialGradient>
        <linearGradient
          id="paint13_linear_11490_5620"
          x1="16.5696"
          y1="8.55871"
          x2="17.2858"
          y2="9.80812"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#757574" stopOpacity="0" />
          <stop offset="0.25" stopColor="#757574" />
          <stop offset="0.5" stopColor="#757574" />
          <stop offset="1" stopColor="#757574" stopOpacity="0" />
        </linearGradient>
        <radialGradient
          id="paint14_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(16.6523 8.15105) rotate(-9.57537) scale(0.858406 0.810874)"
        >
          <stop stopColor="#C8C8C8" />
          <stop offset="1" stopColor="#797978" />
        </radialGradient>
        <linearGradient
          id="paint15_linear_11490_5620"
          x1="16.4741"
          y1="6.57173"
          x2="18.0059"
          y2="8.09833"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#646464" stopOpacity="0" />
          <stop offset="0.31" stopColor="#646464" stopOpacity="0.58" />
          <stop offset="0.47" stopColor="#646464" />
          <stop offset="0.73" stopColor="#646464" stopOpacity="0.26" />
          <stop offset="1" stopColor="#646464" stopOpacity="0" />
        </linearGradient>
        <radialGradient
          id="paint16_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(21.2054 9.22972) rotate(-1.84417) scale(1.8722 2.20495)"
        >
          <stop stopColor="#FEFEFC" />
          <stop offset="0.75" stopColor="#FEFEFC" />
          <stop offset="1" stopColor="#D4D4D4" />
        </radialGradient>
        <linearGradient
          id="paint17_linear_11490_5620"
          x1="21.1795"
          y1="8.64452"
          x2="21.9968"
          y2="9.58966"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#949494" stopOpacity="0.39" />
          <stop offset="0.5" stopColor="#949494" />
          <stop offset="1" stopColor="#949494" stopOpacity="0.39" />
        </linearGradient>
        <linearGradient
          id="paint18_linear_11490_5620"
          x1="20.4974"
          y1="7.09471"
          x2="23.0565"
          y2="8.55652"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#747474" />
          <stop offset="0.13" stopColor="#8C8C8C" />
          <stop offset="0.25" stopColor="#A4A4A4" />
          <stop offset="0.5" stopColor="#D4D4D4" />
          <stop offset="0.62" stopColor="#D4D4D4" />
          <stop offset="1" stopColor="#7C7C7C" />
        </linearGradient>
        <linearGradient
          id="paint19_linear_11490_5620"
          x1="21.3556"
          y1="6.4382"
          x2="23.0768"
          y2="8.02495"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#646464" stopOpacity="0" />
          <stop offset="0.31" stopColor="#646464" stopOpacity="0.58" />
          <stop offset="0.47" stopColor="#646464" />
          <stop offset="0.73" stopColor="#646464" stopOpacity="0.26" />
          <stop offset="1" stopColor="#646464" stopOpacity="0" />
        </linearGradient>
        <radialGradient
          id="paint20_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(18.4023 10.4545) rotate(-36.6633) scale(1.58362 1.44731)"
        >
          <stop stopColor="#020204" />
          <stop offset="0.73" stopColor="#020204" />
          <stop offset="1" stopColor="#5C5C5C" />
        </radialGradient>
        <radialGradient
          id="paint21_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(20.0665 11.9296) rotate(-22.8939) scale(3.7399 2.67209)"
        >
          <stop stopColor="#D2940A" />
          <stop offset="0.75" stopColor="#D89C08" />
          <stop offset="0.87" stopColor="#B67E07" />
          <stop offset="1" stopColor="#946106" />
        </radialGradient>
        <linearGradient
          id="paint22_linear_11490_5620"
          x1="15.7177"
          y1="11.74"
          x2="22.3992"
          y2="11.6891"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#AD780A" />
          <stop offset="0.12" stopColor="#D89E08" />
          <stop offset="0.25" stopColor="#EDB80B" />
          <stop offset="0.39" stopColor="#EBC80D" />
          <stop offset="0.53" stopColor="#F5D838" />
          <stop offset="0.77" stopColor="#F6D811" />
          <stop offset="1" stopColor="#F5CD31" />
        </linearGradient>
        <radialGradient
          id="paint23_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(17.6418 10.4206) scale(0.181177 0.199688)"
        >
          <stop stopColor="#3A2903" />
          <stop offset="0.55" stopColor="#735208" />
          <stop offset="1" stopColor="#AC8C04" />
        </radialGradient>
        <radialGradient
          id="paint24_radial_11490_5620"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(19.3635 10.3952) scale(0.381569 0.227813)"
        >
          <stop stopColor="#3A2903" />
          <stop offset="0.55" stopColor="#735208" />
          <stop offset="1" stopColor="#AC8C04" />
        </radialGradient>
        <linearGradient
          id="paint25_linear_11490_5620"
          x1="22.3951"
          y1="11.4906"
          x2="22.3951"
          y2="11.9969"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#F5CE2D" />
          <stop offset="1" stopColor="#D79B08" />
        </linearGradient>
      </defs>
    </svg>
  );
};
