import { Mode, THEME_DARK } from '@/theme/ThemeContext';

export const SeverityMedium = ({ theme }: { theme: Mode }) => (
  <svg
    width="100%"
    height="100%"
    viewBox="0 0 18 18"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M15.1163 12.7448C15.1163 12.74 15.1151 12.7352 15.1128 12.731L10.037 3.39068C9.83106 3.01121 9.43393 2.7749 9.00216 2.7749C8.57039 2.7749 8.17325 3.01121 7.96728 3.39068L2.89165 12.7375C2.68739 13.1032 2.69282 13.5499 2.9059 13.9106C3.11898 14.2712 3.50763 14.4915 3.92652 14.4891H14.0815C14.4959 14.4886 14.8797 14.2703 15.0918 13.9143C15.3027 13.5603 15.3132 13.122 15.1198 12.7585C15.1175 12.7543 15.1163 12.7496 15.1163 12.7448Z"
      fill="currentColor"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M9.00002 4.9967C8.66865 4.9967 8.40002 5.22964 8.40002 5.51697V9.97643C8.40002 10.2638 8.66865 10.4967 9.00002 10.4967C9.3314 10.4967 9.60002 10.2638 9.60002 9.97643V5.51697C9.60002 5.22964 9.3314 4.9967 9.00002 4.9967ZM8.25 12.2533C8.25 12.6675 8.58579 13.0033 9 13.0033C9.41421 13.0033 9.75 12.6675 9.75 12.2533C9.75 11.839 9.41421 11.5033 9 11.5033C8.58579 11.5033 8.25 11.839 8.25 12.2533Z"
      fill={theme === THEME_DARK ? 'black' : 'white'}
    />
  </svg>
);
