import { Mode, THEME_DARK } from '@/theme/ThemeContext';

export const SeverityHigh = ({ theme }: { theme: Mode }) => (
  <svg
    width="100%"
    height="100%"
    viewBox="0 0 18 18"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M3.13852 10.4143C2.35747 9.63322 2.35747 8.36689 3.13852 7.58585L7.58573 3.13864C8.36677 2.35759 9.6331 2.3576 10.4142 3.13864L14.8614 7.58585C15.6424 8.3669 15.6424 9.63322 14.8614 10.4143L10.4141 14.8615C9.6331 15.6425 8.36677 15.6425 7.58572 14.8615L3.13852 10.4143Z"
      fill="currentColor"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M9.00002 4.9967C8.66865 4.9967 8.40002 5.22964 8.40002 5.51697V9.97643C8.40002 10.2638 8.66865 10.4967 9.00002 10.4967C9.3314 10.4967 9.60002 10.2638 9.60002 9.97643V5.51697C9.60002 5.22964 9.3314 4.9967 9.00002 4.9967ZM8.25 12.2533C8.25 12.6675 8.58579 13.0033 9 13.0033C9.41421 13.0033 9.75 12.6675 9.75 12.2533C9.75 11.839 9.41421 11.5033 9 11.5033C8.58579 11.5033 8.25 11.839 8.25 12.2533Z"
      fill={theme === THEME_DARK ? 'black' : 'white'}
    />
  </svg>
);
