import { Mode, THEME_DARK } from '@/theme/ThemeContext';

export const SeverityCritical = ({ theme }: { theme: Mode }) => (
  <svg
    width="100%"
    height="100%"
    viewBox="0 0 18 18"
    fill="none"
    xmlns="http://www.w3.org/2000/svg"
  >
    <path
      d="M8.41222 2.9384C8.7627 2.68376 9.2373 2.68376 9.58779 2.9384L14.8318 6.74844C15.1823 7.00308 15.329 7.45445 15.1951 7.86647L13.1921 14.0312C13.0582 14.4433 12.6742 14.7222 12.241 14.7222H5.75899C5.32577 14.7222 4.94181 14.4433 4.80794 14.0312L2.80488 7.86647C2.67101 7.45445 2.81767 7.00308 3.16815 6.74844L8.41222 2.9384Z"
      fill="currentColor"
    />
    <path
      fillRule="evenodd"
      clipRule="evenodd"
      d="M9.00002 5.48694C8.66865 5.48694 8.40002 5.71987 8.40002 6.00721V10.4667C8.40002 10.754 8.66865 10.9869 9.00002 10.9869C9.3314 10.9869 9.60002 10.754 9.60002 10.4667V6.00721C9.60002 5.71987 9.3314 5.48694 9.00002 5.48694ZM8.25 12.7435C8.25 13.1577 8.58579 13.4935 9 13.4935C9.41421 13.4935 9.75 13.1577 9.75 12.7435C9.75 12.3293 9.41421 11.9935 9 11.9935C8.58579 11.9935 8.25 12.3293 8.25 12.7435Z"
      fill={theme === THEME_DARK ? 'black' : 'white'}
    />
  </svg>
);
