import { useRouteError } from 'react-router-dom';

const SVG404 = () => {
  return (
    <svg
      width="100%"
      height="100%"
      viewBox="0 0 449 407"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M225.594 406.793C348.456 406.793 448.056 354.931 448.056 290.956C448.056 226.98 348.456 175.118 225.594 175.118C102.731 175.118 3.13086 226.98 3.13086 290.956C3.13086 354.931 102.731 406.793 225.594 406.793Z"
        fill="#16253B"
      />
      <path
        d="M368.115 306.09C400.885 306.09 427.45 290.752 427.45 271.831C427.45 252.91 400.885 237.571 368.115 237.571C335.344 237.571 308.779 252.91 308.779 271.831C308.779 290.752 335.344 306.09 368.115 306.09Z"
        fill="#0B121E"
      />
      <path
        d="M129.155 251.497C151.855 264.605 152.78 286.243 130.07 299.351C107.36 312.459 69.6438 312.069 46.934 298.962C24.2242 285.854 24.2339 264.605 46.934 251.497C69.6341 238.389 106.435 238.389 129.155 251.497Z"
        fill="#0B121E"
      />
      <path
        d="M314.32 322.13L239.802 279.106C238.495 278.443 237.05 278.098 235.585 278.098C234.12 278.098 232.675 278.443 231.368 279.106L156.851 322.13C154.523 323.474 154.523 325.655 156.851 326.999L190.789 346.593L159.09 364.891C152.653 368.602 142.175 368.602 135.718 364.891L85.8581 336.105C83.1118 334.517 81.5927 332.521 81.5927 330.495C81.5927 328.47 83.1118 326.464 85.8581 324.876L130.041 299.362C130.274 299.24 130.479 299.073 130.646 298.869C130.812 298.666 130.935 298.431 131.009 298.179C131.082 297.926 131.103 297.662 131.072 297.401C131.04 297.141 130.956 296.889 130.824 296.661C130.693 296.434 130.517 296.236 130.307 296.078C130.097 295.92 129.857 295.807 129.602 295.744C129.346 295.682 129.081 295.672 128.822 295.714C128.563 295.757 128.315 295.852 128.093 295.992L83.9299 321.487C79.9274 323.805 77.7168 326.999 77.7168 330.486C77.7168 333.972 79.9274 337.156 83.9299 339.474L133.79 368.261C138.006 370.434 142.681 371.567 147.424 371.567C152.167 371.567 156.841 370.434 161.058 368.261L194.704 348.842L231.407 370.023C232.714 370.686 234.159 371.032 235.624 371.032C237.089 371.032 238.534 370.686 239.841 370.023L314.359 326.999C316.647 325.655 316.647 323.474 314.32 322.13Z"
        fill="#0B121E"
      />
      <path
        d="M399.472 255.742C399.472 255.742 402.179 215.639 401.419 200.856C400.786 189.17 399.199 184.301 398.868 181.662C398.868 181.662 395.995 154.395 395.761 131.13C395.645 119.95 394.612 112.004 388.487 98.7207L349.115 108.138C348.316 114.039 345.609 153.285 344.966 188.177C344.411 218.726 345.278 245.468 345.278 245.468V247.075C345.278 248.867 344.888 250.113 343.739 252.976C342.303 256.665 340.24 260.078 337.643 263.065C336.835 263.941 331.216 268.85 330.476 269.882C328.06 272.696 333.066 274.284 336.776 273.777C340.672 273.251 346.768 271.761 348.462 269.385C349.611 267.788 350.478 262.228 351.656 260.621C355.639 255.187 357.276 252.83 357.305 251.116C357.363 247.98 356.282 246.744 355.893 244.971C356.214 241.271 364.209 210.838 364.346 200.058C364.414 194.926 364.063 187.856 364.063 187.856L370.257 152.291C372.652 161.173 376.859 183.22 378.281 191.683C380.005 202.025 384.514 228.572 387.182 244.406C388.204 250.512 388.682 253.599 389.13 256.433L389.237 257.641C389.324 259.179 390.444 275.637 391.048 279.065C392.314 286.262 398.712 285.356 399.735 279.533C400.611 274.585 399.52 259.238 399.491 257.358L399.472 255.742Z"
        fill="#FFA8A7"
      />
      <path
        d="M399.472 255.741C401.283 255.741 400.095 262.763 400.563 267.252C401.059 272.072 402.637 275.598 403.094 279.542C403.709 282.989 403.178 286.542 401.585 289.66C400.329 292.581 393.999 296.477 391.593 292.377C389.188 288.277 388.672 283.534 388.954 279.035C389.237 274.536 388.954 271.517 389.042 267.982C389.13 264.866 386.841 256.91 389.188 256.462L389.295 257.669C390.142 259.354 398.693 259.685 399.55 257.406L399.472 255.741Z"
        fill="#37474F"
      />
      <path
        d="M357.714 254.943C358.269 257.193 357.714 263.367 357.714 263.367C357.714 263.367 356.74 265.5 353.263 266.912L351.705 258.323L357.714 254.943Z"
        fill="#263238"
      />
      <path
        d="M353.244 266.911L345.59 264.399L343.739 257.602L352.348 261.955L353.244 266.911Z"
        fill="black"
      />
      <path
        d="M345.278 247.074V245.468C344.236 245.974 341.948 254.359 338.851 260.075C336.027 265.324 330.427 268.246 328.606 270.534C326.171 273.582 330.904 277.526 338.49 275.9C342.259 275.092 347.966 272.686 349.514 270.145C351.063 267.603 351.579 262.928 352.845 261.059C354.111 259.189 357.12 257.037 357.714 254.914C358.209 252.997 358.209 250.987 357.714 249.071C357.12 247.123 356.594 244.796 355.932 245.01V246.48C355.425 247.513 353.585 248.72 349.758 248.934C347.888 249.022 346.116 248.74 345.278 247.074Z"
        fill="#37474F"
      />
      <path
        d="M348.316 107.631C348.316 107.631 345.716 136.525 344.879 162.107C344.041 187.69 344.791 220.703 344.791 220.703C344.791 220.703 347.43 222.592 353.244 222.855C359.058 223.118 361.035 221.18 361.035 221.18C361.035 221.18 364.589 209.582 365.144 201.421C365.497 197.003 365.497 192.565 365.144 188.148L370.335 154.005C370.335 154.005 376.918 187.622 377.668 191.683C378.418 195.743 384.718 231.668 384.718 231.668C384.718 231.668 387.192 233.947 393.541 233.83C399.16 233.723 400.787 231.707 400.787 231.707C400.787 231.707 402.14 209.679 401.829 200.272C401.566 191.975 399.667 185.372 399.287 179.987C398.907 174.602 398.693 143.955 398.313 132.269C397.933 120.583 396.96 110.552 386.958 96.4902L348.316 107.631Z"
        fill="#455A64"
      />
      <path
        d="M370.374 154.033L366.05 132.609C366.05 132.609 358.522 130.661 355.007 126.045C355.007 126.045 355.981 131.148 363.771 134.41L368.368 155.718L366.771 177.746L370.374 154.033Z"
        fill="#37474F"
      />
      <path
        d="M293.304 102.303C296.078 102.726 298.911 102.516 301.592 101.689C300.414 101.101 299.312 100.371 298.31 99.5176C297.85 99.1481 297.552 98.6141 297.48 98.0287C297.407 97.4434 297.565 96.8527 297.92 96.3819C298.281 95.9924 299.177 96.898 301.202 97.4726C303.793 98.203 305.672 98.3588 308.165 99.8001C309.106 100.347 310.211 100.541 311.281 100.345C317.358 99.206 331.527 92.5547 338.023 89.0879C339.347 83.6831 341.646 75.7366 344.479 65.823C347.099 56.6884 351.296 52.6957 357.996 52.8418L357.032 72.6788C357.032 72.6788 353.838 86.3806 349.884 97.57C349.193 99.5176 346.417 101.787 341.334 103.676C334.751 106.12 326.804 108.428 317.095 111.087C313.161 112.207 309.142 113.005 305.078 113.473C294.814 114.349 290.88 111.525 289.497 109.499C285.562 103.91 287.89 101.222 293.304 102.303Z"
        fill="#FFA8A7"
      />
      <path
        d="M375.263 52.6958L384.631 53.4164C383.824 57.2239 384.053 61.1779 385.293 64.8671C386.533 68.5562 388.739 71.8456 391.681 74.3928L387.504 91.2207C387.64 93.3047 391.087 100.316 394.428 107.854C388.146 116.268 357.334 119.141 347.284 111.749C348.833 103.822 349.992 97.8038 350.303 94.7947L349.797 83.9169C337.195 73.5845 352.397 57.8376 357.996 52.8321L365.028 52.5205L375.263 52.6958Z"
        fill="#489CFF"
      />
      <path
        d="M414.713 136.534C414.033 136.003 413.494 135.314 413.144 134.526C412.794 133.738 412.644 132.875 412.706 132.015C412.872 130.447 413.232 128.48 413.885 127.721C414.537 126.961 418.627 121.401 420.439 124.634C422.386 128.159 421.987 129.59 421.987 129.59L414.713 136.534Z"
        fill="#F28F8F"
      />
      <path
        d="M402.091 210.857C397.695 210.71 393.414 209.414 389.675 207.098L341.051 179.012C333.543 174.679 327.418 164.093 327.418 155.416V114.622C327.413 113.257 327.049 111.917 326.363 110.737C325.678 109.556 324.694 108.576 323.51 107.896C322.327 107.215 320.985 106.858 319.62 106.859C318.255 106.86 316.914 107.22 315.731 107.903L298.709 117.758C298.487 117.899 298.239 117.994 297.98 118.036C297.721 118.079 297.456 118.069 297.201 118.006C296.945 117.944 296.706 117.83 296.495 117.673C296.285 117.515 296.109 117.317 295.978 117.089C295.846 116.862 295.762 116.61 295.731 116.349C295.699 116.088 295.72 115.824 295.793 115.572C295.867 115.319 295.99 115.085 296.156 114.881C296.323 114.678 296.528 114.51 296.761 114.389L313.833 104.524C315.607 103.499 317.621 102.959 319.67 102.958C321.72 102.957 323.733 103.495 325.509 104.518C327.285 105.541 328.761 107.013 329.788 108.787C330.815 110.56 331.358 112.573 331.362 114.622V155.416C331.362 162.72 336.718 171.971 343.048 175.643L391.671 203.709C397.894 207.302 403.669 207.925 407.915 205.481C412.161 203.037 414.508 197.69 414.508 190.533V138.452C414.508 129.629 420.146 119.462 427.343 115.304L439.214 108.487C439.435 108.346 439.683 108.252 439.943 108.209C440.202 108.166 440.467 108.177 440.722 108.239C440.977 108.302 441.217 108.415 441.427 108.573C441.637 108.73 441.813 108.929 441.945 109.156C442.076 109.384 442.16 109.635 442.192 109.896C442.224 110.157 442.202 110.421 442.129 110.673C442.056 110.926 441.933 111.161 441.766 111.364C441.6 111.567 441.394 111.735 441.161 111.857L429.29 118.673C423.389 122.082 418.403 131.129 418.403 138.442V190.523C418.403 199.151 415.365 205.656 409.862 208.841C407.498 210.194 404.815 210.89 402.091 210.857Z"
        fill="#37474F"
      />
      <path
        d="M318.079 120.573V123.757C318.079 128.85 314.505 135.054 310.084 137.595L280.596 154.628L250.612 137.313V111.351L279.691 97.8921C284.316 95.7594 291.639 96.0905 296.061 98.6323L310.064 106.725C314.476 109.276 318.079 115.48 318.079 120.573Z"
        fill="#37474F"
      />
      <path
        d="M279.69 97.8921C284.316 95.7594 291.639 96.0905 296.061 98.6323L310.064 106.725C314.476 109.267 314.301 113.064 309.675 115.207L280.567 128.646L250.573 111.341L279.69 97.8921Z"
        fill="#455A64"
      />
      <path
        opacity="0.15"
        d="M283.4 122.413C284.562 123.171 285.529 124.192 286.222 125.394C286.916 126.595 287.317 127.942 287.393 129.328V150.684L280.576 154.579L250.592 137.264V111.351L258.188 107.845L283.4 122.413Z"
        fill="black"
      />
      <path
        d="M248.031 106.88C248.481 106.671 248.978 106.586 249.471 106.634C249.964 106.682 250.435 106.861 250.836 107.153L280.324 124.185C281.487 124.944 282.455 125.966 283.149 127.169C283.843 128.372 284.243 129.722 284.316 131.109V156.507C284.369 157.001 284.289 157.5 284.084 157.952C283.878 158.404 283.555 158.793 283.148 159.078C282.466 159.458 280.061 160.85 279.389 161.249C278.938 161.458 278.439 161.543 277.945 161.495C277.45 161.447 276.977 161.268 276.574 160.977L247.077 143.944C245.915 143.186 244.948 142.165 244.255 140.964C243.561 139.763 243.16 138.415 243.084 137.03V111.633C243.032 111.138 243.112 110.639 243.316 110.186C243.519 109.733 243.839 109.341 244.243 109.052L248.031 106.88Z"
        fill="#37474F"
      />
      <path
        d="M276.574 126.347L247.077 109.324C244.876 108.048 243.084 109.081 243.084 111.632V137.03C243.16 138.415 243.561 139.763 244.254 140.964C244.948 142.165 245.915 143.186 247.077 143.944L276.574 160.976C278.775 162.252 280.567 161.22 280.567 158.668V133.271C280.491 131.884 280.09 130.535 279.396 129.332C278.703 128.13 277.736 127.107 276.574 126.347Z"
        fill="#455A64"
      />
      <path
        d="M241.643 155.913V160.305C241.643 162.087 242.256 163.324 243.269 163.908L245.918 165.437C246.553 165.746 247.259 165.876 247.963 165.815C248.666 165.753 249.339 165.501 249.91 165.086L274.256 151.005V133.671L271.607 132.142L247.213 146.223C245.588 147.287 244.238 148.719 243.27 150.402C242.302 152.086 241.744 153.974 241.643 155.913ZM252.676 150.479C252.769 150.796 252.821 151.123 252.832 151.453C252.762 152.754 252.387 154.021 251.735 155.149C251.084 156.278 250.175 157.237 249.083 157.948C248.779 158.126 248.451 158.257 248.109 158.338C248.024 158.02 247.978 157.693 247.973 157.364C248.043 156.063 248.419 154.796 249.07 153.668C249.722 152.539 250.63 151.58 251.722 150.868C252.024 150.703 252.344 150.573 252.676 150.479Z"
        fill="#489CFF"
      />
      <path
        opacity="0.2"
        d="M245.781 165.34C245.832 165.385 245.888 165.424 245.947 165.457L245.85 165.398L243.288 163.908C242.266 163.344 241.662 162.107 241.662 160.315V155.923C241.726 153.971 242.293 152.069 243.308 150.401L245.957 151.93C244.952 153.602 244.389 155.502 244.321 157.452V161.844C244.249 162.981 244.615 164.103 245.343 164.98C245.474 165.117 245.622 165.238 245.781 165.34Z"
        fill="black"
      />
      <path
        opacity="0.5"
        d="M274.257 133.671L249.911 147.752C248.259 148.782 246.898 150.216 245.957 151.92L243.308 150.391C244.248 148.69 245.606 147.256 247.252 146.223L271.647 132.142L274.257 133.671Z"
        fill="white"
      />
      <path
        opacity="0.2"
        d="M252.832 151.453C252.831 151.101 252.785 150.751 252.696 150.411C254.302 149.973 255.481 150.976 255.481 152.982C255.411 154.282 255.036 155.548 254.386 156.676C253.737 157.804 252.831 158.764 251.741 159.478C250.008 160.451 248.528 159.955 248.119 158.338C248.463 158.263 248.792 158.131 249.092 157.949C250.181 157.235 251.087 156.275 251.736 155.147C252.386 154.018 252.761 152.753 252.832 151.453Z"
        fill="black"
      />
      <path
        d="M219.157 142.923V147.324C219.157 149.097 219.77 150.343 220.783 150.918L223.432 152.457C224.066 152.759 224.77 152.884 225.469 152.819C226.169 152.754 226.838 152.501 227.405 152.086L251.751 137.995V120.69L249.102 119.151L224.756 133.233C223.128 134.295 221.773 135.726 220.8 137.409C219.827 139.093 219.264 140.981 219.157 142.923ZM230.19 137.459C230.279 137.8 230.325 138.15 230.327 138.501C230.256 139.803 229.88 141.069 229.229 142.198C228.577 143.326 227.669 144.285 226.577 144.997C226.269 145.164 225.942 145.295 225.604 145.386C225.511 145.054 225.465 144.709 225.467 144.364C225.537 143.064 225.912 141.798 226.562 140.67C227.211 139.541 228.117 138.582 229.207 137.868C229.514 137.687 229.845 137.549 230.19 137.459Z"
        fill="#489CFF"
      />
      <path
        opacity="0.2"
        d="M223.549 152.525H223.5H223.432L220.783 150.977C219.761 150.402 219.157 149.165 219.157 147.374V142.982C219.167 142.043 219.315 141.112 219.595 140.216C219.888 139.258 220.29 138.336 220.793 137.47L223.442 138.989C223.191 139.423 222.966 139.872 222.77 140.333C222.165 141.642 221.834 143.06 221.796 144.501V148.893C221.713 150.024 222.061 151.144 222.77 152.029C222.999 152.237 223.263 152.405 223.549 152.525Z"
        fill="black"
      />
      <path
        opacity="0.5"
        d="M251.781 120.69L227.435 134.772C225.781 135.798 224.419 137.234 223.481 138.94L220.832 137.421C221.756 135.718 223.096 134.277 224.727 133.233L249.073 119.151L251.781 120.69Z"
        fill="white"
      />
      <path
        opacity="0.2"
        d="M230.317 138.491C230.319 138.142 230.276 137.796 230.19 137.458C231.787 137.01 232.975 138.023 232.975 140.029C232.906 141.329 232.531 142.595 231.881 143.723C231.231 144.852 230.325 145.811 229.236 146.525C227.493 147.499 226.022 147.002 225.613 145.376C225.958 145.303 226.288 145.171 226.587 144.986C227.676 144.273 228.581 143.313 229.229 142.184C229.877 141.056 230.25 139.79 230.317 138.491Z"
        fill="black"
      />
      <path
        d="M226.538 126.668C226.214 126.669 225.898 126.561 225.642 126.362C225.386 126.162 225.205 125.883 225.126 125.568L221.231 110.298C221.134 109.922 221.19 109.523 221.388 109.189C221.585 108.855 221.907 108.613 222.283 108.516C222.658 108.419 223.057 108.476 223.391 108.673C223.726 108.87 223.968 109.192 224.065 109.568L227.96 124.847C228.01 125.033 228.022 125.226 227.995 125.416C227.969 125.607 227.905 125.79 227.807 125.955C227.709 126.12 227.579 126.264 227.425 126.378C227.27 126.492 227.095 126.574 226.908 126.62C226.787 126.651 226.663 126.667 226.538 126.668Z"
        fill="#E0E0E0"
      />
      <path
        d="M215.573 133.038C215.244 133.039 214.925 132.929 214.667 132.727L200.167 121.265C200.007 121.149 199.872 121.002 199.77 120.833C199.668 120.664 199.602 120.477 199.574 120.281C199.547 120.086 199.56 119.887 199.612 119.696C199.664 119.506 199.753 119.328 199.876 119.173C199.998 119.019 200.151 118.89 200.324 118.796C200.498 118.702 200.688 118.644 200.885 118.626C201.081 118.607 201.279 118.629 201.467 118.689C201.655 118.749 201.829 118.847 201.978 118.976L216.478 130.428C216.782 130.67 216.977 131.021 217.023 131.406C217.068 131.79 216.96 132.178 216.722 132.483C216.586 132.658 216.411 132.799 216.212 132.895C216.013 132.991 215.794 133.04 215.573 133.038Z"
        fill="#E0E0E0"
      />
      <path
        d="M195.59 147.022C195.203 147.037 194.825 146.896 194.541 146.632C194.257 146.369 194.09 146.003 194.076 145.615C194.061 145.228 194.202 144.851 194.466 144.567C194.73 144.283 195.095 144.115 195.483 144.101L212.437 142.786C212.629 142.77 212.821 142.793 213.004 142.852C213.187 142.911 213.356 143.006 213.502 143.131C213.648 143.256 213.768 143.408 213.854 143.58C213.94 143.751 213.992 143.939 214.005 144.13C214.032 144.516 213.906 144.896 213.655 145.19C213.403 145.483 213.046 145.666 212.661 145.698L195.707 147.013L195.59 147.022Z"
        fill="#E0E0E0"
      />
      <path
        d="M427.966 120.64C427.636 117.042 427.103 113.466 426.369 109.928C424.154 101.627 421.201 93.5416 417.546 85.7669C415.92 82.6603 412.249 78.132 409.648 74.3048C405.967 68.9 403.377 65.8714 400.582 62.2001C394.427 54.1465 391.818 53.679 384.631 53.4355C383.657 55.9967 381.436 66.4947 388.633 74.9768L404.059 91.2398C404.935 92.6519 414.362 108.769 415.93 114.719C416.201 115.777 416.069 116.898 415.56 117.864C414.327 120.592 413.422 123.455 412.862 126.395C412.404 128.46 411.177 130.096 411.596 130.417C412.113 130.763 412.732 130.924 413.353 130.875C413.973 130.825 414.558 130.568 415.014 130.145C416.116 128.963 417.014 127.607 417.673 126.132C417.962 126.113 418.253 126.155 418.525 126.254C418.798 126.353 419.047 126.508 419.257 126.708C419.466 126.909 419.632 127.151 419.743 127.419C419.855 127.687 419.909 127.975 419.903 128.265C419.991 129.463 419.445 131.128 419.026 133.202C418.949 133.611 418.851 134.079 418.666 135.208C418.506 135.971 418.415 136.747 418.393 137.526C420.341 137.886 422.376 136.698 425.649 133.631C428.599 130.768 428.794 127.009 427.966 120.64Z"
        fill="#FFA8A7"
      />
      <path
        d="M376.937 47.9635C376.996 46.0159 383.326 41.4583 386.53 36.6086C389.451 32.1095 393.648 19.7418 383.812 15.788C383.812 15.788 385.935 9.85738 382.079 6.36131C378.223 2.86525 373.032 5.02716 372.214 6.48791C371.72 4.66684 370.651 3.05389 369.167 1.88887C367.683 0.723858 365.862 0.0689948 363.975 0.0216458C362.133 -0.117095 360.302 0.414519 358.821 1.5186C357.339 2.62269 356.306 4.2249 355.912 6.0302C354.356 5.3565 352.615 5.23849 350.982 5.69595C349.349 6.15342 347.923 7.15853 346.943 8.5427C343.33 13.519 348.121 18.0765 348.121 18.0765C347.5 18.4959 347.004 19.0762 346.687 19.7554C346.37 20.4346 346.243 21.1872 346.32 21.9329C346.602 24.0364 348.618 24.5525 348.852 25.6043C348.897 25.8243 348.869 26.0532 348.773 26.256C348.676 26.4588 348.516 26.6245 348.316 26.7281C348.117 26.8316 347.889 26.8673 347.668 26.8297C347.446 26.7921 347.243 26.6832 347.089 26.5197C347.142 26.7943 347.248 27.0558 347.402 27.2893C347.556 27.5227 347.754 27.7234 347.986 27.88C348.217 28.0365 348.478 28.1458 348.752 28.2014C349.026 28.2571 349.308 28.2581 349.582 28.2044C351.851 28.0778 353.877 24.9908 353.877 24.9908L376.937 47.9635Z"
        fill="#263238"
      />
      <path
        d="M356.292 15.165C353.37 16.431 350.615 20.8814 350.653 33.3271C350.653 43.8737 353.926 46.542 355.523 47.3308C357.12 48.1196 360.343 47.7106 363.45 47.2334V53.3004C363.45 53.3004 357.831 60.2731 362.865 63.7399C375.837 61.4709 376.83 52.9596 376.83 52.9596L377.064 39.7349C377.064 39.7349 378.846 41.6046 381.933 38.8584C384.523 36.5894 385.458 32.7038 383.511 30.5614C381.563 28.4189 379.07 28.2534 376.811 30.6393C376.811 30.6393 372.672 30.9119 366.449 27.0069C360.226 23.1018 358.006 19.1383 356.292 15.165Z"
        fill="#FFA8A7"
      />
      <path
        d="M363.761 39.9292C363.774 40.1303 363.747 40.3321 363.682 40.5227C363.616 40.7133 363.513 40.8889 363.379 41.0394C363.245 41.1898 363.082 41.3121 362.901 41.399C362.719 41.486 362.521 41.5358 362.32 41.5457C362.008 41.5708 361.695 41.5019 361.423 41.3478C361.15 41.1936 360.93 40.9614 360.79 40.681C360.651 40.4006 360.599 40.0849 360.64 39.7745C360.682 39.4641 360.816 39.1733 361.024 38.9395C361.232 38.7058 361.506 38.5398 361.81 38.463C362.113 38.3861 362.433 38.402 362.727 38.5084C363.022 38.6149 363.278 38.8072 363.462 39.0604C363.646 39.3136 363.751 39.6162 363.761 39.9292Z"
        fill="#B16668"
      />
      <path
        d="M355.747 29.7239C355.745 29.9983 355.662 30.266 355.509 30.4939C355.356 30.7218 355.14 30.8999 354.887 31.006C354.634 31.1122 354.355 31.1418 354.086 31.0912C353.816 31.0405 353.567 30.9119 353.37 30.7212C353.173 30.5305 353.036 30.2861 352.976 30.0182C352.916 29.7504 352.936 29.471 353.034 29.2145C353.131 28.958 353.302 28.7358 353.524 28.5753C353.747 28.4149 354.012 28.3233 354.286 28.3118C354.475 28.308 354.663 28.3415 354.838 28.4105C355.014 28.4795 355.174 28.5825 355.31 28.7138C355.446 28.8451 355.555 29.0019 355.629 29.1752C355.704 29.3486 355.744 29.5351 355.747 29.7239Z"
        fill="#263238"
      />
      <path
        d="M366.527 30.3668C366.54 30.568 366.513 30.7697 366.448 30.9603C366.382 31.1509 366.279 31.3266 366.145 31.477C366.011 31.6275 365.848 31.7498 365.667 31.8367C365.485 31.9236 365.287 31.9735 365.086 31.9834C364.679 31.986 364.287 31.8281 363.995 31.5437C363.703 31.2593 363.536 30.8715 363.528 30.4642C363.521 30.2673 363.554 30.071 363.623 29.8866C363.693 29.7022 363.798 29.5333 363.933 29.3895C364.067 29.2457 364.229 29.1299 364.409 29.0486C364.588 28.9673 364.782 28.9222 364.979 28.9158C365.176 28.9094 365.372 28.9419 365.557 29.0114C365.741 29.0808 365.91 29.1859 366.054 29.3207C366.197 29.4554 366.313 29.6171 366.395 29.7966C366.476 29.9761 366.521 30.1699 366.527 30.3668Z"
        fill="#263238"
      />
      <path
        d="M354.773 24.1436L351.802 25.8867C351.909 26.0875 352.055 26.2644 352.232 26.4062C352.41 26.5481 352.614 26.6519 352.833 26.7113C353.053 26.7707 353.282 26.7843 353.507 26.7513C353.731 26.7184 353.947 26.6395 354.14 26.5197C354.53 26.2808 354.814 25.9007 354.932 25.4583C355.05 25.0159 354.993 24.5451 354.773 24.1436Z"
        fill="#263238"
      />
      <path
        d="M376.869 28.9258V34.7688C376.494 34.7783 376.122 34.7111 375.774 34.5712C375.426 34.4313 375.111 34.2217 374.847 33.9553C374.584 33.6889 374.377 33.3714 374.241 33.0222C374.105 32.6731 374.041 32.2998 374.055 31.9252C374.058 31.1621 374.35 30.4285 374.872 29.872C375.394 29.3156 376.108 28.9775 376.869 28.9258Z"
        fill="#263238"
      />
      <path
        d="M359.584 28.3311L358.99 36.745L354.549 35.703L359.584 28.3311Z"
        fill="#F28F8F"
      />
      <path
        d="M363.489 47.2526C366.751 46.8728 373.49 45.003 374.59 42.2568C374.154 43.6327 373.312 44.8446 372.175 45.7334C370.14 47.4863 363.479 49.2977 363.479 49.2977L363.489 47.2526Z"
        fill="#F28F8F"
      />
      <path
        d="M57.8799 269.006C60.9669 270.885 65.0668 270.954 68.9329 269.6L71.8544 249.149L58.2207 245.663L57.8799 269.006Z"
        fill="#FFA8A7"
      />
      <path
        d="M79.8788 288.581C80.2197 288.931 80.0152 291.502 79.5964 292.077C79.1777 292.652 76.8307 294.599 72.5069 294.677C68.3876 294.745 64.7162 293.995 62.418 292.33C60.1197 290.665 59.0193 288.922 58.9122 286.565C58.805 284.208 59.1946 281.978 58.1818 280.118C57.169 278.258 55.9517 276.7 55.6401 275.785C55.2743 274.126 55.2743 272.408 55.6401 270.75L79.8788 288.581Z"
        fill="#263238"
      />
      <path
        d="M69.8778 268.743C69.897 269.631 70.0212 270.514 70.2479 271.372C70.7789 273.214 71.5275 274.986 72.478 276.65C72.9507 277.519 73.481 278.355 74.0653 279.153C75.2242 280.702 76.7044 281.997 77.9606 283.487C79.2942 284.899 80.0962 286.73 80.2297 288.668C80.2297 291.901 76.6752 292.806 73.9582 293.137C71.0057 293.498 68.0101 293.188 65.1937 292.232C63.7197 291.761 62.4129 290.874 61.4301 289.679C60.4473 288.484 59.8301 287.03 59.6525 285.493C59.5454 284.587 59.6525 283.682 59.5941 282.776C59.3516 280.698 58.5952 278.713 57.3933 277.001C56.6945 276.01 56.1066 274.946 55.6404 273.826C54.9002 271.791 55.6988 269.58 56.3415 267.623C56.8966 265.938 57.3153 263.903 57.9386 264.098C57.9386 264.439 57.9386 265.198 57.9386 265.198C58.1139 265.578 58.5424 265.851 58.6495 266.299C58.7505 266.761 58.8906 267.214 59.0682 267.652C59.3335 268.33 59.8032 268.909 60.4121 269.308C60.5193 268.09 60.6264 266.873 60.7238 265.666C60.6961 265.474 60.7126 265.278 60.7719 265.093C60.8312 264.909 60.9318 264.74 61.066 264.6C61.2003 264.46 61.3647 264.353 61.5466 264.286C61.7286 264.219 61.9235 264.195 62.1164 264.215C64.4007 263.797 66.7353 263.728 69.0403 264.01C69.2139 264.023 69.3833 264.07 69.5387 264.149C69.6941 264.227 69.8325 264.336 69.946 264.468C70.0649 264.726 70.1022 265.015 70.0531 265.296C69.9326 266.441 69.874 267.591 69.8778 268.743Z"
        fill="#489CFF"
      />
      <path
        opacity="0.2"
        d="M69.8778 268.743C69.897 269.631 70.0212 270.514 70.2479 271.372C70.7789 273.214 71.5275 274.986 72.478 276.65C72.9507 277.519 73.481 278.355 74.0653 279.153C75.2242 280.702 76.7044 281.997 77.9606 283.487C79.2942 284.899 80.0962 286.73 80.2297 288.668C80.2297 291.901 76.6752 292.806 73.9582 293.137C71.0057 293.498 68.0101 293.188 65.1937 292.232C63.7197 291.761 62.4129 290.874 61.4301 289.679C60.4473 288.484 59.8301 287.03 59.6525 285.493C59.5454 284.587 59.6525 283.682 59.5941 282.776C59.3516 280.698 58.5952 278.713 57.3933 277.001C56.6945 276.01 56.1066 274.946 55.6404 273.826C54.9002 271.791 55.6988 269.58 56.3415 267.623C56.8966 265.938 57.3153 263.903 57.9386 264.098C57.9386 264.439 57.9386 265.198 57.9386 265.198C58.1139 265.578 58.5424 265.851 58.6495 266.299C58.7505 266.761 58.8906 267.214 59.0682 267.652C59.3335 268.33 59.8032 268.909 60.4121 269.308C60.5193 268.09 60.6264 266.873 60.7238 265.666C60.6961 265.474 60.7126 265.278 60.7719 265.093C60.8312 264.909 60.9318 264.74 61.066 264.6C61.2003 264.46 61.3647 264.353 61.5466 264.286C61.7286 264.219 61.9235 264.195 62.1164 264.215C64.4007 263.797 66.7353 263.728 69.0403 264.01C69.2139 264.023 69.3833 264.07 69.5387 264.149C69.6941 264.227 69.8325 264.336 69.946 264.468C70.0649 264.726 70.1022 265.015 70.0531 265.296C69.9326 266.441 69.874 267.591 69.8778 268.743Z"
        fill="black"
      />
      <path
        d="M72.877 277.352C71.7279 276.378 69.0401 276.232 67.5599 276.31C66.0603 276.36 64.5972 276.786 63.3042 277.547C63.1132 277.663 62.8879 277.71 62.6662 277.68C62.4445 277.65 62.2399 277.545 62.0869 277.381C61.997 277.286 61.9289 277.173 61.8875 277.049C61.846 276.925 61.8323 276.793 61.8471 276.663C61.862 276.533 61.9051 276.408 61.9734 276.297C62.0418 276.185 62.1337 276.09 62.2427 276.018C63.6738 275.085 65.3362 274.57 67.0438 274.528C70.7248 274.47 71.6987 275.132 71.6987 275.132C71.6987 275.132 73.2958 276.3 72.877 277.352Z"
        fill="#455A64"
      />
      <path
        d="M75.458 280.8C73.9972 279.826 71.0368 279.826 69.5565 279.875C68.0844 279.945 66.6568 280.401 65.4177 281.199C65.2257 281.318 64.9984 281.367 64.7745 281.337C64.5507 281.307 64.3443 281.199 64.1907 281.034C64.0996 280.939 64.0307 280.825 63.989 280.701C63.9474 280.576 63.934 280.443 63.9498 280.313C63.9657 280.182 64.0104 280.057 64.0807 279.946C64.151 279.835 64.2451 279.741 64.3562 279.671C65.7956 278.686 67.4829 278.126 69.2254 278.054C72.8578 277.986 73.7635 278.784 73.7635 278.784C74.1811 278.969 74.5509 279.246 74.8446 279.596C75.1384 279.945 75.3482 280.357 75.458 280.8Z"
        fill="#455A64"
      />
      <path
        d="M65.7875 270.993C67.3254 270.809 68.8849 271.023 70.3158 271.616C70.9294 272.015 71.2897 273.038 70.8709 273.272C69.6079 272.685 68.2195 272.421 66.8295 272.502C65.4685 272.562 64.1279 272.856 62.866 273.369C62.5446 273.486 62.1746 273.661 61.8922 273.817C61.7881 273.87 61.6742 273.901 61.5575 273.909C61.4408 273.916 61.3239 273.899 61.2141 273.858C61.1043 273.818 61.0041 273.756 60.9197 273.675C60.8353 273.594 60.7685 273.496 60.7236 273.388C60.6625 273.208 60.666 273.013 60.7335 272.835C60.8011 272.657 60.9284 272.509 61.0936 272.415C62.5392 271.612 64.1395 271.127 65.7875 270.993Z"
        fill="#455A64"
      />
      <path
        d="M96.3075 261.324C98.6836 267.274 102.404 265.443 108.071 262.016L108.928 241.701L94.5059 240.367L96.3075 261.324Z"
        fill="#FFA8A7"
      />
      <path
        d="M129.827 275.648C130.09 276.604 129.979 277.624 129.515 278.501C129.067 279.319 124.559 281.559 118.667 280.838C114.298 280.301 110.155 278.599 106.669 275.911C104.498 274.294 102.17 273.895 99.2487 273.564C96.3272 273.233 94.136 272.22 93.5615 270.818C92.9869 269.415 93.8634 267.098 93.8634 267.098L129.827 275.648Z"
        fill="#263238"
      />
      <path
        d="M106.883 256.921C107.416 256.808 107.94 256.658 108.451 256.473C108.737 256.367 109.051 256.367 109.337 256.473C109.707 256.638 109.824 257.086 109.912 257.446C109.995 258.328 110.165 259.199 110.418 260.047C110.817 260.75 111.345 261.372 111.976 261.877C113.38 263.134 114.911 264.24 116.544 265.179C118.423 266.328 120.273 267.233 122.211 268.236C124.149 269.24 126.866 269.96 128.405 271.158C130.635 272.852 130.723 276.796 127.996 278.199C125.649 279.416 119.572 280.546 113.388 278.423C110.009 277.264 106.406 273.398 101.926 272.804C99.073 272.434 95.275 271.986 93.5514 269.717C92.9281 268.743 93.4735 265.919 93.9798 262.617C94.4375 259.696 94.8563 255.022 95.8009 255.333L95.8691 256.229L97.0182 257.602C97.2699 257.87 97.5365 258.124 97.8168 258.362C98.1243 258.722 98.4493 259.066 98.7906 259.394C99.2536 259.791 99.8291 260.032 100.436 260.085C100.724 260.104 101.011 260.039 101.264 259.9C101.751 259.628 101.819 258.985 102.238 258.586C102.691 258.12 103.234 257.752 103.835 257.505C104.669 257.208 105.541 257.031 106.425 256.979C106.579 256.969 106.732 256.95 106.883 256.921Z"
        fill="#489CFF"
      />
      <path
        opacity="0.2"
        d="M106.883 256.921C107.416 256.808 107.94 256.658 108.451 256.473C108.737 256.367 109.051 256.367 109.337 256.473C109.707 256.638 109.824 257.086 109.912 257.446C109.995 258.328 110.165 259.199 110.418 260.047C110.817 260.75 111.345 261.372 111.976 261.877C113.38 263.134 114.911 264.24 116.544 265.179C118.423 266.328 120.273 267.233 122.211 268.236C124.149 269.24 126.866 269.96 128.405 271.158C130.635 272.852 130.723 276.796 127.996 278.199C125.649 279.416 119.572 280.546 113.388 278.423C110.009 277.264 106.406 273.398 101.926 272.804C99.073 272.434 95.275 271.986 93.5514 269.717C92.9281 268.743 93.4735 265.919 93.9798 262.617C94.4375 259.696 94.8563 255.022 95.8009 255.333L95.8691 256.229L97.0182 257.602C97.2699 257.87 97.5365 258.124 97.8168 258.362C98.1243 258.722 98.4493 259.066 98.7906 259.394C99.2536 259.791 99.8291 260.032 100.436 260.085C100.724 260.104 101.011 260.039 101.264 259.9C101.751 259.628 101.819 258.985 102.238 258.586C102.691 258.12 103.234 257.752 103.835 257.505C104.669 257.208 105.541 257.031 106.425 256.979C106.579 256.969 106.732 256.95 106.883 256.921Z"
        fill="black"
      />
      <path
        d="M113.963 263.446C113.776 263.042 113.491 262.69 113.134 262.423C112.777 262.157 112.359 261.983 111.918 261.917C110.633 261.606 108.286 262.443 106.796 263.544C106.654 263.647 106.54 263.783 106.463 263.94C106.386 264.097 106.349 264.27 106.355 264.445C106.361 264.62 106.409 264.791 106.496 264.943C106.583 265.095 106.706 265.223 106.854 265.316C107.042 265.429 107.259 265.483 107.478 265.471C107.697 265.459 107.907 265.381 108.081 265.248C109.729 263.897 111.842 263.25 113.963 263.446Z"
        fill="#455A64"
      />
      <path
        d="M117.869 265.95C117.606 265.535 117.248 265.19 116.824 264.942C116.401 264.695 115.924 264.553 115.434 264.528C113.425 264.508 111.461 265.125 109.825 266.29C109.686 266.386 109.573 266.514 109.495 266.664C109.416 266.813 109.375 266.979 109.375 267.147C109.375 267.316 109.416 267.482 109.495 267.631C109.573 267.78 109.686 267.909 109.825 268.004C110.007 268.114 110.219 268.166 110.431 268.152C110.643 268.138 110.846 268.059 111.013 267.927C111.933 267.102 113.027 266.496 114.214 266.153C115.402 265.811 116.651 265.741 117.869 265.95Z"
        fill="#455A64"
      />
      <path
        d="M122.211 268.227C121.908 267.84 121.525 267.523 121.088 267.298C120.651 267.073 120.171 266.945 119.679 266.922C117.741 266.938 115.856 267.565 114.294 268.714C114.159 268.814 114.05 268.946 113.976 269.098C113.903 269.25 113.868 269.417 113.874 269.586C113.879 269.755 113.926 269.919 114.009 270.066C114.093 270.212 114.211 270.337 114.353 270.428C114.529 270.547 114.74 270.605 114.953 270.592C115.166 270.58 115.369 270.498 115.531 270.36C116.4 269.507 117.457 268.869 118.618 268.499C119.778 268.129 121.009 268.035 122.211 268.227Z"
        fill="#455A64"
      />
      <path
        d="M57.5002 214.18C57.9384 204.373 60.0224 199.27 60.3145 196.553C60.3145 196.553 61.1131 142.603 62.4278 126.233L110.73 124.178C111.441 141.707 112.084 188.801 111.704 195.034C111.343 201.004 108.919 252.782 108.919 252.782C102.102 254.915 94.8272 251.809 94.8272 251.809C94.8272 251.809 90.7761 222.35 90.1139 215.855C89.6439 210.012 89.794 204.136 90.5619 198.326L87.4748 156.382C87.4748 156.382 83.745 188.909 81.9045 201.179C79.801 215.212 70.7248 258.713 70.7248 258.713C64.2001 260.339 57.8507 257.525 57.8507 257.525C57.8507 257.525 56.8574 228.388 57.5002 214.18Z"
        fill="#455A64"
      />
      <path
        d="M87.4849 156.421L88.4003 150.637C91.2147 150.218 98.3431 145.767 102.56 141.872C99.556 146.417 95.492 150.164 90.718 152.789L90.5719 198.345L87.4849 156.421Z"
        fill="#37474F"
      />
      <path
        d="M107.293 95.7614C104.011 88.2726 98.3627 75.6615 98.3627 75.6615L96.9312 55.2109C99.0208 55.2775 101.105 55.4628 103.173 55.766C106.212 56.2432 111.032 59.1452 113.233 64.6182C114.879 68.6791 123.429 93.4534 123.429 93.4534L138.329 85.6043C142.146 83.1795 143.5 79.1575 145.935 76.8398C148.369 74.5221 150.804 74.1715 153.501 72.3115C156.199 70.4514 157.26 68.9615 157.942 70.8215C158.624 72.6815 155.605 75.5349 155.02 76.2458C154.436 76.9567 151.505 78.4758 155.244 78.6706C158.984 78.8654 166.551 75.2232 168.362 74.6C170.173 73.9767 170.017 76.1289 169.073 77.4631C168.128 78.7972 168.031 82.712 166.453 84.9032C164.778 87.2404 163.873 88.2434 160.279 89.636C156.939 90.9215 150.015 91.2526 146.451 93.3073C142.886 95.3621 134.258 103.163 128.503 107.165C120.78 112.541 116.437 112.891 113.408 108.606C110.38 104.321 108.452 98.4005 107.293 95.7614Z"
        fill="#FFA8A7"
      />
      <path
        d="M94.915 54.772C99.979 54.3824 105.949 54.6941 109.25 57.6935C111.889 60.0989 112.882 61.5888 115.823 69.9054C117.771 75.4854 121.939 88.3401 121.939 88.3401C116.216 89.6311 111.081 92.7775 107.331 97.2896L97.8365 75.9529L94.915 54.772Z"
        fill="#A9B6BE"
      />
      <path
        d="M123.429 93.4044C120.862 94.313 118.654 96.0194 117.128 98.2736C117.128 98.2736 117.488 94.3782 122.971 92.0508L123.429 93.4044Z"
        fill="#F28F8F"
      />
      <path
        d="M82.7909 53.8572C80.3923 53.7583 77.9925 54.021 75.6721 54.6363C71.2217 55.8146 63.246 58.0544 63.246 58.0544C60.714 59.3691 59.7305 63.7514 59.1559 66.2736C57.3251 74.3467 62.0774 92.5672 62.8078 99.6664C63.5382 106.766 61.9605 128.511 61.9605 128.511C67.4043 134.822 96.9017 139.009 111.266 128.511C111.266 128.511 111.889 78.5829 110.477 71.4155C108.335 60.5669 105.15 55.4154 93.9218 54.7629L82.7909 53.8572Z"
        fill="#D9E4EA"
      />
      <path
        d="M89.0919 27.0771L85.888 28.8397C85.6664 28.3986 85.6205 27.8897 85.7597 27.4161C85.8989 26.9424 86.2128 26.5393 86.6378 26.2883C86.8496 26.1733 87.0825 26.1024 87.3224 26.08C87.5623 26.0576 87.8042 26.084 88.0336 26.1578C88.263 26.2315 88.475 26.351 88.6569 26.509C88.8388 26.667 88.9868 26.8602 89.0919 27.0771Z"
        fill="#263238"
      />
      <path
        d="M103.027 28.3614L100.105 26.1118C100.243 25.9143 100.419 25.7467 100.623 25.6193C100.827 25.492 101.055 25.4075 101.293 25.371C101.53 25.3346 101.773 25.3469 102.006 25.4073C102.239 25.4677 102.457 25.5749 102.647 25.7223C103.034 26.0314 103.289 26.4764 103.359 26.9667C103.43 27.4569 103.311 27.9557 103.027 28.3614Z"
        fill="#263238"
      />
      <path
        d="M74.3675 16.8799C74.3675 16.8799 70.9201 17.3571 69.6542 19.9864C68.5635 22.2457 68.953 27.6992 70.4235 33.6201C71.2545 37.4618 72.4951 41.2032 74.1241 44.7803C74.6995 45.7937 75.6399 46.5495 76.7534 46.8935L76.5684 39.8234L76.3152 34.9543C76.3152 34.9543 79.4607 30.6499 79.8113 27.1636C80.2592 22.6255 79.3049 20.7655 79.3049 20.7655L74.3675 16.8799Z"
        fill="#263238"
      />
      <path
        d="M79.9278 23.6975C79.9407 27.1869 81.3372 30.5287 83.811 32.9897C86.2848 35.4508 89.6338 36.83 93.1233 36.8248C100.388 36.8248 105.842 30.8357 105.783 23.5612C105.725 16.2866 100.271 10.4631 92.9967 10.4923C89.5149 10.518 86.1851 11.9219 83.7359 14.3967C81.2866 16.8715 79.9174 20.2157 79.9278 23.6975Z"
        fill="#263238"
      />
      <path
        d="M76.568 34.1272C75.38 35.1595 74.4159 32.5009 73.4225 31.4589C72.4292 30.4169 69.1669 29.0146 67.5795 32.4327C65.9922 35.8509 69.0013 40.8077 71.4749 41.7621C72.2216 42.0448 73.0417 42.0679 73.8031 41.8276C74.5646 41.5873 75.2229 41.0977 75.6721 40.4376V56.019C79.4214 62.7774 86.0337 62.5632 89.5687 62.1834C93.1037 61.8036 93.8731 58.1322 91.2924 55.1718V50.3026C93.2566 50.6108 95.2483 50.7055 97.2328 50.585C100.466 50.0786 102.102 47.6635 103.076 44.1285C104.634 38.49 105.267 29.0243 103.076 18.0881C99.4532 15.2835 86.8907 15.7509 79.285 20.5714C79.8791 30.3779 77.6977 33.1047 76.568 34.1272Z"
        fill="#FFA8A7"
      />
      <path
        d="M103.719 12.6738C104.208 10.6437 104.427 8.55799 104.371 6.47052C104.371 5.6525 104.166 4.65919 103.397 4.34756C102.628 4.03593 101.868 4.60076 101.206 5.04872C98.4014 6.93796 94.9151 7.47356 91.5358 7.65859C85.6928 7.97996 76.7628 7.60017 73.7926 13.9983C72.9648 15.7706 72.8187 17.6404 74.4548 18.8674C75.9134 19.8445 77.5814 20.465 79.324 20.6788C82.2455 21.1949 85.167 21.8376 88.1664 22.2369C91.1658 22.6362 94.73 23.0257 97.7002 22.1103C100.203 21.341 102.745 20.6788 104.605 18.6921C106.217 16.9599 107.126 14.6895 107.156 12.3233C107.156 11.9922 107.088 11.5734 106.757 11.4858C106.591 11.465 106.424 11.4992 106.28 11.5832L103.719 12.6738Z"
        fill="#263238"
      />
      <path
        d="M91.2632 50.4103C91.2632 50.4103 84.0373 48.9788 81.5248 47.6446C80.0366 46.8736 78.815 45.6724 78.019 44.1973C78.3891 45.6709 79.0515 47.0551 79.9667 48.2679C81.8267 50.6246 91.2437 52.3288 91.2437 52.3288L91.2632 50.4103Z"
        fill="#F28F8F"
      />
      <path
        d="M89.8119 31.8586C89.8024 32.178 89.6989 32.4875 89.5145 32.7485C89.3301 33.0094 89.0729 33.2103 88.775 33.3259C88.4771 33.4416 88.1518 33.4669 87.8396 33.3988C87.5274 33.3306 87.2422 33.172 87.0196 32.9428C86.797 32.7135 86.6468 32.4238 86.5879 32.1097C86.529 31.7956 86.5639 31.4712 86.6883 31.1768C86.8127 30.8825 87.0211 30.6313 87.2874 30.4547C87.5537 30.278 87.8661 30.1837 88.1856 30.1836C88.623 30.1913 89.0396 30.3718 89.3443 30.6856C89.649 30.9995 89.8172 31.4212 89.8119 31.8586Z"
        fill="#263238"
      />
      <path
        d="M92.1494 43.1059C92.1573 43.5175 92.0019 43.9155 91.7172 44.213C91.4326 44.5104 91.0418 44.6831 90.6302 44.6933C90.2161 44.6856 89.8218 44.5143 89.5335 44.2169C89.2453 43.9195 89.0864 43.5201 89.0916 43.1059C89.0877 42.9026 89.1239 42.7005 89.1982 42.5111C89.2725 42.3218 89.3833 42.1489 89.5244 42.0024C89.6654 41.8559 89.834 41.7386 90.0204 41.6573C90.2068 41.5759 90.4074 41.5321 90.6108 41.5283C91.0232 41.536 91.416 41.7059 91.704 42.0012C91.992 42.2965 92.1521 42.6934 92.1494 43.1059Z"
        fill="#B16668"
      />
      <path
        d="M87.767 26.7461L84.417 28.8593C84.1406 28.3995 84.0532 27.8504 84.173 27.3275C84.2929 26.8045 84.6107 26.3483 85.0597 26.0547C85.2819 25.9185 85.5291 25.8283 85.7867 25.7894C86.0443 25.7505 86.3071 25.7637 86.5595 25.8282C86.812 25.8926 87.0489 26.0071 87.2563 26.1648C87.4637 26.3224 87.6374 26.5201 87.767 26.7461Z"
        fill="#263238"
      />
      <path
        d="M99.5895 24.6807L103.115 26.2583C103.02 26.4897 102.879 26.6994 102.7 26.8747C102.522 27.0501 102.31 27.1874 102.077 27.2785C101.844 27.3695 101.595 27.4123 101.344 27.4044C101.094 27.3964 100.849 27.3378 100.622 27.2321C100.162 27.0133 99.8001 26.6297 99.609 26.1573C99.4179 25.6849 99.4109 25.158 99.5895 24.6807Z"
        fill="#263238"
      />
      <path
        d="M101.45 31.3714C101.438 31.6784 101.337 31.9752 101.158 32.225C100.979 32.4748 100.731 32.6667 100.445 32.7767C100.158 32.8868 99.8451 32.9102 99.5451 32.844C99.2452 32.7779 98.9713 32.6251 98.7574 32.4046C98.5436 32.1842 98.3992 31.9058 98.3422 31.6039C98.2852 31.3021 98.3181 30.9902 98.4368 30.707C98.5555 30.4237 98.7548 30.1815 99.01 30.0105C99.2651 29.8395 99.5648 29.7472 99.872 29.7451C100.296 29.7528 100.701 29.9282 100.996 30.2329C101.292 30.5376 101.455 30.9469 101.45 31.3714Z"
        fill="#263238"
      />
      <path
        d="M93.4834 28.625L94.0677 39.454L99.1998 38.0907L93.4834 28.625Z"
        fill="#F28F8F"
      />
      <path
        d="M2.55663 73.227C4.24136 74.1327 11.1069 78.9629 14.8367 79.3817C16.4143 79.5569 16.8428 79.3038 16.7844 78.8947C16.7065 78.3299 15.7034 77.4827 15.4599 77.025C15.0412 76.2264 12.5384 72.9154 13.5123 71.182C14.4861 69.4485 15.3333 71.1041 17.6511 73.3731C19.9688 75.6421 22.345 76.4309 24.3803 79.07C26.4156 81.7091 27.0973 85.8869 30.4667 88.9155L43.8862 98.0793C43.8862 98.0793 50.1382 69.0687 52.8844 65.6506C55.8059 62.0571 68.3392 69.8868 65.7098 81.3098C63.0805 92.7329 57.0914 112.56 52.9234 116.446C50.2356 118.968 44.5776 116.592 37.5173 110.311C31.9372 105.344 24.2926 97.8942 21.0595 95.2552C17.8264 92.6161 11.1069 91.1943 8.01984 89.4121C4.69907 87.4645 3.96869 86.3251 2.69297 83.7444C1.49515 81.3196 2.03076 77.434 1.31986 75.9538C0.608961 74.4735 0.842682 72.3213 2.55663 73.227Z"
        fill="#FFA8A7"
      />
      <path
        d="M63.2463 58.0547C67.5506 60.7425 67.7649 64.6573 67.9791 69.1369C68.0401 74.3806 67.2103 79.5966 65.5251 84.5625C63.704 90.201 60.8117 100.494 60.8117 100.494C60.8117 100.494 49.5736 100.757 43.7891 95.7616C43.7891 95.7616 46.4282 84.6599 48.2882 76.2849C50.1482 67.9099 52.4075 58.9993 63.2463 58.0547Z"
        fill="#A9B6BE"
      />
      <path
        d="M43.8374 98.0994C46.905 99.8036 48.7066 103.465 49.2617 104.916C49.1288 103.227 48.597 101.593 47.71 100.149C46.8229 98.7046 45.6058 97.4916 44.1588 96.6094L43.8374 98.0994Z"
        fill="#F28F8F"
      />
      <path
        d="M160.425 308.572L235.585 351.966V367.957L160.425 324.563V308.572Z"
        fill="#489CFF"
      />
      <path
        opacity="0.35"
        d="M160.425 308.572L235.585 351.966V367.957L160.425 324.563V308.572Z"
        fill="black"
      />
      <path
        d="M310.746 308.572L235.585 351.966V367.957L310.746 324.563V308.572Z"
        fill="#489CFF"
      />
      <path
        opacity="0.2"
        d="M310.746 308.572L235.585 351.966V367.957L310.746 324.563V308.572Z"
        fill="black"
      />
      <path
        d="M310.746 308.573L235.585 265.188L160.425 308.573L235.585 351.967L310.746 308.573Z"
        fill="#489CFF"
      />
      <path
        opacity="0.15"
        d="M310.746 308.573L235.585 265.188L160.425 308.573L235.585 351.967L310.746 308.573Z"
        fill="black"
      />
      <path
        opacity="0.1"
        d="M235.585 351.966V347.399L168.332 308.572H160.425L235.585 351.966Z"
        fill="black"
      />
      <path
        opacity="0.1"
        d="M235.585 265.188V269.756L302.838 308.573H310.746L235.585 265.188Z"
        fill="black"
      />
      <path
        d="M310.746 308.572H302.838L235.585 347.399V351.966L310.746 308.572Z"
        fill="#489CFF"
      />
      <path
        d="M235.585 265.188V269.756L168.332 308.573H160.425L235.585 265.188Z"
        fill="#489CFF"
      />
      <path
        d="M235.858 289.739L268.15 308.378C270.565 309.78 270.565 312.04 268.15 313.432L244.067 327.377C242.711 328.071 241.209 328.432 239.685 328.432C238.162 328.432 236.66 328.071 235.303 327.377L203.011 308.738C200.595 307.336 200.595 305.077 203.011 303.684L227.103 289.739C228.459 289.047 229.959 288.687 231.481 288.687C233.002 288.687 234.502 289.047 235.858 289.739Z"
        fill="#37474F"
      />
      <path
        d="M244.067 327.377L267.352 313.928L235.858 295.747C234.499 295.062 232.998 294.705 231.476 294.705C229.954 294.705 228.453 295.062 227.093 295.747L203.809 309.215L235.303 327.377C236.66 328.07 238.162 328.432 239.685 328.432C241.209 328.432 242.711 328.07 244.067 327.377Z"
        fill="#455A64"
      />
      <path
        d="M216.352 308.602L230.482 300.451C230.745 300.319 231.035 300.25 231.329 300.25C231.624 300.25 231.914 300.319 232.177 300.451L233.91 301.424C234.378 301.687 234.378 302.126 233.91 302.398L219.78 310.549C219.519 310.681 219.23 310.75 218.937 310.75C218.645 310.75 218.356 310.681 218.095 310.549L216.362 309.575C216.26 309.541 216.172 309.476 216.11 309.389C216.047 309.303 216.013 309.199 216.012 309.092C216.011 308.985 216.043 308.88 216.104 308.793C216.165 308.705 216.251 308.638 216.352 308.602Z"
        fill="#263238"
      />
      <path
        d="M237.455 320.805L251.585 312.654C251.846 312.522 252.135 312.453 252.428 312.453C252.72 312.453 253.009 312.522 253.27 312.654L255.013 313.627C255.481 313.89 255.481 314.329 255.013 314.601L240.883 322.752C240.622 322.884 240.333 322.953 240.04 322.953C239.748 322.953 239.459 322.884 239.198 322.752L237.465 321.778C237.363 321.744 237.275 321.679 237.213 321.592C237.15 321.506 237.116 321.402 237.115 321.295C237.114 321.188 237.146 321.084 237.207 320.996C237.268 320.908 237.354 320.841 237.455 320.805Z"
        fill="#263238"
      />
      <path
        d="M202.933 340.154C202.854 338.676 202.426 337.238 201.684 335.957C200.943 334.676 199.909 333.588 198.668 332.782C198.238 332.469 197.732 332.276 197.203 332.225C196.674 332.173 196.14 332.265 195.658 332.49L193.818 333.561C193.385 333.867 193.041 334.283 192.822 334.765C192.603 335.248 192.516 335.78 192.571 336.308C192.652 337.786 193.079 339.224 193.819 340.506C194.558 341.789 195.589 342.879 196.827 343.689C197.258 344.003 197.766 344.195 198.297 344.247C198.828 344.298 199.362 344.207 199.846 343.982L201.677 342.881C202.107 342.577 202.45 342.165 202.671 341.686C202.891 341.208 202.982 340.679 202.933 340.154Z"
        fill="#489CFF"
      />
      <path
        opacity="0.1"
        d="M196.826 333.883C198.068 334.688 199.102 335.776 199.843 337.057C200.585 338.338 201.012 339.777 201.092 341.255C201.092 343.972 199.144 345.072 196.826 343.719C195.588 342.908 194.557 341.818 193.818 340.535C193.079 339.253 192.652 337.815 192.571 336.337C192.571 333.63 194.48 332.529 196.826 333.883Z"
        fill="black"
      />
      <path
        d="M147.424 364.987C142.672 365.07 137.978 363.933 133.791 361.686L83.9303 332.899C79.9279 330.581 77.7173 327.387 77.7173 323.901C77.7173 320.415 79.9279 317.23 83.9303 314.912L141.698 281.559C148.028 277.907 153.384 268.646 153.384 261.332V78.5141C153.384 77.9975 153.589 77.5021 153.955 77.1369C154.32 76.7716 154.815 76.5664 155.332 76.5664C155.848 76.5664 156.344 76.7716 156.709 77.1369C157.074 77.5021 157.28 77.9975 157.28 78.5141V261.332C157.28 270.155 151.3 280.526 143.646 284.938L85.878 318.292C83.1318 319.879 81.6126 321.866 81.6126 323.901C81.6126 325.936 83.1318 327.933 85.878 329.52L135.738 358.306C142.175 362.027 152.654 362.027 159.11 358.306L195.873 337.096C196.094 336.955 196.342 336.861 196.601 336.818C196.861 336.776 197.126 336.786 197.381 336.848C197.636 336.911 197.876 337.024 198.086 337.182C198.296 337.339 198.472 337.538 198.604 337.765C198.735 337.993 198.819 338.244 198.851 338.505C198.883 338.766 198.861 339.03 198.788 339.283C198.715 339.535 198.591 339.77 198.425 339.973C198.259 340.177 198.053 340.344 197.82 340.466L161.058 361.686C156.871 363.935 152.177 365.072 147.424 364.987Z"
        fill="#37474F"
      />
    </svg>
  );
};

const PageNotFoundComponent = () => {
  return (
    <div className="flex flex-col h-full items-center sm:pt-10 2xl:pt-20">
      <h1 className="sm:text-[80px] 2xl:text-[100px] text-chart-orange dark:text-chart-orange font-black leading-none">
        404
      </h1>
      <div className="mt-6 flex flex-col gap-y-14 items-center">
        <h4 className="sm:text-base 2xl:text-xl font-semibold text-text-text-and-icon flex flex-col text-center">
          The page/resource you are looking for does not exist or it has been deleted.
        </h4>
        <div className="sm:w-[375px] 2xl:w-[455px]">
          <SVG404 />
        </div>
      </div>
    </div>
  );
};

export const FourZeroFourAuthenticated = () => {
  const error = useRouteError();
  console.error(error);

  return <PageNotFoundComponent />;
};

export const FourZeroFourPublic = () => {
  const error = useRouteError();
  console.error(error);

  return (
    <div className="fixed inset-0 bg-bg-page py-20">
      <PageNotFoundComponent />
    </div>
  );
};

export class DF404Error extends Error {
  public readonly status = 404;
  public readonly message = 'Resource not found';
}
