/* tslint:disable */
/* eslint-disable */
/**
 * Deepfence ThreatMapper
 * Deepfence Runtime API provides programmatic control over Deepfence microservice securing your container, kubernetes and cloud deployments. The API abstracts away underlying infrastructure details like cloud provider,  container distros, container orchestrator and type of deployment. This is one uniform API to manage and control security alerts, policies and response to alerts for microservices running anywhere i.e. managed pure greenfield container deployments or a mix of containers, VMs and serverless paradigms like AWS Fargate.
 *
 * The version of the OpenAPI document: v2.5.0
 * Contact: community@deepfence.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ApiDocsBadRequestResponse,
  ApiDocsFailureResponse,
  ModelDownloadReportResponse,
  ModelPackageVulnerabilityScanResult,
  ModelSbomRequest,
  ModelSbomResponse,
  ModelScanListReq,
  ModelScanListResp,
  ModelScanResultsReq,
  ModelScanStatusReq,
  ModelScanStatusResp,
  ModelScanTriggerResp,
  ModelStopScanRequest,
  ModelVulnerabilityScanResult,
  ModelVulnerabilityScanTriggerReq,
  SearchSearchCountResp,
  UtilsScanSbomRequest,
} from '../models';
import {
    ApiDocsBadRequestResponseFromJSON,
    ApiDocsBadRequestResponseToJSON,
    ApiDocsFailureResponseFromJSON,
    ApiDocsFailureResponseToJSON,
    ModelDownloadReportResponseFromJSON,
    ModelDownloadReportResponseToJSON,
    ModelPackageVulnerabilityScanResultFromJSON,
    ModelPackageVulnerabilityScanResultToJSON,
    ModelSbomRequestFromJSON,
    ModelSbomRequestToJSON,
    ModelSbomResponseFromJSON,
    ModelSbomResponseToJSON,
    ModelScanListReqFromJSON,
    ModelScanListReqToJSON,
    ModelScanListRespFromJSON,
    ModelScanListRespToJSON,
    ModelScanResultsReqFromJSON,
    ModelScanResultsReqToJSON,
    ModelScanStatusReqFromJSON,
    ModelScanStatusReqToJSON,
    ModelScanStatusRespFromJSON,
    ModelScanStatusRespToJSON,
    ModelScanTriggerRespFromJSON,
    ModelScanTriggerRespToJSON,
    ModelStopScanRequestFromJSON,
    ModelStopScanRequestToJSON,
    ModelVulnerabilityScanResultFromJSON,
    ModelVulnerabilityScanResultToJSON,
    ModelVulnerabilityScanTriggerReqFromJSON,
    ModelVulnerabilityScanTriggerReqToJSON,
    SearchSearchCountRespFromJSON,
    SearchSearchCountRespToJSON,
    UtilsScanSbomRequestFromJSON,
    UtilsScanSbomRequestToJSON,
} from '../models';

export interface CountResultsVulnerabilityScansRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface DownloadSBOMRequest {
    modelSbomRequest?: ModelSbomRequest;
}

export interface GetSBOMRequest {
    modelSbomRequest?: ModelSbomRequest;
}

export interface IngestSbomRequest {
    utilsScanSbomRequest?: UtilsScanSbomRequest;
}

export interface ListVulnerabilityScansRequest {
    modelScanListReq?: ModelScanListReq;
}

export interface ResultsVulnerabilityScansRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface ResultsVulnerablePackagesScansRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface StartVulnerabilityScanRequest {
    modelVulnerabilityScanTriggerReq?: ModelVulnerabilityScanTriggerReq;
}

export interface StatusVulnerabilityScanRequest {
    modelScanStatusReq?: ModelScanStatusReq;
}

export interface StopVulnerabilityScanRequest {
    modelStopScanRequest?: ModelStopScanRequest;
}

/**
 * VulnerabilityApi - interface
 * 
 * @export
 * @interface VulnerabilityApiInterface
 */
export interface VulnerabilityApiInterface {
    /**
     * Get Vulnerability Scan results on agent or registry
     * @summary Get Vulnerability Scans Results
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    countResultsVulnerabilityScansRaw(requestParameters: CountResultsVulnerabilityScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchSearchCountResp>>;

    /**
     * Get Vulnerability Scan results on agent or registry
     * Get Vulnerability Scans Results
     */
    countResultsVulnerabilityScans(requestParameters: CountResultsVulnerabilityScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchSearchCountResp>;

    /**
     * Download SBOM for a node or scan id
     * @summary Download SBOM for a node or scan id
     * @param {ModelSbomRequest} [modelSbomRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    downloadSBOMRaw(requestParameters: DownloadSBOMRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelDownloadReportResponse>>;

    /**
     * Download SBOM for a node or scan id
     * Download SBOM for a node or scan id
     */
    downloadSBOM(requestParameters: DownloadSBOMRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelDownloadReportResponse>;

    /**
     * Get SBOM for a node or scan id
     * @summary Get SBOM for a node or scan id
     * @param {ModelSbomRequest} [modelSbomRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    getSBOMRaw(requestParameters: GetSBOMRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelSbomResponse>>>;

    /**
     * Get SBOM for a node or scan id
     * Get SBOM for a node or scan id
     */
    getSBOM(requestParameters: GetSBOMRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelSbomResponse>>;

    /**
     * Ingest SBOM from Scan
     * @summary Ingest SBOM from Scan
     * @param {UtilsScanSbomRequest} [utilsScanSbomRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    ingestSbomRaw(requestParameters: IngestSbomRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Ingest SBOM from Scan
     * Ingest SBOM from Scan
     */
    ingestSbom(requestParameters: IngestSbomRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Get Vulnerability Scan list on agent or registry
     * @summary Get Vulnerability Scans List
     * @param {ModelScanListReq} [modelScanListReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    listVulnerabilityScansRaw(requestParameters: ListVulnerabilityScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanListResp>>;

    /**
     * Get Vulnerability Scan list on agent or registry
     * Get Vulnerability Scans List
     */
    listVulnerabilityScans(requestParameters: ListVulnerabilityScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanListResp>;

    /**
     * Get Vulnerability Scan results on agent or registry
     * @summary Get Vulnerability Scans Results
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    resultsVulnerabilityScansRaw(requestParameters: ResultsVulnerabilityScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelVulnerabilityScanResult>>;

    /**
     * Get Vulnerability Scan results on agent or registry
     * Get Vulnerability Scans Results
     */
    resultsVulnerabilityScans(requestParameters: ResultsVulnerabilityScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelVulnerabilityScanResult>;

    /**
     * Get Vulnerability Pacakge Scan results on agent or registry
     * @summary Get Vulnerability Package Scans Results
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    resultsVulnerablePackagesScansRaw(requestParameters: ResultsVulnerablePackagesScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelPackageVulnerabilityScanResult>>;

    /**
     * Get Vulnerability Pacakge Scan results on agent or registry
     * Get Vulnerability Package Scans Results
     */
    resultsVulnerablePackagesScans(requestParameters: ResultsVulnerablePackagesScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelPackageVulnerabilityScanResult>;

    /**
     * Start Vulnerability Scan on agent or registry
     * @summary Start Vulnerability Scan
     * @param {ModelVulnerabilityScanTriggerReq} [modelVulnerabilityScanTriggerReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    startVulnerabilityScanRaw(requestParameters: StartVulnerabilityScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanTriggerResp>>;

    /**
     * Start Vulnerability Scan on agent or registry
     * Start Vulnerability Scan
     */
    startVulnerabilityScan(requestParameters: StartVulnerabilityScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanTriggerResp>;

    /**
     * Get Vulnerability Scan Status on agent or registry
     * @summary Get Vulnerability Scan Status
     * @param {ModelScanStatusReq} [modelScanStatusReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    statusVulnerabilityScanRaw(requestParameters: StatusVulnerabilityScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanStatusResp>>;

    /**
     * Get Vulnerability Scan Status on agent or registry
     * Get Vulnerability Scan Status
     */
    statusVulnerabilityScan(requestParameters: StatusVulnerabilityScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanStatusResp>;

    /**
     * Stop Vulnerability Scan on agent or registry
     * @summary Stop Vulnerability Scan
     * @param {ModelStopScanRequest} [modelStopScanRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof VulnerabilityApiInterface
     */
    stopVulnerabilityScanRaw(requestParameters: StopVulnerabilityScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Stop Vulnerability Scan on agent or registry
     * Stop Vulnerability Scan
     */
    stopVulnerabilityScan(requestParameters: StopVulnerabilityScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

}

/**
 * 
 */
export class VulnerabilityApi extends runtime.BaseAPI implements VulnerabilityApiInterface {

    /**
     * Get Vulnerability Scan results on agent or registry
     * Get Vulnerability Scans Results
     */
    async countResultsVulnerabilityScansRaw(requestParameters: CountResultsVulnerabilityScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchSearchCountResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/count/vulnerability`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SearchSearchCountRespFromJSON(jsonValue));
    }

    /**
     * Get Vulnerability Scan results on agent or registry
     * Get Vulnerability Scans Results
     */
    async countResultsVulnerabilityScans(requestParameters: CountResultsVulnerabilityScansRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchSearchCountResp> {
        const response = await this.countResultsVulnerabilityScansRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Download SBOM for a node or scan id
     * Download SBOM for a node or scan id
     */
    async downloadSBOMRaw(requestParameters: DownloadSBOMRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelDownloadReportResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/sbom/download`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelSbomRequestToJSON(requestParameters.modelSbomRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelDownloadReportResponseFromJSON(jsonValue));
    }

    /**
     * Download SBOM for a node or scan id
     * Download SBOM for a node or scan id
     */
    async downloadSBOM(requestParameters: DownloadSBOMRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelDownloadReportResponse> {
        const response = await this.downloadSBOMRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get SBOM for a node or scan id
     * Get SBOM for a node or scan id
     */
    async getSBOMRaw(requestParameters: GetSBOMRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelSbomResponse>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/sbom`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelSbomRequestToJSON(requestParameters.modelSbomRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelSbomResponseFromJSON));
    }

    /**
     * Get SBOM for a node or scan id
     * Get SBOM for a node or scan id
     */
    async getSBOM(requestParameters: GetSBOMRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelSbomResponse>> {
        const response = await this.getSBOMRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Ingest SBOM from Scan
     * Ingest SBOM from Scan
     */
    async ingestSbomRaw(requestParameters: IngestSbomRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/ingest/sbom`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: UtilsScanSbomRequestToJSON(requestParameters.utilsScanSbomRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Ingest SBOM from Scan
     * Ingest SBOM from Scan
     */
    async ingestSbom(requestParameters: IngestSbomRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.ingestSbomRaw(requestParameters, initOverrides);
    }

    /**
     * Get Vulnerability Scan list on agent or registry
     * Get Vulnerability Scans List
     */
    async listVulnerabilityScansRaw(requestParameters: ListVulnerabilityScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanListResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/list/vulnerability`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanListReqToJSON(requestParameters.modelScanListReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelScanListRespFromJSON(jsonValue));
    }

    /**
     * Get Vulnerability Scan list on agent or registry
     * Get Vulnerability Scans List
     */
    async listVulnerabilityScans(requestParameters: ListVulnerabilityScansRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanListResp> {
        const response = await this.listVulnerabilityScansRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Vulnerability Scan results on agent or registry
     * Get Vulnerability Scans Results
     */
    async resultsVulnerabilityScansRaw(requestParameters: ResultsVulnerabilityScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelVulnerabilityScanResult>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/vulnerability`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelVulnerabilityScanResultFromJSON(jsonValue));
    }

    /**
     * Get Vulnerability Scan results on agent or registry
     * Get Vulnerability Scans Results
     */
    async resultsVulnerabilityScans(requestParameters: ResultsVulnerabilityScansRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelVulnerabilityScanResult> {
        const response = await this.resultsVulnerabilityScansRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Vulnerability Pacakge Scan results on agent or registry
     * Get Vulnerability Package Scans Results
     */
    async resultsVulnerablePackagesScansRaw(requestParameters: ResultsVulnerablePackagesScansRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelPackageVulnerabilityScanResult>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/packages`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelPackageVulnerabilityScanResultFromJSON(jsonValue));
    }

    /**
     * Get Vulnerability Pacakge Scan results on agent or registry
     * Get Vulnerability Package Scans Results
     */
    async resultsVulnerablePackagesScans(requestParameters: ResultsVulnerablePackagesScansRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelPackageVulnerabilityScanResult> {
        const response = await this.resultsVulnerablePackagesScansRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Start Vulnerability Scan on agent or registry
     * Start Vulnerability Scan
     */
    async startVulnerabilityScanRaw(requestParameters: StartVulnerabilityScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanTriggerResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/start/vulnerability`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelVulnerabilityScanTriggerReqToJSON(requestParameters.modelVulnerabilityScanTriggerReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelScanTriggerRespFromJSON(jsonValue));
    }

    /**
     * Start Vulnerability Scan on agent or registry
     * Start Vulnerability Scan
     */
    async startVulnerabilityScan(requestParameters: StartVulnerabilityScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanTriggerResp> {
        const response = await this.startVulnerabilityScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Vulnerability Scan Status on agent or registry
     * Get Vulnerability Scan Status
     */
    async statusVulnerabilityScanRaw(requestParameters: StatusVulnerabilityScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanStatusResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/status/vulnerability`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanStatusReqToJSON(requestParameters.modelScanStatusReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelScanStatusRespFromJSON(jsonValue));
    }

    /**
     * Get Vulnerability Scan Status on agent or registry
     * Get Vulnerability Scan Status
     */
    async statusVulnerabilityScan(requestParameters: StatusVulnerabilityScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanStatusResp> {
        const response = await this.statusVulnerabilityScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Stop Vulnerability Scan on agent or registry
     * Stop Vulnerability Scan
     */
    async stopVulnerabilityScanRaw(requestParameters: StopVulnerabilityScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/stop/vulnerability`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelStopScanRequestToJSON(requestParameters.modelStopScanRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Stop Vulnerability Scan on agent or registry
     * Stop Vulnerability Scan
     */
    async stopVulnerabilityScan(requestParameters: StopVulnerabilityScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.stopVulnerabilityScanRaw(requestParameters, initOverrides);
    }

}
