/* tslint:disable */
/* eslint-disable */
/**
 * Deepfence ThreatMapper
 * Deepfence Runtime API provides programmatic control over Deepfence microservice securing your container, kubernetes and cloud deployments. The API abstracts away underlying infrastructure details like cloud provider,  container distros, container orchestrator and type of deployment. This is one uniform API to manage and control security alerts, policies and response to alerts for microservices running anywhere i.e. managed pure greenfield container deployments or a mix of containers, VMs and serverless paradigms like AWS Fargate.
 *
 * The version of the OpenAPI document: v2.5.0
 * Contact: community@deepfence.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ApiDocsBadRequestResponse,
  ApiDocsFailureResponse,
  ModelAddScheduledTaskRequest,
  ModelEmailConfigurationAdd,
  ModelEmailConfigurationResp,
  ModelGenerateLicenseRequest,
  ModelGenerateLicenseResponse,
  ModelGetAgentBinaryDownloadURLResponse,
  ModelGetAuditLogsRequest,
  ModelLicense,
  ModelListAgentVersionResp,
  ModelMessageResponse,
  ModelRegisterLicenseRequest,
  ModelRegisterLicenseResponse,
  ModelUpdateScheduledTaskRequest,
  PostgresqlDbGetAuditLogsRow,
  PostgresqlDbScheduler,
  SearchSearchCountResp,
  SettingSettingUpdateRequest,
  SettingSettingsResponse,
} from '../models';
import {
    ApiDocsBadRequestResponseFromJSON,
    ApiDocsBadRequestResponseToJSON,
    ApiDocsFailureResponseFromJSON,
    ApiDocsFailureResponseToJSON,
    ModelAddScheduledTaskRequestFromJSON,
    ModelAddScheduledTaskRequestToJSON,
    ModelEmailConfigurationAddFromJSON,
    ModelEmailConfigurationAddToJSON,
    ModelEmailConfigurationRespFromJSON,
    ModelEmailConfigurationRespToJSON,
    ModelGenerateLicenseRequestFromJSON,
    ModelGenerateLicenseRequestToJSON,
    ModelGenerateLicenseResponseFromJSON,
    ModelGenerateLicenseResponseToJSON,
    ModelGetAgentBinaryDownloadURLResponseFromJSON,
    ModelGetAgentBinaryDownloadURLResponseToJSON,
    ModelGetAuditLogsRequestFromJSON,
    ModelGetAuditLogsRequestToJSON,
    ModelLicenseFromJSON,
    ModelLicenseToJSON,
    ModelListAgentVersionRespFromJSON,
    ModelListAgentVersionRespToJSON,
    ModelMessageResponseFromJSON,
    ModelMessageResponseToJSON,
    ModelRegisterLicenseRequestFromJSON,
    ModelRegisterLicenseRequestToJSON,
    ModelRegisterLicenseResponseFromJSON,
    ModelRegisterLicenseResponseToJSON,
    ModelUpdateScheduledTaskRequestFromJSON,
    ModelUpdateScheduledTaskRequestToJSON,
    PostgresqlDbGetAuditLogsRowFromJSON,
    PostgresqlDbGetAuditLogsRowToJSON,
    PostgresqlDbSchedulerFromJSON,
    PostgresqlDbSchedulerToJSON,
    SearchSearchCountRespFromJSON,
    SearchSearchCountRespToJSON,
    SettingSettingUpdateRequestFromJSON,
    SettingSettingUpdateRequestToJSON,
    SettingSettingsResponseFromJSON,
    SettingSettingsResponseToJSON,
} from '../models';

export interface AddEmailConfigurationRequest {
    modelEmailConfigurationAdd?: ModelEmailConfigurationAdd;
}

export interface AddScheduledTaskRequest {
    modelAddScheduledTaskRequest?: ModelAddScheduledTaskRequest;
}

export interface DeleteCustomScheduledTaskRequest {
    id: number;
}

export interface DeleteEmailConfigurationRequest {
    configId: string;
}

export interface GenerateLicenseRequest {
    modelGenerateLicenseRequest?: ModelGenerateLicenseRequest;
}

export interface GetUserAuditLogsRequest {
    modelGetAuditLogsRequest?: ModelGetAuditLogsRequest;
}

export interface RegisterLicenseRequest {
    modelRegisterLicenseRequest?: ModelRegisterLicenseRequest;
}

export interface TestUnconfiguredEmailRequest {
    modelEmailConfigurationAdd?: ModelEmailConfigurationAdd;
}

export interface UpdateScheduledTaskRequest {
    id: number;
    modelUpdateScheduledTaskRequest?: ModelUpdateScheduledTaskRequest;
}

export interface UpdateSettingRequest {
    id: number;
    settingSettingUpdateRequest?: SettingSettingUpdateRequest;
}

export interface UploadAgentVersionRequest {
    tarball: Blob;
}

export interface UploadMalwareRulesRequest {
    database: Blob;
}

export interface UploadPostureControlsRequest {
    database: Blob;
}

export interface UploadSecretsRulesRequest {
    database: Blob;
}

export interface UploadVulnerabilityDatabaseRequest {
    database: Blob;
}

/**
 * SettingsApi - interface
 * 
 * @export
 * @interface SettingsApiInterface
 */
export interface SettingsApiInterface {
    /**
     * This email configuration is used to send email notifications
     * @summary Add Email Configuration
     * @param {ModelEmailConfigurationAdd} [modelEmailConfigurationAdd] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    addEmailConfigurationRaw(requestParameters: AddEmailConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>>;

    /**
     * This email configuration is used to send email notifications
     * Add Email Configuration
     */
    addEmailConfiguration(requestParameters: AddEmailConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse>;

    /**
     * Add scheduled task
     * @summary Add scheduled task
     * @param {ModelAddScheduledTaskRequest} [modelAddScheduledTaskRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    addScheduledTaskRaw(requestParameters: AddScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Add scheduled task
     * Add scheduled task
     */
    addScheduledTask(requestParameters: AddScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Delete Custom Schedule task
     * @summary Delete Custom Schedule task
     * @param {number} id 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    deleteCustomScheduledTaskRaw(requestParameters: DeleteCustomScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Delete Custom Schedule task
     * Delete Custom Schedule task
     */
    deleteCustomScheduledTask(requestParameters: DeleteCustomScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Delete Email Smtp / ses Configurations in system
     * @summary Delete Email Configurations
     * @param {string} configId 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    deleteEmailConfigurationRaw(requestParameters: DeleteEmailConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Delete Email Smtp / ses Configurations in system
     * Delete Email Configurations
     */
    deleteEmailConfiguration(requestParameters: DeleteEmailConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Delete license from the console database
     * @summary Delete License
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    deleteLicenseRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Delete license from the console database
     * Delete License
     */
    deleteLicense(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Generate a new ThreatMapper license key
     * @summary Generate License Key
     * @param {ModelGenerateLicenseRequest} [modelGenerateLicenseRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    generateLicenseRaw(requestParameters: GenerateLicenseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelGenerateLicenseResponse>>;

    /**
     * Generate a new ThreatMapper license key
     * Generate License Key
     */
    generateLicense(requestParameters: GenerateLicenseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelGenerateLicenseResponse>;

    /**
     * Get agent binary download url
     * @summary Get agent binary download url
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getAgentBinaryDownloadURLRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelGetAgentBinaryDownloadURLResponse>>;

    /**
     * Get agent binary download url
     * Get agent binary download url
     */
    getAgentBinaryDownloadURL(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelGetAgentBinaryDownloadURLResponse>;

    /**
     * Get available agent versions
     * @summary Get available agent versions
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getAgentVersionsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelListAgentVersionResp>>;

    /**
     * Get available agent versions
     * Get available agent versions
     */
    getAgentVersions(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelListAgentVersionResp>;

    /**
     * Get Email Smtp / ses Configurations in system
     * @summary Get Email Configurations
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getEmailConfigurationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelEmailConfigurationResp>>>;

    /**
     * Get Email Smtp / ses Configurations in system
     * Get Email Configurations
     */
    getEmailConfiguration(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelEmailConfigurationResp>>;

    /**
     * Get license status and expiry
     * @summary Get License Details
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getLicenseRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelLicense>>;

    /**
     * Get license status and expiry
     * Get License Details
     */
    getLicense(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelLicense>;

    /**
     * Get scheduled tasks
     * @summary Get scheduled tasks
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getScheduledTasksRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<PostgresqlDbScheduler>>>;

    /**
     * Get scheduled tasks
     * Get scheduled tasks
     */
    getScheduledTasks(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<PostgresqlDbScheduler>>;

    /**
     * Get all settings
     * @summary Get settings
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getSettingsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<SettingSettingsResponse>>>;

    /**
     * Get all settings
     * Get settings
     */
    getSettings(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<SettingSettingsResponse>>;

    /**
     * Get audit logs for all users
     * @summary Get user audit logs
     * @param {ModelGetAuditLogsRequest} [modelGetAuditLogsRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getUserAuditLogsRaw(requestParameters: GetUserAuditLogsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<PostgresqlDbGetAuditLogsRow>>>;

    /**
     * Get audit logs for all users
     * Get user audit logs
     */
    getUserAuditLogs(requestParameters: GetUserAuditLogsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<PostgresqlDbGetAuditLogsRow>>;

    /**
     * Get user audit logs count
     * @summary Get user audit logs count
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    getUserAuditLogsCountRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchSearchCountResp>>;

    /**
     * Get user audit logs count
     * Get user audit logs count
     */
    getUserAuditLogsCount(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchSearchCountResp>;

    /**
     * Register new license key to the console and activate
     * @summary Register License
     * @param {ModelRegisterLicenseRequest} [modelRegisterLicenseRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    registerLicenseRaw(requestParameters: RegisterLicenseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelRegisterLicenseResponse>>;

    /**
     * Register new license key to the console and activate
     * Register License
     */
    registerLicense(requestParameters: RegisterLicenseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelRegisterLicenseResponse>;

    /**
     * Test Configured Email
     * @summary Test Configured Email
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    testConfiguredEmailRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>>;

    /**
     * Test Configured Email
     * Test Configured Email
     */
    testConfiguredEmail(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse>;

    /**
     * Test Unconfigured Email
     * @summary Test Unconfigured Email
     * @param {ModelEmailConfigurationAdd} [modelEmailConfigurationAdd] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    testUnconfiguredEmailRaw(requestParameters: TestUnconfiguredEmailRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>>;

    /**
     * Test Unconfigured Email
     * Test Unconfigured Email
     */
    testUnconfiguredEmail(requestParameters: TestUnconfiguredEmailRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse>;

    /**
     * Update scheduled task
     * @summary Update scheduled task
     * @param {number} id 
     * @param {ModelUpdateScheduledTaskRequest} [modelUpdateScheduledTaskRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    updateScheduledTaskRaw(requestParameters: UpdateScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Update scheduled task
     * Update scheduled task
     */
    updateScheduledTask(requestParameters: UpdateScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Update setting
     * @summary Update setting
     * @param {number} id 
     * @param {SettingSettingUpdateRequest} [settingSettingUpdateRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    updateSettingRaw(requestParameters: UpdateSettingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Update setting
     * Update setting
     */
    updateSetting(requestParameters: UpdateSettingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Upload Agent version
     * @summary Upload New agent version
     * @param {Blob} tarball 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    uploadAgentVersionRaw(requestParameters: UploadAgentVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Upload Agent version
     * Upload New agent version
     */
    uploadAgentVersion(requestParameters: UploadAgentVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Upload malware rules for use in malware scans
     * @summary Upload Malware Rules
     * @param {Blob} database 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    uploadMalwareRulesRaw(requestParameters: UploadMalwareRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>>;

    /**
     * Upload malware rules for use in malware scans
     * Upload Malware Rules
     */
    uploadMalwareRules(requestParameters: UploadMalwareRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse>;

    /**
     * Upload posture controls for use in posture scans
     * @summary Upload Posture Controls
     * @param {Blob} database 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    uploadPostureControlsRaw(requestParameters: UploadPostureControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>>;

    /**
     * Upload posture controls for use in posture scans
     * Upload Posture Controls
     */
    uploadPostureControls(requestParameters: UploadPostureControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse>;

    /**
     * Upload secrets rules for use in secrets scans
     * @summary Upload Secrets Rules
     * @param {Blob} database 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    uploadSecretsRulesRaw(requestParameters: UploadSecretsRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>>;

    /**
     * Upload secrets rules for use in secrets scans
     * Upload Secrets Rules
     */
    uploadSecretsRules(requestParameters: UploadSecretsRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse>;

    /**
     * Upload Vulnerability Database for use in vulnerability scans
     * @summary Upload Vulnerability Database
     * @param {Blob} database 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SettingsApiInterface
     */
    uploadVulnerabilityDatabaseRaw(requestParameters: UploadVulnerabilityDatabaseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>>;

    /**
     * Upload Vulnerability Database for use in vulnerability scans
     * Upload Vulnerability Database
     */
    uploadVulnerabilityDatabase(requestParameters: UploadVulnerabilityDatabaseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse>;

}

/**
 * 
 */
export class SettingsApi extends runtime.BaseAPI implements SettingsApiInterface {

    /**
     * This email configuration is used to send email notifications
     * Add Email Configuration
     */
    async addEmailConfigurationRaw(requestParameters: AddEmailConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/email`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelEmailConfigurationAddToJSON(requestParameters.modelEmailConfigurationAdd),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMessageResponseFromJSON(jsonValue));
    }

    /**
     * This email configuration is used to send email notifications
     * Add Email Configuration
     */
    async addEmailConfiguration(requestParameters: AddEmailConfigurationRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse> {
        const response = await this.addEmailConfigurationRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Add scheduled task
     * Add scheduled task
     */
    async addScheduledTaskRaw(requestParameters: AddScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scheduled-task`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelAddScheduledTaskRequestToJSON(requestParameters.modelAddScheduledTaskRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Add scheduled task
     * Add scheduled task
     */
    async addScheduledTask(requestParameters: AddScheduledTaskRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.addScheduledTaskRaw(requestParameters, initOverrides);
    }

    /**
     * Delete Custom Schedule task
     * Delete Custom Schedule task
     */
    async deleteCustomScheduledTaskRaw(requestParameters: DeleteCustomScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling deleteCustomScheduledTask.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scheduled-task/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Delete Custom Schedule task
     * Delete Custom Schedule task
     */
    async deleteCustomScheduledTask(requestParameters: DeleteCustomScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteCustomScheduledTaskRaw(requestParameters, initOverrides);
    }

    /**
     * Delete Email Smtp / ses Configurations in system
     * Delete Email Configurations
     */
    async deleteEmailConfigurationRaw(requestParameters: DeleteEmailConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.configId === null || requestParameters.configId === undefined) {
            throw new runtime.RequiredError('configId','Required parameter requestParameters.configId was null or undefined when calling deleteEmailConfiguration.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/email/{config_id}`.replace(`{${"config_id"}}`, encodeURIComponent(String(requestParameters.configId))),
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Delete Email Smtp / ses Configurations in system
     * Delete Email Configurations
     */
    async deleteEmailConfiguration(requestParameters: DeleteEmailConfigurationRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteEmailConfigurationRaw(requestParameters, initOverrides);
    }

    /**
     * Delete license from the console database
     * Delete License
     */
    async deleteLicenseRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/license`,
            method: 'DELETE',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Delete license from the console database
     * Delete License
     */
    async deleteLicense(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.deleteLicenseRaw(initOverrides);
    }

    /**
     * Generate a new ThreatMapper license key
     * Generate License Key
     */
    async generateLicenseRaw(requestParameters: GenerateLicenseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelGenerateLicenseResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/license/generate`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelGenerateLicenseRequestToJSON(requestParameters.modelGenerateLicenseRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelGenerateLicenseResponseFromJSON(jsonValue));
    }

    /**
     * Generate a new ThreatMapper license key
     * Generate License Key
     */
    async generateLicense(requestParameters: GenerateLicenseRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelGenerateLicenseResponse> {
        const response = await this.generateLicenseRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get agent binary download url
     * Get agent binary download url
     */
    async getAgentBinaryDownloadURLRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelGetAgentBinaryDownloadURLResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/agent-deployment/binary/download-url`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelGetAgentBinaryDownloadURLResponseFromJSON(jsonValue));
    }

    /**
     * Get agent binary download url
     * Get agent binary download url
     */
    async getAgentBinaryDownloadURL(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelGetAgentBinaryDownloadURLResponse> {
        const response = await this.getAgentBinaryDownloadURLRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get available agent versions
     * Get available agent versions
     */
    async getAgentVersionsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelListAgentVersionResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/agent/versions`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelListAgentVersionRespFromJSON(jsonValue));
    }

    /**
     * Get available agent versions
     * Get available agent versions
     */
    async getAgentVersions(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelListAgentVersionResp> {
        const response = await this.getAgentVersionsRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get Email Smtp / ses Configurations in system
     * Get Email Configurations
     */
    async getEmailConfigurationRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelEmailConfigurationResp>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/email`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelEmailConfigurationRespFromJSON));
    }

    /**
     * Get Email Smtp / ses Configurations in system
     * Get Email Configurations
     */
    async getEmailConfiguration(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelEmailConfigurationResp>> {
        const response = await this.getEmailConfigurationRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get license status and expiry
     * Get License Details
     */
    async getLicenseRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelLicense>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/license`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelLicenseFromJSON(jsonValue));
    }

    /**
     * Get license status and expiry
     * Get License Details
     */
    async getLicense(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelLicense> {
        const response = await this.getLicenseRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get scheduled tasks
     * Get scheduled tasks
     */
    async getScheduledTasksRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<PostgresqlDbScheduler>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scheduled-task`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(PostgresqlDbSchedulerFromJSON));
    }

    /**
     * Get scheduled tasks
     * Get scheduled tasks
     */
    async getScheduledTasks(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<PostgresqlDbScheduler>> {
        const response = await this.getScheduledTasksRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get all settings
     * Get settings
     */
    async getSettingsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<SettingSettingsResponse>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/global-settings`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(SettingSettingsResponseFromJSON));
    }

    /**
     * Get all settings
     * Get settings
     */
    async getSettings(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<SettingSettingsResponse>> {
        const response = await this.getSettingsRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get audit logs for all users
     * Get user audit logs
     */
    async getUserAuditLogsRaw(requestParameters: GetUserAuditLogsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<PostgresqlDbGetAuditLogsRow>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/user-audit-log`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelGetAuditLogsRequestToJSON(requestParameters.modelGetAuditLogsRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(PostgresqlDbGetAuditLogsRowFromJSON));
    }

    /**
     * Get audit logs for all users
     * Get user audit logs
     */
    async getUserAuditLogs(requestParameters: GetUserAuditLogsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<PostgresqlDbGetAuditLogsRow>> {
        const response = await this.getUserAuditLogsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get user audit logs count
     * Get user audit logs count
     */
    async getUserAuditLogsCountRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchSearchCountResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/user-audit-log/count`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SearchSearchCountRespFromJSON(jsonValue));
    }

    /**
     * Get user audit logs count
     * Get user audit logs count
     */
    async getUserAuditLogsCount(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchSearchCountResp> {
        const response = await this.getUserAuditLogsCountRaw(initOverrides);
        return await response.value();
    }

    /**
     * Register new license key to the console and activate
     * Register License
     */
    async registerLicenseRaw(requestParameters: RegisterLicenseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelRegisterLicenseResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/license`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelRegisterLicenseRequestToJSON(requestParameters.modelRegisterLicenseRequest),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelRegisterLicenseResponseFromJSON(jsonValue));
    }

    /**
     * Register new license key to the console and activate
     * Register License
     */
    async registerLicense(requestParameters: RegisterLicenseRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelRegisterLicenseResponse> {
        const response = await this.registerLicenseRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Test Configured Email
     * Test Configured Email
     */
    async testConfiguredEmailRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/email/test`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMessageResponseFromJSON(jsonValue));
    }

    /**
     * Test Configured Email
     * Test Configured Email
     */
    async testConfiguredEmail(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse> {
        const response = await this.testConfiguredEmailRaw(initOverrides);
        return await response.value();
    }

    /**
     * Test Unconfigured Email
     * Test Unconfigured Email
     */
    async testUnconfiguredEmailRaw(requestParameters: TestUnconfiguredEmailRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/email/test-unconfigured`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelEmailConfigurationAddToJSON(requestParameters.modelEmailConfigurationAdd),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMessageResponseFromJSON(jsonValue));
    }

    /**
     * Test Unconfigured Email
     * Test Unconfigured Email
     */
    async testUnconfiguredEmail(requestParameters: TestUnconfiguredEmailRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse> {
        const response = await this.testUnconfiguredEmailRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Update scheduled task
     * Update scheduled task
     */
    async updateScheduledTaskRaw(requestParameters: UpdateScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling updateScheduledTask.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scheduled-task/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: ModelUpdateScheduledTaskRequestToJSON(requestParameters.modelUpdateScheduledTaskRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Update scheduled task
     * Update scheduled task
     */
    async updateScheduledTask(requestParameters: UpdateScheduledTaskRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.updateScheduledTaskRaw(requestParameters, initOverrides);
    }

    /**
     * Update setting
     * Update setting
     */
    async updateSettingRaw(requestParameters: UpdateSettingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.id === null || requestParameters.id === undefined) {
            throw new runtime.RequiredError('id','Required parameter requestParameters.id was null or undefined when calling updateSetting.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/settings/global-settings/{id}`.replace(`{${"id"}}`, encodeURIComponent(String(requestParameters.id))),
            method: 'PATCH',
            headers: headerParameters,
            query: queryParameters,
            body: SettingSettingUpdateRequestToJSON(requestParameters.settingSettingUpdateRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Update setting
     * Update setting
     */
    async updateSetting(requestParameters: UpdateSettingRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.updateSettingRaw(requestParameters, initOverrides);
    }

    /**
     * Upload Agent version
     * Upload New agent version
     */
    async uploadAgentVersionRaw(requestParameters: UploadAgentVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        if (requestParameters.tarball === null || requestParameters.tarball === undefined) {
            throw new runtime.RequiredError('tarball','Required parameter requestParameters.tarball was null or undefined when calling uploadAgentVersion.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.tarball !== undefined) {
            formParams.append('tarball', requestParameters.tarball as any);
        }

        const response = await this.request({
            path: `/deepfence/settings/agent/version`,
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Upload Agent version
     * Upload New agent version
     */
    async uploadAgentVersion(requestParameters: UploadAgentVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.uploadAgentVersionRaw(requestParameters, initOverrides);
    }

    /**
     * Upload malware rules for use in malware scans
     * Upload Malware Rules
     */
    async uploadMalwareRulesRaw(requestParameters: UploadMalwareRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>> {
        if (requestParameters.database === null || requestParameters.database === undefined) {
            throw new runtime.RequiredError('database','Required parameter requestParameters.database was null or undefined when calling uploadMalwareRules.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.database !== undefined) {
            formParams.append('database', requestParameters.database as any);
        }

        const response = await this.request({
            path: `/deepfence/database/malware`,
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMessageResponseFromJSON(jsonValue));
    }

    /**
     * Upload malware rules for use in malware scans
     * Upload Malware Rules
     */
    async uploadMalwareRules(requestParameters: UploadMalwareRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse> {
        const response = await this.uploadMalwareRulesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Upload posture controls for use in posture scans
     * Upload Posture Controls
     */
    async uploadPostureControlsRaw(requestParameters: UploadPostureControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>> {
        if (requestParameters.database === null || requestParameters.database === undefined) {
            throw new runtime.RequiredError('database','Required parameter requestParameters.database was null or undefined when calling uploadPostureControls.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.database !== undefined) {
            formParams.append('database', requestParameters.database as any);
        }

        const response = await this.request({
            path: `/deepfence/database/posture`,
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMessageResponseFromJSON(jsonValue));
    }

    /**
     * Upload posture controls for use in posture scans
     * Upload Posture Controls
     */
    async uploadPostureControls(requestParameters: UploadPostureControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse> {
        const response = await this.uploadPostureControlsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Upload secrets rules for use in secrets scans
     * Upload Secrets Rules
     */
    async uploadSecretsRulesRaw(requestParameters: UploadSecretsRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>> {
        if (requestParameters.database === null || requestParameters.database === undefined) {
            throw new runtime.RequiredError('database','Required parameter requestParameters.database was null or undefined when calling uploadSecretsRules.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.database !== undefined) {
            formParams.append('database', requestParameters.database as any);
        }

        const response = await this.request({
            path: `/deepfence/database/secret`,
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMessageResponseFromJSON(jsonValue));
    }

    /**
     * Upload secrets rules for use in secrets scans
     * Upload Secrets Rules
     */
    async uploadSecretsRules(requestParameters: UploadSecretsRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse> {
        const response = await this.uploadSecretsRulesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Upload Vulnerability Database for use in vulnerability scans
     * Upload Vulnerability Database
     */
    async uploadVulnerabilityDatabaseRaw(requestParameters: UploadVulnerabilityDatabaseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMessageResponse>> {
        if (requestParameters.database === null || requestParameters.database === undefined) {
            throw new runtime.RequiredError('database','Required parameter requestParameters.database was null or undefined when calling uploadVulnerabilityDatabase.');
        }

        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const consumes: runtime.Consume[] = [
            { contentType: 'multipart/form-data' },
        ];
        // @ts-ignore: canConsumeForm may be unused
        const canConsumeForm = runtime.canConsumeForm(consumes);

        let formParams: { append(param: string, value: any): any };
        let useForm = false;
        // use FormData to transmit files using content-type "multipart/form-data"
        useForm = canConsumeForm;
        if (useForm) {
            formParams = new FormData();
        } else {
            formParams = new URLSearchParams();
        }

        if (requestParameters.database !== undefined) {
            formParams.append('database', requestParameters.database as any);
        }

        const response = await this.request({
            path: `/deepfence/database/vulnerability`,
            method: 'PUT',
            headers: headerParameters,
            query: queryParameters,
            body: formParams,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMessageResponseFromJSON(jsonValue));
    }

    /**
     * Upload Vulnerability Database for use in vulnerability scans
     * Upload Vulnerability Database
     */
    async uploadVulnerabilityDatabase(requestParameters: UploadVulnerabilityDatabaseRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMessageResponse> {
        const response = await this.uploadVulnerabilityDatabaseRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
