/* tslint:disable */
/* eslint-disable */
/**
 * Deepfence ThreatMapper
 * Deepfence Runtime API provides programmatic control over Deepfence microservice securing your container, kubernetes and cloud deployments. The API abstracts away underlying infrastructure details like cloud provider,  container distros, container orchestrator and type of deployment. This is one uniform API to manage and control security alerts, policies and response to alerts for microservices running anywhere i.e. managed pure greenfield container deployments or a mix of containers, VMs and serverless paradigms like AWS Fargate.
 *
 * The version of the OpenAPI document: v2.5.0
 * Contact: community@deepfence.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ApiDocsBadRequestResponse,
  ApiDocsFailureResponse,
  ModelScanListReq,
  ModelScanListResp,
  ModelScanResultsReq,
  ModelScanStatusReq,
  ModelScanStatusResp,
  ModelScanTriggerResp,
  ModelSecretScanResult,
  ModelSecretScanResultRules,
  ModelSecretScanTriggerReq,
  ModelStopScanRequest,
  SearchResultGroupResp,
  SearchSearchCountResp,
} from '../models';
import {
    ApiDocsBadRequestResponseFromJSON,
    ApiDocsBadRequestResponseToJSON,
    ApiDocsFailureResponseFromJSON,
    ApiDocsFailureResponseToJSON,
    ModelScanListReqFromJSON,
    ModelScanListReqToJSON,
    ModelScanListRespFromJSON,
    ModelScanListRespToJSON,
    ModelScanResultsReqFromJSON,
    ModelScanResultsReqToJSON,
    ModelScanStatusReqFromJSON,
    ModelScanStatusReqToJSON,
    ModelScanStatusRespFromJSON,
    ModelScanStatusRespToJSON,
    ModelScanTriggerRespFromJSON,
    ModelScanTriggerRespToJSON,
    ModelSecretScanResultFromJSON,
    ModelSecretScanResultToJSON,
    ModelSecretScanResultRulesFromJSON,
    ModelSecretScanResultRulesToJSON,
    ModelSecretScanTriggerReqFromJSON,
    ModelSecretScanTriggerReqToJSON,
    ModelStopScanRequestFromJSON,
    ModelStopScanRequestToJSON,
    SearchResultGroupRespFromJSON,
    SearchResultGroupRespToJSON,
    SearchSearchCountRespFromJSON,
    SearchSearchCountRespToJSON,
} from '../models';

export interface CountResultsSecretScanRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface ListSecretScanRequest {
    modelScanListReq?: ModelScanListReq;
}

export interface ResultsRulesSecretScanRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface ResultsSecretScanRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface StartSecretScanRequest {
    modelSecretScanTriggerReq?: ModelSecretScanTriggerReq;
}

export interface StatusSecretScanRequest {
    modelScanStatusReq?: ModelScanStatusReq;
}

export interface StopSecretScanRequest {
    modelStopScanRequest?: ModelStopScanRequest;
}

/**
 * SecretScanApi - interface
 * 
 * @export
 * @interface SecretScanApiInterface
 */
export interface SecretScanApiInterface {
    /**
     * Get Secret Scans results on agent or registry
     * @summary Get Secret Scans Results
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretScanApiInterface
     */
    countResultsSecretScanRaw(requestParameters: CountResultsSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchSearchCountResp>>;

    /**
     * Get Secret Scans results on agent or registry
     * Get Secret Scans Results
     */
    countResultsSecretScan(requestParameters: CountResultsSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchSearchCountResp>;

    /**
     * Group Secret Scans results by severity/rule
     * @summary Group Secret Results
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretScanApiInterface
     */
    groupResultsSecretsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchResultGroupResp>>;

    /**
     * Group Secret Scans results by severity/rule
     * Group Secret Results
     */
    groupResultsSecrets(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchResultGroupResp>;

    /**
     * Get Secret Scans list on agent or registry
     * @summary Get Secret Scans List
     * @param {ModelScanListReq} [modelScanListReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretScanApiInterface
     */
    listSecretScanRaw(requestParameters: ListSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanListResp>>;

    /**
     * Get Secret Scans list on agent or registry
     * Get Secret Scans List
     */
    listSecretScan(requestParameters: ListSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanListResp>;

    /**
     * Get Secret Scans detected rules names
     * @summary Get Secret Scans Result Rules
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretScanApiInterface
     */
    resultsRulesSecretScanRaw(requestParameters: ResultsRulesSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelSecretScanResultRules>>;

    /**
     * Get Secret Scans detected rules names
     * Get Secret Scans Result Rules
     */
    resultsRulesSecretScan(requestParameters: ResultsRulesSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelSecretScanResultRules>;

    /**
     * Get Secret Scans results on agent or registry
     * @summary Get Secret Scans Results
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretScanApiInterface
     */
    resultsSecretScanRaw(requestParameters: ResultsSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelSecretScanResult>>;

    /**
     * Get Secret Scans results on agent or registry
     * Get Secret Scans Results
     */
    resultsSecretScan(requestParameters: ResultsSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelSecretScanResult>;

    /**
     * Start Secret Scan on agent or registry
     * @summary Start Secret Scan
     * @param {ModelSecretScanTriggerReq} [modelSecretScanTriggerReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretScanApiInterface
     */
    startSecretScanRaw(requestParameters: StartSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanTriggerResp>>;

    /**
     * Start Secret Scan on agent or registry
     * Start Secret Scan
     */
    startSecretScan(requestParameters: StartSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanTriggerResp>;

    /**
     * Get Secret Scan Status on agent or registry
     * @summary Get Secret Scan Status
     * @param {ModelScanStatusReq} [modelScanStatusReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretScanApiInterface
     */
    statusSecretScanRaw(requestParameters: StatusSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanStatusResp>>;

    /**
     * Get Secret Scan Status on agent or registry
     * Get Secret Scan Status
     */
    statusSecretScan(requestParameters: StatusSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanStatusResp>;

    /**
     * Stop Secret Scan on agent or registry
     * @summary Stop Secret Scan
     * @param {ModelStopScanRequest} [modelStopScanRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof SecretScanApiInterface
     */
    stopSecretScanRaw(requestParameters: StopSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Stop Secret Scan on agent or registry
     * Stop Secret Scan
     */
    stopSecretScan(requestParameters: StopSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

}

/**
 * 
 */
export class SecretScanApi extends runtime.BaseAPI implements SecretScanApiInterface {

    /**
     * Get Secret Scans results on agent or registry
     * Get Secret Scans Results
     */
    async countResultsSecretScanRaw(requestParameters: CountResultsSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchSearchCountResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/count/secret`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SearchSearchCountRespFromJSON(jsonValue));
    }

    /**
     * Get Secret Scans results on agent or registry
     * Get Secret Scans Results
     */
    async countResultsSecretScan(requestParameters: CountResultsSecretScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchSearchCountResp> {
        const response = await this.countResultsSecretScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Group Secret Scans results by severity/rule
     * Group Secret Results
     */
    async groupResultsSecretsRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchResultGroupResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/count/group/secret`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SearchResultGroupRespFromJSON(jsonValue));
    }

    /**
     * Group Secret Scans results by severity/rule
     * Group Secret Results
     */
    async groupResultsSecrets(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchResultGroupResp> {
        const response = await this.groupResultsSecretsRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get Secret Scans list on agent or registry
     * Get Secret Scans List
     */
    async listSecretScanRaw(requestParameters: ListSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanListResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/list/secret`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanListReqToJSON(requestParameters.modelScanListReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelScanListRespFromJSON(jsonValue));
    }

    /**
     * Get Secret Scans list on agent or registry
     * Get Secret Scans List
     */
    async listSecretScan(requestParameters: ListSecretScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanListResp> {
        const response = await this.listSecretScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Secret Scans detected rules names
     * Get Secret Scans Result Rules
     */
    async resultsRulesSecretScanRaw(requestParameters: ResultsRulesSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelSecretScanResultRules>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/secret/rules`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelSecretScanResultRulesFromJSON(jsonValue));
    }

    /**
     * Get Secret Scans detected rules names
     * Get Secret Scans Result Rules
     */
    async resultsRulesSecretScan(requestParameters: ResultsRulesSecretScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelSecretScanResultRules> {
        const response = await this.resultsRulesSecretScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Secret Scans results on agent or registry
     * Get Secret Scans Results
     */
    async resultsSecretScanRaw(requestParameters: ResultsSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelSecretScanResult>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/secret`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelSecretScanResultFromJSON(jsonValue));
    }

    /**
     * Get Secret Scans results on agent or registry
     * Get Secret Scans Results
     */
    async resultsSecretScan(requestParameters: ResultsSecretScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelSecretScanResult> {
        const response = await this.resultsSecretScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Start Secret Scan on agent or registry
     * Start Secret Scan
     */
    async startSecretScanRaw(requestParameters: StartSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanTriggerResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/start/secret`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelSecretScanTriggerReqToJSON(requestParameters.modelSecretScanTriggerReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelScanTriggerRespFromJSON(jsonValue));
    }

    /**
     * Start Secret Scan on agent or registry
     * Start Secret Scan
     */
    async startSecretScan(requestParameters: StartSecretScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanTriggerResp> {
        const response = await this.startSecretScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Secret Scan Status on agent or registry
     * Get Secret Scan Status
     */
    async statusSecretScanRaw(requestParameters: StatusSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanStatusResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/status/secret`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanStatusReqToJSON(requestParameters.modelScanStatusReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelScanStatusRespFromJSON(jsonValue));
    }

    /**
     * Get Secret Scan Status on agent or registry
     * Get Secret Scan Status
     */
    async statusSecretScan(requestParameters: StatusSecretScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanStatusResp> {
        const response = await this.statusSecretScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Stop Secret Scan on agent or registry
     * Stop Secret Scan
     */
    async stopSecretScanRaw(requestParameters: StopSecretScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/stop/secret`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelStopScanRequestToJSON(requestParameters.modelStopScanRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Stop Secret Scan on agent or registry
     * Stop Secret Scan
     */
    async stopSecretScan(requestParameters: StopSecretScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.stopSecretScanRaw(requestParameters, initOverrides);
    }

}
