/* tslint:disable */
/* eslint-disable */
/**
 * Deepfence ThreatMapper
 * Deepfence Runtime API provides programmatic control over Deepfence microservice securing your container, kubernetes and cloud deployments. The API abstracts away underlying infrastructure details like cloud provider,  container distros, container orchestrator and type of deployment. This is one uniform API to manage and control security alerts, policies and response to alerts for microservices running anywhere i.e. managed pure greenfield container deployments or a mix of containers, VMs and serverless paradigms like AWS Fargate.
 *
 * The version of the OpenAPI document: v2.5.0
 * Contact: community@deepfence.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ApiDocsBadRequestResponse,
  ApiDocsFailureResponse,
  ModelMalwareScanResult,
  ModelMalwareScanResultClass,
  ModelMalwareScanResultRules,
  ModelMalwareScanTriggerReq,
  ModelScanListReq,
  ModelScanListResp,
  ModelScanResultsReq,
  ModelScanStatusReq,
  ModelScanStatusResp,
  ModelScanTriggerResp,
  ModelStopScanRequest,
  SearchResultGroupResp,
  SearchSearchCountResp,
} from '../models';
import {
    ApiDocsBadRequestResponseFromJSON,
    ApiDocsBadRequestResponseToJSON,
    ApiDocsFailureResponseFromJSON,
    ApiDocsFailureResponseToJSON,
    ModelMalwareScanResultFromJSON,
    ModelMalwareScanResultToJSON,
    ModelMalwareScanResultClassFromJSON,
    ModelMalwareScanResultClassToJSON,
    ModelMalwareScanResultRulesFromJSON,
    ModelMalwareScanResultRulesToJSON,
    ModelMalwareScanTriggerReqFromJSON,
    ModelMalwareScanTriggerReqToJSON,
    ModelScanListReqFromJSON,
    ModelScanListReqToJSON,
    ModelScanListRespFromJSON,
    ModelScanListRespToJSON,
    ModelScanResultsReqFromJSON,
    ModelScanResultsReqToJSON,
    ModelScanStatusReqFromJSON,
    ModelScanStatusReqToJSON,
    ModelScanStatusRespFromJSON,
    ModelScanStatusRespToJSON,
    ModelScanTriggerRespFromJSON,
    ModelScanTriggerRespToJSON,
    ModelStopScanRequestFromJSON,
    ModelStopScanRequestToJSON,
    SearchResultGroupRespFromJSON,
    SearchResultGroupRespToJSON,
    SearchSearchCountRespFromJSON,
    SearchSearchCountRespToJSON,
} from '../models';

export interface CountResultsMalwareScanRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface ListMalwareScanRequest {
    modelScanListReq?: ModelScanListReq;
}

export interface ResultsClassMalwareScanRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface ResultsMalwareScanRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface ResultsRulesMalwareScanRequest {
    modelScanResultsReq?: ModelScanResultsReq;
}

export interface StartMalwareScanRequest {
    modelMalwareScanTriggerReq?: ModelMalwareScanTriggerReq;
}

export interface StatusMalwareScanRequest {
    modelScanStatusReq?: ModelScanStatusReq;
}

export interface StopMalwareScanRequest {
    modelStopScanRequest?: ModelStopScanRequest;
}

/**
 * MalwareScanApi - interface
 * 
 * @export
 * @interface MalwareScanApiInterface
 */
export interface MalwareScanApiInterface {
    /**
     * Get Malware Scans results on agent or registry
     * @summary Get Malware Scans Results
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    countResultsMalwareScanRaw(requestParameters: CountResultsMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchSearchCountResp>>;

    /**
     * Get Malware Scans results on agent or registry
     * Get Malware Scans Results
     */
    countResultsMalwareScan(requestParameters: CountResultsMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchSearchCountResp>;

    /**
     * Group Malware Scans results by severity/rule
     * @summary Group Malware Results
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    groupResultsMalwaresRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchResultGroupResp>>;

    /**
     * Group Malware Scans results by severity/rule
     * Group Malware Results
     */
    groupResultsMalwares(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchResultGroupResp>;

    /**
     * Group Malware Scans results by severity/class
     * @summary Group Malware Results By Class
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    groupResultsMalwaresClassRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchResultGroupResp>>;

    /**
     * Group Malware Scans results by severity/class
     * Group Malware Results By Class
     */
    groupResultsMalwaresClass(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchResultGroupResp>;

    /**
     * Get Malware Scans list on agent or registry
     * @summary Get Malware Scans List
     * @param {ModelScanListReq} [modelScanListReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    listMalwareScanRaw(requestParameters: ListMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanListResp>>;

    /**
     * Get Malware Scans list on agent or registry
     * Get Malware Scans List
     */
    listMalwareScan(requestParameters: ListMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanListResp>;

    /**
     * Get Malware Scans detected class names
     * @summary Get Malware Scans Results
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    resultsClassMalwareScanRaw(requestParameters: ResultsClassMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMalwareScanResultClass>>;

    /**
     * Get Malware Scans detected class names
     * Get Malware Scans Results
     */
    resultsClassMalwareScan(requestParameters: ResultsClassMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMalwareScanResultClass>;

    /**
     * Get Malware Scans results on agent or registry
     * @summary Get Malware Scans Results
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    resultsMalwareScanRaw(requestParameters: ResultsMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMalwareScanResult>>;

    /**
     * Get Malware Scans results on agent or registry
     * Get Malware Scans Results
     */
    resultsMalwareScan(requestParameters: ResultsMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMalwareScanResult>;

    /**
     * Get Malware Scans detected rules names
     * @summary Get Malware Scans Result Rules
     * @param {ModelScanResultsReq} [modelScanResultsReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    resultsRulesMalwareScanRaw(requestParameters: ResultsRulesMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMalwareScanResultRules>>;

    /**
     * Get Malware Scans detected rules names
     * Get Malware Scans Result Rules
     */
    resultsRulesMalwareScan(requestParameters: ResultsRulesMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMalwareScanResultRules>;

    /**
     * Start Malware Scan on agent or registry
     * @summary Start Malware Scan
     * @param {ModelMalwareScanTriggerReq} [modelMalwareScanTriggerReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    startMalwareScanRaw(requestParameters: StartMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanTriggerResp>>;

    /**
     * Start Malware Scan on agent or registry
     * Start Malware Scan
     */
    startMalwareScan(requestParameters: StartMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanTriggerResp>;

    /**
     * Get Malware Scan status on agent or registry
     * @summary Get Malware Scan Status
     * @param {ModelScanStatusReq} [modelScanStatusReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    statusMalwareScanRaw(requestParameters: StatusMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanStatusResp>>;

    /**
     * Get Malware Scan status on agent or registry
     * Get Malware Scan Status
     */
    statusMalwareScan(requestParameters: StatusMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanStatusResp>;

    /**
     * Stop Malware Scan on agent or registry
     * @summary Stop Malware Scan
     * @param {ModelStopScanRequest} [modelStopScanRequest] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof MalwareScanApiInterface
     */
    stopMalwareScanRaw(requestParameters: StopMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Stop Malware Scan on agent or registry
     * Stop Malware Scan
     */
    stopMalwareScan(requestParameters: StopMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

}

/**
 * 
 */
export class MalwareScanApi extends runtime.BaseAPI implements MalwareScanApiInterface {

    /**
     * Get Malware Scans results on agent or registry
     * Get Malware Scans Results
     */
    async countResultsMalwareScanRaw(requestParameters: CountResultsMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchSearchCountResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/count/malware`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SearchSearchCountRespFromJSON(jsonValue));
    }

    /**
     * Get Malware Scans results on agent or registry
     * Get Malware Scans Results
     */
    async countResultsMalwareScan(requestParameters: CountResultsMalwareScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchSearchCountResp> {
        const response = await this.countResultsMalwareScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Group Malware Scans results by severity/rule
     * Group Malware Results
     */
    async groupResultsMalwaresRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchResultGroupResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/count/group/malware`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SearchResultGroupRespFromJSON(jsonValue));
    }

    /**
     * Group Malware Scans results by severity/rule
     * Group Malware Results
     */
    async groupResultsMalwares(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchResultGroupResp> {
        const response = await this.groupResultsMalwaresRaw(initOverrides);
        return await response.value();
    }

    /**
     * Group Malware Scans results by severity/class
     * Group Malware Results By Class
     */
    async groupResultsMalwaresClassRaw(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<SearchResultGroupResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/count/group/malware/class`,
            method: 'GET',
            headers: headerParameters,
            query: queryParameters,
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => SearchResultGroupRespFromJSON(jsonValue));
    }

    /**
     * Group Malware Scans results by severity/class
     * Group Malware Results By Class
     */
    async groupResultsMalwaresClass(initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<SearchResultGroupResp> {
        const response = await this.groupResultsMalwaresClassRaw(initOverrides);
        return await response.value();
    }

    /**
     * Get Malware Scans list on agent or registry
     * Get Malware Scans List
     */
    async listMalwareScanRaw(requestParameters: ListMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanListResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/list/malware`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanListReqToJSON(requestParameters.modelScanListReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelScanListRespFromJSON(jsonValue));
    }

    /**
     * Get Malware Scans list on agent or registry
     * Get Malware Scans List
     */
    async listMalwareScan(requestParameters: ListMalwareScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanListResp> {
        const response = await this.listMalwareScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Malware Scans detected class names
     * Get Malware Scans Results
     */
    async resultsClassMalwareScanRaw(requestParameters: ResultsClassMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMalwareScanResultClass>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/malware/class`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMalwareScanResultClassFromJSON(jsonValue));
    }

    /**
     * Get Malware Scans detected class names
     * Get Malware Scans Results
     */
    async resultsClassMalwareScan(requestParameters: ResultsClassMalwareScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMalwareScanResultClass> {
        const response = await this.resultsClassMalwareScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Malware Scans results on agent or registry
     * Get Malware Scans Results
     */
    async resultsMalwareScanRaw(requestParameters: ResultsMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMalwareScanResult>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/malware`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMalwareScanResultFromJSON(jsonValue));
    }

    /**
     * Get Malware Scans results on agent or registry
     * Get Malware Scans Results
     */
    async resultsMalwareScan(requestParameters: ResultsMalwareScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMalwareScanResult> {
        const response = await this.resultsMalwareScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Malware Scans detected rules names
     * Get Malware Scans Result Rules
     */
    async resultsRulesMalwareScanRaw(requestParameters: ResultsRulesMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelMalwareScanResultRules>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/results/malware/rules`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanResultsReqToJSON(requestParameters.modelScanResultsReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelMalwareScanResultRulesFromJSON(jsonValue));
    }

    /**
     * Get Malware Scans detected rules names
     * Get Malware Scans Result Rules
     */
    async resultsRulesMalwareScan(requestParameters: ResultsRulesMalwareScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelMalwareScanResultRules> {
        const response = await this.resultsRulesMalwareScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Start Malware Scan on agent or registry
     * Start Malware Scan
     */
    async startMalwareScanRaw(requestParameters: StartMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanTriggerResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/start/malware`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelMalwareScanTriggerReqToJSON(requestParameters.modelMalwareScanTriggerReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelScanTriggerRespFromJSON(jsonValue));
    }

    /**
     * Start Malware Scan on agent or registry
     * Start Malware Scan
     */
    async startMalwareScan(requestParameters: StartMalwareScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanTriggerResp> {
        const response = await this.startMalwareScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Get Malware Scan status on agent or registry
     * Get Malware Scan Status
     */
    async statusMalwareScanRaw(requestParameters: StatusMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelScanStatusResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/status/malware`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelScanStatusReqToJSON(requestParameters.modelScanStatusReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelScanStatusRespFromJSON(jsonValue));
    }

    /**
     * Get Malware Scan status on agent or registry
     * Get Malware Scan Status
     */
    async statusMalwareScan(requestParameters: StatusMalwareScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelScanStatusResp> {
        const response = await this.statusMalwareScanRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Stop Malware Scan on agent or registry
     * Stop Malware Scan
     */
    async stopMalwareScanRaw(requestParameters: StopMalwareScanRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/scan/stop/malware`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelStopScanRequestToJSON(requestParameters.modelStopScanRequest),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Stop Malware Scan on agent or registry
     * Stop Malware Scan
     */
    async stopMalwareScan(requestParameters: StopMalwareScanRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.stopMalwareScanRaw(requestParameters, initOverrides);
    }

}
