/* tslint:disable */
/* eslint-disable */
/**
 * Deepfence ThreatMapper
 * Deepfence Runtime API provides programmatic control over Deepfence microservice securing your container, kubernetes and cloud deployments. The API abstracts away underlying infrastructure details like cloud provider,  container distros, container orchestrator and type of deployment. This is one uniform API to manage and control security alerts, policies and response to alerts for microservices running anywhere i.e. managed pure greenfield container deployments or a mix of containers, VMs and serverless paradigms like AWS Fargate.
 *
 * The version of the OpenAPI document: v2.5.0
 * Contact: community@deepfence.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ApiDocsBadRequestResponse,
  ApiDocsFailureResponse,
  LookupLookupFilter,
  ModelCloudCompliance,
  ModelCloudComplianceControl,
  ModelCloudResource,
  ModelCompliance,
  ModelContainer,
  ModelContainerImage,
  ModelHost,
  ModelKubernetesCluster,
  ModelMalware,
  ModelMalwareRule,
  ModelPod,
  ModelProcess,
  ModelRegistryAccount,
  ModelSecret,
  ModelSecretRule,
  ModelVulnerability,
  ModelVulnerabilityRule,
} from '../models';
import {
    ApiDocsBadRequestResponseFromJSON,
    ApiDocsBadRequestResponseToJSON,
    ApiDocsFailureResponseFromJSON,
    ApiDocsFailureResponseToJSON,
    LookupLookupFilterFromJSON,
    LookupLookupFilterToJSON,
    ModelCloudComplianceFromJSON,
    ModelCloudComplianceToJSON,
    ModelCloudComplianceControlFromJSON,
    ModelCloudComplianceControlToJSON,
    ModelCloudResourceFromJSON,
    ModelCloudResourceToJSON,
    ModelComplianceFromJSON,
    ModelComplianceToJSON,
    ModelContainerFromJSON,
    ModelContainerToJSON,
    ModelContainerImageFromJSON,
    ModelContainerImageToJSON,
    ModelHostFromJSON,
    ModelHostToJSON,
    ModelKubernetesClusterFromJSON,
    ModelKubernetesClusterToJSON,
    ModelMalwareFromJSON,
    ModelMalwareToJSON,
    ModelMalwareRuleFromJSON,
    ModelMalwareRuleToJSON,
    ModelPodFromJSON,
    ModelPodToJSON,
    ModelProcessFromJSON,
    ModelProcessToJSON,
    ModelRegistryAccountFromJSON,
    ModelRegistryAccountToJSON,
    ModelSecretFromJSON,
    ModelSecretToJSON,
    ModelSecretRuleFromJSON,
    ModelSecretRuleToJSON,
    ModelVulnerabilityFromJSON,
    ModelVulnerabilityToJSON,
    ModelVulnerabilityRuleFromJSON,
    ModelVulnerabilityRuleToJSON,
} from '../models';

export interface GetCloudCompliancesRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetCloudResourcesRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetComplianceControlsRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetCompliancesRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetContainerImagesRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetContainersRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetHostsRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetKubernetesClustersRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetMalwareRulesRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetMalwaresRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetPodsRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetProcessesRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetRegistryAccountRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetSecretRulesRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetSecretsRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetVulnerabilitiesRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

export interface GetVulnerabilityRulesRequest {
    lookupLookupFilter?: LookupLookupFilter;
}

/**
 * LookupApi - interface
 * 
 * @export
 * @interface LookupApiInterface
 */
export interface LookupApiInterface {
    /**
     * Retrieve all the data associated with cloud-compliances
     * @summary Retrieve Cloud Compliances data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getCloudCompliancesRaw(requestParameters: GetCloudCompliancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelCloudCompliance>>>;

    /**
     * Retrieve all the data associated with cloud-compliances
     * Retrieve Cloud Compliances data
     */
    getCloudCompliances(requestParameters: GetCloudCompliancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelCloudCompliance>>;

    /**
     * Retrieve the cloud resources
     * @summary Get Cloud Resources
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getCloudResourcesRaw(requestParameters: GetCloudResourcesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelCloudResource>>>;

    /**
     * Retrieve the cloud resources
     * Get Cloud Resources
     */
    getCloudResources(requestParameters: GetCloudResourcesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelCloudResource>>;

    /**
     * Retrieve all the data associated with cloud compliance controls
     * @summary Retrieve Cloud Compliances Control data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getComplianceControlsRaw(requestParameters: GetComplianceControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelCloudComplianceControl>>>;

    /**
     * Retrieve all the data associated with cloud compliance controls
     * Retrieve Cloud Compliances Control data
     */
    getComplianceControls(requestParameters: GetComplianceControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelCloudComplianceControl>>;

    /**
     * Retrieve all the data associated with compliances
     * @summary Retrieve Compliances data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getCompliancesRaw(requestParameters: GetCompliancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelCompliance>>>;

    /**
     * Retrieve all the data associated with compliances
     * Retrieve Compliances data
     */
    getCompliances(requestParameters: GetCompliancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelCompliance>>;

    /**
     * Retrieve all the data associated with images
     * @summary Retrieve Container Images data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getContainerImagesRaw(requestParameters: GetContainerImagesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelContainerImage>>>;

    /**
     * Retrieve all the data associated with images
     * Retrieve Container Images data
     */
    getContainerImages(requestParameters: GetContainerImagesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelContainerImage>>;

    /**
     * Retrieve all the data associated with containers
     * @summary Retrieve Containers data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getContainersRaw(requestParameters: GetContainersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelContainer>>>;

    /**
     * Retrieve all the data associated with containers
     * Retrieve Containers data
     */
    getContainers(requestParameters: GetContainersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelContainer>>;

    /**
     * Retrieve all the data associated with hosts
     * @summary Retrieve Hosts data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getHostsRaw(requestParameters: GetHostsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelHost>>>;

    /**
     * Retrieve all the data associated with hosts
     * Retrieve Hosts data
     */
    getHosts(requestParameters: GetHostsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelHost>>;

    /**
     * Retrieve all the data associated with k8s clusters
     * @summary Retrieve K8s data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getKubernetesClustersRaw(requestParameters: GetKubernetesClustersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelKubernetesCluster>>>;

    /**
     * Retrieve all the data associated with k8s clusters
     * Retrieve K8s data
     */
    getKubernetesClusters(requestParameters: GetKubernetesClustersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelKubernetesCluster>>;

    /**
     * Retrieve malware rule resources
     * @summary Get Malware Rules
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getMalwareRulesRaw(requestParameters: GetMalwareRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelMalwareRule>>>;

    /**
     * Retrieve malware rule resources
     * Get Malware Rules
     */
    getMalwareRules(requestParameters: GetMalwareRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelMalwareRule>>;

    /**
     * Retrieve all the data associated with malwares
     * @summary Retrieve Malwares data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getMalwaresRaw(requestParameters: GetMalwaresRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelMalware>>>;

    /**
     * Retrieve all the data associated with malwares
     * Retrieve Malwares data
     */
    getMalwares(requestParameters: GetMalwaresRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelMalware>>;

    /**
     * Retrieve all the data associated with pods
     * @summary Retrieve Pods data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getPodsRaw(requestParameters: GetPodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelPod>>>;

    /**
     * Retrieve all the data associated with pods
     * Retrieve Pods data
     */
    getPods(requestParameters: GetPodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelPod>>;

    /**
     * Retrieve all the data associated with processes
     * @summary Retrieve Processes data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getProcessesRaw(requestParameters: GetProcessesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelProcess>>>;

    /**
     * Retrieve all the data associated with processes
     * Retrieve Processes data
     */
    getProcesses(requestParameters: GetProcessesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelProcess>>;

    /**
     * List all the images present in the given registry
     * @summary Get Images in Registry
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getRegistryAccountRaw(requestParameters: GetRegistryAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelRegistryAccount>>>;

    /**
     * List all the images present in the given registry
     * Get Images in Registry
     */
    getRegistryAccount(requestParameters: GetRegistryAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelRegistryAccount>>;

    /**
     * Retrieve secret rule resources
     * @summary Get Secret Rules
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getSecretRulesRaw(requestParameters: GetSecretRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelSecretRule>>>;

    /**
     * Retrieve secret rule resources
     * Get Secret Rules
     */
    getSecretRules(requestParameters: GetSecretRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelSecretRule>>;

    /**
     * Retrieve all the data associated with secrets
     * @summary Retrieve Secrets data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getSecretsRaw(requestParameters: GetSecretsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelSecret>>>;

    /**
     * Retrieve all the data associated with secrets
     * Retrieve Secrets data
     */
    getSecrets(requestParameters: GetSecretsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelSecret>>;

    /**
     * Retrieve all the data associated with vulnerabilities
     * @summary Retrieve Vulnerabilities data
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getVulnerabilitiesRaw(requestParameters: GetVulnerabilitiesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelVulnerability>>>;

    /**
     * Retrieve all the data associated with vulnerabilities
     * Retrieve Vulnerabilities data
     */
    getVulnerabilities(requestParameters: GetVulnerabilitiesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelVulnerability>>;

    /**
     * Retrieve vulnerability rule resources
     * @summary Get Vulnerability Rules
     * @param {LookupLookupFilter} [lookupLookupFilter] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof LookupApiInterface
     */
    getVulnerabilityRulesRaw(requestParameters: GetVulnerabilityRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelVulnerabilityRule>>>;

    /**
     * Retrieve vulnerability rule resources
     * Get Vulnerability Rules
     */
    getVulnerabilityRules(requestParameters: GetVulnerabilityRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelVulnerabilityRule>>;

}

/**
 * 
 */
export class LookupApi extends runtime.BaseAPI implements LookupApiInterface {

    /**
     * Retrieve all the data associated with cloud-compliances
     * Retrieve Cloud Compliances data
     */
    async getCloudCompliancesRaw(requestParameters: GetCloudCompliancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelCloudCompliance>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/cloud-compliances`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelCloudComplianceFromJSON));
    }

    /**
     * Retrieve all the data associated with cloud-compliances
     * Retrieve Cloud Compliances data
     */
    async getCloudCompliances(requestParameters: GetCloudCompliancesRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelCloudCompliance>> {
        const response = await this.getCloudCompliancesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve the cloud resources
     * Get Cloud Resources
     */
    async getCloudResourcesRaw(requestParameters: GetCloudResourcesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelCloudResource>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/cloud-resources`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelCloudResourceFromJSON));
    }

    /**
     * Retrieve the cloud resources
     * Get Cloud Resources
     */
    async getCloudResources(requestParameters: GetCloudResourcesRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelCloudResource>> {
        const response = await this.getCloudResourcesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with cloud compliance controls
     * Retrieve Cloud Compliances Control data
     */
    async getComplianceControlsRaw(requestParameters: GetComplianceControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelCloudComplianceControl>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/compliance-controls`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelCloudComplianceControlFromJSON));
    }

    /**
     * Retrieve all the data associated with cloud compliance controls
     * Retrieve Cloud Compliances Control data
     */
    async getComplianceControls(requestParameters: GetComplianceControlsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelCloudComplianceControl>> {
        const response = await this.getComplianceControlsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with compliances
     * Retrieve Compliances data
     */
    async getCompliancesRaw(requestParameters: GetCompliancesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelCompliance>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/compliances`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelComplianceFromJSON));
    }

    /**
     * Retrieve all the data associated with compliances
     * Retrieve Compliances data
     */
    async getCompliances(requestParameters: GetCompliancesRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelCompliance>> {
        const response = await this.getCompliancesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with images
     * Retrieve Container Images data
     */
    async getContainerImagesRaw(requestParameters: GetContainerImagesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelContainerImage>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/containerimages`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelContainerImageFromJSON));
    }

    /**
     * Retrieve all the data associated with images
     * Retrieve Container Images data
     */
    async getContainerImages(requestParameters: GetContainerImagesRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelContainerImage>> {
        const response = await this.getContainerImagesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with containers
     * Retrieve Containers data
     */
    async getContainersRaw(requestParameters: GetContainersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelContainer>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/containers`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelContainerFromJSON));
    }

    /**
     * Retrieve all the data associated with containers
     * Retrieve Containers data
     */
    async getContainers(requestParameters: GetContainersRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelContainer>> {
        const response = await this.getContainersRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with hosts
     * Retrieve Hosts data
     */
    async getHostsRaw(requestParameters: GetHostsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelHost>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/hosts`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelHostFromJSON));
    }

    /**
     * Retrieve all the data associated with hosts
     * Retrieve Hosts data
     */
    async getHosts(requestParameters: GetHostsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelHost>> {
        const response = await this.getHostsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with k8s clusters
     * Retrieve K8s data
     */
    async getKubernetesClustersRaw(requestParameters: GetKubernetesClustersRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelKubernetesCluster>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/kubernetesclusters`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelKubernetesClusterFromJSON));
    }

    /**
     * Retrieve all the data associated with k8s clusters
     * Retrieve K8s data
     */
    async getKubernetesClusters(requestParameters: GetKubernetesClustersRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelKubernetesCluster>> {
        const response = await this.getKubernetesClustersRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve malware rule resources
     * Get Malware Rules
     */
    async getMalwareRulesRaw(requestParameters: GetMalwareRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelMalwareRule>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/malware-rules`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelMalwareRuleFromJSON));
    }

    /**
     * Retrieve malware rule resources
     * Get Malware Rules
     */
    async getMalwareRules(requestParameters: GetMalwareRulesRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelMalwareRule>> {
        const response = await this.getMalwareRulesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with malwares
     * Retrieve Malwares data
     */
    async getMalwaresRaw(requestParameters: GetMalwaresRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelMalware>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/malwares`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelMalwareFromJSON));
    }

    /**
     * Retrieve all the data associated with malwares
     * Retrieve Malwares data
     */
    async getMalwares(requestParameters: GetMalwaresRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelMalware>> {
        const response = await this.getMalwaresRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with pods
     * Retrieve Pods data
     */
    async getPodsRaw(requestParameters: GetPodsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelPod>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/pods`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelPodFromJSON));
    }

    /**
     * Retrieve all the data associated with pods
     * Retrieve Pods data
     */
    async getPods(requestParameters: GetPodsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelPod>> {
        const response = await this.getPodsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with processes
     * Retrieve Processes data
     */
    async getProcessesRaw(requestParameters: GetProcessesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelProcess>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/processes`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelProcessFromJSON));
    }

    /**
     * Retrieve all the data associated with processes
     * Retrieve Processes data
     */
    async getProcesses(requestParameters: GetProcessesRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelProcess>> {
        const response = await this.getProcessesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * List all the images present in the given registry
     * Get Images in Registry
     */
    async getRegistryAccountRaw(requestParameters: GetRegistryAccountRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelRegistryAccount>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/registryaccount`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelRegistryAccountFromJSON));
    }

    /**
     * List all the images present in the given registry
     * Get Images in Registry
     */
    async getRegistryAccount(requestParameters: GetRegistryAccountRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelRegistryAccount>> {
        const response = await this.getRegistryAccountRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve secret rule resources
     * Get Secret Rules
     */
    async getSecretRulesRaw(requestParameters: GetSecretRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelSecretRule>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/secret-rules`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelSecretRuleFromJSON));
    }

    /**
     * Retrieve secret rule resources
     * Get Secret Rules
     */
    async getSecretRules(requestParameters: GetSecretRulesRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelSecretRule>> {
        const response = await this.getSecretRulesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with secrets
     * Retrieve Secrets data
     */
    async getSecretsRaw(requestParameters: GetSecretsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelSecret>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/secrets`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelSecretFromJSON));
    }

    /**
     * Retrieve all the data associated with secrets
     * Retrieve Secrets data
     */
    async getSecrets(requestParameters: GetSecretsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelSecret>> {
        const response = await this.getSecretsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve all the data associated with vulnerabilities
     * Retrieve Vulnerabilities data
     */
    async getVulnerabilitiesRaw(requestParameters: GetVulnerabilitiesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelVulnerability>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/vulnerabilities`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelVulnerabilityFromJSON));
    }

    /**
     * Retrieve all the data associated with vulnerabilities
     * Retrieve Vulnerabilities data
     */
    async getVulnerabilities(requestParameters: GetVulnerabilitiesRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelVulnerability>> {
        const response = await this.getVulnerabilitiesRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Retrieve vulnerability rule resources
     * Get Vulnerability Rules
     */
    async getVulnerabilityRulesRaw(requestParameters: GetVulnerabilityRulesRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<Array<ModelVulnerabilityRule>>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/lookup/vulnerability-rules`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: LookupLookupFilterToJSON(requestParameters.lookupLookupFilter),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => jsonValue.map(ModelVulnerabilityRuleFromJSON));
    }

    /**
     * Retrieve vulnerability rule resources
     * Get Vulnerability Rules
     */
    async getVulnerabilityRules(requestParameters: GetVulnerabilityRulesRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<Array<ModelVulnerabilityRule>> {
        const response = await this.getVulnerabilityRulesRaw(requestParameters, initOverrides);
        return await response.value();
    }

}
