/* tslint:disable */
/* eslint-disable */
/**
 * Deepfence ThreatMapper
 * Deepfence Runtime API provides programmatic control over Deepfence microservice securing your container, kubernetes and cloud deployments. The API abstracts away underlying infrastructure details like cloud provider,  container distros, container orchestrator and type of deployment. This is one uniform API to manage and control security alerts, policies and response to alerts for microservices running anywhere i.e. managed pure greenfield container deployments or a mix of containers, VMs and serverless paradigms like AWS Fargate.
 *
 * The version of the OpenAPI document: v2.5.0
 * Contact: community@deepfence.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


import * as runtime from '../runtime';
import type {
  ApiDocsBadRequestResponse,
  ApiDocsFailureResponse,
  ControlsAgentControls,
  ModelAgentID,
  ModelAgentPluginDisable,
  ModelAgentPluginEnable,
  ModelAgentUpgrade,
  ModelCloudNodeControlReq,
  ModelCloudNodeControlResp,
  ModelCloudNodeEnableDisableReq,
  ModelInitAgentReq,
} from '../models';
import {
    ApiDocsBadRequestResponseFromJSON,
    ApiDocsBadRequestResponseToJSON,
    ApiDocsFailureResponseFromJSON,
    ApiDocsFailureResponseToJSON,
    ControlsAgentControlsFromJSON,
    ControlsAgentControlsToJSON,
    ModelAgentIDFromJSON,
    ModelAgentIDToJSON,
    ModelAgentPluginDisableFromJSON,
    ModelAgentPluginDisableToJSON,
    ModelAgentPluginEnableFromJSON,
    ModelAgentPluginEnableToJSON,
    ModelAgentUpgradeFromJSON,
    ModelAgentUpgradeToJSON,
    ModelCloudNodeControlReqFromJSON,
    ModelCloudNodeControlReqToJSON,
    ModelCloudNodeControlRespFromJSON,
    ModelCloudNodeControlRespToJSON,
    ModelCloudNodeEnableDisableReqFromJSON,
    ModelCloudNodeEnableDisableReqToJSON,
    ModelInitAgentReqFromJSON,
    ModelInitAgentReqToJSON,
} from '../models';

export interface DisableAgentPluginRequest {
    modelAgentPluginDisable?: ModelAgentPluginDisable;
}

export interface DisableCloudNodeControlsRequest {
    modelCloudNodeEnableDisableReq?: ModelCloudNodeEnableDisableReq;
}

export interface EnableAgentPluginRequest {
    modelAgentPluginEnable?: ModelAgentPluginEnable;
}

export interface EnableCloudNodeControlsRequest {
    modelCloudNodeEnableDisableReq?: ModelCloudNodeEnableDisableReq;
}

export interface GetAgentControlsRequest {
    modelAgentID?: ModelAgentID;
}

export interface GetAgentInitControlsRequest {
    modelInitAgentReq?: ModelInitAgentReq;
}

export interface GetCloudNodeControlsRequest {
    modelCloudNodeControlReq?: ModelCloudNodeControlReq;
}

export interface GetKubernetesClusterControlsRequest {
    modelAgentID?: ModelAgentID;
}

export interface UpgradeAgentVersionRequest {
    modelAgentUpgrade?: ModelAgentUpgrade;
}

/**
 * ControlsApi - interface
 * 
 * @export
 * @interface ControlsApiInterface
 */
export interface ControlsApiInterface {
    /**
     * Schedule agent plugin disable
     * @summary Schedule new agent plugin version disabling
     * @param {ModelAgentPluginDisable} [modelAgentPluginDisable] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ControlsApiInterface
     */
    disableAgentPluginRaw(requestParameters: DisableAgentPluginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Schedule agent plugin disable
     * Schedule new agent plugin version disabling
     */
    disableAgentPlugin(requestParameters: DisableAgentPluginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Disable controls for a cloud node
     * @summary Disable Cloud Node Controls
     * @param {ModelCloudNodeEnableDisableReq} [modelCloudNodeEnableDisableReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ControlsApiInterface
     */
    disableCloudNodeControlsRaw(requestParameters: DisableCloudNodeControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Disable controls for a cloud node
     * Disable Cloud Node Controls
     */
    disableCloudNodeControls(requestParameters: DisableCloudNodeControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Schedule agent plugin enable
     * @summary Schedule new agent plugin version enabling
     * @param {ModelAgentPluginEnable} [modelAgentPluginEnable] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ControlsApiInterface
     */
    enableAgentPluginRaw(requestParameters: EnableAgentPluginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Schedule agent plugin enable
     * Schedule new agent plugin version enabling
     */
    enableAgentPlugin(requestParameters: EnableAgentPluginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Enable controls for a cloud node
     * @summary Enable Cloud Node Controls
     * @param {ModelCloudNodeEnableDisableReq} [modelCloudNodeEnableDisableReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ControlsApiInterface
     */
    enableCloudNodeControlsRaw(requestParameters: EnableCloudNodeControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Enable controls for a cloud node
     * Enable Cloud Node Controls
     */
    enableCloudNodeControls(requestParameters: EnableCloudNodeControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

    /**
     * Fetch actions for a given agent
     * @summary Fetch Agent Actions
     * @param {ModelAgentID} [modelAgentID] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ControlsApiInterface
     */
    getAgentControlsRaw(requestParameters: GetAgentControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ControlsAgentControls>>;

    /**
     * Fetch actions for a given agent
     * Fetch Agent Actions
     */
    getAgentControls(requestParameters: GetAgentControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ControlsAgentControls>;

    /**
     * Fetch initial actions for a given agent after it started
     * @summary Fetch Agent Init Actions
     * @param {ModelInitAgentReq} [modelInitAgentReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ControlsApiInterface
     */
    getAgentInitControlsRaw(requestParameters: GetAgentInitControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ControlsAgentControls>>;

    /**
     * Fetch initial actions for a given agent after it started
     * Fetch Agent Init Actions
     */
    getAgentInitControls(requestParameters: GetAgentInitControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ControlsAgentControls>;

    /**
     * Fetch controls for a cloud node
     * @summary Fetch Cloud Node Controls
     * @param {ModelCloudNodeControlReq} [modelCloudNodeControlReq] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ControlsApiInterface
     */
    getCloudNodeControlsRaw(requestParameters: GetCloudNodeControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelCloudNodeControlResp>>;

    /**
     * Fetch controls for a cloud node
     * Fetch Cloud Node Controls
     */
    getCloudNodeControls(requestParameters: GetCloudNodeControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelCloudNodeControlResp>;

    /**
     * Fetch actions for a given Kubernetes Cluster
     * @summary Fetch Kubernetes Cluster Actions
     * @param {ModelAgentID} [modelAgentID] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ControlsApiInterface
     */
    getKubernetesClusterControlsRaw(requestParameters: GetKubernetesClusterControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ControlsAgentControls>>;

    /**
     * Fetch actions for a given Kubernetes Cluster
     * Fetch Kubernetes Cluster Actions
     */
    getKubernetesClusterControls(requestParameters: GetKubernetesClusterControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ControlsAgentControls>;

    /**
     * Schedule new agent version upgrade
     * @summary Schedule new agent version upgrade
     * @param {ModelAgentUpgrade} [modelAgentUpgrade] 
     * @param {*} [options] Override http request option.
     * @throws {RequiredError}
     * @memberof ControlsApiInterface
     */
    upgradeAgentVersionRaw(requestParameters: UpgradeAgentVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>>;

    /**
     * Schedule new agent version upgrade
     * Schedule new agent version upgrade
     */
    upgradeAgentVersion(requestParameters: UpgradeAgentVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void>;

}

/**
 * 
 */
export class ControlsApi extends runtime.BaseAPI implements ControlsApiInterface {

    /**
     * Schedule agent plugin disable
     * Schedule new agent plugin version disabling
     */
    async disableAgentPluginRaw(requestParameters: DisableAgentPluginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/controls/agent-plugins/disable`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelAgentPluginDisableToJSON(requestParameters.modelAgentPluginDisable),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Schedule agent plugin disable
     * Schedule new agent plugin version disabling
     */
    async disableAgentPlugin(requestParameters: DisableAgentPluginRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.disableAgentPluginRaw(requestParameters, initOverrides);
    }

    /**
     * Disable controls for a cloud node
     * Disable Cloud Node Controls
     */
    async disableCloudNodeControlsRaw(requestParameters: DisableCloudNodeControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/controls/cloud-node/disable`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelCloudNodeEnableDisableReqToJSON(requestParameters.modelCloudNodeEnableDisableReq),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Disable controls for a cloud node
     * Disable Cloud Node Controls
     */
    async disableCloudNodeControls(requestParameters: DisableCloudNodeControlsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.disableCloudNodeControlsRaw(requestParameters, initOverrides);
    }

    /**
     * Schedule agent plugin enable
     * Schedule new agent plugin version enabling
     */
    async enableAgentPluginRaw(requestParameters: EnableAgentPluginRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/controls/agent-plugins/enable`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelAgentPluginEnableToJSON(requestParameters.modelAgentPluginEnable),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Schedule agent plugin enable
     * Schedule new agent plugin version enabling
     */
    async enableAgentPlugin(requestParameters: EnableAgentPluginRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.enableAgentPluginRaw(requestParameters, initOverrides);
    }

    /**
     * Enable controls for a cloud node
     * Enable Cloud Node Controls
     */
    async enableCloudNodeControlsRaw(requestParameters: EnableCloudNodeControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/controls/cloud-node/enable`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelCloudNodeEnableDisableReqToJSON(requestParameters.modelCloudNodeEnableDisableReq),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Enable controls for a cloud node
     * Enable Cloud Node Controls
     */
    async enableCloudNodeControls(requestParameters: EnableCloudNodeControlsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.enableCloudNodeControlsRaw(requestParameters, initOverrides);
    }

    /**
     * Fetch actions for a given agent
     * Fetch Agent Actions
     */
    async getAgentControlsRaw(requestParameters: GetAgentControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ControlsAgentControls>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/controls/agent`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelAgentIDToJSON(requestParameters.modelAgentID),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ControlsAgentControlsFromJSON(jsonValue));
    }

    /**
     * Fetch actions for a given agent
     * Fetch Agent Actions
     */
    async getAgentControls(requestParameters: GetAgentControlsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ControlsAgentControls> {
        const response = await this.getAgentControlsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Fetch initial actions for a given agent after it started
     * Fetch Agent Init Actions
     */
    async getAgentInitControlsRaw(requestParameters: GetAgentInitControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ControlsAgentControls>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/controls/agent-init`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelInitAgentReqToJSON(requestParameters.modelInitAgentReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ControlsAgentControlsFromJSON(jsonValue));
    }

    /**
     * Fetch initial actions for a given agent after it started
     * Fetch Agent Init Actions
     */
    async getAgentInitControls(requestParameters: GetAgentInitControlsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ControlsAgentControls> {
        const response = await this.getAgentInitControlsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Fetch controls for a cloud node
     * Fetch Cloud Node Controls
     */
    async getCloudNodeControlsRaw(requestParameters: GetCloudNodeControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ModelCloudNodeControlResp>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/controls/cloud-node`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelCloudNodeControlReqToJSON(requestParameters.modelCloudNodeControlReq),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ModelCloudNodeControlRespFromJSON(jsonValue));
    }

    /**
     * Fetch controls for a cloud node
     * Fetch Cloud Node Controls
     */
    async getCloudNodeControls(requestParameters: GetCloudNodeControlsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ModelCloudNodeControlResp> {
        const response = await this.getCloudNodeControlsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Fetch actions for a given Kubernetes Cluster
     * Fetch Kubernetes Cluster Actions
     */
    async getKubernetesClusterControlsRaw(requestParameters: GetKubernetesClusterControlsRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<ControlsAgentControls>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/controls/kubernetes-cluster`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelAgentIDToJSON(requestParameters.modelAgentID),
        }, initOverrides);

        return new runtime.JSONApiResponse(response, (jsonValue) => ControlsAgentControlsFromJSON(jsonValue));
    }

    /**
     * Fetch actions for a given Kubernetes Cluster
     * Fetch Kubernetes Cluster Actions
     */
    async getKubernetesClusterControls(requestParameters: GetKubernetesClusterControlsRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<ControlsAgentControls> {
        const response = await this.getKubernetesClusterControlsRaw(requestParameters, initOverrides);
        return await response.value();
    }

    /**
     * Schedule new agent version upgrade
     * Schedule new agent version upgrade
     */
    async upgradeAgentVersionRaw(requestParameters: UpgradeAgentVersionRequest, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<runtime.ApiResponse<void>> {
        const queryParameters: any = {};

        const headerParameters: runtime.HTTPHeaders = {};

        headerParameters['Content-Type'] = 'application/json';

        if (this.configuration && this.configuration.accessToken) {
            const token = this.configuration.accessToken;
            const tokenString = await token("bearer_token", []);

            if (tokenString) {
                headerParameters["Authorization"] = `Bearer ${tokenString}`;
            }
        }
        const response = await this.request({
            path: `/deepfence/controls/agent-upgrade`,
            method: 'POST',
            headers: headerParameters,
            query: queryParameters,
            body: ModelAgentUpgradeToJSON(requestParameters.modelAgentUpgrade),
        }, initOverrides);

        return new runtime.VoidApiResponse(response);
    }

    /**
     * Schedule new agent version upgrade
     * Schedule new agent version upgrade
     */
    async upgradeAgentVersion(requestParameters: UpgradeAgentVersionRequest = {}, initOverrides?: RequestInit | runtime.InitOverrideFunction): Promise<void> {
        await this.upgradeAgentVersionRaw(requestParameters, initOverrides);
    }

}
