# Contributing to ThreatMapper

First off, thank you for taking the time to contribute!

Here are some important resources:
 
  * [Security Policy](SECURITY.md): If you need to share a security vulnerability, please refer to our Security Policy.
  * [Slack Discussions](https://join.slack.com/t/deepfence-community/shared_invite/zt-podmzle9-5X~qYx8wMaLt9bGWwkSdgQ): Any questions - join us on Slack
  * [Documentation](https://github.com/deepfence/ThreatMapper/wiki): Find and contribute to ThreatMapper documentation on the wiki.
  * [ThreatMapper License](LICENSE): ThreatMapper is 100% open source, using the Apache 2.0 license.
  * [Contributor License](https://docs.github.com/en/github/site-policy/github-terms-of-service#6-contributions-under-repository-license): The Apache 2.0 license applies to all contributions offered to the ThreatMapper project.
  * [Code of Conduct](CODE_OF_CONDUCT.md): The ThreatMapper community strives to be open and welcoming to all.

## How can I contribute?

### I'm having difficulty installing, operating or building ThreatMapper

Head over to our [Community Slack](https://join.slack.com/t/deepfence-community/shared_invite/zt-podmzle9-5X~qYx8wMaLt9bGWwkSdgQ) and share what's going on.  It's generally useful to include details of your installation, as ThreatMapper is under constant development and we fix bugs fast. `docker images list` and `docker ps -a`, or the equivalent Kubernetes commands are a good start.  Logs from any containers that may be misbehaving are also useful.

### I think I have found a bug in ThreatMapper

If you believe you've found a security vulnerability, please refer to our [Security Policy](SECURITY.md).

For all other bugs, please [first check if the issue has already been opened](https://github.com/deepfence/ThreatMapper/issues).  If so, go ahead and add details to the existing issue.

If the bug appears to be new, please [open a new GitHub Bug report](https://github.com/deepfence/ThreatMapper/issues/new/choose).  The template will prompt you for the information that will help us to understand and address the issue.

### I'd like to share a change to ThreatMapper

Thank you.  Please send a [GitHub Pull Request to ThreatMapper](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests) with a clear explanation of what you're seeking to achieve, and what you have done.

Code Style: we're flexible and accomodating. Copy the style of the code adjacent to your contributions, keep it clear and easy to understand for other developers and we're all good.

### I have an idea for an enhancement to ThreatMapper

If it's a well-formed enhancement, please [open a new GitHub Feature request](https://github.com/deepfence/ThreatMapper/issues/new/choose).  Explain the enhancement and any supporting information - who it benefits, why it's important etc.

If you'd like to discuss the idea before proposing it on GitHub, share it on our [Community Slack](https://join.slack.com/t/deepfence-community/shared_invite/zt-podmzle9-5X~qYx8wMaLt9bGWwkSdgQ) and we will work through it together.

## I'd like to talk to someone directly

You can reach out to the ThreatMapper community leads at **community *at* deepfence *dot* io**.