# 4.4.0 (2022-09-04)

### Build

- improve support for `vite` projects

# 4.3.0 (2022-03-18)

### Features

- use `.min.js` files to load addition languages at runtime
- an optional CDN can be provided instead of `https://unpkg.com/prismjs@latest` through a global variable `window.prismjs_cdn` to fetch additional languages

# 4.2.0 (2022-03-18)

### Features

- init and add new `terminal` style "Papyrs"
- update list of supported languages

### Build

- bump dependencies

# 4.1.0 (2022-02-27)

### Build

- bump `primsjs` and list of supported languages
- replace deprecated `dist-custom-elements-bundle` with `dist-custom-elements`

# 4.0.0 (2022-01-23)

### Breaking Changes

- component does **not** support an `editable` mode anymore

i.e. setting the property `editable` to `true` won't turn the shadowed `code` as `contenteditable` anymore!

Instead, if `editable` is set to `true`, it will only display an "edit" button above (bottom + right) the code.
If the button is triggered, an event `editCode` will be emitted. Edition itself has to be implemented by the consumer.

### Style

- lighter `box-shadow` default for host

# 3.6.0 (2021-12-01)

### Fix

- clean zero width spaces on copy

# 3.5.0 (2021-11-13)

### Feature

- fallback to JavaScript to display code anyway if the main language or a required one cannot be loaded

### Fix

- definitely solve required scripts loading if multiple components with the same complex languages are use in the same page

# 3.4.4 (2021-11-12)

### Fix

- miscellaneous languages on the same page and loading

# 3.4.3 (2021-11-12)

### Fix

- required languages scripts need to be loaded before loading main language script ([#1387](https://github.com/deckgo/deckdeckgo/pull/1387))

### Build

- bump `prismjs`
- bump `@deckdeckgo/utils`

# 3.4.2 (2021-11-04)

### Fix

- focus and text selection if editable

# 3.4.1 (2021-10-29)

### Refactor

- move `catchTab` function to utils

# 3.4.0 (2021-10-15)

### Features

- update list of code supported by prismjs

# 3.3.1 (2021-06-18)

### Fix

- editable content: support for html template as code block
- editable content: new lines duplication

# 3.3.0 (2021-05-29)

### Build

- output custom elements as a single bundle (`dist-custom-elements-bundle`)
- bump dependencies

# 3.2.0 (2021-05-29)

### Style

- add `width` and `height` CSS variables for the shadowed code block

# 3.1.0 (2021-05-28)

### Style

- adaptive header size (`em` instead of `px`)

# 3.0.2 (2021-05-21)

### Fix

- in case of overlapping highlighted rows, highlight from lowest

# 3.0.1 (2021-05-21)

### Fix

- property `revealProgress` should be mutable

# 3.0.0 (2021-05-21)

### Breaking Changes

- remove fetch code through an url\*
- highlight lines per default not through background but, with more contrast against those not highlighted ("highlight opacity 1, no highlighted opacity 0.32")

### Features

- support dash to highlight lines too (example: 1 4-8 12,18 22 26-32)
- animate highlight with methods `nextHighlight` and `prevHighlight` (this will "focus" the highlight through the groups)
- integrate functions and properties to animate the component when used in DeckDeckGo presentations

### Refactoring

- extract some functions to utils

* I removed this feature because I think it is really rarely used and, it can simplify the code base which had becomes quite complicated for such a component.

# 2.6.0 (2021-04-23)

### Features

- better support for JSX / HTML markup when component editable

# 2.5.2 (2021-04-23)

### Styles

- add new CSS variable `--deckgo-editable-cursor`

# 2.5.1 (2021-03-07)

### Styles

- add new CSS variable `--deckgo-highlight-code-line-height`

# 2.5.0 (2021-02-17)

### Features

- expose const `deckdeckgoHighlightCodeLanguages` to make the list of supported languages programmatically readable

# 2.4.0 (2021-02-17)

### Features

- improve `highlight-lines` to support single digit line (as for example `1,1` or `1` accepted)
- update languages list

# 2.3.2 (2021-01-29)

### Features

- on content editable `input`, debounce the copy of the changes to the `slot`

# 2.3.1 (2021-01-14)

### Style

- carbon toolbar spacing if not displayed

# 2.3.0 (2021-01-14)

### Features

Some new features related to the `editable` mode:

- make the shadowed `code` editable instead of `slot` (less quirky ui)
- on click on the host component, focus the editable `code`
- tab support

# 2.2.2 (2020-12-10)

### Features

- display a `console.error` if the language is not supported

### Fix

- support alias (such as `html` for `markup`)
- load alias required scripts
- required scripts loading race condition

# 2.2.1 (2020-11-19)

### Style

- cursor text if set as editable

# 2.2.0 (2020-11-19)

### Style

- new style to hide characters in ubuntu bar buttons
- ubuntu styling options variables renamed

# 2.1.1 (2020-10-23)

### Fix

- es5 has been dropped with v2, update `unpkg` reference

# 2.1.0 (2020-09-17)

### Features

- added the ability to toggle the Carbon toolbar and adjust the margin ([#873](https://github.com/deckgo/deckdeckgo/pull/873))

# 2.0.0 (2020-09-03)

### Breaking Changes

- IE11, Edge 16-18 and Safari 10 not supported

# 1.1.4 (2020-08-21)

### Fix

- load required scripts for prismjs ([#848](https://github.com/deckgo/deckdeckgo/issues/848))

# 1.1.3 (2020-08-08)

### Features

- update dependencies including prism v1.21.0

# 1.1.2 (2020-07-03)

### Style

- set default scrollbar (overflow) behavior to `auto` instead of `scroll`
- host `display` set as `block`

# 1.1.1 (2020-06-14)

### Style

- line numbers color inherits code's comments color
- when highlighting, highlight only code not line numbers

# 1.1.0 (2020-05-21)

### Features

- themes for the carbon terminals

# 1.0.5 (2020-05-11)

### Features

- update Stencil for Gatsby build

# 1.0.4 (2020-04-27)

### Fix

- if prism script did not load, do not keep reference in DOM

# 1.0.3 (2020-04-26)

### Features

- make code white-space a css variable ([#707](https://github.com/deckgo/deckdeckgo/issues/707))

# 1.0.2 (2020-04-02)

### Fix

- PrismJS CSS import into bundle

# 1.0.1 (2020-03-21)

### Features

- update dependencies

### Fix

- republish component bundle to fix loading of '~prismjs/themes/prism.css'

# 1.0.0 (2020-03-18)

To infinity and beyond 🚀

### Features

- update dependencies

# 1.0.0-rc.3-2 (2020-02-23)

### Fix

- CSS typo

# 1.0.0-rc.3-1 (2020-02-23)

- CSS variable misspelled
- require @deckdeckgo/utils rc.3

# 1.0.0-rc.3 (2020-02-23)

### Breaking Changes

- property `carbon` renamed to `terminal` (default display remains the same)

### Features

- new optional terminal style "Ubuntu" ([#623](https://github.com/deckgo/deckdeckgo/issues/623))

# 1.0.0-rc.2-1 (2019-12-12)

### Features

- if the language definition doesn't exist or if unpkg is down, display code anyway

# 1.0.0-rc.2 (2019-12-12)

### Breaking Changes

- as of now, code will be per default displayed in a stylish card. you could opt out setting the property `carbon` to `false` ([#525](https://github.com/deckgo/deckdeckgo/issues/525))

# 1.0.0-rc.1-3 (2019-10-21)

### Fix

- missing place holder (not displayed)

# 1.0.0-rc.1-2 (2019-10-21)

### Fix

- wrong code highlight when line numbers are off ([#423](https://github.com/deckgo/deckdeckgo/issues/423))

# 1.0.0-rc.1-1 (2019-09-09)

### Features

- display code container as `block` per default

# 1.0.0-rc.1 (2019-08-30)

### Libs

- update to most recent dependencies

### Note about v1.0.0-rc.1

The first users began to test, and to create content in, our web open source editor for presentations (`studio`)

# 1.0.0-alpha.19 (2019-08-15)

- add some CSS4 variables to style the code's container

# 1.0.0-alpha.18 (2019-08-09)

## Features

- improve lines highlighting detection with ResizeObserver for modern browsers

## Fix

- the component displayed line numbers from 1 but the highlight used to expect line numbers from 0. this is now fixed, highlight will also begin with 1.
- add empty lines if line numbers has to be displayed to avoid sizing problem regarding font-size

# 1.0.0-alpha.17 (2019-07-30)

### Features

- display optional line numbers [#115](https://github.com/deckgo/deckdeckgo/issues/115)

# 1.0.0-alpha.16 (2019-06-04)

### Libs

- upgrade to Stencil One

# 1.0.0-alpha.15 (2019-05-24)

### Breaking

- move to the org scoped package `@deckdeckgo/highlight-code`

# 1.0.0-alpha.14 (2019-04-30)

### Features

- add a default color for the code highlighting background

# 1.0.0-alpha.13 (2019-04-30)

### Features

- add new properties and events in case you would like optionally set the code block as `editable`

# 1.0.0-alpha.12 (2019-03-03)

### Features

- style: add a variable for the display of the shadowed code element ([e00a3ea](https://github.com/deckgo/deckdeckgo/commit/e00a3ea170330de867cfedcdd0390c56988ae2f7))

# [1.0.0-alpha.11](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.10...v1.0.0-alpha.11) (2019-02-11)

### Breaking changes

- refactor CSS4 margin variable to give access to the all margin element not just margin-bottom ((ec4d260)[https://github.com/deckgo/deckdeckgo-highlight-code/commit/ec4d2602d3fa10e8e1ddf0ee20790d1fd6646720])

# [1.0.0-alpha.10](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.9...v1.0.0-alpha.10) (2019-02-01)

### Features

- add a method to load or reload the component ([ab11a8c](https://github.com/deckgo/deckdeckgo-highlight-code/commit/ab11a8c3be46bb7b6f3cdee6d9c7b0119baea595))
- loading of component with src and particular language ([ed88c8e](https://github.com/deckgo/deckdeckgo-highlight-code/commit/ed88c8e92aceebeb7d673819a8bed616d8ed8022))
- prevent error in case language is set as empty ([3790fc9](https://github.com/deckgo/deckdeckgo-highlight-code/commit/3790fc94da019047df7792628478f7a7d0c390d5))

# [1.0.0-alpha.9](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.8...v1.0.0-alpha.9) (2019-02-01)

### Fix and rollback

- if not shadowed the component was not compatible if used in other shadowed components, therefore rollback to a shadowed component ([#5](https://github.com/deckgo/deckdeckgo-highlight-code/issues/5))

### Features

- add height new CSS4 variables to style the highlighted code ([#5](https://github.com/deckgo/deckdeckgo-highlight-code/issues/5))

# [1.0.0-alpha.8](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.8...v1.0.0-alpha.8) (2019-02-01)

### Fix

- when the component was used in shadowed component, sometimes the slot content was not loaded ([6df0d0e](https://github.com/deckgo/deckdeckgo-highlight-code/commit/6df0d0e6802afeba2277caa90b1b0e4ddcc39fed))

# [1.0.0-alpha.7](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.6...v1.0.0-alpha.7) (2019-02-01)

### Features

- this Web Component isn't shadowed anymore to give you full access to its style ([#5](https://github.com/deckgo/deckdeckgo-highlight-code/issues/5))

### Fix

- synchronize load languages across multiple components ([44fac83](https://github.com/deckgo/deckdeckgo-highlight-code/commit/44fac8378d6ea0d88ccb67175e3dcca2f0b9bb52))

# [1.0.0-alpha.6](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.5...v1.0.0-alpha.6) (2019-01-31)

### Refactor

- export anchor interface declaration ([680a2d3](https://github.com/deckgo/deckdeckgo-highlight-code/commit/680a2d30746a9cb86c617433b46ccb5c30894491))

# [1.0.0-alpha.5](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.4...v1.0.0-alpha.5) (2019-01-23)

### Bugs

- highlight code lines: first element might be a text ([#4](https://github.com/deckgo/deckdeckgo-highlight-code/issues/4))

# [1.0.0-alpha.4](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.3...v1.0.0-alpha.4) (2019-01-23)

### Bugs

- slot code: unescape characters ([#2](https://github.com/deckgo/deckdeckgo-highlight-code/issues/2))
- CSS text-align per default left ([#3](https://github.com/deckgo/deckdeckgo-highlight-code/issues/3))

# [1.0.0-alpha.3](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.2...v1.0.0-alpha.3) (2019-01-20)

### Features

- highlight code lines ([#1](https://github.com/deckgo/deckdeckgo-highlight-code/issues/1))

# [1.0.0-alpha.2](https://github.com/deckgo/deckdeckgo-highlight-code/compare/v1.0.0-alpha.1...v1.0.0-alpha.2) (2019-01-20)

### Breaking changes

- this Web Component doesn't provide a scroll assist method anymore but rather provide a method `findNextAnchor()` which would provide you the information about the next anchor position to scroll to
