interface I18nCore {
  close: string;
  loading: string;
  in_progress: string;
  yes: string;
  no: string;
  reset: string;
  ok: string;
  save: string;
  delete: string;
  sure: string;
  add: string;
  submit: string;
  cancel: string;
  got_it: string;
  back: string;
}

interface I18nNav {
  menu: string;
  sign_out: string;
  sign_in: string;
  write_a_presentation: string;
  ready_to_share: string;
  profile: string;
  customization: string;
  templates: string;
  settings: string;
  dashboard: string;
}

interface I18nNot_found {
  title: string;
  text: string;
  action: string;
}

interface I18nMenu {
  dashboard: string;
  poll: string;
  remote_control: string;
  editor: string;
  presentations: string;
  assets: string;
  documents: string;
}

interface I18nLinks {
  home: string;
  discover: string;
  enterprise: string;
  about: string;
  team: string;
  newsletter: string;
  contact: string;
  press: string;
  faq: string;
  developers: string;
  open_source: string;
  services: string;
  developer: string;
  terms: string;
  terms_of_use: string;
  privacy_policy: string;
}

interface I18nShare {
  a_presentation: string;
  a_document: string;
  content_by: string;
  content_no_author: string;
  update_share: string;
  embed: string;
  link: string;
}

interface I18nSign_in {
  hi: string;
  why: string;
  additionally: string;
  internet_identity: string;
  why_internet_computer: string;
  accept_by_continuing: string;
}

interface I18nSettings {
  un_publish: string;
  cannot_undone: string;
  type_to_confirm: string;
  type_ddg_to_confirm: string;
  i_understand: string;
  customization: string;
  edit_mode: string;
  properties: string;
  profile: string;
  access_settings: string;
  access_templates: string;
  access_decks: string;
  access_docs: string;
  access_assets: string;
  info_assets: string;
  profile_note: string;
  name: string;
  email: string;
  newsletter: string;
  username: string;
  danger_zone: string;
  no_way_back: string;
  delete_user: string;
  profile_picture: string;
  profile_picture_tips: string;
  summary: string;
  bio: string;
  custom: string;
  custom_url: string;
  logo_address: string;
  custom_logo: string;
  contribute_community: string;
  contact: string;
  add_a_template: string;
  deactivate_contrast_warning: string;
  contrast_warning: string;
  contrast_warning_active: string;
  contrast_warning_inactive: string;
}

interface I18nDashboard {
  welcome: string;
  your_presentations: string;
  your_documents: string;
  try: string;
  filter: string;
  no_slides: string;
  no_docs: string;
  sync_slides: string;
  sync_docs: string;
  copy: string;
  delete: string;
  cannot_undone: string;
  understand: string;
  published: string;
  edited: string;
}

interface I18nEditor {
  loading: string;
  add_slide: string;
  help: string;
  share: string;
  previous: string;
  next: string;
  slides: string;
  slide: string;
  style: string;
  present: string;
  go_online: string;
  go_offline: string;
  more: string;
  exit_fullscreen: string;
  export: string;
  delete: string;
  notes: string;
  notes_display: string;
  copy: string;
  format: string;
  options: string;
  transform: string;
  add_text: string;
  add_shape: string;
  add_image: string;
  image: string;
  qr_code: string;
  chart: string;
  text: string;
  header_footer: string;
  header_footer_sign_in: string;
  header_footer_edit: string;
  background: string;
  code: string;
  code_options: string;
  transition: string;
  sides: string;
  side: string;
  huge_title: string;
  large_title: string;
  small_title: string;
  paragraph: string;
  separator: string;
  skip: string;
  list: string;
  list_style: string;
  decimal: string;
  decimal_with_zero: string;
  latin_lowercase: string;
  latin_uppercase: string;
  roman_lowercase: string;
  roman_uppercase: string;
  bullet: string;
  circle: string;
  square: string;
  markdown: string;
  math: string;
  word_cloud: string;
  color: string;
  colors: string;
  series: string;
  series_index: string;
  word: string;
  color_picker: string;
  rgb_red: string;
  rgb_green: string;
  rgb_blue: string;
  images: string;
  history: string;
  history_details: string;
  stock_photo: string;
  photos_by_unsplash: string;
  searching: string;
  gif: string;
  your_images: string;
  waves: string;
  no_images: string;
  typography: string;
  default: string;
  community: string;
  yours: string;
  no_options: string;
  auto_slide: string;
  direction: string;
  horizontal: string;
  vertical: string;
  animation: string;
  swipe: string;
  fade: string;
  instant: string;
  desktop: string;
  mobile: string;
  block: string;
  rotate: string;
  deg: string;
  padding: string;
  width: string;
  border_radius: string;
  all_corners: string;
  individual_corners: string;
  top_left: string;
  top_right: string;
  bottom_right: string;
  bottom_left: string;
  box_shadow: string;
  horizontal_length: string;
  vertical_length: string;
  blur_radius: string;
  spread_radius: string;
  more_colors: string;
  apply_a_color_to: string;
  select_category: string;
  comments: string;
  functions: string;
  keywords: string;
  operators: string;
  punctuation: string;
  properties: string;
  regex: string;
  selector: string;
  line_numbers: string;
  display_line_number: string;
  terminal: string;
  select_terminal: string;
  theme: string;
  select_theme: string;
  display_toolbar: string;
  highlight_lines: string;
  size: string;
  select_font_size: string;
  very_small: string;
  small: string;
  normal: string;
  big: string;
  very_big: string;
  medium: string;
  large: string;
  custom: string;
  original: string;
  alignment: string;
  scale: string;
  start: string;
  center: string;
  left: string;
  right: string;
  end: string;
  animate_transition: string;
  ordered: string;
  unordered: string;
  letter_spacing: string;
  tighter: string;
  tight: string;
  wide: string;
  wider: string;
  superwide: string;
  widest: string;
  text_align: string;
  fill: string;
  backdrop: string;
  stroke: string;
  font: string;
  axis: string;
  grid: string;
  languages: string;
  language: string;
  filter_languages: string;
  your_data: string;
  your_collection_empty: string;
  upload_data: string;
  upload_image: string;
  demo: string;
  enter_demo_url: string;
  embed: string;
  copy_embed_code: string;
  copy_to_clipboard: string;
  gifs: string;
  search_tenor: string;
  url_playground: string;
  embed_codepen: string;
  youtube_video: string;
  question: string;
  enter_question: string;
  add_answer: string;
  published: string;
  remote: string;
  scan: string;
  direction_up: string;
  direction_down: string;
  enter_youtube_url: string;
  copy_style: string;
  apply_style: string;
  add_new_slide: string;
  select_chart: string;
  compose_slide: string;
  back_to_slides: string;
  action_cannot_undone: string;
  delete_question: string;
  fullscreen_tips: string;
  fullscreen_edit: string;
  fullscreen_typo: string;
  fullscreen_swipe: string;
  need_help: string;
  need_help_comment: string;
  reach_us: string;
  or: string;
  slide_background: string;
  macros: string;
  remote_enabled: string;
  remote_disabled: string;
  presenter_view: string;
  remote_features: string;
  open_presenter_view: string;
  control_presentation: string;
  connect: string;
  start_presenting: string;
  enter_fullscreen_to_start: string;
  enter_fullscreen: string;
  no_pending_requests: string;
  grant_access: string;
  deny: string;
  accept: string;
  add_a_shape: string;
  shapes: string;
  arrows: string;
  status: string;
  computers: string;
  date_time: string;
  files: string;
  finance: string;
  jump_or_change: string;
  math_options: string;
  qr_code_options: string;
  chart_options: string;
  author_options: string;
  slide_options: string;
  display_mode_image: string;
  cover: string;
  none: string;
  data_separator: string;
  date_pattern: string;
  radius_display: string;
  smooth: string;
  area: string;
  y_axis: string;
  domain: string;
  max: string;
  extent: string;
  ticks: string;
  custom_number_ticks: string;
  qr_code_explanation: string;
  target: string;
  your_presentation: string;
  custom_url: string;
  your_logo: string;
  delete_logo: string;
  deck_style: string;
  slide_style: string;
  transform_element: string;
  transform_slide: string;
  add_element: string;
  saving: string;
  edit_code: string;
  search_term: string;
}

interface I18nOffline {
  editing: string;
  why: string;
  turn: string;
  offline: string;
  still_edit: string;
  edit: string;
  offline_now: string;
  hang_on_gather: string;
  oopsie: string;
  check: string;
  cool: string;
  online: string;
  note: string;
  replace: string;
  long_story: string;
  online_now: string;
  hang_on_upload: string;
  error_offline: string;
  error_online: string;
}

interface I18nPublish_done {
  hooray: string;
  did_it: string;
  applause: string;
  thumbs_up: string;
  published: string;
  post_published: string;
  share: string;
  source_processing: string;
  source_submitted: string;
  repository: string;
}

interface I18nPublish_edit {
  share: string;
  publish: string;
  modern_app: string;
  meta: string;
  title_edit: string;
  title_max_chars: string;
  description: string;
  tags: string;
  social_card: string;
  error_previous: string;
  contact: string;
  title: string;
  publish_now: string;
  hang_on_publishing: string;
  source_push: string;
  source_submit: string;
}

interface I18nWarning {
  low_contrast: string;
  overflow: string;
  overflow_explanation: string;
  overflow_visibility: string;
  contrast_ratio: string;
  wcag: string;
  note: string;
}

interface I18nTemplates {
  no_personal_templates: string;
  no_personal_templates_guide: string;
  set_of_default: string;
  sign_in_to_add: string;
  pie: string;
  donut: string;
  pie_comparison: string;
  area: string;
  sharp_area: string;
  lines: string;
  line_graph_comparison: string;
  bar: string;
  grouped_bars: string;
  bar_comparison: string;
  poll: string;
  do_not_know: string;
  live_votes: string;
  charts: string;
  diagrams: string;
  playground: string;
  author: string;
  qr_code: string;
  showcase: string;
  template: string;
  tag: string;
  definition: string;
  cdn: string;
  get_in_touch: string;
  url: string;
  tag_format: string;
  upload_definition: string;
}

interface I18nShapes {
  robot: string;
  desktop: string;
  arrow: string;
  cloud: string;
  database: string;
  envelope: string;
}

interface I18nPoll {
  vote_now: string;
  scan: string;
  vote_cast: string;
  enjoy: string;
  vote_again: string;
  created_with: string;
}

interface I18nImport {
  import: string;
  import_from_figma: string;
  create: string;
  export: string;
  sign_in: string;
  upload: string;
  hang_on_creation: string;
  done: string;
}

interface I18nTools {
  new: string;
  new_presentation: string;
  new_warning_text: string;
  new_deck: string;
  new_doc: string;
  new_experimental: string;
  open: string;
  user: string;
  profile_image: string;
}

interface I18nSync {
  cloud: string;
  cloud_error: string;
  cloud_in_progress: string;
  cloud_idle: string;
  cloud_pending: string;
  cloud_init: string;
  info: string;
  status: string;
  wait: string;
}

interface I18n {
  lang: Languages;
  core: I18nCore;
  nav: I18nNav;
  not_found: I18nNot_found;
  menu: I18nMenu;
  links: I18nLinks;
  share: I18nShare;
  sign_in: I18nSign_in;
  settings: I18nSettings;
  dashboard: I18nDashboard;
  editor: I18nEditor;
  offline: I18nOffline;
  publish_done: I18nPublish_done;
  publish_edit: I18nPublish_edit;
  warning: I18nWarning;
  templates: I18nTemplates;
  shapes: I18nShapes;
  poll: I18nPoll;
  import: I18nImport;
  tools: I18nTools;
  sync: I18nSync;
}
