<div align="center">
  <a href="https://deckdeckgo.com"><img src="studio/src/assets/img/deckdeckgo-logo.svg" alt="DeckDeckGo logo" height="160"></a>
  
  <br/>
  
  <p><strong>DeckDeckGo</strong> - The open source web editor for presentations</p>
  
  <p>Create slides with our <a href="https://deckdeckgo.com">online editor</a> or developer kit 🔥.</p>
  
  <p>Interact with your decks through a <a href="https://deckdeckgo.app">remote control</a> 📱.</p>
  
  <br/>
  
  ![Website](https://img.shields.io/website?label=Editor&url=https%3A%2F%2Fdeckdeckgo.com)
  ![Website](https://img.shields.io/website?label=Remotre%20control&url=https%3A%2F%2Fdeckdeckgo.app)
  [![GitHub release](https://img.shields.io/github/release/deckgo/deckdeckgo/all?logo=GitHub)](https://github.com/deckgo/deckdeckgo/releases/latest)
  [![Chat on Slack](https://img.shields.io/badge/chat-Slack-EBB424?logo=Slack)](https://join.slack.com/t/deckdeckgo/shared_invite/enQtNzM0NjMwOTc3NTI0LTBlNmFhODNhYmRkMWUxZmU4ZTQ2MDJiNjlmYWZiODNjMDU5OGRjYThlZmZjMTc5YmQ3MzUzMDlhMzk0ZDgzMDY)
  [![Tweet](https://img.shields.io/twitter/url?url=https%3A%2F%2Fdeckdeckgo.com)](https://twitter.com/intent/tweet?url=https%3A%2F%2Fdeckdeckgo.com&text=DeckDeckGo%20-%20The%20web%20open%20source%20editor%20for%20presentations%20%F0%9F%9A%80%20%40deckdeckgo)
</div>

---

## Table of contents

- [Getting Started](#getting-started)
- [Features](#features)
- [Documentation](#documentation)
- [Contributing](#contributing)
- [Community](#community)
- [Supporting](#supporting)
- [Applications](#applications)
- [Web Components](#web-components)
- [Templates](#templates)
- [Infrastructure](#infrastructure)
- [Providers](#providers)
- [Utils](#utils)
- [Others](#others)

## Getting Started

Start your new presentation using our 👉 [online Editor](https://deckdeckgo.com) 👈 or with our developer kit by following the quick [Getting Started guide](https://docs.deckdeckgo.com/docs).

## Features

We are constantly developing new features and, are always happy to hear about cool ideas.

- Create, present and share your slides as Progressive Web Apps
- Interact with your audience with live polls
- Use predefined rich and responsive templates
- Search Unsplash and Tenor GIFs
- Integrate easily YouTube video
- Showcase your best developer code snippets
- Interact with your presentations with a remote control
- Present and work offline
- Push the source code of your online slides to GitHub
- Import Figma frames

## Documentation

The developers' documentation is available [online](https://docs.deckdeckgo.com).

## Contributing

Are you interested to contribute to our open source project? That would be awesome 👍 Have a look to our contributing [guide](CONTRIBUTING.md) to get started.

## Community

Templates and tools that are driven by the community of DeckDeckGo developers and maintainers are gathered together in a dedicated GitHub [org](https://github.com/deckgo-community).

If you would like to add your contribution, get in [touch](https://deckdeckgo.com/en/contact).

## Supporting

If you like the project, you can become a sponsor at [Open Collective](https://opencollective.com/deckdeckgo).

<a href="https://opencollective.com/deckdeckgo#category-CONTRIBUTE" target="_blank"><img src="https://opencollective.com/deckdeckgo/tiers/backers.svg?avatarHeight=32"/></a>

## Applications

| Project            | Version                                                                                                                       | Online                                                     |                   Links                   |                               Changelog                                |
| ------------------ | ----------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------- | :---------------------------------------: | :--------------------------------------------------------------------: |
| **Studio**         | [![version](https://img.shields.io/static/v1.svg?label=production&message=v5.3.0&color=success)](https://app.deckdeckgo.com)  | [https://app.deckdeckgo.com](https://app.deckdeckgo.com)   |       [`README`](studio/README.md)        |                   [`CHANGELOG`](studio/CHANGELOG.md)                   |
| **Remote control** | [![version](https://img.shields.io/static/v1.svg?label=production&message=v1.15.3&color=success)](https://deckdeckgo.app)     | [https://deckdeckgo.app](https://deckdeckgo.app)           |       [`README`](remote/README.md)        |                   [`CHANGELOG`](remote/CHANGELOG.md)                   |
| **Documentation**  | [![version](https://img.shields.io/static/v1.svg?label=production&message=v3.1.0&color=success)](https://docs.deckdeckgo.com) | [https://docs.deckdeckgo.com](https://docs.deckdeckgo.com) |        [`README`](docs/README.md)         |                    [`CHANGELOG`](docs/CHANGELOG.md)                    |
| **Site**           | [![version](https://img.shields.io/static/v1.svg?label=production&message=v1.2.0&color=success)](https://deckdeckgo.com)      | [https://deckdeckgo.com](https://deckdeckgo.com)           |        [`README`](site/README.md)         |                    [`CHANGELOG`](site/CHANGELOG.md)                    |
| **Demo**           | [![version](https://img.shields.io/static/v1.svg?label=production&message=v8.3.2&color=success)](https://demo.deckdeckgo.com) | [https://demo.deckdeckgo.com](https://demo.deckdeckgo.com) | [`Repo`](https://github.com/deckgo/demo/) | [`CHANGELOG`](https://github.com/deckgo/demo/blob/master/CHANGELOG.md) |

## Web Components

| Project                     | Package                                                                                          | Version                                                                                                                                                          |                         Links                          |                          Changelog                           |
|-----------------------------|--------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------|:------------------------------------------------------:|:------------------------------------------------------------:|
| **Core**                    | [`@deckdeckgo/core`](https://www.npmjs.com/package/@deckdeckgo/core)                             | [![version](https://img.shields.io/npm/v/@deckdeckgo/core/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/core)                             |        [`README`](webcomponents/core/README.md)        |        [`CHANGELOG`](webcomponents/core/CHANGELOG.md)        |
| **Charts**                  | [`@deckdeckgo/charts`](https://www.npmjs.com/package/@deckdeckgo/charts)                         | [![version](https://img.shields.io/npm/v/@deckdeckgo/charts/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/charts)                         |       [`README`](webcomponents/charts/README.md)       |       [`CHANGELOG`](webcomponents/charts/CHANGELOG.md)       |
| **Drag, Resize and Rotate** | [`@deckdeckgo/drag-resize-rotate`](https://www.npmjs.com/package/@deckdeckgo/drag-resize-rotate) | [![version](https://img.shields.io/npm/v/@deckdeckgo/drag-resize-rotate/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/drag-resize-rotate) | [`README`](webcomponents/drag-resize-rotate/README.md) | [`CHANGELOG`](webcomponents/drag-resize-rotate/CHANGELOG.md) |
| **Elements**                | [`@deckdeckgo/elements`](https://www.npmjs.com/package/@deckdeckgo/elements)                     | [![version](https://img.shields.io/npm/v/@deckdeckgo/elements/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/elements)                     |      [`README`](webcomponents/elements/README.md)      |      [`CHANGELOG`](webcomponents/elements/CHANGELOG.md)      |
| **Excalidraw (wrapper)**    | [`@deckdeckgo/excalidraw`](https://www.npmjs.com/package/@deckdeckgo/excalidraw)                 | [![version](https://img.shields.io/npm/v/@deckdeckgo/excalidraw/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/excalidraw)                 |   [`README`](webcomponents/excalidraw/README.md)       |    [`CHANGELOG`](webcomponents/excalidraw/CHANGELOG.md)      |
| **Highlight code**          | [`@deckdeckgo/highlight-code`](https://www.npmjs.com/package/@deckdeckgo/highlight-code)         | [![version](https://img.shields.io/npm/v/@deckdeckgo/highlight-code/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/highlight-code)         |   [`README`](webcomponents/highlight-code/README.md)   |   [`CHANGELOG`](webcomponents/highlight-code/CHANGELOG.md)   |
| **Laser Pointer**           | [`@deckdeckgo/laser-pointer`](https://www.npmjs.com/package/@deckdeckgo/laser-pointer)           | [![version](https://img.shields.io/npm/v/@deckdeckgo/laser-pointer/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/laser-pointer)           |   [`README`](webcomponents/laser-pointer/README.md)    |   [`CHANGELOG`](webcomponents/laser-pointer/CHANGELOG.md)    |
| **Lazy image**              | [`@deckdeckgo/lazy-img`](https://www.npmjs.com/package/@deckdeckgo/lazy-img)                     | [![version](https://img.shields.io/npm/v/@deckdeckgo/lazy-img/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/lazy-img)                     |      [`README`](webcomponents/lazy-img/README.md)      |      [`CHANGELOG`](webcomponents/lazy-img/CHANGELOG.md)      |
| **Math**                    | [`@deckdeckgo/math`](https://www.npmjs.com/package/@deckdeckgo/math)                             | [![version](https://img.shields.io/npm/v/@deckdeckgo/math/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/math)                             |        [`README`](webcomponents/math/README.md)        |        [`CHANGELOG`](webcomponents/math/CHANGELOG.md)        |
| **Markdown**                | [`@deckdeckgo/markdown`](https://www.npmjs.com/package/@deckdeckgo/markdown)                     | [![version](https://img.shields.io/npm/v/@deckdeckgo/markdown/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/markdown)                     |      [`README`](webcomponents/markdown/README.md)      |      [`CHANGELOG`](webcomponents/markdown/CHANGELOG.md)      |
| **Monaco Editor (wrapper)** | [`@deckdeckgo/monaco-editor`](https://www.npmjs.com/package/@deckdeckgo/monaco-editor)           | [![version](https://img.shields.io/npm/v/@deckdeckgo/monaco-editor/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/monaco-editor)           |   [`README`](webcomponents/monaco-editor/README.md)    |   [`CHANGELOG`](webcomponents/monaco-editor/CHANGELOG.md)    |
| **Pager**                   | [`@deckdeckgo/pager`](https://www.npmjs.com/package/@deckdeckgo/pager)                           | [![version](https://img.shields.io/npm/v/@deckdeckgo/pager/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/pager)                           |       [`README`](webcomponents/pager/README.md)        |       [`CHANGELOG`](webcomponents/pager/CHANGELOG.md)        |
| **Remote**                  | [`@deckdeckgo/remote`](https://www.npmjs.com/package/@deckdeckgo/remote)                         | [![version](https://img.shields.io/npm/v/@deckdeckgo/remote/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/remote)                         |       [`README`](webcomponents/remote/README.md)       |       [`CHANGELOG`](webcomponents/remote/CHANGELOG.md)       |
| **Social Image**            | [`@deckdeckgo/social-img`](https://www.npmjs.com/package/@deckdeckgo/social-img)                 | [![version](https://img.shields.io/npm/v/@deckdeckgo/social-img/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/social-img)                 |     [`README`](webcomponents/social-img/README.md)     |     [`CHANGELOG`](webcomponents/social-img/CHANGELOG.md)     |
| **Studio**                  | [`@deckdeckgo/studio`](https://www.npmjs.com/package/@deckdeckgo/studio)                         | [![version](https://img.shields.io/npm/v/@deckdeckgo/studio/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/studio)                         |       [`README`](webcomponents/studio/README.md)       |       [`CHANGELOG`](webcomponents/studio/CHANGELOG.md)       |
| **Word cloud**              | [`@deckdeckgo/word-cloud`](https://www.npmjs.com/package/@deckdeckgo/word-cloud)                 | [![version](https://img.shields.io/npm/v/@deckdeckgo/word-cloud/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/word-cloud)                 |     [`README`](webcomponents/word-cloud/README.md)     |     [`CHANGELOG`](webcomponents/word-cloud/CHANGELOG.md)     |

## Templates

| Project          | Package                                                                                          | Version                                                                                                                                                          |                    Links                     |                     Changelog                      |
| ---------------- | ------------------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------- | :------------------------------------------: | :------------------------------------------------: |
| **Author**       | [`@deckdeckgo/slide-author`](https://www.npmjs.com/package/@deckdeckgo/slide-author)             | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-author/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-author)             |    [`README`](templates/author/README.md)    |    [`CHANGELOG`](templates/author/CHANGELOG.md)    |
| **Aspect Ratio** | [`@deckdeckgo/slide-aspect-ratio`](https://www.npmjs.com/package/@deckdeckgo/slide-aspect-ratio) | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-aspect-ratio/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-aspect-ratio) | [`README`](templates/aspect-ratio/README.md) | [`CHANGELOG`](templates/aspect-ratio/CHANGELOG.md) |
| **Chart**        | [`@deckdeckgo/slide-chart`](https://www.npmjs.com/package/@deckdeckgo/slide-chart)               | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-chart/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-chart)               |    [`README`](templates/chart/README.md)     |    [`CHANGELOG`](templates/chart/CHANGELOG.md)     |
| **Content**      | [`@deckdeckgo/slide-content`](https://www.npmjs.com/package/@deckdeckgo/slide-content)           | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-content/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-content)           |   [`README`](templates/content/README.md)    |   [`CHANGELOG`](templates/content/CHANGELOG.md)    |
| **Gif**          | [`@deckdeckgo/slide-gif`](https://www.npmjs.com/package/@deckdeckgo/slide-gif)                   | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-gif/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-gif)                   |     [`README`](templates/gif/README.md)      |     [`CHANGELOG`](templates/gif/CHANGELOG.md)      |
| **Playground**   | [`@deckdeckgo/slide-playground`](https://www.npmjs.com/package/@deckdeckgo/slide-playground)     | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-playground/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-playground)     |  [`README`](templates/playground/README.md)  |  [`CHANGELOG`](templates/playground/CHANGELOG.md)  |
| **Poll**         | [`@deckdeckgo/slide-poll`](https://www.npmjs.com/package/@deckdeckgo/slide-poll)                 | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-poll/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-poll)                 |     [`README`](templates/poll/README.md)     |     [`CHANGELOG`](templates/poll/CHANGELOG.md)     |
| **QR Code**      | [`@deckdeckgo/slide-qrcode`](https://www.npmjs.com/package/@deckdeckgo/slide-qrcode)             | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-qrcode/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-qrcode)             |    [`README`](templates/qrcode/README.md)    |    [`CHANGELOG`](templates/qrcode/CHANGELOG.md)    |
| **Split**        | [`@deckdeckgo/slide-split`](https://www.npmjs.com/package/@deckdeckgo/slide-split)               | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-split/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-split)               |    [`README`](templates/split/README.md)     |    [`CHANGELOG`](templates/split/CHANGELOG.md)     |
| **Title**        | [`@deckdeckgo/slide-title`](https://www.npmjs.com/package/@deckdeckgo/slide-title)               | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-title/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-title)               |    [`README`](templates/title/README.md)     |    [`CHANGELOG`](templates/title/CHANGELOG.md)     |
| **YouTube**      | [`@deckdeckgo/slide-youtube`](https://www.npmjs.com/package/@deckdeckgo/slide-youtube)           | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-youtube/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-youtube)           |   [`README`](templates/youtube/README.md)    |   [`CHANGELOG`](templates/youtube/CHANGELOG.md)    |

## Infrastructure

⚠️ **DEPRECATED** ⚠️

| Project               | Version                                                                                        |              Links              |               Changelog               |
| --------------------- | ---------------------------------------------------------------------------------------------- | :-----------------------------: | :-----------------------------------: |
| **AWS (Backend)**     | ![version](https://img.shields.io/static/v1.svg?label=production&message=v2.0.0&color=success) |  [`README`](backend/README.md)  |  [`CHANGELOG`](backend/CHANGELOG.md)  |
| **AWS (Infra)**       | ![version](https://img.shields.io/static/v1.svg?label=production&message=up&color=success)     |   [`README`](infra/README.md)   |                                       |
| **Firebase (Cloud)**  | ![version](https://img.shields.io/static/v1.svg?label=production&message=v2.2.1&color=success) |   [`README`](cloud/README.md)   |   [`CHANGELOG`](cloud/CHANGELOG.md)   |

## Providers

| Project               | Package                                                                      | Version                                                                                                                                      |                  Links                   |                   Changelog                    |
|-----------------------|------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------|:----------------------------------------:|:----------------------------------------------:|
| **API (AWS)**         | [`@deckdeckgo/api`](https://www.npmjs.com/package/@deckdeckgo/api)           | [![version](https://img.shields.io/npm/v/@deckdeckgo/api/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/api)           |   [`README`](providers/api/README.md)    |   [`CHANGELOG`](providers/api/CHANGELOG.md)    |
| **Firebase**          | [`@deckdeckgo/firebase`](https://www.npmjs.com/package/@deckdeckgo/firebase) | [![version](https://img.shields.io/npm/v/@deckdeckgo/firebase/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/firebase) | [`README`](providers/firebase/README.md) | [`CHANGELOG`](providers/firebase/CHANGELOG.md) |
| **Internet Computer** | [`@deckdeckgo/ic`](https://www.npmjs.com/package/@deckdeckgo/ic)             | [![version](https://img.shields.io/npm/v/@deckdeckgo/ic/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/ic)             |    [`README`](providers/ic/README.md)    |    [`CHANGELOG`](providers/ic/CHANGELOG.md)    |
| **Offline**           | [`@deckdeckgo/offline`](https://www.npmjs.com/package/@deckdeckgo/offline)   | [![version](https://img.shields.io/npm/v/@deckdeckgo/offline/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/offline)   | [`README`](providers/offline/README.md)  | [`CHANGELOG`](providers/offline/CHANGELOG.md)  |
| **Sync**              | [`@deckdeckgo/sync`](https://www.npmjs.com/package/@deckdeckgo/sync)         | [![version](https://img.shields.io/npm/v/@deckdeckgo/sync/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/sync)         |   [`README`](providers/sync/README.md)   |   [`CHANGELOG`](providers/sync/CHANGELOG.md)   |

## Utils

| Project          | Package                                                                              | Version                                                                                                                                              |               Links                |                Changelog                 |
| ---------------- | ------------------------------------------------------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------- | :--------------------------------: | :--------------------------------------: |
| **Deck Utils**   | [`@deckdeckgo/deck-utils`](https://www.npmjs.com/package/@deckdeckgo/deck-utils)     | [![version](https://img.shields.io/npm/v/@deckdeckgo/deck-utils/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/deck-utils)     |  [`README`](utils/deck/README.md)  |  [`CHANGELOG`](utils/deck/CHANGELOG.md)  |
| **Kit**          | [`@deckdeckgo/kit`](https://www.npmjs.com/package/@deckdeckgo/kit)                   | [![version](https://img.shields.io/npm/v/@deckdeckgo/kit/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/kit)                   |  [`README`](utils/kit/README.md)   |  [`CHANGELOG`](utils/kit/CHANGELOG.md)   |
| **Remote Utils** | [`@deckdeckgo/remote-utils`](https://www.npmjs.com/package/@deckdeckgo/remote-utils) | [![version](https://img.shields.io/npm/v/@deckdeckgo/remote-utils/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/remote-utils) | [`README`](utils/remote/README.md) | [`CHANGELOG`](utils/remote/CHANGELOG.md) |
| **Slide Utils**  | [`@deckdeckgo/slide-utils`](https://www.npmjs.com/package/@deckdeckgo/slide-utils)   | [![version](https://img.shields.io/npm/v/@deckdeckgo/slide-utils/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/slide-utils)   | [`README`](utils/slide/README.md)  | [`CHANGELOG`](utils/slide/CHANGELOG.md)  |
| **Styles**       | [`@deckdeckgo/styles`](https://www.npmjs.com/package/@deckdeckgo/styles)             | [![version](https://img.shields.io/npm/v/@deckdeckgo/styles/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/styles)             | [`README`](utils/styles/README.md) | [`CHANGELOG`](utils/styles/CHANGELOG.md) |
| **Types**        | [`@deckdeckgo/types`](https://www.npmjs.com/package/@deckdeckgo/types)               | [![version](https://img.shields.io/npm/v/@deckdeckgo/types/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/types)               | [`README`](utils/types/README.md)  | [`CHANGELOG`](utils/types/CHANGELOG.md)  |
| **Utils**        | [`@deckdeckgo/utils`](https://www.npmjs.com/package/@deckdeckgo/utils)               | [![version](https://img.shields.io/npm/v/@deckdeckgo/utils/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/utils)               | [`README`](utils/utils/README.md)  | [`CHANGELOG`](utils/utils/CHANGELOG.md)  |
| **Editor Utils** | [`@deckdeckgo/editor`](https://www.npmjs.com/package/@deckdeckgo/editor)             | [![version](https://img.shields.io/npm/v/@deckdeckgo/editor/latest.svg?color=success)](https://www.npmjs.com/package/@deckdeckgo/editor)             | [`README`](utils/editor/README.md) | [`CHANGELOG`](utils/editor/CHANGELOG.md) |

## Others

| Project                          | Package                                                                                  | Version                                                                                                                                                      |                               Links                               |                                           Changelog                                            |
| -------------------------------- | ---------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------ | :---------------------------------------------------------------: | :--------------------------------------------------------------------------------------------: |
| **CLI**                          | [`create-deckdeckgo`](https://www.npmjs.com/package/create-deckdeckgo)                   | [![version](https://img.shields.io/npm/v/create-deckdeckgo/latest.svg?color=success)](https://www.npmjs.com/package/create-deckdeckgo)                       |                     [`README`](cli/README.md)                     |                                [`CHANGELOG`](cli/CHANGELOG.md)                                 |
| **Figma plugin**                 |                                                                                          | ![version](https://img.shields.io/static/v1.svg?label=version&message=v2.0.0&color=success)                                                                  |    [`Repo`](https://github.com/deckgo/figma-deckdeckgo-plugin)    |    [`CHANGELOG`](https://github.com/deckgo/figma-deckdeckgo-plugin/blob/main/CHANGELOG.md)     |
| **Gatsby plugin highlight code** |                                                                                          | [![version](https://img.shields.io/npm/v/gatsby-remark-highlight-code/latest.svg?color=success)](https://www.npmjs.com/package/gatsby-remark-highlight-code) | [`Repo`](https://github.com/deckgo/gatsby-remark-highlight-code/) | [`CHANGELOG`](https://github.com/deckgo/gatsby-remark-highlight-code/blob/master/CHANGELOG.md) |
| **Starter kit**                  |                                                                                          | ![version](https://img.shields.io/static/v1.svg?label=version&message=v8.3.2&color=success)                                                                  |          [`Repo`](http://github.com/deckgo/starter-kit/)          |         [`CHANGELOG`](https://github.com/deckgo/starter-kit/blob/master/CHANGELOG.md)          |
| **Studio kit**                   |                                                                                          | ![version](https://img.shields.io/static/v1.svg?label=version&message=v8.3.2&color=success)                                                                  |          [`Repo`](http://github.com/deckgo/studio-kit/)           |          [`CHANGELOG`](https://github.com/deckgo/studio-kit/blob/master/CHANGELOG.md)          |
| **IC kit**                       |                                                                                          | ![version](https://img.shields.io/static/v1.svg?label=version&message=v1.2.1&color=success)                                                                  |            [`Repo`](http://github.com/deckgo/ic-kit/)             |            [`CHANGELOG`](https://github.com/deckgo/ic-kit/blob/master/CHANGELOG.md)            |
| **Template kit**                 |                                                                                          | ![version](https://img.shields.io/static/v1.svg?label=version&message=v1.1.0&color=success)                                                                  |         [`Repo`](http://github.com/deckgo/template-kit/)          |         [`CHANGELOG`](https://github.com/deckgo/template-kit/blob/master/CHANGELOG.md)         |
| **WAI Lambda**                   |                                                                                          |                                                                                                                                                              |          [`Repo`](https://github.com/deckgo/wai-lambda)           |                                                                                                |
| **Webpack plugins**              | [`deckdeckgo-webpack-plugins`](https://www.npmjs.com/package/deckdeckgo-webpack-plugins) | [![version](https://img.shields.io/npm/v/deckdeckgo-webpack-plugins/latest.svg?color=success)](https://www.npmjs.com/package/deckdeckgo-webpack-plugins)     |                   [`README`](webpack/README.md)                   |                              [`CHANGELOG`](webpack/CHANGELOG.md)                               |

[deckdeckgo]: https://deckdeckgo.com
