function(check_git_submodule DIR)
    file(GLOB DIR_FILES "${DIR}/*")
	if (DIR_FILES STREQUAL "")
		message(WARNING "It looks like the '${DIR}' directory is empty. Did you forget to update git submodules?")
		find_package(Git MODULE)
		if (Git_FOUND)
			message(STATUS "Updating the '${DIR}' git submodule to fix.")
			execute_process(COMMAND "${GIT_EXECUTABLE}" -C "${CMAKE_CURRENT_LIST_DIR}" submodule update --init -- "${DIR}")
		endif()
	endif()
endfunction()
