/// <reference path="../test-types.ts"/>

import * as _ from 'lodash';
import assert = require('assert');
import fs = require('fs');
import server = require('../utils/server');
import utils = require('../utils/utils');
import { TyE2eTestBrowser } from '../utils/pages-for';
import settings = require('../utils/settings');
import make = require('../utils/make');
import logAndDie = require('../utils/log-and-die');
import c = require('../test-constants');


let owen: Member;
let owensBrowser: TyE2eTestBrowser;
let strangersBrowser: TyE2eTestBrowser;

let idAddress: IdAddress;
let siteId: any;

const localHostname = 'comments-for-e2e-test-embdscid';
const embeddingOrigin = 'http://e2e-test-embdscid.localhost:8080';
const pageAaaSlug = 'emb-cmts-aaa.html';


describe("emb cmts forum intro tour for admins  TyT6AKBR2044", () => {

  it("initialize people", () => {
    owensBrowser = new TyE2eTestBrowser(wdioBrowser);
    owen = make.memberOwenOwner();
  });

  it("import a site", () => {
    const site: SiteData = make.forumOwnedByOwen('embftour', { title: "Emb Cmts Forum Tour Test" });
    site.meta.localHostname = localHostname;
    site.settings.allowEmbeddingFrom = embeddingOrigin;
    site.settings.showCategories = false;

    // TESTS_MISSING create a site from scratch. Break out & reuse code from 
    // embedded-comments-create-site-no-verif-email-admin-area-tour.2browsers.test.ts ?

    idAddress = server.importSiteData(site);
    siteId = idAddress.id;
  });

  it("create an embedding page aaa", () => {
    const dir = 'target';
    fs.writeFileSync(`${dir}/${pageAaaSlug}`, makeHtml());
  });


  function makeHtml(): string {
    return `
<html>
<head>
<title>Embedded comments E2E test</title>
</head>
<body>
<p>Embedded comments E2E test page, for emb cmts forum intro tour<br>
Ok to delete. The comments: ("long ago" generated by the admin js bundle [5AKBST03])
</p>

<script>talkyardCommentsServerUrl='${settings.scheme}://${localHostname}.localhost';</script>
<script async defer src="${settings.scheme}://${localHostname}.localhost/-/talkyard-comments.js"></script>
<div class="talkyard-comments" data-discussion-id="" style="margin-top: 45px;">

<p>/End of page.</p>
</body>
</html>`;
  }

  it("Owen goes to the topic list", () => {
    owensBrowser.go(idAddress.origin);
    owensBrowser.tour.runToursAlthoughE2eTest();
  });

  it("... logs in", () => {
    owensBrowser.complex.loginWithPasswordViaTopbar(owen);
  });

  it("An intro tour appears", () => {
    owensBrowser.tour.assertTourStarts(true);
  });

  it("... Owen views the tour", () => {
    console.log('Step 1');
    owensBrowser.tour.clickNextForStepNr(1);
    console.log('Step 2');
    owensBrowser.tour.clickNextForStepNr(2);
    console.log('Step 3');
    owensBrowser.tour.clickNextForStepNr(3);
    console.log('Step 4');
    owensBrowser.tour.clickNextForStepNr(4);
    console.log('Step 5');
    owensBrowser.waitAndClick('.esAvtrName_name');
  });

  it("... but skips last steps 6 and 7. So tour won't get marked as seen [TyT2ABKRT05]", () => {
    // Noop.
  });

  it("Owen goes to the blog", () => {
    owensBrowser.go2(embeddingOrigin + '/' + pageAaaSlug);
  });

  it("... Owen needs to login??", () => {
    owensBrowser.complex.loginIfNeededViaMetabar(owen);
  });

  it("... adds a comment, so a page gets created", () => {
    owensBrowser.complex.replyToEmbeddingBlogPost("Text text text");
  });

  it("... then back to the topic list", () => {
    owensBrowser.go2(idAddress.origin);
  });

  it("The intro tour appears again (since he didn't finish watching it)", () => {
    owensBrowser.tour.assertTourStarts(true);
  });

  it("... Owen views the tour", () => {
    console.log('Step 1');
    owensBrowser.tour.clickNextForStepNr(1);
    console.log('Step 2');
    owensBrowser.tour.clickNextForStepNr(2);
    console.log('Step 3');
    owensBrowser.tour.clickNextForStepNr(3);
    console.log('Step 4');
    owensBrowser.tour.clickNextForStepNr(4);
    console.log('Step 5');
    owensBrowser.waitAndClick('.esAvtrName_name');
  });

  it("... all steps, this time", () => {
    console.log('Step 6');
    owensBrowser.tour.clickNextForStepNr(6);
  });

  it("Now the tour won't start again", () => {
    owensBrowser.refresh2();  // beacon-saves tourTipsSeen
    // Here, the tour would restart, but ...
    owensBrowser.refresh2();  // reloads up-to-date tourTipsSeen
    owensBrowser.tour.assertTourStarts(false);
  });

});

