#!/bin/bash

# You can try the whole test suite twice:
# (you need your own secrets file)
#
#  for x in 1 2 ; do  time  s/run-e2e-tests.sh --3 --secretsPath=../debiki-site-www.debiki.com/conf/e2e-secrets.json && break  ; done


# Delete this whole file — run tests via `s/tyd e2e ...` instead.  [rm_run_e2e_tests_sh]
echo "This script, run-e2e-tests.sh is DEPRECATED, but still in use."
echo "Soon, will use instead:  s/tyd e2e ..."


if [ `id -u` -eq 0 ]; then
  echo "You are root. Don't run the E2E tests as root please."
  exit 1
fi

await_maybe_missing=$(egrep -n -r '[a-z]_br[A-Z][a-zA-Z0-9_]*\..*\(' tests/e2e-wdio7/specs/ | grep -v '\bawait '  | grep -v '\bnew ' | grep -v '_sync\b')
if [ ! -z "$await_maybe_missing" ]; then
  echo
  echo "Maybe E2E bugs — could await be missing? Check these lines:"
  echo
  echo "$await_maybe_missing"
  echo
  echo "Bye."
  exit 1
fi

# Make `command | tee -a logfile` preserve the command's exit status.
set -o pipefail

mkdir -p logs/

offset=0
every=1

positional_args=()
while [[ $# -gt 0 ]]; do
  arg_name="$1"
  case $arg_name in
    -o|--offset)
    offset="$2"
    shift  # past key
    shift  # past value
    ;;
    -e|--every)
    every="$2"
    shift  # past key
    shift  # past value
    ;;
    *)
    # Could:
    # positional_args+=("$1")  # add to array
    # shift
    # and wait until -- before passing the rest of the args to wdio.
    # For now though:
    break
    ;;
  esac
done



# If we start running the tests too early, they will need to wait for Nashorn, and might then timeout and fail.
echo "Waiting for Nashorn to compile Javascript code... (polling http://localhost/-/are-scripts-ready )"
until $(curl --output /dev/null --silent --head --fail http://localhost/-/are-scripts-ready); do
  printf '.'
  sleep 1
done

function log_message {
  echo "`date --iso-8601=seconds --utc`: $1"
}

failfile=logs/e2e-failures.txt
echo "" >> $failfile
log_message "Running: $*" >> $failfile

isoDate=$(date --iso-8601=seconds)
randAlnum=$(< /dev/urandom tr -cd 'a-z0-9' | head -c 10)

testStartId="$isoDate-$randAlnum"

function runE2eTest {
  site_nr=`printf '%d' $(($site_nr + 1))`

  # This hostname will avoid using the same hostname, for different tests at the same time,
  # if running many tests in parallel.
  local_hostname="e2e-test-e$every-o$offset-s$site_nr"  # dupl [5WAKEF02]

  # Later: Run only every $every test, starting at offset $offset.
  # Then, can run many tests in parallel. For example, run this script with
  # '-e 2 -o 0' and '-e 2 -o 1' at the same time.

  # Incl $testStartId so ps-grep-kill below kills only wdio processes we start here.
  test_log_file="logs/failed-e2e-test-$testStartId-nr-$site_nr.log"
  cmd="$@ --deleteOldSite --localHostname=$local_hostname --dummy-wdio-test $testStartId"

  echo "————————————————————————————————————————————————————————————————————"
  echo "Next test:  $cmd"
  echo

  # Sometimes, randomly?, there's some weird port conflict causing this to fail & hang forever.
  # So timeout after 3 minutes. The slow tests take about one minute, so 3 minutes is a lot.
  # Also, kill any wdio things that have failed to stop, and might block a/the port.
  wdio_ps=$(ps aux | grep node | egrep 'wdio(.[0-9a-z]+)?.conf.js' | grep "wdio-test $testStartId")
  if [ -n "$wdio_ps" ] ; then
    # Column 2 is the process id.
    wdio_ps_ids=$( echo "$wdio_ps" | awk '{ print $2 }' | tr '\n' ' ' )
    echo "Killing old wdio processes, ids: $wdio_ps_ids commands:"
    echo "$wdio_ps"
    kill $wdio_ps_ids
  fi

  timeout --foreground 180 $cmd  |& tee -a $test_log_file  # note: pipefail enabled

  if [ $? -ne 0 ]; then
    log_message "Failed: $cmd" >> $failfile
    log_message "See logs: $test_log_file" >> $failfile


    see_log_file="Log file:  $test_log_file"

    # Try again, so some harmless race condition I haven't thought about that breaks the test,
    # won't result in a false failures. Usually a race condition breaks the tests only very
    # infrequently, so it's "impossible" to reproduce manually, and thus hard to fix. However,
    # if the test breaks directly *again*, then apparently the failure / race-condition is easy
    # to reproduce, so I'll be able to fix it :-)
    echo
    echo "$see_log_file"
    echo
    echo "*** Test failed 1/3. Waiting a few seconds, then will retry ... [EdME2ETRY1] ***"
    echo
    sleep 7

    echo "Again:"
    echo "    $cmd"
    echo

    $cmd  |& tee -a $test_log_file  # note: pipefail enabled

    if [ $? -ne 0 ]; then
      # Eh. Well, try a 3rd time. Not so easy to make all e2e tests stable, and
      # sometimes they work 30 times in a row, when I'm there at the computer, trying to
      # find out why they fail ... And then I start building a new server and run the
      # tests "for real" as part of the build process ... And then they start failing!
      # But they won't do that 3 times in a row?
      #
      # B.t.w. if a test works 1 time out of 3 — then almost certainly, all is fine,
      # and any bug is in the test suite: a race condition. I don't remember any single
      # time when, if an e2e test work *sometimes*, the bug has been in the real
      # Talkyard app — instead it's "always" a race bug, in the e2e test suite.
      # So, trying many times, is ok. (We're not building the Space Shuttle)
      #
      log_message "Failed 2nd time: $cmd" >> $failfile
      echo
      echo "$see_log_file"
      echo
      echo "*** Test failed 2/3. Waiting a few seconds, then trying one last time ... [EdME2ETRY2] ***"
      echo
      sleep 7

      echo "Last attempt:"
      echo "    $cmd"
      echo

      $cmd  |& tee -a $test_log_file  # note: pipefail enabled

      if [ $? -ne 0 ]; then
        log_message "Failed: $cmd" >> $failfile
        log_message "Test failed trice, aborting." >> $failfile
        cmd_with_debug=$(echo $@)  # skip:  | sed 's/wdio /wdio-debug-9101 /')  doesn't work anyway
        echo
        echo
        echo "*** ERROR [TyEE2E] ***"
        echo
        echo "$see_log_file"
        echo
        echo "This end-to-end test failed trice:"
        echo
        echo "  $cmd"
        echo
        echo
        echo "Run it with debug flags, and try to fix it:"
        echo
        # Later: use --localHostname=e2e-test-manual or just e2e-test, instead of -20, so won't overwrite test site nr 20.
        # (But first add a cname entry for -manual.)
        cmd_with_debug="$cmd_with_debug --deleteOldSite --localHostname=e2e-test-e$every-o$offset-retry --nt --da"  # dupl [5WAKEF02]
        echo "  $cmd_with_debug"
        echo
        echo
        echo "Once it works, run it 33 times, and if it's flaky and fails once, that's ok:"
        echo "(Because the likelihood that a tests fails twice, is then 1/33/33 ~= 1/1000,"
        echo "so, with 100 such e2e tests, it's 90% probability of no double failures.)"
        echo
        echo "  rm e2e.log ;  for x in {1..33}; do echo \$x: ; $cmd |& tee -a e2e.log ; done"
        echo "  egrep -i -C10 '^error' e2e.log | gvim -"
        echo
        echo
        echo
        exit 1
      else
        echo "Ok, on the 3rd attempt. [TyME2ERETRYOK3]"
        echo
      fi
    else
      echo "Ok, on the 2nd attempt. [TyME2ERETRYOK2]"
      echo
    fi
  else
    echo "Ok. [EdM4RZW0J]"
    echo
    # The log file is uninteresting, since all went fine.
    rm -f $test_log_file
  fi
}


#------------------------------------------------------------
# dupl code (7UKTWC0)
# Start building the Gatsby blog, if needed.
if [ ! -d modules/gatsby-starter-blog/public/ ]; then
  echo "Building the Gatsby starter blog public html..."
  pushd .
  cd modules/gatsby-starter-blog/
  rm -fr .cache public
  # 'yarn' doesn't work, result in a "Gatsby may not be installed" error. 'npm install' works.
  (npm install && yarn build && echo 'yarn-build-1' ) &
  yarn_build_gatsby_pid=$(jobs -l | grep yarn-build-1 | awk '{ printf $2; }')
  # Could copy the generated files and change from http: to https:, so can test
  # Gatsby under https too? [GATSBYHTTPS]
  echo "Background building the Gatsby blog in process id $yarn_build_gatsby_pid"
  popd
fi

# dupl code (7UKTWC0)
# Start building another version of the Gatsby blog, with an older ed-comments version.
if [ ! -d modules/gatsby-starter-blog-ed-comments-0.4.4/public/ ]; then
  echo "Building the Gatsby starter blog public html, for ed-comments 0.4.4..."
  pushd .
  cd modules/gatsby-starter-blog-ed-comments-0.4.4/
  rm -fr .cache public
  # 'yarn' doesn't work, result in a "Gatsby may not be installed" error. 'npm install' works.
  (npm install && yarn build && echo 'yarn-build-2' ) &
  yarn_build_gatsby_pid2=$(jobs -l | grep yarn-build-2 | awk '{ printf $2; }')
  echo "Background building the Gatsby blog, ed-comments 0.4.4, in process id $yarn_build_gatsby_pid2"
  popd
fi
#------------------------------------------------------------

http_server_port=''
http_server_pid=''

function start_http_server {
  port="$1"
  http_server_port=$(netstat -nl | grep ":$port.*LISTEN")
  http_server_pid=''
  if [ -z "$http_server_port" ]; then
    echo "Starting a http server for embedded comments html pages..."
    ./node_modules/.bin/http-server "-p$port" target/ &
    # Field 2 is the process id.
    http_server_pid=$(jobs -l | grep "p$port" | awk '{ printf $2; }')
  fi
  # else: the user has probably started the server henself already, do nothing.
}


args=$@
site_nr=0

function runAllE2eTests {
  echo "Running all end-to-end tests..."

  r=runE2eTest

  # If you want to skip the first tests, then move the end-if down wards.
  if [ -z "SKIP these tests" ]; then
    echo
  fi

  # Start and exit the manual testing tests, just to verify this works.
  $r s/wdio --only manual.2browsers $args  # remove soon
  $r s/wdio-7 --only dir.manual.2br.e2e.ts --cd -i $args
  #
  # To restart, reusing same test site: (not deleting and recreating)
  #
  #   s/wdio --only manual.2browsers --dt --da --reuse --localHostname e2e-test-something

  $r s/wdio --only all-links $args   # RENAME to test-import  ?
  $r s/wdio-7 --only create-site-password-run-admin-intro-tours.1br.d --cd -i $args
  $r s/wdio-7 --only create-site-gmail-and-email-notf.1br.d.extidp --cd -i $args
  $r s/wdio-7 --only create-site-facebook.1br.d.extidp --cd -i $args
  $r s/wdio-7 --only create-site-github-uppercase-email.1br.d.extidp --cd -i $args
  $r s/wdio-7 --only create-site-linkedin.1br.d.extidp --cd -i $args
  $r s/wdio-7 --only create-site-admin-guide.2br.d --cd -i $args
  $r s/wdio --only gmail-fb-join-login.extidp.1br $args

  $r s/wdio-7 --only create-private-site-password.2br.f --cd -i $args
  $r s/wdio-7 --only create-private-site-gmail-invite-only.2br.f --cd -i $args

  # Needs HTTPS (dummy localhost cert is ok).
  $r s/wdio-7 --only oidc-azure-login-required.2br.extidp --cd -i $args
  $r s/wdio-7 --only oidc-azure-pub-site.2br.extidp --cd -i $args

  $r s/wdio --only login-expire-idle-after.2br.mtime $args

  $r s/wdio-7 --only forum-sort-and-scroll.d.2br --cd -i $args

  $r s/wdio --only navigation-as-admin $args
  $r s/wdio --only navigation-as-member $args
  $r s/wdio --only navigation-as-stranger $args
  # Also:  embedded-comments-navigation-as-guest  further below.

  $r s/wdio-7 --only d.sessions-logout-elsewhere.4br --cd -i $args
  $r s/wdio-7 --only d.sessions-staff-logout-others.4br --cd -i $args

  $r s/wdio --only hide-unhide-tips.2br $args
  $r s/wdio-7 --only show-admin-notices.2br --cd -i $args

  $r s/wdio-7 --only editor-toolbar-preview.1br --cd -i $args
  $r s/wdio --only sanitize-posts.2browsers $args

  $r s/wdio-7 --only votes-and-best-first.d.2br --cd -i $args
  $r s/wdio-7 --only comment-sort-order.d.2br --cd -i $args
  $r s/wdio-7 --only comment-sort-order-inherited.d.2br --cd -i $args
  $r s/wdio-7 --only dir.summarize-squash-siblings.2br --cd -i $args

  $r s/wdio-7 --only backlinks-basic.2br.d --cd -i $args

  $r s/wdio-7 --only link-previews-internal-may-see.2br.d --cd -i $args
  $r s/wdio-7 --only link-previews-internal-not-see-cat.2br.d --cd -i $args
  $r s/wdio-7 --only link-previews-internal-to-cats-not-see.2br.f --cd -i $args
  $r s/wdio-7 --only link-previews-http-to-https.1br.d --cd -i $args
  $r s/wdio-7 --only link-previews-images-mp4-youtube.1br.d.extln --cd -i $args
  $r s/wdio-7 --only link-previews-twitter-max-editor.1br.d.extln --cd -i $args
  $r s/wdio-7 --only link-previews-all-others.1br.d.extln --cd -i $args


  $r s/wdio --only view-edit-history.2br.mtime $args
  $r s/wdio --only upload-images-and-files.2br $args
  $r s/wdio-7 --only direct-messages-notfs.3br.d --cd -i $args
  $r s/wdio --only direct-messages-delete.2browsers $args
  $r s/wdio --only chat-basic.2br.mtime $args  #  broken [DRAFTS_BUG]
  $r s/wdio --only chat-create-from-direct-message.2browsers $args
  $r s/wdio --only chat-create-from-profile-pages.2browsers $args

  $r s/wdio-7 --only categories-basic.3br.d --cd -i $args
  # There're more category tests below. [.more_cat_tests]

  $r s/wdio-7 --only badges-basic.2br --cd -i $args
  $r s/wdio-7 --only tags-basic.2br --cd -i $args
  $r s/wdio-7 --only tags-badges-not-missing.2br --cd -i $args

  $r s/wdio-7 --only private-chat.3br.d --cd -i $args

  # Is named 'forum-' because there's another test with 'drafts-not-logged-in' in the name.
  # But now that one got renamed, so remove 'forum-' from here — should be 'dir.' instead for "direct".
  $r s/wdio --only forum-drafts-not-logged-in.2browsers $args

  $r s/wdio --only drafts-new-topic.2br.mtime $args
  $r s/wdio --only drafts-new-topic-from-cats-page $args
  $r s/wdio --only drafts-reply-edit-dir-msg.2br.mtime $args
  $r s/wdio --only drafts-chat-adv-ed.2browsers $args
  $r s/wdio --only drafts-delete $args

  # Wip:
  # $r s/wdio-7 --only frag-action-compose-topic.2br.f.wip.ts --cd -i

  $r s/wdio --only delete-pages.2br $args

  $r s/wdio-7 --only move-posts-same-page.2br.d --cd -i $args
  $r s/wdio-7 --only move-posts-other-page.2br.d --cd -i $args
  $r s/wdio-7 --only move-posts-newer-page-reply.2br.d --cd -i $args
  $r s/wdio-7 --only move-posts-pin-delete.2br.d --cd -i $args
  # + delete-posts

  $r s/wdio --only settings-allowed-email-domains.extidp.2br $args
  $r s/wdio-7 --only settings-toggle-login-required.3br.d --cd -i $args
  $r s/wdio --only login-required-ext-signup-login.1br.extidp $args
  $r s/wdio --only login-required-join-global-chat.2br $args

  # Moderation   # RENAME to  modn- ...  instead of  admin- ...and MOVE to (4862065) below?
  $r s/wdio --only settings-approve-members.2browsers $args
  $r s/wdio --only admin-user-approve-reject.2browsers $args
  $r s/wdio --only admin-user-staff.2browsers $args
  $r s/wdio --only admin-user-threat-mild.2br.mtime $args
  $r s/wdio --only admin-user-threat-moderate.2br.mtime $args
  $r s/wdio --only admin-user-suspend.2browsers $args
  $r s/wdio --only admin-review-invalidate-for-reply.2br.mtime $args
  $r s/wdio --only admin-review-invalidate-page-deld.2br.mtime $args
  $r s/wdio --only admin-review-cascade-approval.2br.mtime $args
  $r s/wdio --only modn-approve-before.2br.mtime $args
  $r s/wdio --only modn-review-after.2br.mtime $args   # + liked, marked as solution
  $r s/wdio --only modn-appr-bef-comb-w-revw-aftr.2br.mtime $args
  $r s/wdio --only mod-review.2br.mtime $args  # RENAME to modn-by-moderator-not-admin

  $r s/wdio --only modn-from-disc-page-appr-befr.2browsers $args
  $r s/wdio --only modn-from-disc-page-review-after.2browsers $args

  # TESTS_MISSING
  #$r s/wdio --only modn-appr-deleted-posts.2browsers $args   [apr_deld_post]
  #$r s/wdio --only mod-task-emails-approve-before.2browsers $args
  #$r s/wdio --only mod-task-emails-review-after.2browsers $args

  $r s/wdio --only promote-demote-by-staff-join-leave-chats.2br $args
  #$r s/wdio --only promote-demote-by-system-join-leave-chats.2br $args

  $r s/wdio --only admin-move-hostname.2browsers $args

  $r s/wdio-7 --only password-login-reset.2br.f --cd -i $args   # pretty ...
  $r s/wdio --only user-profile-access $args
  $r s/wdio --only user-profile-change-username $args
  $r s/wdio --only user-profile-change-email.2browsers $args
  $r s/wdio --only user-profile-change-password.2br.mtime $args  # ... similar
  $r s/wdio --only user-profile-cannot-delete-idp-email.1br.extidp $args
  $r s/wdio-7 --only user-self-delete-upd-groups.2br.f.e2e.ts --cd -i $args

  $r s/wdio --only group-profile-change-things.2browsers $args

  $r s/wdio --only many-users-mention-list-join-group.2browsers $args
  #$r s/wdio --only many-users-large-group.2browsers $args
  #$r s/wdio --only many-groups.2browsers $args
  #$r s/wdio --only many-users-many-large-groups.2browsers $args

  $r s/wdio-7 --only custom-forms.3br.d --cd -i $args

  $r s/wdio --only authz-view-as-stranger $args
  $r s/wdio --only authz-basic-see-reply-create $args
  $r s/wdio --only impersonate-post-as-other.2browsers $args
  $r s/wdio --only impersonate-restricted-areas $args

  # Notifications
  # ------------

  # There're email notfs and unsubscription tests for guests, further below, in:
  # embedded-comments-guest-login-email-notf-unsbscribe
  $r s/wdio --only unsubscribe.2browsers $args
  $r s/wdio --only notf-emails-discussion.2br.mtime $args
  $r s/wdio --only notfs-like-votes.2browsers $args
  $r s/wdio --only notfs-mark-all-as-read.2browsers $args  # REANME append -manually
  $r s/wdio --only notfs-snooze-talk.2br.mtime $args
  $r s/wdio --only notf-override-group-prefs.2browsers $args
  $r s/wdio-7 --only notfs-prefs-inherit-own.d.2br --cd -i $args
  $r s/wdio-7 --only notfs-prefs-inherit-group.d.2br --cd -i $args
  $r s/wdio --only notf-prefs-custom-groups.2browsers $args
  $r s/wdio --only notf-prefs-private-groups.2browsers $args
  $r s/wdio --only notf-prefs-pages-replied-to.2br $args
  $r s/wdio-7 --only cannot-reply-via-email.2br --cd -i $args
  $r s/wdio --only notfs-page-gone.2browsers $args
  # Later:
  # Move page from a staff only cat, to a publ cat, and verify people who have
  # subscr to the publ cat and haven't seen the topic before, get notified.

  # See: specs/notf-page-cats-site.2browsers.test.ts:
  #$r s/wdio --only notfs-for-whole-site.2browsers $args
  #$r s/wdio --only notfs-for-publ-cat.2browsers $args
  #$r s/wdio --only notfs-for-priv-cat.2browsers $args
  #$r s/wdio --only notfs-for-publ-page.2browsers $args
  #$r s/wdio --only notfs-for-priv-group-page.2browsers $args
  #$r s/wdio --only notfs-for-dir-message.2browsers $args

  $r s/wdio-7 --only notfs-mark-seen-as-seen.d.2br --cd -i $args  # RENAME append -automatically

  # Privacy preferences
  # ------------

  $r s/wdio-7 --only privacy-list-activity.2br.f.e2e.ts --cd -i $args
  $r s/wdio-7 --only privacy-may-see.3br.f.e2e.ts --cd -i $args
  $r s/wdio-7 --only block-mentions.2br.d --cd -i $args
  $r s/wdio-7 --only block-dir-msgs.2br.d --cd -i $args

  # ------------

  # RENAME these to  modn-... ,  and MOVE to (4862065) below?
  $r s/wdio --only new-user-review-ok.2br.mtime $args
  #$r s/wdio --only new-user-review-bad.2browsers $args
  $r s/wdio --only new-member-allow-approve.2br.mtime $args
  #$r s/wdio --only new-member-allow-reject.2browsers $args
  $r s/wdio --only review-edits-ninja-late.2br.mtime $args

  # MOVE to (4862065) below?
  $r s/wdio --only spam-basic-local.2browsers $args
  $r s/wdio --only spam-basic-local-ip-links-unblock.2br.mtime $args
  $r s/wdio --only spam-basic-safe-browsing-api-blocked.2br.mtime $args
  $r s/wdio --only spam-basic-akismet-blocked.2br.mtime $args
  $r s/wdio --only spam-basic-akismet-false-positives.2br.mtime $args
  $r s/wdio --only spam-basic-akismet-false-negatives.2br.mtime $args
  $r s/wdio --only flag-member-block-agree.2browsers $args
  $r s/wdio --only flag-guest-block-agree.2browsers $args

  # Page types
  # ------------

  $r s/wdio-7 --only page-type-discussion-progress.1br.d --cd -i $args
  $r s/wdio-7 --only page-type-idea-statuses-comments.2br.d --cd -i $args
  $r s/wdio-7 --only page-type-problem-statuses.2br.d --cd -i $args
  $r s/wdio-7 --only page-type-question-closed.2br.d --cd -i $args
  $r s/wdio-7 --only page-type-info-page.1br.d --cd -i $args

  $r s/wdio-7 --only do-api-upvote-ideas-sort-by-votes.2br.d --cd -i $args

  # Seach
  # ------------

  $r s/wdio --only search-public-basic.2browsers $args
  $r s/wdio --only search-private-chat.2browsers $args
  $r s/wdio-7 --only reindex-sites.2br.f --cd -i $args


  # This test is flaky because missing feature: disabling email notfs for replies
  # one has seen.
  $r s/wdio --only summary-emails.2br.mtime $args

  # Invites
  # ------------

  $r s/wdio --only invites-by-adm-click-email-set-pwd-link.2browsers $args
  $r s/wdio --only invites-by-mod-try-signup-after.2browsers $args
  $r s/wdio --only invites-by-core-try-login-after.2browsers $args
  $r s/wdio --only invites-weird-email-addrs.2browsers $args
  $r s/wdio --only invites-many-retry.2browsers $args
  $r s/wdio --only invites-too-many.2browsers $args
  $r s/wdio --only invite-to-groups.2browsers $args

  # ------------

  $r s/wdio --only weird-usernames.2browsers $args

  $r s/wdio --only group-mentions-built-in-groups.2browsers $args
  $r s/wdio --only group-mentions-custom-groups.2browsers $args

  $r s/wdio --only group-permissions-similar-topics.2br.mtime $args
  $r s/wdio --only permissions-edit-wiki-posts.2browsers $args
  $r s/wdio-7 --only perms-see-own.2br.f $args --cd -i  # _see_own

  # Do after the search and access permission tests above.  [.more_cat_tests]
  $r s/wdio --only categories-delete.2br $args
  $r s/wdio-7 --only category-perms.2br.d --cd -i $args
  $r s/wdio-7 --only cats-perf-many.2br.d --cd -i $args

  # E2EBUG: Flappy  (or cats-perf-many.2br.d above?)
  $r s/wdio-7 --only search-tag-vals-priv-cats.2br.f --cd -i $args

  $r s/wdio --only slow-3g-navigate-edit-drafts.2browsers $args

  $r s/wdio-7 --only assign-to-basic.2br.d --cd -i $args
  $r s/wdio-7 --only assign-to-notfs.2br.d --cd -i $args
  $r s/wdio-7 --only assign-can-see.2br.d --cd -i $args

  $r s/wdio-7 --only topic-prominent-pats-basic.2br.d --cd -i $args
  $r s/wdio-7 --only topic-prominent-pats-reply-approve.2br.d --cd -i $args


  # Moderation   (4862065)
  # ------------

  $r s/wdio-7 --only modn-ban-spammer.2br.f.e2e.ts --cd -i $args

  $r s/wdio-7 --only may-see-email-adrs.2br.d --cd -i $args


  # Aliases (anonyms, pseudonyms)
  # ------------

  $r s/wdio-7 --only alias-anons-basic-temp.2br.f --cd -i $args
  $r s/wdio-7 --only alias-anons-basic-perm.2br.f --cd -i $args
  $r s/wdio-7 --only alias-anons-approve-review.2br.f --cd -i $args
  $r s/wdio-7 --only alias-anons-edit-alter.2br.f --cd -i $args
  # $r s/wdio-7 --only alias-anons-true-mixed.2br.f --cd -i $args
  # Would be good with this too, later:
  #$r s/wdio-7 --only alias-anons-see-own.2br.f --cd -i $args  # _see_own


  # API
  # ------------

  $r s/wdio --only api-upsert-categories.2browsers $args
  $r s/wdio --only api-upsert-pages.2browsers $args
  $r s/wdio --only api-upsert-page-notfs.2browsers $args
  $r s/wdio-7 --only api-upsert-posts.2br.d --cd -i $args

  $r s/wdio-7 --only api-search-full-text.1br.f --cd -i $args
  $r s/wdio-7 --only api-list-query-for-topics-popular-first --cd -i $args
  $r s/wdio --only api-list-query-for-topics-recent-etc-first $args
  $r s/wdio --only api-list-query-for-posts $args
 #$r s/wdio --only api-list-query-for-events $args

  $r s/wdio-7 --only api-get-query-for-pats.2br --cd -i $args
 #$r s/wdio-7 --only api-get-query-for-cats.2br --cd -i $args
 #$r s/wdio-7 --only api-get-query-for-pages.2br --cd -i $args
 #$r s/wdio-7 --only api-get-query-for-posts.2br --cd -i $args
 #$r s/wdio-7 --only api-get-query-for-tags.2br --cd -i $args

  $r s/wdio-7 --only do-api-like-and-subscribe.2br --cd -i $args
  $r s/wdio-7 --only do-api-create-pages-comts-check-webhooks-search.2br --cd -i $args
  

  $r s/wdio-7 --only dir.create-site-via-api.2br --cd -i $args
  $r s/wdio-7 --only embcom.create-site-via-api.2br --cd -i $args
  $r s/wdio-7 --only dir.create-site-imp-json.2br --cd -i $args

  $r s/wdio-7 --only webhooks-basic.2br --cd -i $args
  # In Prod, there's soon lots of time between the retries — so, some extra timeout.
  # But what about using server.playTimeSeconds(..) instead? Then, would finish fast?
  $r s/wdio-7 --only webhooks-retry.2br --cd -i --waitforTimeout 40100 $args
  $r s/wdio-7 --only webhooks-enable-disable.2br --cd -i $args
  $r s/wdio-7 --only webhooks-for-api-upserts.2br --cd -i $args

  $r s/wdio-7 --only plan-maintenance.2br.d --cd -i $args

  $r s/wdio-7 --only site-api-secrets-not-global.2br.f --cd -i $args

  # ! countdownUndoTimeout  slooow if mod task list is long.



  # wip:
  # settings-allow-local-signup
  # settings-allow-signup
  # settings-disable-openauth


  # Usability Testing Exchange
  # ------------

  $r s/wdio --only utx-all-logins.1br.extidp $args



  #------------------------------------------------------------
  # Start a http server, for the embedding html pages,
  # and the -w-logout-url test.
  start_http_server 8080


  # Single Sign-On
  # ------------

  $r s/wdio --only sso-test.2browsers $args
  $r s/wdio --only sso-login-member.2browsers $args
  $r s/wdio --only sso-login-new-members.2browsers $args
  $r s/wdio --only sso-login-required.2browsers $args
  $r s/wdio --only sso-login-required-w-logout-url.2browsers $args
  $r s/wdio --only sso.logout-url.2br $args
  # unimpl:  s/wdio --only sso-approval-required.2browsers $args
  # unimpl:  s/wdio --only sso-login-and-approval-required.2browsers $args
  $r s/wdio --only sso-admin-extra-login $args
  $r s/wdio --only sso-all-ways-to-login.2browsers $args
  $r s/wdio --only sso-access-denied-login.2browsers $args
  $r s/wdio --only sso-one-time-key-errors.2browsers $args

  # Also see  --only embcom.sso  below.


  # API + SSO
  # ------------

  $r s/wdio --only api-update-user-and-sso-user.2br $args
  $r s/wdio --only api-w-sso-upsert-pages.2browsers $args
  $r s/wdio --only api-private-chat-two-pps-sso-extid.2browsers $args
  $r s/wdio --only api-private-chat-two-pps-list-use-usernames.2browsers $args


  # API: CORS
  # ------------

  $r s/wdio-7 --only api-search-ext-site-and-server.2br.cors --cd -i $args


  # Embedded forum
  # ------------

  #$r s/wdio --b3c  --only embforum.b3c.login.1br  $args
  #$r s/wdio --b3c  --only embforum.b3c.sso-login.1br $args


  # Embedded comments
  # ------------

  # For testing manually. Just verify the test starts properly.
  # For now, not "manual" (with 'l' at the end) — that'd start manual.2browsers too  o.O
  $r s/wdio       --only embcom.manua.2br $args  # delete soon
  $r s/wdio-7     --only embcom.manual.2br --cd -i $args
  $r s/wdio-7     --only embcom.manyframes.manual.2br --cd -i $args

  # Also see navigation-as-* above.
  $r s/wdio       --only embedded-comments-navigation-as-guest $args

  $r s/wdio       --only embedded-comments-create-site-no-verif-email-admin-area-tour.2browsers $args
  $r s/wdio-7     --only embcom.create-site-req-verif-email-exit-tours.2br --cd -i $args
  $r s/wdio       --only embedded-comments-create-site-forum-intro-tour $args
  $r s/wdio       --only embedded-comments-create-site-import-disqus.2br $args
  $r s/wdio-7     --only embcom.drafts-previews-not-logged-in.2br --cd -i $args
  $r s/wdio       --only embedded-comments-scroll-and-load-more.2browsers $args
  $r s/wdio       --only embedded-comments-scroll-embedding-page $args
  # (no -old-name version, because the new name is always included in the server's genetarted html.)

  $r s/wdio       --only embedded-comments-different-disc-ids-same-page $args
  #r s/wdio       --only embcom.many-comment-iframes-click-load-more.2br $args TESTS_MISSING
  $r s/wdio       --only embedded-comments-discussion-id.test $args
  $r s/wdio       --only embedded-comments-discussion-id-old-name $args
  $r s/wdio-7     --only embcom.ignore-query-params.2br --cd -i $args

  $r s/wdio       --only embedded-comments-guest-login-email-notf-unsbscribe $args
  $r s/wdio       --only embcom.all-idp-logins.1br.extidp $args
  $r s/wdio       --only embcom.all-idp-logins-old-name.1br.extidp $args
  $r s/wdio --b3c --only embcom.b3c.verif-email.1br $args
  $r s/wdio --b3c --only embcom.b3c.guest.1br $args
  $r s/wdio --b3c --only embcom.b3c.verif-gmail.1br.extidp $args
  $r s/wdio --b3c --only embcom.b3c.unverif-gmail.1br.extidp $args
  $r s/wdio       --only embedded-comments-edit-and-vote.test $args
  $r s/wdio       --only embedded-comments-edit-and-vote-old-name $args
  $r s/wdio-7     --only embcom.vote-bef-page-exists.1br --cd -i $args
  $r s/wdio-7     --only embcom.reply-vote-report-bef-login.2br --cd -i $args
  $r s/wdio       --only embedded-comments-conf-notf-pref-first $args

  # E2EBUG: Flappy
  $r s/wdio-7     --only embcom.sort-order-op-likes-btn-txt.2br.ec --cd -i $args

  $r s/wdio       --only embedded-comments-category-refs.2browsers $args
  $r s/wdio       --only embedded-comments-cat-refs-and-disc-ids.2browsers $args
  $r s/wdio       --only embedded-comments-uploads-origin $args
  $r s/wdio       --only embedded-comments-short-script-cache-time $args
  # (all names included in short-cache-time already)

  # Do last, easier to debug the tests above instead if there's a bug:
  $r s/wdio-7     --only embcom.expimpjson.create-site-exp-json.2br --cd -i $args
  $r s/wdio-7     --only embcom.expimpjson.imp-to-new-site.2br --cd -i $args
  #r s/wdio-7     --only embcom.expimpjson.imp-to-existing-site.2br.e2e-UNIMPL --cd -i $args
  $r s/wdio-7     --only embcom.expimpjson.restore-overwrite-site-same-domain.2br --cd -i $args
  $r s/wdio-7     --only embcom.expimpjson.restore-overwrite-site-new-domain.2br --cd -i $args

  $r s/wdio-7     --only embcom.comment-counts.2br.ec.cors --cd -i $args

  # Single Sign-On, embedded comments:
  $r s/wdio-7     --only embcom.sso.token-direct-w-logout-url.2br.ec --cd -i $args
  $r s/wdio-7     --only embcom.sso.token-in-cookie.2br.ec --cd -i $args
  $r s/wdio-7     --only embcom.sso.redir-page.2br.ec --cd -i $args

  # Many comments iframes:
  $r s/wdio-7     --only embcom.manyframes.basic.2br --cd -i $args
  $r s/wdio-7     --only embcom.manyframes.drafts-repl-to.2br --cd -i $args
  $r s/wdio-7     --only embcom.manyframes.js-api.2br.ec --cd -i $args
  $r s/wdio-7     --only embcom.manyframes.js-api.sso.2br.ec --cd -i $args
  $r s/wdio-7     --only embcom.manyframes.comment-counts.2br.cors --cd -i $args

  # Single-Page Applications (SPA)
  $r s/wdio-7     --only embcom.dont-load-script-twice.1br.ec --cd -i $args

  $r s/wdio-7     --only embcom.log-levels-on-loaded.1br.ec --cd -i $args

  # Stealing an embedded session id
  $r s/wdio-7     --only embcom.sessions-emb-sess-cannot-moderate.3br --cd -i $args



  if [ -n "$http_server_pid" ]; then
    kill $http_server_pid
    echo "Stopped the http server for the embedded comments, pid $http_server_pid."
    http_server_pid=''
  fi
  #------------------------------------------------------------


  #------------------------------------------------------------
  # Ghost embedded comments

  # Ooops, Ty's Ghost image isn't available for prod tests. [ghost_prod_test_img]
  # So, comment out for now:
  # Ghost will listen on port 2368, see docker-compose.yml.
  #s/d up -d it-ghost
  #$r s/wdio-7     --only ghost.embcom.comments-basic.2br --cd -i $args
  #s/d stop it-ghost


  #------------------------------------------------------------
  # dupl code (8BMFEW2)
  # Gatsby embedded comments
  # ------------
  if [ -n "$yarn_build_gatsby_pid" ]; then
    echo "Waiting for \$yarn_build_gatsby_pid $yarn_build_gatsby_pid to finish ..."
    wait $yarn_build_gatsby_pid
  fi
  # And then start a server, for the blog: (but let's do that here, if not started)
  server_port_8000=$(netstat -nl | grep ':8000.*LISTEN')
  if [ -z "$server_port_8000" ]; then
    echo "Starting a http server for the Gatsby blog..."
    ./node_modules/.bin/http-server -p8000 modules/gatsby-starter-blog/public/ &
    # Field 2 is the process id.
    server_port_8000_pid=$(jobs -l | grep p8000 | awk '{ printf $2; }')
  fi
  # else: the user has probably started the server henself already, do nothing.

  $r s/wdio --only embedded-comments-gatsby $args

  if [ -n "$server_port_8000_pid" ]; then
    kill $server_port_8000_pid
    wait $server_port_8000_pid
    echo "Stopped the http server for the Gatsby blog, pid $server_port_8000_pid."
  fi


  # dupl code (8BMFEW2)
  # Gatsby embedded comments, old version 0.4.4
  # ------------
  if [ -n "$yarn_build_gatsby_pid2" ]; then
    echo "Waiting for \$yarn_build_gatsby_pid2 $yarn_build_gatsby_pid2 to finish, old ed-comments 0.4.4 ..."
    wait $yarn_build_gatsby_pid2
  fi
  # And then start a server, for the blog: (but let's do that here, if not started)
  server_port_8000=$(netstat -nl | grep ':8000.*LISTEN')
  if [ -z "$server_port_8000" ]; then
    echo "Starting a http server for the Gatsby blog, old ed-comments 0.4.4..."
    ./node_modules/.bin/http-server -p8000 modules/gatsby-starter-blog-ed-comments-0.4.4/public/ &
    # Field 2 is the process id.
    server_port_8000_pid2=$(jobs -l | grep p8000 | awk '{ printf $2; }')
    echo "Gatsby blog server running as pid $server_port_8000_pid2."
  fi
  # else: the user has probably started the server henself already, do nothing.

  $r s/wdio --only embedded-comments-gatsby $args

  if [ -n "$server_port_8000_pid2" ]; then
    kill $server_port_8000_pid2
    wait $server_port_8000_pid2
    echo "Stopped the http server for the Gatsby blog, old ed-comments 0.4.4, pid $server_port_8000_pid2."
  fi
  #------------------------------------------------------------
}


runAllE2eTests


log_message "Done." >> $failfile
echo "Done running end-to-end tests."

# vim: et ts=2 sw=2 tw=0
