(Move into tyworld.adoc)

Different ids
--------------

### Single Sign-On ids

Prefix: `ssoid:`.

When you upsert a SSO user, you include a SSO id, so the next time that
same user logs in, Talkyard knows it's the same user, and won't create
a new user. Instead, Talkyard could (not impl) update its name and email
etc to match the new data being upserted (with the same SSO id).

In most cases, probably it'd worked fine to use the External Ids for this.
However, in some rare cases, Talkyard might be connected to a SSO system
that uses different user ids, than the external ids the API clients use
for those same users? Then, the SSO ids need to be stored separately from
the external ids, so it's possible for a user to have a SSO id that is
different from its external id.


### External ids

Prefix: `extid:`, or just `ext:`?

For usage with Talkyard's API. E.g. if you upsert something into Talkyard,
you include an external id — so the next time you upsert the same thing,
Talkyard knows you're updating that thing, not inserting something new.


### Internal ids

Prefix: `tyid:`.

Most things in Talkyard have their own ids, and you can ignore those ids.
Sometimes you see them in urls, e.g. `https://talkyard-server/-1234/page-slug`
would load and show the page with id 1234 (works also if the `page-slug`
is incorrect).


### Discussion ids `[docs-3035KSSD2]`

Prefix: `diid:`.

Ids for embedded blog comments discussion pages. So the discussions
can still be found, also if the blog author changes the urls to the blog posts.

The discussion ids need a different namespace than external ids [J402RKDT] for
usage by Talkyard's API — because the discussion ids in the Disqus xml dump,
can be anything, incl short numbers — they're generated by e.g. WordPress
or Ghost or Disqus or whatever. And they can collide with external
ids from another data source and used with Talkyard's API. That would
make the API partly unusable (in the rare cases when there was a collision).
They're stored in the embedded discussions lookup table, where they are prefixed
with `diid:` so they also won't be mistaken for discussion page urls, which
are also stored in that table for simplicity.
