/*
 * Copyright (C) 2015 Kaj Magnus Lindberg
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/// <reference path="../more-prelude.more.ts" />

//------------------------------------------------------------------------------
   namespace debiki2.pagedialogs {
//------------------------------------------------------------------------------

const r = ReactDOMFactories;
var Modal = rb.Modal;
var ModalHeader = rb.ModalHeader;
var ModalTitle = rb.ModalTitle;
var ModalBody = rb.ModalBody;
var ModalFooter = rb.ModalFooter;
var ProgressBar = rb.ProgressBar;


var progressBarDialog;

export function getProgressBarDialog() {
  if (!progressBarDialog) {
    progressBarDialog = ReactDOM.render(ProgressBarDialog(), utils.makeMountNode());
  }
  return progressBarDialog;
}


var ProgressBarDialog = createComponent({
  getInitialState: function () {
    return {
      isOpen: false,
      title: '',
      percentDone: 0,
      onCancel: null,
    };
  },

  open: function(title: string, onCancel) {
    this.setState({
      isOpen: true,
      title: title,
      percentDone: 0,
      onCancel: onCancel
    });
  },

  close: function() {
    this.setState({ isOpen: false });
  },

  setDonePercent: function(percent: number) {
    this.setState({ percentDone: percent });
  },

  render: function () {
    var content;
    var footer;
    if (this.state.isOpen) {
      content =
          r.div({},
            ProgressBar({ now: this.state.percentDone, label: this.state.percentDone + "%", srOnly: true }));
      if (this.state.onCancel) {
        footer =
            ModalFooter({},
              Button({ onClick: () => { this.close(); this.state.onCancel() } }, 'Cancel'));
      }
    }
    return (
      Modal({ show: this.state.isOpen, onHide: this.close, dialogClassName: 'dw-progress-bar-dialog',
          // Don't close via Esc key or click outside dialog — only when done, or Cancel button:
          keyboard: false, backdrop: 'static' },
        ModalHeader({}, ModalTitle({}, this.state.title)),
        ModalBody({}, content),
        footer));
  }
});


//------------------------------------------------------------------------------
   }
//------------------------------------------------------------------------------
// vim: fdm=marker et ts=2 sw=2 tw=0 fo=r list
