--------------------
-- This is the PLAY_EVOLUTIONOS table corresponding to the state of the prod db in dw0azirdbpv11danny.

-- This file was generated like so:
--  pg_dump --host 192.168.0.123 --username=debiki_test_evolutions --table=play_evolutions --no-owner --no-tablespaces --use-set-session-authorization > play_evolutions-table-in-debiki_evolutions_test.sql

-- (Please note that the row below COPY below is 32 kb long (!) Fortunately it doesn't exceed the 64 limit.)
--------------------

--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET default_with_oids = false;

--
-- Name: play_evolutions; Type: TABLE; Schema: debiki_test_evolutions; Owner: -
--

CREATE TABLE play_evolutions (
    id integer NOT NULL,
    hash character varying(255) NOT NULL,
    applied_at timestamp without time zone NOT NULL,
    apply_script text,
    revert_script text,
    state character varying(255),
    last_problem text
);


--
-- Data for Name: play_evolutions; Type: TABLE DATA; Schema: debiki_test_evolutions; Owner: -
--

COPY play_evolutions (id, hash, applied_at, apply_script, revert_script, state, last_problem) FROM stdin;
1	d174a7b56f479611f567f00a67cec6f3c157c0b5	2013-05-26 00:00:00	CREATE FUNCTION hex_to_int(hexval character varying) RETURNS integer\nLANGUAGE plpgsql IMMUTABLE STRICT\nAS $$\nDECLARE\nresult  int;;\nBEGIN\nEXECUTE 'SELECT x''' || hexval || '''::int' INTO result;;\nRETURN result;;\nEND;;\n$$;\n\n\nCREATE FUNCTION inc_next_per_page_reply_id(site_id character varying, page_id character varying, step integer) RETURNS integer\nLANGUAGE plpgsql\nAS $$\ndeclare\nnext_id int;;\nbegin\nupdate DW1_PAGES\nset NEXT_REPLY_ID = NEXT_REPLY_ID + step\nwhere TENANT = site_id and GUID = page_id\nreturning NEXT_REPLY_ID into next_id;;\nreturn next_id;;\nend;;\n$$;\n\n\nCREATE FUNCTION string_id_to_int(string_id character varying) RETURNS character varying\nLANGUAGE plpgsql IMMUTABLE STRICT\nAS $_$\nDECLARE\nresult  int;;\nBEGIN\nSELECT\ncase\nwhen string_id ~ '^[0-9]+$' then string_id\nelse case string_id\nwhen '0t' then '65501'\nwhen '0b' then '65502'\nwhen '0c' then '65503'\n-- I used `7` in test & dev though, but shorter ids = better, I hope 5 will do:\nelse '' || substring('' || hex_to_int(substring(md5(string_id) from 1 for 7)) from 1 for 6)\nend\nend\nINTO result;;\nRETURN result;;\nEND;;\n$_$;\n\n\nCREATE TABLE dw0_version (\nversion character varying(100) NOT NULL\n);\n\n\nCREATE TABLE dw1_emails_out (\ntenant character varying(32) NOT NULL,\nid character varying(32) NOT NULL,\nsent_to character varying(100) NOT NULL,\nsent_on timestamp without time zone,\nsubject character varying(200) NOT NULL,\nbody_html character varying(2000) NOT NULL,\nprovider_email_id character varying(100),\nfailure_type character varying(1) DEFAULT NULL::character varying,\nfailure_text character varying(2000) DEFAULT NULL::character varying,\nfailure_time timestamp without time zone,\nCONSTRAINT dw1_emlot_failtext_type__c CHECK (((failure_text IS NULL) = (failure_type IS NULL))),\nCONSTRAINT dw1_emlot_failtime_type__c CHECK (((failure_time IS NULL) = (failure_type IS NULL))),\nCONSTRAINT dw1_emlot_failtype__c CHECK (((failure_type)::text = ANY ((ARRAY['B'::character varying, 'R'::character varying, 'C'::character varying, 'O'::character varying])::text[])))\n);\n\n\nCREATE TABLE dw1_guests (\nsite_id character varying(32) NOT NULL,\nid character varying(32) NOT NULL,\nname character varying(100) NOT NULL,\nemail_addr character varying(100) NOT NULL,\nlocation character varying(100) NOT NULL,\nurl character varying(100) NOT NULL\n);\n\n\nCREATE TABLE dw1_ids_openid (\nsno character varying(32) NOT NULL,\ntenant character varying(32) NOT NULL,\nusr character varying(32) NOT NULL,\nusr_orig character varying(32) NOT NULL,\noid_claimed_id character varying(500) NOT NULL,\noid_op_local_id character varying(500) NOT NULL,\noid_realm character varying(100) NOT NULL,\noid_endpoint character varying(100) NOT NULL,\noid_version character varying(100) NOT NULL,\nfirst_name character varying(100) NOT NULL,\nemail character varying(100) NOT NULL,\ncountry character varying(100) NOT NULL,\ncdati timestamp without time zone DEFAULT now() NOT NULL,\nCONSTRAINT dw1_idsoid_sno_not_0__c CHECK (((sno)::text <> '0'::text))\n);\n\n\nCREATE TABLE dw1_ids_simple (\nsno character varying(32) NOT NULL,\nname character varying(100) NOT NULL,\nemail character varying(100) NOT NULL,\nlocation character varying(100) NOT NULL,\nwebsite character varying(100) NOT NULL,\nCONSTRAINT dw1_idssimple_sno_not_0__c CHECK (((sno)::text <> '0'::text))\n);\n\n\nCREATE TABLE dw1_ids_simple_email (\ntenant character varying(32) NOT NULL,\nlogin character varying(32),\nctime timestamp without time zone NOT NULL,\nversion character(1) NOT NULL,\nemail character varying(100) NOT NULL,\nemail_notfs character varying(1) NOT NULL,\nCONSTRAINT dw1_idsmpleml_email__c CHECK (((email)::text ~~ '%@%.%'::text)),\nCONSTRAINT dw1_idsmpleml_notfs__c CHECK (((email_notfs)::text = ANY ((ARRAY['R'::character varying, 'N'::character varying, 'F'::character varying])::text[]))),\nCONSTRAINT dw1_idsmpleml_version__c CHECK ((version = ANY (ARRAY['C'::bpchar, 'O'::bpchar])))\n);\n\n\nCREATE SEQUENCE dw1_ids_sno\nSTART WITH 10\nINCREMENT BY 1\nNO MINVALUE\nNO MAXVALUE\nCACHE 1;\n\n\nCREATE TABLE dw1_logins (\nsno character varying(32) NOT NULL,\ntenant character varying(32) NOT NULL,\nprev_login character varying(32),\nid_type character varying(10) NOT NULL,\nid_sno character varying(32) NOT NULL,\nlogin_ip character varying(39) NOT NULL,\nlogin_time timestamp without time zone NOT NULL,\nlogout_ip character varying(39),\nlogout_time timestamp without time zone,\nCONSTRAINT dw1_logins_idtype__c CHECK (((id_type)::text = ANY ((ARRAY['Simple'::character varying, 'Unau'::character varying, 'OpenID'::character varying, 'EmailID'::character varying])::text[]))),\nCONSTRAINT dw1_logins_sno_not_0__c CHECK (((sno)::text <> '0'::text))\n);\n\n\nCREATE SEQUENCE dw1_logins_sno\nSTART WITH 10\nINCREMENT BY 1\nNO MINVALUE\nNO MAXVALUE\nCACHE 1;\n\n\nCREATE TABLE dw1_notfs_page_actions (\ntenant character varying(32) NOT NULL,\nctime timestamp without time zone NOT NULL,\npage_id character varying(32) NOT NULL,\npage_title character varying(100) NOT NULL,\nrcpt_id_simple character varying(32),\nrcpt_role_id character varying(32),\nevent_type character varying(20) NOT NULL,\nevent_pga integer NOT NULL,\ntarget_pga integer,\nrcpt_pga integer NOT NULL,\nrcpt_user_disp_name character varying(100) NOT NULL,\nevent_user_disp_name character varying(100) NOT NULL,\ntarget_user_disp_name character varying(100),\nstatus character varying(1) DEFAULT 'N'::character varying NOT NULL,\nemail_sent character varying(32) DEFAULT NULL::character varying,\nemail_link_clicked timestamp without time zone,\nmtime timestamp without time zone,\nemail_status character varying(1),\ndebug character varying(200) DEFAULT NULL::character varying,\nCONSTRAINT dw1_ntfpga_emailclkd__c CHECK (CASE WHEN (email_link_clicked IS NULL) THEN true ELSE (email_sent IS NOT NULL) END),\nCONSTRAINT dw1_ntfpga_emlst__c_in CHECK (((email_status)::text = 'P'::text)),\nCONSTRAINT dw1_ntfpga_idsmpl_role__c CHECK (((rcpt_role_id IS NULL) <> (rcpt_id_simple IS NULL))),\nCONSTRAINT dw1_ntfpga_status__c CHECK (((status)::text = ANY ((ARRAY['N'::character varying, 'O'::character varying])::text[])))\n);\n\n\nCREATE TABLE dw1_page_actions (\npage character varying(32),\npaid integer NOT NULL,\nlogin character varying(32),\n"time" timestamp without time zone NOT NULL,\ntype character varying(20) NOT NULL,\nrelpa integer,\ntext text,\nmarkup character varying(30),\nwheere character varying(150),\nnew_ip character varying(39),\ntenant character varying(32) NOT NULL,\npage_id character varying(32) NOT NULL,\napproval character varying(1),\nauto_application character varying(1),\nguest_id character varying(32),\nrole_id character varying(32),\npost_id integer NOT NULL,\nCONSTRAINT dw1_pactions_paid_not_0__c CHECK (((paid)::text <> '0'::text)),\nCONSTRAINT dw1_pgas_appr_autoappl__c CHECK (CASE WHEN (approval IS NOT NULL) THEN (((type)::text <> 'Edit'::text) OR (auto_application IS NOT NULL)) ELSE true END),\nCONSTRAINT dw1_pgas_approval__c_in CHECK (((approval)::text = ANY ((ARRAY['P'::character varying, 'W'::character varying, 'A'::character varying, 'M'::character varying])::text[]))),\nCONSTRAINT dw1_pgas_autoappl__c_in CHECK (((auto_application)::text = 'A'::text)),\nCONSTRAINT dw1_pgas_autoappl_type__c CHECK (CASE WHEN (auto_application IS NOT NULL) THEN ((type)::text = 'Edit'::text) ELSE true END),\nCONSTRAINT dw1_pgas_login_guest_role__c CHECK (((((login IS NULL) AND (guest_id IS NULL)) AND (role_id IS NULL)) OR ((login IS NOT NULL) AND ((guest_id IS NULL) <> (role_id IS NULL))))),\nCONSTRAINT dw1_pgas_magic_id_parents__c CHECK ((relpa = CASE WHEN (paid = 65501) THEN 65501 WHEN (paid = 65502) THEN 65502 WHEN (paid = 65503) THEN 65503 ELSE relpa END)),\nCONSTRAINT dw1_pgas_magic_id_types__c CHECK (((type)::text = (CASE WHEN ((paid)::text = ANY (ARRAY[('0t'::character varying)::text, ('0b'::character varying)::text, ('0c'::character varying)::text])) THEN 'Post'::character varying ELSE type END)::text)),\nCONSTRAINT dw1_pgas_markup__c_ne CHECK ((btrim((markup)::text) <> ''::text)),\nCONSTRAINT dw1_pgas_newip__c_ne CHECK ((btrim((new_ip)::text) <> ''::text)),\nCONSTRAINT dw1_pgas_paid__c_ne CHECK ((btrim((paid)::text) <> ''::text)),\nCONSTRAINT dw1_pgas_post_markup__c_nn CHECK (CASE type WHEN 'Post'::text THEN (markup IS NOT NULL) ELSE true END),\nCONSTRAINT dw1_pgas_text__c_ne CHECK ((btrim(text) <> ''::text)),\nCONSTRAINT dw1_pgas_type__c_in CHECK (((type)::text = ANY ((ARRAY['Post'::character varying, 'Edit'::character varying, 'EditApp'::character varying, 'Aprv'::character varying, 'Rjct'::character varying, 'Rating'::character varying, 'MoveTree'::character varying, 'CollapsePost'::character varying, 'CollapseTree'::character varying, 'DelPost'::character varying, 'DelTree'::character varying, 'FlagSpam'::character varying, 'FlagIllegal'::character varying, 'FlagCopyVio'::character varying, 'FlagOther'::character varying, 'Undo'::character varying, 'VoteUp'::character varying, 'VoteDown'::character varying])::text[]))),\nCONSTRAINT dw1_pgas_type_approval__c CHECK (CASE type WHEN 'Aprv'::text THEN (approval IS NOT NULL) WHEN 'Rjct'::text THEN (approval IS NULL) ELSE true END),\nCONSTRAINT dw1_pgas_where__c_ne CHECK ((btrim((wheere)::text) <> ''::text))\n);\n\n\nCREATE TABLE dw1_page_paths (\ntenant character varying(32) NOT NULL,\nparent_folder character varying(100) NOT NULL,\npage_id character varying(32) NOT NULL,\nshow_id character varying(1) NOT NULL,\npage_slug character varying(100) NOT NULL,\ncdati timestamp without time zone DEFAULT now() NOT NULL,\ncanonical_dati timestamp without time zone DEFAULT now() NOT NULL,\ncanonical character varying(1) NOT NULL,\nCONSTRAINT dw1_pgpths_cdati_mdati__c_le CHECK ((cdati <= canonical_dati)),\nCONSTRAINT dw1_pgpths_cncl__c CHECK (((canonical)::text = ANY ((ARRAY['C'::character varying, 'R'::character varying])::text[]))),\nCONSTRAINT dw1_pgpths_folder__c_dash CHECK (((parent_folder)::text !~~ '%/-%'::text)),\nCONSTRAINT dw1_pgpths_folder__c_start CHECK (((parent_folder)::text ~~ '/%'::text)),\nCONSTRAINT dw1_pgpths_showid__c_in CHECK (((show_id)::text = ANY ((ARRAY['T'::character varying, 'F'::character varying])::text[]))),\nCONSTRAINT dw1_pgpths_slug__c_ne CHECK ((btrim((page_slug)::text) <> ''::text))\n);\n\n\nCREATE TABLE dw1_page_ratings (\npage character varying(32),\npaid integer NOT NULL,\ntag character varying(30) NOT NULL,\ntenant character varying(32) NOT NULL,\npage_id character varying(32) NOT NULL\n);\n\n\nCREATE TABLE dw1_pages (\nsno character varying(32) NOT NULL,\ntenant character varying(32) NOT NULL,\nguid character varying(32) NOT NULL,\npage_role character varying(10) NOT NULL,\nparent_page_id character varying(32),\ncdati timestamp without time zone DEFAULT now() NOT NULL,\nmdati timestamp without time zone DEFAULT now() NOT NULL,\npubl_dati timestamp without time zone DEFAULT now(),\ncached_title character varying(100) DEFAULT NULL::character varying,\nsgfnt_mdati timestamp without time zone,\nnext_reply_id integer DEFAULT 1 NOT NULL,\ncached_author_display_name character varying(100),\ncached_author_user_id character varying(32),\ncached_num_posters integer DEFAULT 0 NOT NULL,\ncached_num_actions integer DEFAULT 0 NOT NULL,\ncached_num_posts_to_review integer DEFAULT 0 NOT NULL,\ncached_num_posts_deleted integer DEFAULT 0 NOT NULL,\ncached_num_replies_visible integer DEFAULT 0 NOT NULL,\ncached_last_visible_post_dati timestamp without time zone,\ncached_num_child_pages integer DEFAULT 0 NOT NULL,\nCONSTRAINT dw1_pages_cachedtitle__c_ne CHECK ((btrim((cached_title)::text) <> ''::text)),\nCONSTRAINT dw1_pages_cdati_mdati__c_le CHECK ((cdati <= mdati)),\nCONSTRAINT dw1_pages_cdati_publdati__c_le CHECK ((cdati <= publ_dati)),\nCONSTRAINT dw1_pages_cdati_smdati__c_le CHECK ((cdati <= sgfnt_mdati)),\nCONSTRAINT dw1_pages_pagerole__c_in CHECK (((page_role)::text = ANY ((ARRAY['G'::character varying, 'B'::character varying, 'BP'::character varying, 'FG'::character varying, 'F'::character varying, 'FT'::character varying, 'W'::character varying, 'WP'::character varying, 'C'::character varying])::text[]))),\nCONSTRAINT dw1_pages_sno_not_0__c CHECK (((sno)::text <> '0'::text))\n);\n\n\nCREATE SEQUENCE dw1_pages_sno\nSTART WITH 10\nINCREMENT BY 1\nNO MINVALUE\nNO MAXVALUE\nCACHE 1;\n\n\nCREATE TABLE dw1_paths (\ntenant character varying(32) NOT NULL,\nfolder character varying(100) NOT NULL,\npage_guid character varying(32) NOT NULL,\npage_name character varying(100) NOT NULL,\nguid_in_path character varying(1) NOT NULL,\nCONSTRAINT dw1_paths_folder__c CHECK (((folder)::text !~~ '%/-%'::text)),\nCONSTRAINT dw1_paths_guidinpath__c CHECK (((guid_in_path)::text = ANY ((ARRAY['T'::character varying, 'F'::character varying])::text[])))\n);\n\n\nCREATE TABLE dw1_posts (\nsite_id character varying(32) NOT NULL,\npage_id character varying(32) NOT NULL,\npost_id integer NOT NULL,\nparent_post_id integer NOT NULL,\nmarkup character varying(30),\nwheere character varying(150),\ncreated_at timestamp without time zone NOT NULL,\nlast_acted_upon_at timestamp without time zone,\nlast_reviewed_at timestamp without time zone,\nlast_authly_reviewed_at timestamp without time zone,\nlast_approved_at timestamp without time zone,\nlast_approval_type character varying(1),\nlast_permanently_approved_at timestamp without time zone,\nlast_manually_approved_at timestamp without time zone,\nauthor_id character varying(32),\nlast_edit_applied_at timestamp without time zone,\nlast_edit_reverted_at timestamp without time zone,\nlast_editor_id character varying(32),\npost_collapsed_at timestamp without time zone,\ntree_collapsed_at timestamp without time zone,\npost_deleted_at timestamp without time zone,\ntree_deleted_at timestamp without time zone,\nnum_edit_suggestions smallint DEFAULT 0 NOT NULL,\nnum_edits_appld_unreviewed smallint DEFAULT 0 NOT NULL,\nnum_edits_appld_prel_approved smallint DEFAULT 0 NOT NULL,\nnum_edits_to_review smallint DEFAULT 0 NOT NULL,\nnum_distinct_editors smallint DEFAULT 0 NOT NULL,\nnum_collapse_post_votes_pro smallint DEFAULT 0 NOT NULL,\nnum_collapse_post_votes_con smallint DEFAULT 0 NOT NULL,\nnum_uncollapse_post_votes_pro smallint DEFAULT 0 NOT NULL,\nnum_uncollapse_post_votes_con smallint DEFAULT 0 NOT NULL,\nnum_collapse_tree_votes_pro smallint DEFAULT 0 NOT NULL,\nnum_collapse_tree_votes_con smallint DEFAULT 0 NOT NULL,\nnum_uncollapse_tree_votes_pro smallint DEFAULT 0 NOT NULL,\nnum_uncollapse_tree_votes_con smallint DEFAULT 0 NOT NULL,\nnum_collapses_to_review smallint DEFAULT 0 NOT NULL,\nnum_uncollapses_to_review smallint DEFAULT 0 NOT NULL,\nnum_delete_post_votes_pro smallint DEFAULT 0 NOT NULL,\nnum_delete_post_votes_con smallint DEFAULT 0 NOT NULL,\nnum_undelete_post_votes_pro smallint DEFAULT 0 NOT NULL,\nnum_undelete_post_votes_con smallint DEFAULT 0 NOT NULL,\nnum_delete_tree_votes_pro smallint DEFAULT 0 NOT NULL,\nnum_delete_tree_votes_con smallint DEFAULT 0 NOT NULL,\nnum_undelete_tree_votes_pro smallint DEFAULT 0 NOT NULL,\nnum_undelete_tree_votes_con smallint DEFAULT 0 NOT NULL,\nnum_deletes_to_review smallint DEFAULT 0 NOT NULL,\nnum_undeletes_to_review smallint DEFAULT 0 NOT NULL,\nnum_pending_flags smallint DEFAULT 0 NOT NULL,\nnum_handled_flags smallint DEFAULT 0 NOT NULL,\nflags character varying(100),\nratings character varying(100),\napproved_text text,\nunapproved_text_diff text,\nCONSTRAINT dw1_posts_approval__c_in CHECK (((last_approval_type)::text = ANY ((ARRAY['P'::character varying, 'W'::character varying, 'A'::character varying, 'M'::character varying])::text[])))\n);\n\n\nCREATE TABLE dw1_quotas (\ntenant character varying(32),\nip character varying(32),\nrole_id character varying(32),\nversion character varying(1) NOT NULL,\nctime timestamp without time zone NOT NULL,\nmtime timestamp without time zone NOT NULL,\nquota_used_paid bigint DEFAULT 0 NOT NULL,\nquota_used_free bigint DEFAULT 0 NOT NULL,\nquota_used_freeloaded bigint DEFAULT 0 NOT NULL,\nquota_limit_paid bigint DEFAULT 0 NOT NULL,\nquota_limit_free bigint DEFAULT 0 NOT NULL,\nquota_limit_freeload bigint DEFAULT 0 NOT NULL,\nquota_daily_free bigint DEFAULT 0 NOT NULL,\nquota_daily_freeload bigint DEFAULT 0 NOT NULL,\nnum_logins integer DEFAULT 0 NOT NULL,\nnum_ids_unau integer DEFAULT 0 NOT NULL,\nnum_ids_au integer DEFAULT 0 NOT NULL,\nnum_roles integer DEFAULT 0 NOT NULL,\nnum_pages integer DEFAULT 0 NOT NULL,\nnum_actions integer DEFAULT 0 NOT NULL,\nnum_action_text_bytes bigint DEFAULT 0 NOT NULL,\nnum_notfs integer DEFAULT 0 NOT NULL,\nnum_emails_out integer DEFAULT 0 NOT NULL,\nnum_db_reqs_read bigint DEFAULT 0 NOT NULL,\nnum_db_reqs_write bigint DEFAULT 0 NOT NULL,\nCONSTRAINT dw1_qtas_time__c CHECK ((mtime >= ctime)),\nCONSTRAINT dw1_qtas_tnt_ip_role__c CHECK (CASE WHEN ((ip)::text <> '-'::text) THEN ((role_id)::text = '-'::text) ELSE ((tenant)::text <> '-'::text) END),\nCONSTRAINT dw1_qtas_version__c_in CHECK (((version)::text = ANY ((ARRAY['C'::character varying, 'O'::character varying])::text[])))\n);\n\n\nCREATE TABLE dw1_tenant_hosts (\ntenant character varying(32) NOT NULL,\nhost character varying(50) NOT NULL,\ncanonical character varying(1) NOT NULL,\nhttps character varying(1) DEFAULT 'N'::character varying NOT NULL,\nctime timestamp without time zone DEFAULT now() NOT NULL,\nmtime timestamp without time zone DEFAULT now() NOT NULL,\nCONSTRAINT dw1_tnthsts_cncl__c CHECK (((canonical)::text = ANY ((ARRAY['C'::character varying, 'R'::character varying, 'L'::character varying, 'D'::character varying])::text[]))),\nCONSTRAINT dw1_tnthsts_https__c CHECK (((https)::text = ANY (ARRAY[('R'::character varying)::text, ('A'::character varying)::text, ('N'::character varying)::text])))\n);\n\n\nCREATE TABLE dw1_tenants (\nid character varying(32) NOT NULL,\nname character varying(100) NOT NULL,\nctime timestamp without time zone DEFAULT now() NOT NULL,\ncreator_ip character varying(39),\ncreator_tenant_id character varying(32),\ncreator_login_id character varying(32),\ncreator_role_id character varying(32),\nCONSTRAINT dw1_tnt_id__c_n0 CHECK (((id)::text <> '0'::text)),\nCONSTRAINT dw1_tnt_id__c_ne CHECK ((btrim((id)::text) <> ''::text)),\nCONSTRAINT dw1_tnt_name__c_ne CHECK ((btrim((name)::text) <> ''::text))\n);\n\n\nCREATE SEQUENCE dw1_tenants_id\nSTART WITH 10\nINCREMENT BY 1\nNO MINVALUE\nNO MAXVALUE\nCACHE 1;\n\n\nCREATE TABLE dw1_users (\ntenant character varying(32) NOT NULL,\nsno character varying(32) NOT NULL,\ndisplay_name character varying(100),\nemail character varying(100),\ncountry character varying(100),\nwebsite character varying(100),\nsuperadmin character varying(1),\nemail_notfs character varying(1),\nis_owner character varying(1),\nCONSTRAINT dw1_users_country__c CHECK (((country)::text <> ''::text)),\nCONSTRAINT dw1_users_dname__c CHECK (((display_name)::text <> ''::text)),\nCONSTRAINT dw1_users_email__c CHECK (((email)::text ~~ '%@%.%'::text)),\nCONSTRAINT dw1_users_emlntf__c CHECK (((email_notfs)::text = ANY ((ARRAY['R'::character varying, 'N'::character varying, 'F'::character varying])::text[]))),\nCONSTRAINT dw1_users_isowner__c_b CHECK (((is_owner)::text = 'T'::text)),\nCONSTRAINT dw1_users_sno_not_0__c CHECK (((sno)::text <> '0'::text)),\nCONSTRAINT dw1_users_superadm__c CHECK (((superadmin)::text = 'T'::text)),\nCONSTRAINT dw1_users_website__c CHECK (((website)::text <> ''::text))\n);\n\n\nCREATE SEQUENCE dw1_users_sno\nSTART WITH 10\nINCREMENT BY 1\nNO MINVALUE\nNO MAXVALUE\nCACHE 1;\n\n\nALTER TABLE ONLY dw1_page_ratings\nADD CONSTRAINT dw1_arts__p PRIMARY KEY (tenant, page_id, paid, tag);\n\n\nALTER TABLE ONLY dw1_emails_out\nADD CONSTRAINT dw1_emlot_tnt_id__p PRIMARY KEY (tenant, id);\n\n\nALTER TABLE ONLY dw1_guests\nADD CONSTRAINT dw1_guests__u UNIQUE (site_id, name, email_addr, location, url);\n\n\nALTER TABLE ONLY dw1_guests\nADD CONSTRAINT dw1_guests_site_id__p PRIMARY KEY (site_id, id);\n\n\nALTER TABLE ONLY dw1_ids_simple_email\nADD CONSTRAINT dw1_idsmpleml__p PRIMARY KEY (tenant, email, ctime);\n\n\nALTER TABLE ONLY dw1_ids_openid\nADD CONSTRAINT dw1_idsoid_sno__p PRIMARY KEY (sno);\n\n\nALTER TABLE ONLY dw1_ids_openid\nADD CONSTRAINT dw1_idsoid_tnt_oid__u UNIQUE (tenant, oid_claimed_id);\n\n\nALTER TABLE ONLY dw1_ids_simple\nADD CONSTRAINT dw1_idssimple__u UNIQUE (name, email, location, website);\n\n\nALTER TABLE ONLY dw1_ids_simple\nADD CONSTRAINT dw1_idssimple_sno__p PRIMARY KEY (sno);\n\n\nALTER TABLE ONLY dw1_logins\nADD CONSTRAINT dw1_logins_sno__p PRIMARY KEY (sno);\n\n\nALTER TABLE ONLY dw1_notfs_page_actions\nADD CONSTRAINT dw1_ntfpga_t_pg_evt_rcpt__p PRIMARY KEY (tenant, page_id, event_pga, rcpt_pga);\n\n\nALTER TABLE ONLY dw1_pages\nADD CONSTRAINT dw1_pages__u UNIQUE (tenant, guid);\n\n\nALTER TABLE ONLY dw1_pages\nADD CONSTRAINT dw1_pages_sno__p PRIMARY KEY (sno);\n\n\nALTER TABLE ONLY dw1_paths\nADD CONSTRAINT dw1_paths_tnt_page__p PRIMARY KEY (tenant, page_guid);\n\n\nALTER TABLE ONLY dw1_page_actions\nADD CONSTRAINT dw1_pgas_tnt_pgid_id__p PRIMARY KEY (tenant, page_id, paid);\n\n\nALTER TABLE ONLY dw1_posts\nADD CONSTRAINT dw1_posts_site_page_post__p PRIMARY KEY (site_id, page_id, post_id);\n\n\nALTER TABLE ONLY dw1_tenants\nADD CONSTRAINT dw1_tenants_id__p PRIMARY KEY (id);\n\n\nALTER TABLE ONLY dw1_tenants\nADD CONSTRAINT dw1_tenants_name__u UNIQUE (name);\n\n\nALTER TABLE ONLY dw1_tenant_hosts\nADD CONSTRAINT dw1_tnthsts_host__u UNIQUE (host);\n\n\nALTER TABLE ONLY dw1_users\nADD CONSTRAINT dw1_users_tnt_sno__p PRIMARY KEY (tenant, sno);\n\n\nCREATE INDEX dw1_idsmpleml_login ON dw1_ids_simple_email USING btree (login);\n\n\nCREATE UNIQUE INDEX dw1_idsmpleml_version__u ON dw1_ids_simple_email USING btree (tenant, email, version) WHERE (version = 'C'::bpchar);\n\n\nCREATE INDEX dw1_idsoid_email ON dw1_ids_openid USING btree (email);\n\n\nCREATE UNIQUE INDEX dw1_idsoid_tnt_email__u ON dw1_ids_openid USING btree (tenant, email) WHERE ((oid_endpoint)::text = 'https://www.google.com/accounts/o8/ud'::text);\n\n\nCREATE INDEX dw1_idsoid_tnt_usr ON dw1_ids_openid USING btree (tenant, usr);\n\n\nCREATE INDEX dw1_logins_prevl ON dw1_logins USING btree (prev_login);\n\n\nCREATE INDEX dw1_logins_tnt ON dw1_logins USING btree (tenant);\n\n\nCREATE INDEX dw1_ntfpga_emlpndng_ctime ON dw1_notfs_page_actions USING btree (email_status, ctime) WHERE ((email_status)::text = 'P'::text);\n\n\nCREATE UNIQUE INDEX dw1_ntfpga_t_idsmpl_pg_evt__u ON dw1_notfs_page_actions USING btree (tenant, rcpt_id_simple, page_id, event_pga) WHERE (rcpt_id_simple IS NOT NULL);\n\n\nCREATE INDEX dw1_ntfpga_tnt_emailsent ON dw1_notfs_page_actions USING btree (tenant, email_sent);\n\n\nCREATE INDEX dw1_ntfpga_tnt_idsmpl_ctime ON dw1_notfs_page_actions USING btree (tenant, rcpt_id_simple, ctime);\n\n\nCREATE UNIQUE INDEX dw1_ntfpga_tnt_rl_pg_evt__u ON dw1_notfs_page_actions USING btree (tenant, rcpt_role_id, page_id, event_pga) WHERE (rcpt_role_id IS NOT NULL);\n\n\nCREATE INDEX dw1_ntfpga_tnt_role_ctime ON dw1_notfs_page_actions USING btree (tenant, rcpt_role_id, ctime);\n\n\nCREATE INDEX dw1_ntfpga_tnt_status_ctime ON dw1_notfs_page_actions USING btree (tenant, status, ctime);\n\n\nCREATE INDEX dw1_pactions_login ON dw1_page_actions USING btree (login);\n\n\nCREATE INDEX dw1_pages_tnt_parent_publdati ON dw1_pages USING btree (tenant, parent_page_id, publ_dati);\n\n\nCREATE INDEX dw1_pages_tnt_parentpage ON dw1_pages USING btree (tenant, parent_page_id);\n\n\nCREATE INDEX dw1_pages_tnt_prnt_cdati_nopub ON dw1_pages USING btree (tenant, parent_page_id, cdati) WHERE (publ_dati IS NULL);\n\n\nCREATE UNIQUE INDEX dw1_paths__u ON dw1_paths USING btree (tenant, folder, page_name, page_guid) WHERE ((guid_in_path)::text = 'T'::text);\n\n\nCREATE INDEX dw1_paths_all ON dw1_paths USING btree (tenant, folder, page_name, page_guid);\n\n\nCREATE INDEX dw1_pgas_tenant_page_post ON dw1_page_actions USING btree (tenant, page_id, post_id);\n\n\nCREATE INDEX dw1_pgas_tnt_guestid ON dw1_page_actions USING btree (tenant, guest_id);\n\n\nCREATE INDEX dw1_pgas_tnt_roleid ON dw1_page_actions USING btree (tenant, role_id);\n\n\nCREATE UNIQUE INDEX dw1_pgpths_path__u ON dw1_page_paths USING btree (tenant, page_id, parent_folder, page_slug, show_id);\n\n\nCREATE UNIQUE INDEX dw1_pgpths_path_noid_cncl__u ON dw1_page_paths USING btree (tenant, parent_folder, page_slug) WHERE (((show_id)::text = 'F'::text) AND ((canonical)::text = 'C'::text));\n\n\nCREATE INDEX dw1_pgpths_tnt_fldr_slg_cncl ON dw1_page_paths USING btree (tenant, parent_folder, page_slug, canonical);\n\n\nCREATE INDEX dw1_pgpths_tnt_pgid_cncl ON dw1_page_paths USING btree (tenant, page_id, canonical);\n\n\nCREATE UNIQUE INDEX dw1_pgpths_tnt_pgid_cncl__u ON dw1_page_paths USING btree (tenant, page_id) WHERE ((canonical)::text = 'C'::text);\n\n\nCREATE INDEX dw1_posts_pending_edit_suggs ON dw1_posts USING btree (site_id, last_acted_upon_at) WHERE ((((((((num_pending_flags = 0) AND ((last_approval_type)::text = ANY ((ARRAY['W'::character varying, 'A'::character varying, 'M'::character varying])::text[]))) AND (num_edits_to_review = 0)) AND (num_collapses_to_review = 0)) AND (num_uncollapses_to_review = 0)) AND (num_deletes_to_review = 0)) AND (num_undeletes_to_review = 0)) AND (((((((((num_edit_suggestions > 0) OR ((num_collapse_post_votes_pro > 0) AND (post_collapsed_at IS NULL))) OR ((num_uncollapse_post_votes_pro > 0) AND (post_collapsed_at IS NOT NULL))) OR ((num_collapse_tree_votes_pro > 0) AND (tree_collapsed_at IS NULL))) OR ((num_uncollapse_tree_votes_pro > 0) AND (tree_collapsed_at IS NOT NULL))) OR ((num_delete_post_votes_pro > 0) AND (post_deleted_at IS NULL))) OR ((num_undelete_post_votes_pro > 0) AND (post_deleted_at IS NOT NULL))) OR ((num_delete_tree_votes_pro > 0) AND (tree_deleted_at IS NULL))) OR ((num_undelete_tree_votes_pro > 0) AND (tree_deleted_at IS NOT NULL))));\n\n\nCREATE INDEX dw1_posts_pending_flags ON dw1_posts USING btree (site_id, num_pending_flags) WHERE (num_pending_flags > 0);\n\n\nCREATE INDEX dw1_posts_pending_nothing ON dw1_posts USING btree (site_id, last_acted_upon_at) WHERE (((((((((num_pending_flags = 0) AND ((last_approval_type)::text = ANY ((ARRAY['W'::character varying, 'A'::character varying, 'M'::character varying])::text[]))) AND (num_edits_to_review = 0)) AND (num_collapses_to_review = 0)) AND (num_uncollapses_to_review = 0)) AND (num_deletes_to_review = 0)) AND (num_undeletes_to_review = 0)) AND (num_edit_suggestions = 0)) AND (NOT (((((((((num_edit_suggestions > 0) OR ((num_collapse_post_votes_pro > 0) AND (post_collapsed_at IS NULL))) OR ((num_uncollapse_post_votes_pro > 0) AND (post_collapsed_at IS NOT NULL))) OR ((num_collapse_tree_votes_pro > 0) AND (tree_collapsed_at IS NULL))) OR ((num_uncollapse_tree_votes_pro > 0) AND (tree_collapsed_at IS NOT NULL))) OR ((num_delete_post_votes_pro > 0) AND (post_deleted_at IS NULL))) OR ((num_undelete_post_votes_pro > 0) AND (post_deleted_at IS NOT NULL))) OR ((num_delete_tree_votes_pro > 0) AND (tree_deleted_at IS NULL))) OR ((num_undelete_tree_votes_pro > 0) AND (tree_deleted_at IS NOT NULL)))));\n\n\nCREATE INDEX dw1_posts_pending_sth ON dw1_posts USING btree (site_id, last_acted_upon_at) WHERE ((num_pending_flags = 0) AND (((((((last_approval_type IS NULL) OR ((last_approval_type)::text = 'P'::text)) OR (num_edits_to_review > 0)) OR (num_collapses_to_review > 0)) OR (num_uncollapses_to_review > 0)) OR (num_deletes_to_review > 0)) OR (num_undeletes_to_review > 0)));\n\n\nCREATE UNIQUE INDEX dw1_qtas_tnt_ip_role__u ON dw1_quotas USING btree ((COALESCE(tenant, '-'::character varying)), (COALESCE(ip, '-'::character varying)), (COALESCE(role_id, '-'::character varying)));\n\n\nCREATE INDEX dw1_tenants_creatorip ON dw1_tenants USING btree (creator_ip);\n\n\nCREATE INDEX dw1_tenants_creatorlogin ON dw1_tenants USING btree (creator_tenant_id, creator_login_id);\n\n\nCREATE INDEX dw1_tenants_creatorrole ON dw1_tenants USING btree (creator_tenant_id, creator_role_id);\n\n\nCREATE UNIQUE INDEX dw1_tnthsts_tnt_cncl__u ON dw1_tenant_hosts USING btree (tenant) WHERE ((canonical)::text = 'C'::text);\n\n\nALTER TABLE ONLY dw1_page_ratings\nADD CONSTRAINT dw1_arts__r__pgas FOREIGN KEY (tenant, page_id, paid) REFERENCES dw1_page_actions(tenant, page_id, paid) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_emails_out\nADD CONSTRAINT dw1_emlot__r__tnts FOREIGN KEY (tenant) REFERENCES dw1_tenants(id);\n\n\nALTER TABLE ONLY dw1_ids_simple_email\nADD CONSTRAINT dw1_idsmpleml__r__logins FOREIGN KEY (login) REFERENCES dw1_logins(sno);\n\n\nALTER TABLE ONLY dw1_ids_openid\nADD CONSTRAINT dw1_idsoid_usr_tnt__r__users FOREIGN KEY (tenant, usr) REFERENCES dw1_users(tenant, sno) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_logins\nADD CONSTRAINT dw1_logins__r__logins FOREIGN KEY (prev_login) REFERENCES dw1_logins(sno) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_logins\nADD CONSTRAINT dw1_logins_tnt__r__tenants FOREIGN KEY (tenant) REFERENCES dw1_tenants(id) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_notfs_page_actions\nADD CONSTRAINT dw1_ntfpga__r__emlot FOREIGN KEY (tenant, email_sent) REFERENCES dw1_emails_out(tenant, id);\n\n\nALTER TABLE ONLY dw1_notfs_page_actions\nADD CONSTRAINT dw1_ntfpga__r__guests FOREIGN KEY (tenant, rcpt_id_simple) REFERENCES dw1_guests(site_id, id) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_notfs_page_actions\nADD CONSTRAINT dw1_ntfpga__r__rls FOREIGN KEY (tenant, rcpt_role_id) REFERENCES dw1_users(tenant, sno) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_page_actions\nADD CONSTRAINT dw1_pactions__r__logins FOREIGN KEY (login) REFERENCES dw1_logins(sno) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_page_actions\nADD CONSTRAINT dw1_pactions__r__pages FOREIGN KEY (page) REFERENCES dw1_pages(sno) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_pages\nADD CONSTRAINT dw1_pages__r__tenant FOREIGN KEY (tenant) REFERENCES dw1_tenants(id) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_pages\nADD CONSTRAINT dw1_pages_parentpage__r__pages FOREIGN KEY (tenant, parent_page_id) REFERENCES dw1_pages(tenant, guid) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_paths\nADD CONSTRAINT dw1_paths_tnt_page__r__pages FOREIGN KEY (tenant, page_guid) REFERENCES dw1_pages(tenant, guid) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_page_actions\nADD CONSTRAINT dw1_pgas__r__guests FOREIGN KEY (tenant, guest_id) REFERENCES dw1_guests(site_id, id) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_page_actions\nADD CONSTRAINT dw1_pgas__r__pgas FOREIGN KEY (tenant, page_id, relpa) REFERENCES dw1_page_actions(tenant, page_id, paid) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_page_actions\nADD CONSTRAINT dw1_pgas__r__roles FOREIGN KEY (tenant, role_id) REFERENCES dw1_users(tenant, sno) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_page_actions\nADD CONSTRAINT dw1_pgas_tnt_pgid__r__pages FOREIGN KEY (tenant, page_id) REFERENCES dw1_pages(tenant, guid) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_page_paths\nADD CONSTRAINT dw1_pgpths_tnt_pgid__r__pages FOREIGN KEY (tenant, page_id) REFERENCES dw1_pages(tenant, guid) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_quotas\nADD CONSTRAINT dw1_qtas_tnt__r__tenants FOREIGN KEY (tenant) REFERENCES dw1_tenants(id) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_quotas\nADD CONSTRAINT dw1_qtas_tnt_role__r__roles FOREIGN KEY (tenant, role_id) REFERENCES dw1_users(tenant, sno) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_tenants\nADD CONSTRAINT dw1_tenants_creator__r__roles FOREIGN KEY (creator_tenant_id, creator_role_id) REFERENCES dw1_users(tenant, sno) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_tenants\nADD CONSTRAINT dw1_tenants_creator__r__tnts FOREIGN KEY (creator_tenant_id) REFERENCES dw1_tenants(id) DEFERRABLE;\n\n\nALTER TABLE ONLY dw1_tenant_hosts\nADD CONSTRAINT dw1_tnthsts__r__tenants FOREIGN KEY (tenant) REFERENCES dw1_tenants(id);\n\n\nALTER TABLE ONLY dw1_users\nADD CONSTRAINT dw1_users__r__tenant FOREIGN KEY (tenant) REFERENCES dw1_tenants(id) DEFERRABLE;		applied	
\.


--
-- Name: play_evolutions_pkey; Type: CONSTRAINT; Schema: debiki_test_evolutions; Owner: -
--

ALTER TABLE ONLY play_evolutions
    ADD CONSTRAINT play_evolutions_pkey PRIMARY KEY (id);


--
-- PostgreSQL database dump complete
--

