/**
 * Copyright (C) 2015 Kaj Magnus Lindberg (born 1979)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.debiki.core


/** These Scala based database migrations are placed in project debiki-server, because
  * they make use of some stuff there. Via this interface, they're made accessible to
  * the database module, so they can be called from the database module when it
  * notices that it's time to migrate.
  */
abstract class ScalaBasedDatabaseMigrations {

  def runMigration14(transaction: SystemTransaction): Unit

}
