//
// Aspia Project
// Copyright (C) 2016-2024 Dmitry Chapyshev <dmitry@aspia.ru>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

USB_KEYMAP_DECLARATION
{
    //            USB     evdev    XKB     Win     Mac     Qt
    USB_KEYMAP(0x000000, 0x0000, 0x0000, 0x0000, 0xffff, Qt::Key_unknown),      // Invalid
    USB_KEYMAP(0x010082, 0x008e, 0x0096, 0x015f, 0xffff, Qt::Key_Sleep),        // SystemSleep
    USB_KEYMAP(0x010083, 0x008f, 0x0097, 0x0163, 0xffff, Qt::Key_WakeUp),       // WakeUp
    USB_KEYMAP(0x070004, 0x001e, 0x0026, 0x001e, 0x0000, Qt::Key_A),            // aA
    USB_KEYMAP(0x070005, 0x0030, 0x0038, 0x0030, 0x000b, Qt::Key_B),            // bB
    USB_KEYMAP(0x070006, 0x002e, 0x0036, 0x002e, 0x0008, Qt::Key_C),            // cC
    USB_KEYMAP(0x070007, 0x0020, 0x0028, 0x0020, 0x0002, Qt::Key_D),            // dD
    USB_KEYMAP(0x070008, 0x0012, 0x001a, 0x0012, 0x000e, Qt::Key_E),            // eE
    USB_KEYMAP(0x070009, 0x0021, 0x0029, 0x0021, 0x0003, Qt::Key_F),            // fF
    USB_KEYMAP(0x07000a, 0x0022, 0x002a, 0x0022, 0x0005, Qt::Key_G),            // gG
    USB_KEYMAP(0x07000b, 0x0023, 0x002b, 0x0023, 0x0004, Qt::Key_H),            // hH
    USB_KEYMAP(0x07000c, 0x0017, 0x001f, 0x0017, 0x0022, Qt::Key_I),            // iI
    USB_KEYMAP(0x07000d, 0x0024, 0x002c, 0x0024, 0x0026, Qt::Key_J),            // jJ
    USB_KEYMAP(0x07000e, 0x0025, 0x002d, 0x0025, 0x0028, Qt::Key_K),            // kK
    USB_KEYMAP(0x07000f, 0x0026, 0x002e, 0x0026, 0x0025, Qt::Key_L),            // lL
    USB_KEYMAP(0x070010, 0x0032, 0x003a, 0x0032, 0x002e, Qt::Key_M),            // mM
    USB_KEYMAP(0x070011, 0x0031, 0x0039, 0x0031, 0x002d, Qt::Key_N),            // nN
    USB_KEYMAP(0x070012, 0x0018, 0x0020, 0x0018, 0x001f, Qt::Key_O),            // oO
    USB_KEYMAP(0x070013, 0x0019, 0x0021, 0x0019, 0x0023, Qt::Key_P),            // pP
    USB_KEYMAP(0x070014, 0x0010, 0x0018, 0x0010, 0x000c, Qt::Key_Q),            // qQ
    USB_KEYMAP(0x070015, 0x0013, 0x001b, 0x0013, 0x000f, Qt::Key_R),            // rR
    USB_KEYMAP(0x070016, 0x001f, 0x0027, 0x001f, 0x0001, Qt::Key_S),            // sS
    USB_KEYMAP(0x070017, 0x0014, 0x001c, 0x0014, 0x0011, Qt::Key_T),            // tT
    USB_KEYMAP(0x070018, 0x0016, 0x001e, 0x0016, 0x0020, Qt::Key_U),            // uU
    USB_KEYMAP(0x070019, 0x002f, 0x0037, 0x002f, 0x0009, Qt::Key_V),            // vV
    USB_KEYMAP(0x07001a, 0x0011, 0x0019, 0x0011, 0x000d, Qt::Key_W),            // wW
    USB_KEYMAP(0x07001b, 0x002d, 0x0035, 0x002d, 0x0007, Qt::Key_X),            // xX
    USB_KEYMAP(0x07001c, 0x0015, 0x001d, 0x0015, 0x0010, Qt::Key_Y),            // yY
    USB_KEYMAP(0x07001d, 0x002c, 0x0034, 0x002c, 0x0006, Qt::Key_Z),            // zZ
    USB_KEYMAP(0x07001e, 0x0002, 0x000a, 0x0002, 0x0012, Qt::Key_1),            // 1!
    USB_KEYMAP(0x07001f, 0x0003, 0x000b, 0x0003, 0x0013, Qt::Key_2),            // 2@
    USB_KEYMAP(0x070020, 0x0004, 0x000c, 0x0004, 0x0014, Qt::Key_3),            // 3#
    USB_KEYMAP(0x070021, 0x0005, 0x000d, 0x0005, 0x0015, Qt::Key_4),            // 4$
    USB_KEYMAP(0x070022, 0x0006, 0x000e, 0x0006, 0x0017, Qt::Key_5),            // 5%
    USB_KEYMAP(0x070023, 0x0007, 0x000f, 0x0007, 0x0016, Qt::Key_6),            // 6^
    USB_KEYMAP(0x070024, 0x0008, 0x0010, 0x0008, 0x001a, Qt::Key_7),            // 7&
    USB_KEYMAP(0x070025, 0x0009, 0x0011, 0x0009, 0x001c, Qt::Key_8),            // 8*
    USB_KEYMAP(0x070026, 0x000a, 0x0012, 0x000a, 0x0019, Qt::Key_9),            // 9(
    USB_KEYMAP(0x070027, 0x000b, 0x0013, 0x000b, 0x001d, Qt::Key_0),            // 0)
    USB_KEYMAP(0x070028, 0x001c, 0x0024, 0x001c, 0x0024, Qt::Key_Return),       // Enter
    USB_KEYMAP(0x070029, 0x0001, 0x0009, 0x0001, 0x0035, Qt::Key_Escape),       // Escape
    USB_KEYMAP(0x07002a, 0x000e, 0x0016, 0x000e, 0x0033, Qt::Key_Backspace),    // Backspace
    USB_KEYMAP(0x07002b, 0x000f, 0x0017, 0x000f, 0x0030, Qt::Key_Tab),          // Tab
    USB_KEYMAP(0x07002c, 0x0039, 0x0041, 0x0039, 0x0031, Qt::Key_Space),        // Spacebar
    USB_KEYMAP(0x07002d, 0x000c, 0x0014, 0x000c, 0x001b, Qt::Key_Minus),        // -_
    USB_KEYMAP(0x07002e, 0x000d, 0x0015, 0x000d, 0x0018, Qt::Key_Equal),        // =+
    USB_KEYMAP(0x07002f, 0x001a, 0x0022, 0x001a, 0x0021, Qt::Key_BracketLeft),  // BracketLeft
    USB_KEYMAP(0x070030, 0x001b, 0x0023, 0x001b, 0x001e, Qt::Key_BracketRight), // BracketRight
    USB_KEYMAP(0x070031, 0x002b, 0x0033, 0x002b, 0x002a, Qt::Key_Backslash),    // \|
    USB_KEYMAP(0x070032, 0x0000, 0x0000, 0x0000, 0xffff, Qt::Key_unknown),      // Intl Hash
    USB_KEYMAP(0x070033, 0x0027, 0x002f, 0x0027, 0x0029, Qt::Key_Semicolon),    // ;:
    USB_KEYMAP(0x070034, 0x0028, 0x0030, 0x0028, 0x0027, Qt::Key_Apostrophe),   // '"
    USB_KEYMAP(0x070035, 0x0029, 0x0031, 0x0029, 0x0032, Qt::Key_QuoteLeft),    // `~
    USB_KEYMAP(0x070036, 0x0033, 0x003b, 0x0033, 0x002b, Qt::Key_Comma),        // ,<
    USB_KEYMAP(0x070037, 0x0034, 0x003c, 0x0034, 0x002f, Qt::Key_Period),       // .>
    USB_KEYMAP(0x070038, 0x0035, 0x003d, 0x0035, 0x002c, Qt::Key_Slash),        // /?
    USB_KEYMAP(0x070039, 0x003a, 0x0042, 0x003a, 0x0039, Qt::Key_CapsLock),     // CapsLock
    USB_KEYMAP(0x07003a, 0x003b, 0x0043, 0x003b, 0x007a, Qt::Key_F1),           // F1
    USB_KEYMAP(0x07003b, 0x003c, 0x0044, 0x003c, 0x0078, Qt::Key_F2),           // F2
    USB_KEYMAP(0x07003c, 0x003d, 0x0045, 0x003d, 0x0063, Qt::Key_F3),           // F3
    USB_KEYMAP(0x07003d, 0x003e, 0x0046, 0x003e, 0x0076, Qt::Key_F4),           // F4
    USB_KEYMAP(0x07003e, 0x003f, 0x0047, 0x003f, 0x0060, Qt::Key_F5),           // F5
    USB_KEYMAP(0x07003f, 0x0040, 0x0048, 0x0040, 0x0061, Qt::Key_F6),           // F6
    USB_KEYMAP(0x070040, 0x0041, 0x0049, 0x0041, 0x0062, Qt::Key_F7),           // F7
    USB_KEYMAP(0x070041, 0x0042, 0x004a, 0x0042, 0x0064, Qt::Key_F8),           // F8
    USB_KEYMAP(0x070042, 0x0043, 0x004b, 0x0043, 0x0065, Qt::Key_F9),           // F9
    USB_KEYMAP(0x070043, 0x0044, 0x004c, 0x0044, 0x006d, Qt::Key_F10),          // F10
    USB_KEYMAP(0x070044, 0x0057, 0x005f, 0x0057, 0x0067, Qt::Key_F11),          // F11
    USB_KEYMAP(0x070045, 0x0058, 0x0060, 0x0058, 0x006f, Qt::Key_F12),          // F12
    USB_KEYMAP(0x070046, 0x0063, 0x006b, 0x0137, 0xffff, Qt::Key_Print),        // PrintScreen
    USB_KEYMAP(0x070047, 0x0046, 0x004e, 0x0046, 0xffff, Qt::Key_ScrollLock),   // ScrollLock
    USB_KEYMAP(0x070048, 0x0077, 0x007f, 0x0045, 0xffff, Qt::Key_Pause),        // Pause
    USB_KEYMAP(0x070049, 0x006e, 0x0076, 0x0152, 0x0072, Qt::Key_Insert),       // Insert
    USB_KEYMAP(0x07004a, 0x0066, 0x006e, 0x0147, 0x0073, Qt::Key_Home),         // Home
    USB_KEYMAP(0x07004b, 0x0068, 0x0070, 0x0149, 0x0074, Qt::Key_PageUp),       // PageUp
    USB_KEYMAP(0x07004c, 0x006f, 0x0077, 0x0153, 0x0075, Qt::Key_Delete),       // Delete
    USB_KEYMAP(0x07004d, 0x006b, 0x0073, 0x014f, 0x0077, Qt::Key_End),          // End
    USB_KEYMAP(0x07004e, 0x006d, 0x0075, 0x0151, 0x0079, Qt::Key_PageDown),     // PageDown
    USB_KEYMAP(0x07004f, 0x006a, 0x0072, 0x014d, 0x007c, Qt::Key_Right),        // ArrowRight
    USB_KEYMAP(0x070050, 0x0069, 0x0071, 0x014b, 0x007b, Qt::Key_Left),         // ArrowLeft
    USB_KEYMAP(0x070051, 0x006c, 0x0074, 0x0150, 0x007d, Qt::Key_Down),         // ArrowDown
    USB_KEYMAP(0x070052, 0x0067, 0x006f, 0x0148, 0x007e, Qt::Key_Up),           // ArrowUp
    USB_KEYMAP(0x070053, 0x0045, 0x004d, 0x0145, 0x0047, Qt::Key_NumLock),      // NumLock
    USB_KEYMAP(0x070054, 0x0062, 0x006a, 0x0135, 0x004b, Qt::Key_Slash),        // NumpadDivide
    USB_KEYMAP(0x070055, 0x0037, 0x003f, 0x0037, 0x0043, Qt::Key_Asterisk),     // Keypad_*
    USB_KEYMAP(0x070056, 0x004a, 0x0052, 0x004a, 0x004e, Qt::Key_Minus),        // Keypad_-
    USB_KEYMAP(0x070057, 0x004e, 0x0056, 0x004e, 0x0045, Qt::Key_Plus),         // NumpadAdd
    USB_KEYMAP(0x070058, 0x0060, 0x0068, 0x011c, 0x004c, Qt::Key_Enter),        // NumpadEnter
    USB_KEYMAP(0x070059, 0x004f, 0x0057, 0x004f, 0x0053, Qt::Key_End),          // Numpad1+End
    USB_KEYMAP(0x07005a, 0x0050, 0x0058, 0x0050, 0x0054, Qt::Key_Down),         // Numpad2+Down
    USB_KEYMAP(0x07005b, 0x0051, 0x0059, 0x0051, 0x0055, Qt::Key_PageDown),     // Numpad3+PageDn
    USB_KEYMAP(0x07005c, 0x004b, 0x0053, 0x004b, 0x0056, Qt::Key_Left),         // Numpad4+Left
    USB_KEYMAP(0x07005d, 0x004c, 0x0054, 0x004c, 0x0057, Qt::Key_5),            // Numpad5
    USB_KEYMAP(0x07005e, 0x004d, 0x0055, 0x004d, 0x0058, Qt::Key_Right),        // Numpad6+Right
    USB_KEYMAP(0x07005f, 0x0047, 0x004f, 0x0047, 0x0059, Qt::Key_Home),         // Numpad7+Home
    USB_KEYMAP(0x070060, 0x0048, 0x0050, 0x0048, 0x005b, Qt::Key_Up),           // Numpad8+Up
    USB_KEYMAP(0x070061, 0x0049, 0x0051, 0x0049, 0x005c, Qt::Key_PageUp),       // Numpad9+PageUp
    USB_KEYMAP(0x070062, 0x0052, 0x005a, 0x0052, 0x0052, Qt::Key_Insert),       // Numpad0+Insert
    USB_KEYMAP(0x070063, 0x0053, 0x005b, 0x0053, 0x0041, Qt::Key_Delete),       // Keypad_. Delete
    USB_KEYMAP(0x070064, 0x0056, 0x005e, 0x0056, 0x000a, Qt::Key_unknown),      // IntlBackslash
    USB_KEYMAP(0x070065, 0x007f, 0x0087, 0x015d, 0x006e, Qt::Key_unknown),      // ContextMenu
    USB_KEYMAP(0x070066, 0x0074, 0x007c, 0x015e, 0xffff, Qt::Key_unknown),      // Power
    USB_KEYMAP(0x070067, 0x0075, 0x007d, 0x0059, 0x0051, Qt::Key_Equal),        // NumpadEqual
    USB_KEYMAP(0x070068, 0x00b7, 0x00bf, 0x0064, 0x0069, Qt::Key_F13),          // F13
    USB_KEYMAP(0x070069, 0x00b8, 0x00c0, 0x0065, 0x006b, Qt::Key_F14),          // F14
    USB_KEYMAP(0x07006a, 0x00b9, 0x00c1, 0x0066, 0x0071, Qt::Key_F15),          // F15
    USB_KEYMAP(0x07006b, 0x00ba, 0x00c2, 0x0067, 0x006a, Qt::Key_F16),          // F16
    USB_KEYMAP(0x07006c, 0x00bb, 0x00c3, 0x0068, 0x0040, Qt::Key_F17),          // F17
    USB_KEYMAP(0x07006d, 0x00bc, 0x00c4, 0x0069, 0x004f, Qt::Key_F18),          // F18
    USB_KEYMAP(0x07006e, 0x00bd, 0x00c5, 0x006a, 0x0050, Qt::Key_F19),          // F19
    USB_KEYMAP(0x07006f, 0x00be, 0x00c6, 0x006b, 0x005a, Qt::Key_F20),          // F20
    USB_KEYMAP(0x070070, 0x00bf, 0x00c7, 0x006c, 0xffff, Qt::Key_F21),          // F21
    USB_KEYMAP(0x070071, 0x00c0, 0x00c8, 0x006d, 0xffff, Qt::Key_F22),          // F22
    USB_KEYMAP(0x070072, 0x00c1, 0x00c9, 0x006e, 0xffff, Qt::Key_F23),          // F23
    USB_KEYMAP(0x070073, 0x00c2, 0x00ca, 0x0076, 0xffff, Qt::Key_F24),          // F24
    USB_KEYMAP(0x070074, 0x0086, 0x008e, 0x0000, 0xffff, Qt::Key_unknown),      // Execute
    USB_KEYMAP(0x070075, 0x008a, 0x0092, 0x013b, 0xffff, Qt::Key_Help),         // Help
    USB_KEYMAP(0x070077, 0x0084, 0x008c, 0x0000, 0xffff, Qt::Key_Select),       // Select
    USB_KEYMAP(0x070079, 0x0081, 0x0089, 0x0000, 0xffff, Qt::Key_unknown),      // Again
    USB_KEYMAP(0x07007a, 0x0083, 0x008b, 0x0108, 0xffff, Qt::Key_Undo),         // Undo
    USB_KEYMAP(0x07007b, 0x0089, 0x0091, 0x0117, 0xffff, Qt::Key_Cut),          // Cut
    USB_KEYMAP(0x07007c, 0x0085, 0x008d, 0x0118, 0xffff, Qt::Key_Copy),         // Copy
    USB_KEYMAP(0x07007d, 0x0087, 0x008f, 0x010a, 0xffff, Qt::Key_Paste),        // Paste
    USB_KEYMAP(0x07007e, 0x0088, 0x0090, 0x0000, 0xffff, Qt::Key_Find),         // Find
    USB_KEYMAP(0x07007f, 0x0071, 0x0079, 0x0120, 0x004a, Qt::Key_VolumeMute),   // VolumeMute
    USB_KEYMAP(0x070080, 0x0073, 0x007b, 0x0130, 0x0048, Qt::Key_VolumeUp),     // VolumeUp
    USB_KEYMAP(0x070081, 0x0072, 0x007a, 0x012e, 0x0049, Qt::Key_VolumeDown),   // VolumeDown
    USB_KEYMAP(0x070085, 0x0079, 0x0081, 0x007e, 0x005f, Qt::Key_Comma),        // NumpadComma
    USB_KEYMAP(0x070087, 0x0059, 0x0061, 0x0073, 0x005e, Qt::Key_unknown),      // IntlRo
    USB_KEYMAP(0x070088, 0x005d, 0x0065, 0x0070, 0x0068, Qt::Key_unknown),      // KanaMode
    USB_KEYMAP(0x070089, 0x007c, 0x0084, 0x007d, 0x005d, Qt::Key_unknown),      // IntlYen
    USB_KEYMAP(0x07008a, 0x005c, 0x0064, 0x0079, 0xffff, Qt::Key_unknown),      // Convert
    USB_KEYMAP(0x07008b, 0x005e, 0x0066, 0x007b, 0xffff, Qt::Key_unknown),      // NonConvert
    USB_KEYMAP(0x070090, 0x007a, 0x0082, 0x0072, 0xffff, Qt::Key_unknown),      // Lang1
    USB_KEYMAP(0x070091, 0x007b, 0x0083, 0x0071, 0xffff, Qt::Key_unknown),      // Lang2
    USB_KEYMAP(0x070092, 0x005a, 0x0062, 0x0078, 0xffff, Qt::Key_unknown),      // Lang3
    USB_KEYMAP(0x070093, 0x005b, 0x0063, 0x0077, 0xffff, Qt::Key_unknown),      // Lang4
    USB_KEYMAP(0x070094, 0x0055, 0x005d, 0x0000, 0xffff, Qt::Key_unknown),      // Lang5
    USB_KEYMAP(0x0700b6, 0x00b3, 0x00bb, 0x0000, 0xffff, Qt::Key_BracketLeft),  // Keypad_(
    USB_KEYMAP(0x0700b7, 0x00b4, 0x00bc, 0x0000, 0xffff, Qt::Key_BracketRight), // Keypad_)
    USB_KEYMAP(0x0700d7, 0x0076, 0x007e, 0x0000, 0xffff, Qt::Key_unknown),      // +/-
    USB_KEYMAP(0x0700e0, 0x001d, 0x0025, 0x001d, 0x003b, Qt::Key_Control),      // ControlLeft
    USB_KEYMAP(0x0700e1, 0x002a, 0x0032, 0x002a, 0x0038, Qt::Key_Shift),        // ShiftLeft
    USB_KEYMAP(0x0700e2, 0x0038, 0x0040, 0x0038, 0x003a, Qt::Key_Alt),          // AltLeft
    USB_KEYMAP(0x0700e3, 0x007d, 0x0085, 0x015b, 0x0037, Qt::Key_Meta),         // MetaLeft
    USB_KEYMAP(0x0700e4, 0x0061, 0x0069, 0x011d, 0x003e, Qt::Key_Control),      // ControlRight
    USB_KEYMAP(0x0700e5, 0x0036, 0x003e, 0x0036, 0x003c, Qt::Key_Shift),        // ShiftRight
    USB_KEYMAP(0x0700e6, 0x0064, 0x006c, 0x0138, 0x003d, Qt::Key_Alt),          // AltRight
    USB_KEYMAP(0x0700e7, 0x007e, 0x0086, 0x015c, 0x0036, Qt::Key_Meta),         // MetaRight
    USB_KEYMAP(0x0c0060, 0x0166, 0x016e, 0x0000, 0xffff, Qt::Key_unknown),      // Info
    USB_KEYMAP(0x0c0061, 0x0172, 0x017a, 0x0000, 0xffff, Qt::Key_unknown),      // ClosedCaptionToggle
    USB_KEYMAP(0x0c006f, 0x00e1, 0x00e9, 0x0000, 0xffff, Qt::Key_unknown),      // BrightnessUp
    USB_KEYMAP(0x0c0070, 0x00e0, 0x00e8, 0x0000, 0xffff, Qt::Key_unknown),      // BrightnessDown
    USB_KEYMAP(0x0c0072, 0x01af, 0x01b7, 0x0000, 0xffff, Qt::Key_unknown),      // BrightnessToggle
    USB_KEYMAP(0x0c0073, 0x0250, 0x0258, 0x0000, 0xffff, Qt::Key_unknown),      // BrightnessMinimum
    USB_KEYMAP(0x0c0074, 0x0251, 0x0259, 0x0000, 0xffff, Qt::Key_unknown),      // BrightnessMaximum
    USB_KEYMAP(0x0c0075, 0x00f4, 0x00fc, 0x0000, 0xffff, Qt::Key_unknown),      // BrightnessAuto
    USB_KEYMAP(0x0c0083, 0x0195, 0x019d, 0x0000, 0xffff, Qt::Key_unknown),      // MediaLast
    USB_KEYMAP(0x0c008c, 0x00a9, 0x00b1, 0x0000, 0xffff, Qt::Key_unknown),      // LaunchPhone
    USB_KEYMAP(0x0c008d, 0x016a, 0x0172, 0x0000, 0xffff, Qt::Key_unknown),      // ProgramGuide
    USB_KEYMAP(0x0c0094, 0x00ae, 0x00b6, 0x0000, 0xffff, Qt::Key_unknown),      // Exit
    USB_KEYMAP(0x0c009c, 0x019a, 0x01a2, 0x0000, 0xffff, Qt::Key_unknown),      // ChannelUp
    USB_KEYMAP(0x0c009d, 0x019b, 0x01a3, 0x0000, 0xffff, Qt::Key_unknown),      // ChannelDown
    USB_KEYMAP(0x0c00b0, 0x00cf, 0x00d7, 0x0000, 0xffff, Qt::Key_MediaPlay),    // MediaPlay
    USB_KEYMAP(0x0c00b2, 0x00a7, 0x00af, 0x0000, 0xffff, Qt::Key_MediaRecord),  // Media Record
    USB_KEYMAP(0x0c00b3, 0x00d0, 0x00d8, 0x0000, 0xffff, Qt::Key_unknown),      // MediaFastForward
    USB_KEYMAP(0x0c00b4, 0x00a8, 0x00b0, 0x0000, 0xffff, Qt::Key_unknown),      // MediaRewind
    USB_KEYMAP(0x0c00b5, 0x00a3, 0x00ab, 0x0119, 0xffff, Qt::Key_unknown),      // MediaTrackNext
    USB_KEYMAP(0x0c00b6, 0x00a5, 0x00ad, 0x0110, 0xffff, Qt::Key_unknown),      // MediaTrackPrevious
    USB_KEYMAP(0x0c00b7, 0x00a6, 0x00ae, 0x0124, 0xffff, Qt::Key_MediaStop),    // MediaStop
    USB_KEYMAP(0x0c00b8, 0x00a1, 0x00a9, 0x012c, 0xffff, Qt::Key_unknown),      // Eject
    USB_KEYMAP(0x0c00cd, 0x00a4, 0x00ac, 0x0122, 0xffff, Qt::Key_unknown),      // MediaPlayPause
    USB_KEYMAP(0x0c00cf, 0x0246, 0x024e, 0x0000, 0xffff, Qt::Key_unknown),      // SpeechInputToggle
    USB_KEYMAP(0x0c00e5, 0x00d1, 0x00d9, 0x0000, 0xffff, Qt::Key_unknown),      // BassBoost
    USB_KEYMAP(0x0c0183, 0x00ab, 0x00b3, 0x016d, 0xffff, Qt::Key_unknown),      // MediaSelect
    USB_KEYMAP(0x0c0184, 0x01a5, 0x01ad, 0x0000, 0xffff, Qt::Key_unknown),      // Launch Word Processor
    USB_KEYMAP(0x0c0186, 0x01a7, 0x01af, 0x0000, 0xffff, Qt::Key_unknown),      // Launch Spreadsheet
    USB_KEYMAP(0x0c018a, 0x009b, 0x00a3, 0x016c, 0xffff, Qt::Key_unknown),      // AL_EmailReader
    USB_KEYMAP(0x0c018d, 0x01ad, 0x01b5, 0x0000, 0xffff, Qt::Key_unknown),      // AL Contacts/Address Book
    USB_KEYMAP(0x0c018e, 0x018d, 0x0195, 0x0000, 0xffff, Qt::Key_unknown),      // AL Calendar/Schedule
    USB_KEYMAP(0x0c0192, 0x008c, 0x0094, 0x0121, 0xffff, Qt::Key_unknown),      // AL_Calculator
    USB_KEYMAP(0x0c0194, 0x0090, 0x0098, 0x016b, 0xffff, Qt::Key_unknown),      // AL_LocalMachineBrowser
    USB_KEYMAP(0x0c0196, 0x0096, 0x009e, 0x0000, 0xffff, Qt::Key_unknown),      // Launch Internet Browser
    USB_KEYMAP(0x0c019C, 0x01b1, 0x01b9, 0x0000, 0xffff, Qt::Key_unknown),      // Log Off
    USB_KEYMAP(0x0c019e, 0x0098, 0x00a0, 0x0000, 0xffff, Qt::Key_unknown),      // AL Terminal Lock/Screensaver
    USB_KEYMAP(0x0c019f, 0x0243, 0x024b, 0x0000, 0xffff, Qt::Key_unknown),      // AL Control Panel
    USB_KEYMAP(0x0c01a2, 0x0244, 0x024c, 0x0000, 0xffff, Qt::Key_unknown),      // AL Select Task/Application
    USB_KEYMAP(0x0c01a7, 0x00eb, 0x00f3, 0x0000, 0xffff, Qt::Key_unknown),      // AL_Documents
    USB_KEYMAP(0x0c01ab, 0x01b0, 0x01b8, 0x0000, 0xffff, Qt::Key_unknown),      // Spell Check
    USB_KEYMAP(0x0c01ae, 0x0176, 0x017e, 0x0000, 0xffff, Qt::Key_unknown),      // AL Keyboard Layout
    USB_KEYMAP(0x0c01b1, 0x0245, 0x024d, 0x0000, 0xffff, Qt::Key_unknown),      // AL Screen Saver
    USB_KEYMAP(0x0c01b7, 0x0188, 0x0190, 0x0000, 0xffff, Qt::Key_unknown),      // AL Audio Browser
    USB_KEYMAP(0x0c0201, 0x00b5, 0x00bd, 0x0000, 0xffff, Qt::Key_unknown),      // AC New
    USB_KEYMAP(0x0c0203, 0x00ce, 0x00d6, 0x0000, 0xffff, Qt::Key_unknown),      // AC Close
    USB_KEYMAP(0x0c0207, 0x00ea, 0x00f2, 0x0000, 0xffff, Qt::Key_unknown),      // AC Save
    USB_KEYMAP(0x0c0208, 0x00d2, 0x00da, 0x0000, 0xffff, Qt::Key_unknown),      // AC Print
    USB_KEYMAP(0x0c0221, 0x00d9, 0x00e1, 0x0165, 0xffff, Qt::Key_unknown),      // AC_Search
    USB_KEYMAP(0x0c0223, 0x00ac, 0x00b4, 0x0132, 0xffff, Qt::Key_unknown),      // AC_Home
    USB_KEYMAP(0x0c0224, 0x009e, 0x00a6, 0x016a, 0xffff, Qt::Key_unknown),      // AC_Back
    USB_KEYMAP(0x0c0225, 0x009f, 0x00a7, 0x0169, 0xffff, Qt::Key_unknown),      // AC_Forward
    USB_KEYMAP(0x0c0226, 0x0080, 0x0088, 0x0168, 0xffff, Qt::Key_unknown),      // AC_Stop
    USB_KEYMAP(0x0c0227, 0x00ad, 0x00b5, 0x0167, 0xffff, Qt::Key_unknown),      // AC_Refresh (Reload)
    USB_KEYMAP(0x0c022a, 0x009c, 0x00a4, 0x0166, 0xffff, Qt::Key_unknown),      // AC_Bookmarks (Favorites)
    USB_KEYMAP(0x0c022d, 0x01a2, 0x01aa, 0x0000, 0xffff, Qt::Key_unknown),      // ZoomIn
    USB_KEYMAP(0x0c022e, 0x01a3, 0x01ab, 0x0000, 0xffff, Qt::Key_unknown),      // ZoomOut
    USB_KEYMAP(0x0c0279, 0x00b6, 0x00be, 0x0000, 0xffff, Qt::Key_unknown),      // AC Redo/Repeat
    USB_KEYMAP(0x0c0289, 0x00e8, 0x00f0, 0x0000, 0xffff, Qt::Key_unknown),      // AC_Reply (MailReply)
    USB_KEYMAP(0x0c028b, 0x00e9, 0x00f1, 0x0000, 0xffff, Qt::Key_unknown),      // AC_ForwardMsg (MailForward)
    USB_KEYMAP(0x0c028c, 0x00e7, 0x00ef, 0x0000, 0xffff, Qt::Key_unknown),      // AC_Send (MailSend)
};
