//
// Aspia Project
// Copyright (C) 2016-2024 Dmitry Chapyshev <dmitry@aspia.ru>
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <https://www.gnu.org/licenses/>.
//

#ifndef CLIENT_UI_FILE_TRANSFER_FILE_ITEM_DELEGATE_H
#define CLIENT_UI_FILE_TRANSFER_FILE_ITEM_DELEGATE_H

#include "base/macros_magic.h"

#include <QStyledItemDelegate>

namespace client {

class FileItemDelegate final : public QStyledItemDelegate
{
    Q_OBJECT

public:
    explicit FileItemDelegate(QObject* parent);

    // QStyledItemDelegate implementation.
    QWidget* createEditor(QWidget* parent,
                          const QStyleOptionViewItem& option,
                          const QModelIndex& index) const final;
    void setEditorData(QWidget* editor, const QModelIndex& index) const final;
    void setModelData(QWidget* editor,
                      QAbstractItemModel* model,
                      const QModelIndex& index) const final;
    void updateEditorGeometry(QWidget* editor,
                              const QStyleOptionViewItem& option,
                              const QModelIndex& index) const final;

signals:
    void sig_editFinished();

private:
    DISALLOW_COPY_AND_ASSIGN(FileItemDelegate);
};

} // namespace client

#endif // CLIENT_UI_FILE_TRANSFER_FILE_ITEM_DELEGATE_H
