package acme.twitter.controller;

import acme.twitter.dao.exception.AccountNotExistsException;
import acme.twitter.domain.Account;
import acme.twitter.domain.Tweet;
import acme.twitter.dto.TweetDto;
import acme.twitter.service.AccountService;
import acme.twitter.service.TweetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.*;

import java.security.Principal;
import java.util.List;

/**
 * Tweet controller.
 */
@RestController
@RequestMapping("/api/tweet")
public class TweetController {
    private final TweetService tweetService;
    private final AccountService accountService;

    @Autowired
    public TweetController(TweetService tweetService, AccountService accountService) {
        this.tweetService = tweetService;
        this.accountService = accountService;
    }

    @GetMapping("/tweets/{username}")
    public List<TweetDto> getTweets(@PathVariable String username) throws AccountNotExistsException {
        Account account = accountService.findByUsername(username);
        List<Tweet> tweets = tweetService.findByAccount(account);

        return TweetDto.convertToDto(tweets);
    }

    @PostMapping("/tweets")
    @ResponseStatus(HttpStatus.OK)
    public void addTweet(@RequestBody String text, Principal principal) {
        tweetService.add(principal.getName(), text);
    }

    @GetMapping("/timeline")
    public List<TweetDto> getTimeline(Principal principal) throws AccountNotExistsException {
        Account account = accountService.findByUsername(principal.getName());
        List<Tweet> tweets = tweetService.findTimelineByAccount(account);

        return TweetDto.convertToDto(tweets);
    }
}
