namespace CmsEngine.Core.Utils;

public static class GravatarUtilities
{
    /// <summary>
    /// Generates an MD5 hash of the given string
    /// </summary>
    /// <remarks>Source: http://msdn.microsoft.com/en-us/library/system.security.cryptography.md5.aspx </remarks>
    public static string GetMd5Hash(string input)
    {

        // Convert the input string to a byte array and compute the hash.
        var data = MD5.Create().ComputeHash(Encoding.UTF8.GetBytes(input));

        // Create a new Stringbuilder to collect the bytes
        // and create a string.
        var sBuilder = new StringBuilder();

        // Loop through each byte of the hashed data
        // and format each one as a hexadecimal string.
        for (var i = 0; i < data.Length; i++)
        {
            sBuilder.Append(data[i].ToString("x2"));
        }

        // Return the hexadecimal string.
        return sBuilder.ToString();
    }
}
