# VectorSearch.Tech

![Vector Search](/docs/img/logo.png)

Welcome to the **Vector Search Technologies** repository! This project hosts the code and content for a website dedicated to exploring the world of vector search technologies. Whether you're new to vector databases or an expert seeking in-depth insights, this website provides blogs, tutorials, and guides to support developers, data scientists, and researchers working with vector search solutions. 

## 🌐 Website Overview

The website is a comprehensive resource on vector search technologies, featuring:  
- **Blog Posts**: Thought-provoking articles on trends, innovations, and best practices in the field.  
- **Tutorials**: Hands-on tutorials to help you build and optimize vector search applications.  
- **Guides**: Step-by-step instructions for solving real-world challenges using vector search databases.

## ✨ About the Author

This website is owned and maintained by **David Myriel**, the current **Director of Developer Relations at Qdrant**. With years of experience in developer relations and a passion for advancing AI and search technologies, David aims to foster a community of learners and innovators through this platform.

## 📂 Repository Structure

```
/docs
   /blog       # Blog posts (Markdown files)
   /tutorials  # Tutorials and sample code
   /guides     # Comprehensive guides on vector search
/assets        # Static assets (images, CSS, JS)
/mkdocs.yml    # MkDocs configuration file
```

## 🚀 How to Run Locally with MkDocs Material

To run the website locally using **MkDocs Material**, follow these steps:

1. **Clone the repository**:
   ```bash
   git clone https://github.com/davidmyriel/vectorsearch.git
   cd vector-search-website
   ```

2. **Install MkDocs and dependencies**:
   ```bash
   pip install mkdocs-material
   ```

3. **Serve the site locally**:
   ```bash
   mkdocs serve
   ```

4. **View the website**:  
   Open [http://localhost:8000](http://localhost:8000) in your browser.

## 📝 Contributing

Contributions are welcome! If you'd like to contribute to this project, please follow these steps:

1. Fork the repository.
2. Create a new branch (`git checkout -b feature/your-feature-name`).
3. Commit your changes (`git commit -m 'Add feature'`).
4. Push the branch (`git push origin feature/your-feature-name`).
5. Open a pull request.

## 📄 License

This project is licensed under the **MIT License**. See the [LICENSE](./LICENSE) file for more details.

## 📧 Contact

For any inquiries, feel free to reach out to David Myriel at:  
- **LinkedIn**: [David Myriel](https://linkedin.com/in/davidmyriel)  
