# encoding: UTF-8
# This file is auto-generated from the current state of the database. Instead
# of editing this file, please use the migrations feature of Active Record to
# incrementally modify your database, and then regenerate this schema definition.
#
# Note that this schema.rb definition is the authoritative source for your
# database schema. If you need to create the application database on another
# system, you should be using db:schema:load, not running all the migrations
# from scratch. The latter is a flawed and unsustainable approach (the more migrations
# you'll amass, the slower it'll run and the greater likelihood for issues).
#
# It's strongly recommended that you check this file into your version control system.

ActiveRecord::Schema.define(version: 20150522144628) do

  create_table "extras", force: :cascade do |t|
    t.integer  "user_id",           limit: 4
    t.string   "profile_image_url", limit: 255
    t.integer  "followers_count",   limit: 4
    t.integer  "favourites_count",  limit: 4
    t.datetime "created_at",                    null: false
    t.datetime "updated_at",                    null: false
  end

  add_index "extras", ["user_id"], name: "index_extras_on_user_id", using: :btree

  create_table "followers", force: :cascade do |t|
    t.integer  "user_id",           limit: 4
    t.string   "uid",               limit: 255
    t.string   "username",          limit: 255
    t.string   "name",              limit: 255
    t.string   "description",       limit: 255
    t.string   "profile_image_url", limit: 255
    t.datetime "created_at",                                    null: false
    t.datetime "updated_at",                                    null: false
    t.boolean  "updated",           limit: 1,   default: false
  end

  add_index "followers", ["user_id", "uid"], name: "index_followers_on_user_id_and_uid", unique: true, using: :btree
  add_index "followers", ["user_id"], name: "index_followers_on_user_id", using: :btree

  create_table "identities", force: :cascade do |t|
    t.integer  "user_id",    limit: 4
    t.string   "provider",   limit: 255
    t.string   "uid",        limit: 255
    t.datetime "created_at",             null: false
    t.datetime "updated_at",             null: false
  end

  add_index "identities", ["user_id"], name: "index_identities_on_user_id", using: :btree

  create_table "unfollowers", force: :cascade do |t|
    t.integer  "user_id",           limit: 4
    t.string   "uid",               limit: 255
    t.string   "username",          limit: 255
    t.string   "name",              limit: 255
    t.string   "description",       limit: 255
    t.string   "profile_image_url", limit: 255
    t.datetime "created_at",                                    null: false
    t.datetime "updated_at",                                    null: false
    t.boolean  "updated",           limit: 1,   default: false
  end

  add_index "unfollowers", ["user_id", "uid"], name: "index_unfollowers_on_user_id_and_uid", unique: true, using: :btree
  add_index "unfollowers", ["user_id"], name: "index_unfollowers_on_user_id", using: :btree

  create_table "users", force: :cascade do |t|
    t.string   "email",                  limit: 255,   default: "", null: false
    t.string   "encrypted_password",     limit: 255,   default: "", null: false
    t.string   "reset_password_token",   limit: 255
    t.datetime "reset_password_sent_at"
    t.datetime "remember_created_at"
    t.integer  "sign_in_count",          limit: 4,     default: 0, null: false
    t.datetime "current_sign_in_at"
    t.datetime "last_sign_in_at"
    t.string   "current_sign_in_ip",     limit: 255
    t.string   "last_sign_in_ip",        limit: 255
    t.string   "confirmation_token",     limit: 255
    t.datetime "confirmed_at"
    t.datetime "confirmation_sent_at"
    t.string   "unconfirmed_email",      limit: 255
    t.datetime "created_at"
    t.datetime "updated_at"
    t.string   "name",                   limit: 255
    t.string   "username",               limit: 255
    t.string   "access_token",           limit: 255
    t.string   "access_token_secret",    limit: 255
    t.string   "slug",                   limit: 255
    t.text     "description",            limit: 65535
    t.boolean  "notification",           limit: 1,     default: true
  end

  add_index "users", ["email"], name: "index_users_on_email", unique: true, using: :btree
  add_index "users", ["reset_password_token"], name: "index_users_on_reset_password_token", unique: true, using: :btree
  add_index "users", ["slug"], name: "index_users_on_slug", unique: true, using: :btree

  add_foreign_key "extras", "users"
  add_foreign_key "followers", "users"
  add_foreign_key "identities", "users"
  add_foreign_key "unfollowers", "users"
end