# Contributing to Nuxt 3 DocuSearch AI

First off, thank you for considering contributing to Nuxt 3 DocuSearch AI. We value all the people who want to
contribute to this project. Following these guidelines helps to communicate that you respect the time of the developers
managing and developing this open source project.

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for Nuxt 3 DocuSearch AI. Following these guidelines helps
maintainers understand your report, reproduce the behavior, and find related reports.

- Use a clear and descriptive title for the issue to identify the problem.
- Describe the exact steps which reproduce the problem in as many details as possible.
- Provide specific examples to demonstrate the steps.

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for Nuxt 3 DocuSearch AI, including completely new
features and minor improvements to existing functionality. Following these guidelines helps maintainers understand your
suggestion and make a decision.

- Use a clear and descriptive title for the issue to identify the suggestion.
- Provide a step-by-step description of the suggested enhancement in as many details as possible.
- Explain why this enhancement would be useful to most Nuxt 3 DocuSearch AI users.

### Pull Requests

- Fill in the required template.
- Do not include issue numbers in the PR title.
- Include screenshots and animated GIFs in your pull request whenever possible.
- Ensure your changes do not break any existing functionality.

## Coding Standards

The codebase is built with TypeScript and Nuxt 3 (Vue 3). Please adhere to the standards and styles used in the existing
code, and ensure your contributions are formatted with Prettier.

## Tests

As we are still in the early stages of the project, we don't have a test suite yet. However, please make sure your
contributions do not break any existing functionality.

## Conduct

We expect everyone to follow our [Code of Conduct](CODE_OF_CONDUCT.md). Please make sure to read it before
participating.

## Questions?

If you have any questions or anything is unclear, please reach out via a GitHub issue. We appreciate your contribution
and are glad to clarify any confusion.
