When reporting bugs keep in mind that the people working on it do this unpaid,
in their free time and as a hobby. So be polite and helpful. Reports that
demand, contain insults to this or other projects, or have a general unfriendly
tone will be closed without discussion. Everybody has it own way of working;
What might be the norm for you, might not be for others. Therefore be verbose in
your description.

**The issue tracker is for bugs only.**

This is an attempt to keep the issue tracker clean and searchable.

Questions or discussions about new features belong on
[GITHUB Discussions](https://github.com/davatorium/rofi/discussions) or
[FORUM](https://reddit.com/r/qtools/),
[IRC](https://webchat.freenode.net/?channels=#rofi), frequently asked questions
will be added to the [F.A.Q](https://github.com/DaveDavenport/rofi/wiki#faq) on
the [wiki](https://github.com/DaveDavenport/rofi/wiki).

Questions filled in on the bug tracker will be marked `question`, locked and
closed.

It is preferred to have feature requests discussed via
[GITHUB Discussions](https://github.com/davatorium/rofi/discussions) or
[FORUM](https://reddit.com/r/qtools/) or
[IRC](https://webchat.freenode.net/?channels=#rofi) first.

# Creating a bug report

Please write your bug reports in clear English.

Before creating a bug report:

* Update to the latest version. Check if problem still exists.
* Check existing bug reports, see if it is already reported.
* Read the documentation. Make sure the behaviour you are seeing is a bug.

When reporting bugs include the following information:

* Rofi version. rofi -v
* Rofi configuration. rofi -help (in a [gist](https://gist.github.com/))
* Steps to reproduce.
* What behaviour you see.
* What behaviour you expect to see.
* A proper title for others to search for.
* Be exact.

When adding comments to an issue make sure:

* It is relevant to the issue.
* It contributes to solving the issue.
* Use :+1: :-1: emojis instead of replying 'me too' or 'I also have this.'
* Do **NOT** ask for an update. Asking does not contribute to solving the issue
  and just annoys people with a notification. The answer is already available;
  if there is an update it will be linked/mentioned in the issue, otherwise
  there is no update.


Issue high-jacking, e.g. adding a request/issue to an existing issue, is very
disruptive.
Please create a new issue, if it is similar it will be marked duplicate.

# Creating a feature request


Before creating a feature request:

* First check the *next* branch, to see if the feature has already been
  implemented.
* Check existing reports, see if it is already requested.

When reporting a feature request include the following information:

* Rofi version. (rofi -v)
* A clear description of the feature you want added.
* A use-case for the feature.

If possible try to explain how you would expect to use feature.
For example, should it be a configuration option or a hot-key.

Requesting a feature is no guarantee it will be added.

**Please do not submit reports related to wayland, see
[here](https://github.com/DaveDavenport/rofi/wiki/Wayland) for more
information.**
