---
title: How to quickly create a sandbox website
date: 2023-07-27
authors: ['Lauren Wigmore', 'Ola Rubaj']
filetype: 'blog'
---

By the end of this guide you will have a working markdown site you can edit, which gets published automatically online 🎉

## Prerequisites

- A GitHub account. If you don’t have one, click [here](https://github.com/signup) to create it.
- A Vercel account. If you don't have one, click [here](https://vercel.com/signup) to create it. Ideally, sign up using your Github account or you can choose to sign up with your email.

## Sandbox setup

1. Go to https://github.com/datopian/flowershow
2. At the bottom of the page there is a "Deploy" button - click on this to be redirected to Vercel and log in using your account.
3. Once you have logged in, you will be redirected to the "Create GitHub Repository" page.
4. If you've signed up to Vercel with your GitHub account, you'll see "Git scope" and the field for the repo name. But if you've signed up using email, you'll see different buttons, like "GitHub", "Bitbucket", "GitLab". You need to select GitHub and possibly login to your GitHub account.
5. Select your GitHub account from the "Git Scope" drop-down. If it's not there, click on "Add GitHub Account" to add it.
6. In the right-hand box write a name for the repository. The usual format is all lowercase with hyphens in between words. Then click on the "Create" button.

The website will then be deployed. This takes approximately 1 minute.

Once you are on the Congratulations screen, click on the preview of your sandbox website to see the live/published version.

For instructions on how to add and edit pages, we recommend these howtos:

- [[howtos/add-a-simple-md-page|How to add a simple markdown page]]
- [[howtos/edit-text-on-a-single-md-page|How to edit text on a single markdown-based page]]
- [[howtos/edit-or-add-md-pages-locally|How to edit or add a markdown page locally on your computer]]
