---
title: How to format a perfect Markdown-based page
date: 2023-07-27
authors: ['Lauren Wigmore', 'Ola Rubaj']
filetype: 'blog'
isDraft: true
---

Welcome to this information guide to help you understand how to format the perfect Markdown-based page for your website. The information here is designed to give you an overview.

## Types of Markdown Styles

There are three types of Markdown options that are supported by Flowershow.

- CommonMark
- GitHub Flavored Markdown (GFM) - a superset of CommonMark
- Obsidian Flavored Markdown - a superset of CommonMark with most GFM functionalities plus its own syntax elements, such as wikilinks, callouts, LaTeX, mermaid diagrams, and more.

Each one has extra functionalities building on top of the previous Markdown option.

Flowershow aims to be fully Obsidian compatible since it supports most Obsidian Flavored Markdown syntax elements and therefore, it is the best to use as an editor.

## Useful Links

It would be too complicated (and long) to explain all of the formatting aspects here, so we have included the links below to provide you with this information and more!
[Flowershow Documents Page](https://flowershow.app/docs/syntax) - Use this page to see all of the useful key elements that are frequently required on Flowershow pages.
[Obsidian help pages](https://help.obsidian.md/Editing+and+formatting/Obsidian+Flavored+Markdown) - Use this to get more information on Obsidian's supported syntax
[GFM cheatsheet](https://github.com/adam-p/markdown-here/wiki/Markdown-Cheatsheet) - Use this as a quick guide to using Markdown for Github

## Other useful pages

[How to quickly add a simple Markdown-based page](https://guide.portaljs.org/guides/add-a-simple-md-page)
[How to quickly edit text content on a single Markdown-based page](https://guide.portaljs.org/guides/edit-text-on-a-single-md-page)
