---
title: How to add images to a Markdown-based page
date: 2023-07-27
authors: ['Jake Hirsch', 'Ola Rubaj']
filetype: 'blog'
---

## Intro

Here, you will learn how to add images to a Markdown-based page. These instructions show how to add these images locally, on your computer, so first you need to know how to work locally with GitHub Desktop app and Obsidian. If you're new to these tools, we recommend reading this howto first:

- [[blog/edit-or-add-md-pages-locally|How to edit or add Markdown pages locally]]

Or you can follow these two tutorials to start from scratch:

- [[create-a-website-from-scratch|Tutorial 1: Create a Markdown based website from scratch]]
- [[edit-a-website-locally|Tutorial 2: Edit your website locally on your computer]]

## Prerequisites

- A GitHub account
- A GitHub Desktop app
- Obsidian

## Steps

### Step 1: Set the assets folder as an attachment folder

In Obsidian, in the root of your vault, create a new folder called 'assets'. Then, right click on and select "set as attachment folder". By doing so, all the images you paste into your note will automatically be saved to this folder (instead of being saved to the root, next to all your notes). This is necessary for your website to display embedded images.

### Step 2: Copy and paste your image

Copy whichever image you would like to add and paste it directly into your Obsidian note. You can check that it has been saved to the "assets" folder.

### Step 3: Commit and push

To learn more about this step, see the howto or the tutorials listed in the intro section.

## Summary

Congratulations, you've now learned how to add an image to your Markdown page!

If anything is not clear to you, or you have suggestions on how we can make this 'How to' better, please don't hesitate to let us know.

Happy editing!
