---
title: Working Group on Open Expenditure Data
---

## Working Group on Open Spending Data

### Purpose

* Act as a central point of reference and support for people who are interested in open spending data.
* Develop principles for making official and unofficial information about spending legally and technically open
* Document background and status of initiatives to make official information open in different countries
* Support efforts to make spending data discoverable and channels and methods for collaboration around it.
* Work closely with the [Working Group on Open Data in Economics](http://wiki.okfn.org/Working_Groups/Economics) to help contextualise spending and budget data for the purposes of analysis and research.

### Possible activities (to be reviewed)

* Contributing to / providing feedback on  a Spending Data Manual - A wiki-like, community driven manual on acquiring, working with, publishing and archiving spending data, (building on and referencing other works e.g. World Bank's work on budget classifications)
* Keeping their eye-out for new and interesting initiatives springing up around spending and budget data and invite new members to join the discussion
* Help to build up a registry of spending datasets by adding to the [OpenSpending group on the DataHub](http://thedatahub.org/group/openspending)
* Writing blog updates on new developments e.g. new datasets becoming available, updates to laws in your country affecting spending data, new tools to work with, share and collaborate on data
* Considering possibilities for a Spending Data Camp, most likely at or around OGDCamp 2012 with hands-on sessions on licensing, working with and publishing data, aimed at CSOs from around the world.
* ERDF collection.

### Members

* **Alexandre Ciconello**, [INESC](http://www.inesc.org.br/news), *Brazil*
* **Avani Kapur**, [Accountability Initiative](http://www.accountabilityindia.in/), *India*
* **Codru Vrabie**, [Bribemarket](http://www.piatadespaga.ro/), *Romania*
* **Damir Mehmedbasic**, [Public Interest Advocacy Centre](http://cpi.ba/), *Bosnia and Herzegovina*
* **David Cabo**, Pro Bono Publico, *Spain*
* **Diego de la Mora**, [Fundar](http://fundar.org.mx/index.html/), *Mexico*
* **Dr Effie Vraniali**,[Fondafip](http://www.fondafip.org) and Member of Transparency International *Greece*
* **Elena Calistru**, [Lost Money](http://banipierduti.cloudapp.net/), *Romania*
* **Eva Vozarova**, [Fair-Play Alliance](http://www.fair-play.sk/index.php),  *Slovakia*
* **Federico Ramírez**, [Fundar](http://fundar.org.mx/index.html/), *Mexico*
* **Friedrich Lindenberg**, [Open Knowledge Foundation](http://okfn.org/), *Germany*
* **Hille Hinsberg**, [Praxis Policy Centre](http://www.praxis.ee/index.php?id=96&L=1), *Estonia*
* **Kaitlin Lee**, [Sunlight Foundation](http://sunlightfoundation.com/), *USA*
* **Laina Emmanuel**, [Accountability Initiative](http://www.accountabilityindia.in/), *India*
* **Lucy Chambers**, [Open Knowledge Foundation](http://okfn.org/), *United Kingdom*
* **Mark Brough**, Research Officer, [Publish What You Fund](http://www.publishwhatyoufund.org/), *United Kingdom*
* **Martin Keegan**, [Open Knowledge Foundation](http://okfn.org/), *United Kingdom*
* **Maurice Nsabimana**, [World Bank](http://www.worldbank.org/)
* **Michael Roberts**, Co-founder, [Acclar](http://acclar.org/)
* **Michal Skop**, [KohoVolit.eu](http://en.kohovolit.eu/), *Czech Republic*
* **Oluseun Onigbinde**, [BudgIT](http://yourbudgit.com/), *Nigeria*
* **Photios Zygoulis**, e-gov Coordinator, [Municipality of Neo Iraklio Attikis](http://www.iraklio.gr), *Greece*
* **Sam Lee**, [World Bank Finances](https://finances.worldbank.org/), *USA*
* **Sam Smith**, Organiser of [OpenTech](http://www.ukuug.org/events/opentech2011/), *United Kingdom*

### CSOs

* [Participatory Budgeting Unit](http://participatorybudgeting.org.uk/), UK

### Contact

* There is a [mailing list](http://lists.okfn.org/mailman/listinfo/openspending) where anyone can subscribe. Mailing list archives are public.
* Twitter: [@openspending](http://twitter.com/openspending)
* Twitter list of organisations who work with spending data: [Spending Orgs List](https://twitter.com/#!/openspending/lists)
