---
title: "Other handy datasets"
---

# Other handy datasets

In our conclusions section, we highlighted the main types of data which are in demand (budgets, transaction-level spending, procurement...). We have kept the demands in the conclusion short for clarity's sake, however there are lots of other datasets which are essential for many organisations to be able to combine with the key data:

<ul>
	<li><strong>Information on targets or outputs</strong>, these should be clearly mappable to the project or programme area to which they relate in order to be able to answer questions such as “What is the delivery rate?” or “Did that injection of funds/stimulus package result in better performance?”. These are not always produced by governments, but frequently in demand.</li>
	<li><strong>Geographic information</strong>, should be available at reasonable granular levels. Governments often transfer grants and other payments to geographically identified areas, eg. as part of redistribution schemes. Providing access to such regionalised accounts can be crucial in order to enable CSOs to assess equality and distribution of budgetary priorities. Note that regional data does often provide too little granularity to expose local inequality.</li>
</ul>

Two cases exemplify to what extent including geographic information can be helpful for different missions:

> “What we would like to be able to do is pull out ward-level data [...] or very very micro-level data, neighbourhood level, most of the data which is released [in the UK] is Local Authority Level, and that’s just too big for us.” - <strong> Jez Hall of the Participatory Budgeting Unit (UK) </strong>

Additionally, in the [case study](../../case-studies-budgets/cbga/) from the <strong>Centre for Budget and Governance Accountability (India)</strong>, a lot of questions the group strove to answer could be answered simply by ensuring that the data contained information on, which state received the funds (this is pretty high level information, but still was unavailable.

<ul>
	<li><strong>Information on demographics:</strong> Most policy researchers want to be able to answer questions more specific than per-capita estimates. This makes data such as "Household Surveys" particularly important. They might ask questions such as:
		<ul>
			<li>“How many users of a particular service are there?”</li>
			<li>“How many households benefit from a particular policy?” </li>
			<li>“Of those households, how many are living below the poverty line?”</li>
			<li>“What is the income bracket of those people?” </li>
			<li>“How many young people/women/people with a disability/ people of a specific ethnicity/[...] benefit from a particular policy/programme?”</li>
			<li>“How much does a particular school place cost in different boroughs or regions?”</li>
		</ul>
	<li><strong>Information on the actual goods purchased as part of government funded work.</strong> The majority of questions related to state purchasing require details on the quantity, price and frequency of purchases. (e.g. journalists will often want to know "how many computers?" were purchased, or even "how many computers were published for X amount of money?", rather than "how much was spent on computers?") By way of illustration of the types of analysis groups need to be able to do, see a recent open data success story: <a href="http://www.bj-hc.co.uk/bjhc-news/news-detail.html?news=2327&lang=en&feed=130">Open Data probe shows NHS statin bill twice what it should be</a>. As an example the US Medicare programme published a database on prices charged by various hospitals for thousands of the most regular treatments.</li>
	<li><strong>Economic & Macroeconomic projections</strong> are becoming increasingly more important as national fiscal policies are measured against models from international organisations eg. the EU deficit thresholds. For both EU member states and EU Neighbor Countries economic reviews by the EU Commission can have substantial impacts locally on policy. The public accessibility of macroeconomic governance models has until now not had a prominent place in the debate around these often contested models. However it is clear that the public should be able to scrutinise conditions and calculations for such models.</li>
	<li><strong>Structured information on the planned pattern of cuts</strong> that could be tied to e.g. particular programmes / geographical area</li>
	<li><strong>Data showing how much governments / political candidates spend on media advertising</strong> (both through taxpayer funds and from campaign contributions).</li>
</ul>

This list is clearly not comprehensive, we list here only frequently recurring requests from users.

## Country-specific requests

Some countries have formulated their own detailed requests for information and reviews of currently available information, either as part of a public consultation, research or spontaneously:

* [Romania](https://docs.google.com/spreadsheet/ccc?key=0Anbfx9yMO3c8dGptNHF5aGhjdXdRN2U5aVlEMUJiMmc#gid=0) (In Romanian)
* [India](http://www.accountabilityindia.in/accountabilityblog/2241-dating-data-what-are-characteristics-dream-government-data)
* [Hungary](http://kmonitor.hu/files/page/OGP_ajanlasok_KM_TASZ.pdf) (In Hungarian)

See also the [user testimonials](http://community.openspending.org/research/gift/testimonials/) from the earlier report: “Technology for Transparent and Accountable Public Finance.”