
---
title: "Case Study: Open University"
---

# Budget transparency for an open university
Summary based on blog post by J. Félix Ontañón at OpenKratio

About the project:
The project began by scraping budget documents in PDF format published by the University of Grenade to a machine-readable format with the purpose of making it easier for citizens, journalists and even employees at the university to work with the data, using tools from spreadsheets to visualization suites. The resulting app allow users to download the income and expenditure budgets in CSV format and provides a set of comprehensive visualizations.

The idea emerged under the International Open Data Day, a gathering of citizens in cities around the world to write applications, using open public data to show support for and encourage the adoption open data policies by the world's local, regional and national governments. The OKFN's local Spanish chapter did a call for participants and the Free Software Office at the University of Grenade accepted the challenge.

The set of tools used for the project included:
CometDocs (online pdf 2 excel converter)
Open Refine (data cleaning) 
DataHub (data hosting)
OpenSpending API & D3.js (visualizations)

The importance on University budget transparency 
The Spanish Public Universites are almost solely funded by several Public Administration Offices. With the University of Grenade as an example, the amount of income coming from Public Payments (including college tuition) only raise up to 11% of the total. As a result of the spanish economic crisis some college tuition rates rose, having a deep impact on the 
pocket of those on the verge of being able to pay their studies.

By releasing University budgeting data the project:
Highlight the reality of the resources available at the university
Help identify potential best practices in savings that could be used by other universities
Help citizens to make smart proposals on why-and-where the public should invest in higher education.

<iframe width='700' height='400' src='http://openspending.org/upo-income-budget/embed?widget=treemap&state=%7B%22drilldown%22%3A%22articulo%22%2C%22year%22%3A%222012%22%2C%22cuts%22%3A%7B%7D%2C%22drilldowns%22%3A%5B%22articulo%22%5D%7D&width=700&height=400' frameborder='0'></iframe>

Spanish public universities are equipped with system called SIIU (Integrated University 
Information System) and they are required to report budget data using this
system. Thus in reality most of the technical challenges around developing budgets in electronic and harmonized formats has already been completed. The question is therefore why the Ministry of Education will not make this information available to the public.
