---
title: "Bani pierduti? (Lost Money)"
---

# Lost Money

</strong>This is a profile of a very interesting new project coming out of Romania, aiming to make government finances understandable for the average citizen. It is written based on contributions from <a href="https://twitter.com/MadamadePica" target="_blank">Elena Calistru</a>, who kicked off the project.</strong>

## Vital Statistics

<div class="well">

<ul><li><strong>Name of Project:</strong> Bani pierduti? (Or, in English, "Lost money?")</li>
<li><strong>Link to project: <a href="http://www.banipierduti.ro" target="_blank">banipierduti.ro</a></strong></li>
<li><strong>Approximate number of users engaged through the project:</strong> over 30,000</li>
</ul>

</div>

<img alt="" src="http://farm9.staticflickr.com/8289/7607848026_21cbeef8ed_b.jpg" title="Lost Money" class="alignnone" width="640" height="480" />

## What is the background of the project?

The project is one of the five winners of the <a href="http://restartromania.netsquared.org" target="_blank">Restart Romania 2011</a> competition, initiated by <a href="http://www.techsoup.ro/" target="_blank">Techsoup Romania</a> with the support of the US Embassy to Bucharest.

Starting at the beginning of August 2011, 104 projects were registered for the Social Justice Challenge Restart Romania and went under the scrutiny of the community. In the end, a jury formed by representatives of the diplomatic community, business sector, and IT industry decided the selection of 10 finalist projects. Between 28 - 30 October, the Restart Romania Hackathon transformed the ten ideas with the help of programmers and communication specialists into more concrete platforms which were presented within the Restart Romania Gala. Bani Pierduti was voted within the Gala as one of the five winners of 5000 USD funding.

## What are the aims?

The project formerly known as *"Where’s my LEI, man?"* entered the competition aiming to centralize publicly available financial information regarding the projects financed through public money (budgets, annual reports, etc.). The main objective was make authorities accountable in the manner in which public funds are spent.

After winning the Restart Romania Gala, the project went through a re-thinking aiming to identify both the best technologies for a more complex platform than initially planned and the necessary datasets which would allow the best representation of how public funds are spent in Romania. If at the very beginning the project only aimed at using state budget data, it now operates with data comprising the budgets dedicated to social assistance and public health, the budgets at local level for the Romanian counties, projects financed through EU funds, comparisons with the percentage allocated to various sectors in other EU counties, and more.

The project is a now a permanent programme of a newly-established NGO, <a href="http://www.funkycitizens.org/" target="_blank">Funky Citizens</a> (website under construction at time of publication), which aims to engage civil society (taxpayers) in the decision-making processes related to public funds through the use of technology. Its major objectives are:

* Improving the number of people who are aware of this issue and improving the quality of public understanding
* Offering information and tools for influencing the decision-making process

To achieve its objectives, the project relies on three pillars:

* Data & process presentation
* Public participation
* Understanding the bigger picture

## How does the platform tackle the issues you outlined?

The three pillars of the platform respond to the following problems:

### Problem #1: Fiscal policies represent a mystery for the majority of citizens

<p> <strong>Consequences:</strong> Lack of information and understanding of the process; scarce public oversight of public funds administration; public spending is associated with corruption and distrust</p>

<p> <strong>How we respond:</strong> Educate citizens on the topic</p>

### Problem #2: Little or no participation of the community in fiscal policy

<p> <strong>Consequences:</strong> Limited use of existing tools for participation to the decision-making process; needs of the community not reflected in the resource allocation; no feedback to the policy makers on their decisions</p>

<p> <strong>How we respond:</strong> Facilitate direct participation</p>

### Problem #3: Lack of vision from governments on investment / development priorities

<p> <strong>Consequences:</strong> Short-term planning leading to limited predictability and accountability; bad administration, mismanagement, or corruption in public spending; incoherence between the fiscal policy and other public policies</p>

<p> <strong>How we respond:</strong> Analyse and understand data</p>

<img src="http://farm9.staticflickr.com/8432/7787652558_79191020ee_o.png" title="Lost Money 2" class="alignnone" />

## What is the role of technology in the approach to solving that problem?

The role of technology is an important one, since the web-based platform is the main feature of the project. So far, transparency in fiscal policy can be achieved only through complicated documents published on the websites of the authorities or through FOIA requests. Also, there were previously no e-participatory budgeting experiences, the only means of organizing public debates on budgetary issues being offline events.

## What are the successes of this project?

The project is still very young and in its early stages. However, the evaluation of its outcomes already shows several approaches which proved successful:

* A consultation process with relevant governmental stakeholders prior to the launch of the project proved to be a good approach in ensuring a supportive or at least a not contentious interaction with the authorities, given the sensitivity of the subject.
* The gradual implementation and launch of the features of the platform seems like a successful strategy to educate citizens on a difficult subject while creating interest in and awareness of the topic.
* The engagement of different categories of supporters of the project (from young dynamic professionals to the diplomatic community) ensured greater visibility for the initiative and is expected to further enlarge the community of advocates for more transparency in fiscal matters.

## Are there areas where the project failed? What are the challenges?

The main challenges to the project are mostly related to two major issues encountered by such initiatives:

* The absence of an open data approach in the release of official information related to public spending makes the implementation of the project slower as well as resource-consuming.
* A general perception that public money are lost due to corruption makes people less inclined to look closer at the entire policy cycle and thus the efforts to educate or to engage them harder.

<img alt="" src="http://farm9.staticflickr.com/8289/7787652740_dae031a763_o.png" title="Lost Money 3" class="alignnone" width="640" height="480" />

## Have you had particular problems with the data?

Romania has just joined the Open Government Partnership, and the implementation of the open data format for governmental data sets is expected to take at least a few years. The various data formats present on the websites of authorities, or even their absence in several cases, made data collection a rather difficult process.

## Are you actively seeking the involvement of the user groups?

The project also foresees that an entire pillar of the platform (“public participation”) will actively seek the involvement of the user groups. The implementation of this service started with two features (large investment projects timelines and legislative early warnings) which seek an interaction with the public, and future plans propose to increase the amount of citizen participation. For example, there are plans to do this by:

* encouraging direct feedback into laws already in draft stages, allowing users to cut, add to, and restructure proposed bills on the basis of desired budgetary outcomes
* building a simulator for the central budget, allowing people to visualise and explore the effect of different revenue and expenditure policies (e.g. raising taxes)
* promoting public participation in the annual budget cycle through a calendar of debates on budgets as well as pilot offline events with webcasts

The most consistent involvement features are expected to be implemented by the end of 2012 – early 2013, as a second stage in the development of the project.

## What are the plans for the future?

The project was planned as a continuously growing platform, and its scaling or additional features were taken into consideration from the very beginning. A mobile feature is expected to be implemented into the web platform in 2013, a plan which also involves the use of social audits for public contracts.
