---
title: "Expert Grup"
---

# Expert Grup

<div class="well">Project: <a href="http://www.budgetstories.md/">Budgetstories, Moldova.</a></div>

In mid 2012, Expert Grup began to work to make sense of huge budget
datasets. In November 2012, while finalizing the project concept,
members of the organising team took part in the [Balkan Budget
Workshop](http://openspending.org/blog/2012/11/26/Sarajevo-Workshop-Writeup.html) organised by the OpenSpending team.

> “It was really helpful to learn about data formats. It is the equivalent
> of a data literacy 101 class.” - <strong> Victoria Vlad </strong>

![BudgetStoriesImg](http://www.budgetstories.md/wp-content/uploads/cit-ne-costa-parlamentul.jpg)

## About the team 

The core BudgetStories.md team at Expert Grup
consists of three core staff members: the project director, one project
communication and analytical expert, and one additional analytic expert
as support. The implementation was made with an external web design
company who executed the website based on input from the team. The web
company had a total of five people working on BudgetStories.md: two
designers, two developers, and one project manager.

Expert Grup has introduced several projects using open budget and
spending data. The main challenges they've encountered have related to
accessing data, cleaning the data (using Excel), and managing the data
visualisation work, which was done by an an external web agency.

Most of the needed data was available to the public on
[data.gov.md](http://data.gov.md/) and in the World Bank's [BOOST data
tool](http://www.mf.gov.md/ro/BOOST/), and government agencies were open
to providing direct requests for data requested in a timely manner. The
data was analysed with Excel. During the research, Expert Grup used the
<a href="http://community.openspending.org/resources/handbook/">Spending Data Handbook</a>, the <a href="http://opendatahandbook.org/">Open Data Handbook</a> and the <a href="http://datajournalismhandbook.org/">Data Journalism
Handbook</a> as resources.

## Technical challenges

### Presenting the data 
> “It is still a challenge for us to make visualizations meaningful. We plan to improve with every infographic we
> publish.” 

Expert Grup is planning to work more on developing their
presentations of their data. Most of their visualisations have been
developed by a web agency based on the directions from Expert Grup. One
exception is the visualisation of the [Moldova
budget](http://www.budgetstories.md/bugetul-2013/), which was created with
OpenSpending treemaps by Expert Grup.

In the future Expert Grup wil be looking to expand their work.

> “There is still a lot of work to be done. We have until now published three data
> visualizations.”

So far their portfolio includes excellent examples like these:

*  The [Budget
    calendar](http://www.budgetstories.md/anul-bugetar-2013/), which enables
    citizens to track and learn about the budget approval process for
    2012 - 2014 as an interactive module, including the documents which
    need to be published at each stage of the budget process.
*  An OpenSpending budget treemap, added in order to provide a meaningful
    visualization of the [annual
    proposal](http://www.budgetstories.md/afla-cat-ne-a-costat-parlamentul-in-2012/)
*  A visualisation of the [agricultural subsidy
    program](http://www.budgetstories.md/subventiile-pentru-agricultura-in-2012-pentru-ce-cui-si-unde-au-fost-alocate/).

## Community challenges

<strong>Engaging CSOs in spending data:</strong> According to Expert Grup civil society
(NGOs, journalists, and universities) has until now shown little
knowledge of or interest in the existence of open data. The goal has
therefore been to engage with and educate journalists and policymakers.
The main site was launched in February and gave journalists access to cleaned data sets and visualisations for the first time
journalists, as well as
encouraging their republishing and reuse in the public. The aim would be
to gain increased public attention to inefficiencies identified in
government spending and establish connections to more stakeholders. The
results of the outreach are still being assessed.

Source: [Guest blog post on
OpenSpending](http://community.openspending.org/2013/02/budgetstories-md-using-open-budget-data-to-create-meaningful-stories/).

