---
title: "Case Studies: Budgets"
---

# Case Studies - Budgets

![Budget data](http://i.imgur.com/QEghdYv.png)

The word "budget" can refer to different things in different circles, but for the purposes of this report we adopt a technical definition: a budget is a planning document that provides the details of a spending policy, typically breaking the policy down by aggregated categories rather than individual planned transactions.

Across communities and across the globe, there is a push for making budgets accessible in a timely and granular form. Groups have sprung up all over creating meaningful ways to explore and explain to citizens what's really in their budgets. Some groups pioneer detailed budget calendars enabling citizens to follow the budgeting process, while other groups challenge governments by tracking budget codes and how funds actually shift form year to year.

This section explores some of the diversity of groups using budget data as well as their common concerns and demands. It asks what these CSOs hope to achieve by drawing on budget data and what technological and political obstacles they encounter in doing so.

Several different kinds of work are covered in this section, including completed budget data projects ([Lost Money](./lost-money/), [OpenBudgetOakland](./openbudgetoakland/)), ongoing work by policy researchers and advocates ([Centre for Budget and Governance Accountability, India](./cbga/)), and the results of workshops building up to future projects ([Budzeti.ba](./bosnia/), [Expert Grup](./expert-grup/)).

* [Lost Money](./lost-money/)
* [OpenBudgetOakland](./openbudgetoakland/)
* [Centre for Budget and Governance Accountability, India](./cbga/)
* [Budzeti.ba](./bosnia/)
* [Expert Grup](./expert-grup/)


