---
title: "Centre for Public Interest Advocacy"
---

<div class="well">After meeting the team from the Public Interest Advocacy Centre (CPI) at
the POINT conference in Sarajevo in 2012, a proposal was launched to
start the Budzeti.ba project (<a href="http://budzeti.ba/">beta version</a>). In November 2012, the project had a kick-off workshop to get
the ball rolling and cover some of the key data-wrangling issues faced
by CSOs wanting to create a budget monitoring site. </div>

![CPI Bosnia](http://farm9.staticflickr.com/8063/8219557569_cc12ebbdea_z.jpg)

This workshop happened shortly after the [Spending Data Handbook](http://community.openspending.org/research/handbook/) sprint and was a great opportunity to do a test run on the material.

## What we covered

Some of the topics we covered were:

*  An introduction to [DataWrapper](http://datawrapper.de/) for making simple charts and web visualisations
*  [Kartograph](http://kartograph.org/) for making elegant maps
* Scraping using [ScraperWiki](http://scraperwiki.com/)
*  Using Optical Character Recognition to get data out of PDFs
*  Cleaning data using [Google Refine](http://code.google.com/p/google-refine/)

Also present at this workshop were the team from [Expert Grup in Moldova](../expert-grup/), prior to the launch of their Budget Stories project.

## Status

The Budzeti.ba project is still in progress and is due for a full launch
in Autumn 2013. The aim of the project is to provide a one-stop shop for
budget information in a format which is accessible for citizens.

## Comprehensibility of budget data

The training in Bosnia was a trigger to build on the material in the Spending Data Handbook by developing some guidelines on how to make data published by governments more accessible for citizens. In practice, this is often a process of simplification and aggregating large datasets so as not to overwhelm the viewer. One of the key methodologies which was used to produce [Where Does My Money Go?](http://wheredoesmymoneygo.org) was to think carefully about how we aggregated the data and opting for functional classifications.

### Demanding data in functional classifications: why and what's difficult?

1.  Countries such as Bosnia [do not publish Citizen’s
    Budgets](http://survey.internationalbudget.org/#profile/BA) in the
    first place. This means that a functional classification has to come entirely
    from civil society, leading to worries from the CSO that the
    interpretation of the data may be contested.
2.  Some countries do not group their data by functional
    classifications. This is important, as the average citizen is more
    likely to want to know what money is spent on (i.e. what services
    they got in exchange for their tax money) than, for example, which
    government department is spending the money, which is all it is
    possible to infer from many budgets.
3.  For the purposes of visualisations such as OpenSpending's,
    organisations such as CPI must classify the complex information
    contained in budgets for themselves in a form which is accessible
    and yet not overwhelming for citizens. There are practical
    implications to this. Having more than 10 top-level
    items in a budget, for example, results in a very cramped visualisation, and there are only so many categories a person can take in at
    any one time. For visualisation purposes, the CPI team
    classified the data in a schema similar to the internationally
    recognised [Classifications of Functions of Government](http://unstats.un.org/unsd/cr/registry/regcst.asp?Cl=4), as was used
    in the UK project [Where Does My Money Go?](http://wheredoesmymoneygo.org/).

More information about the classification methodology they used can be
found in the blog post: [Bosnian Budgets - grouping data by categories people
care
about](http://community.openspending.org/2012/11/bosnian-budgets-grouping-data-by-categories-people-care-about/).
