---
title: "Case Study: Hasadna, Israel"
---

# Budget transparency in Israel
This summary is based on the full case study by Aviv Sharon and Adam Kariv from Hasadna (The Public Knowledge Workshop) published in this extensive guest post on their work on financial transparency in Israel.

Hasadna is a civil society organisation working on government transparency across fields with strong technological resources as well as a lively community. 

Notable tech projects on financial transparency include: 
- [Open Budget 1.0](http://open-budget.readthedocs.org/en/latest/) - launched 2011
- [Omuni budget](http://open-budget.readthedocs.org/en/latest/) - an [open budget project](http://en.open-budget.prjts.com/) launched May 2013
- Open 2.0 - to be launched May-June 2013 
- A project to [open up the Finance Committee](http://www.hasadna.org.il/en/our-projects/opening-the-finance-committee/) 

Fianlly Hasadna’s flagship project is the parliamentary app Open Knesset.

## Background on the Open Budget
The flow of money through Israel's coffers became a concern for the developers of "Open Budget" following a large forest fire on Mount Carmel in December 2010 , the deadliest and most widespread fire Israel had ever seen. After the fact, Israel's ministries of Finance and Interior blamed each other for having neglected the fire brigades. On the one hand, the Ministry of Interior claimed that its requests to increase the budget for the brigades were only partially funded by the Ministry of Finance, and very late at that. On the other hand, the Ministry of Finance claimed that it had passed along all the sums stipulated in the relevant governmental resolutions. The Ministry of Finance also added that these resolutions had even greatly increased the funds for aerial firefighting in 2010 compared with previous years.

## Open Budget 1.0
To clear up the argument, activists The Public Knowledge Workshop  asked Michael Eitan, then Minister of Improvement of Government Services, to help retrieve data they could use to put together a comprehensive picture of Israel's state budget. Unfortunately, the Israeli Ministry of Finance did just the bare minimum and released several files in various formats, such as Excel, PDF and html. The files were rife with human errors, like parts of the Hebrew text mistakenly written left-to-right.
First, the "Open Budget" developers at the Public Knowledge Workshop took the data and organized it in a uniform database. Secondly they built a web-based interface allowing any user to explore the budget. Eventually the database of the Public Knowledge Workshop reached a stage where this was the most accurate and comprehensive database of Israel's budget. Some ministries have even asked to export data from the Open Budget for them, because the state systems were much more cumbersome.
The first version of Open Budget 1.0  was launched in March 2011 and is still available on Israel's governmental services portal . It allows the public to track budget changes over time, search items for particular keywords and compare the budgeted amounts with the sums spent on each item.

## Open Budget 2.0
Following the first release, the "Open Budget"-developers realized that many of their basic assumptions for analyzing the data were wrong, and that several important features were missing in version 1.0:
While most high-level numbers usually kept similar meanings over time, the Ministry of Education (Item 20), for example, had changed responsibilities over time: Namely, it was in charge of sports and culture in some years, but not in others. This made it hard to track the education budget properly over time. 
Moreover, to track spending on issues such as for instance firefighting, one would need to put together the sums spent on various different items, paying attention to the differences between salaries, procurement and other items.
Last but not least, while the budget may contain all the data, one can't easily determine if the sums are too much, too little, or just right. Nor can that be determined objectively. This is a value judgment, and different people will analyze the budget in different, and sometimes contradicting, ways, and use different data to frame and support their arguments. What’s more, a good system would then allow experts and civic activists in Israel to publicly annotate budgetary items with their respective opinions, to enrich the budgetary debate with accessible, evidence-based arguments.

These needs have addressed in Open Budget 2.0, which is due for release from the Public Knowledge Workshop within the next few weeks. Namely, the next version of the system will allow users to:
- unify related budgetary items
- analyze them together
- compare spending between different items, or between budgetary items and other data sets, which can help put the budget in a larger context, and
- publicly annotate budgetary items.

## Looking Ahead
Predictably, one of the biggest roadblocks for progress on budgetary transparency comes from the government itself. Currently we are trying to make the most of the data, which have already been released, but the Ministry of Finance and other branches of government still hold a lot of data sets which they reject to share. Open Budget developers suspect that until they are forced to release them, it will stay that way. Some examples of data sets that have not yet been released are:
- state-provided evaluations of the effect of each budget item on the economy
- budgets on the ministerial level
- budgets of governmental agencies
- details of individual procurements, and
- much greater detail on outsourced activities.

Presumably as part of the changes made by the new Israeli Minister of Finance, Yair Lapid, the 2012 budget was made fully available  to the public on April 12, 2013. Amazingly, a representative of the Ministry personally contacted the Public Knowledge Workshop to verify that activists at the Workshop had seen the new release. Hopefully, this is a sign of more openness to come.

