---
lead: true
title: Introduction
authors:
- Neil Ashton
---
The unprecedented quantities of information on public finances now becoming available present an opportunity to create stronger and more participatory democracies, to campaign more effectively for social justice, and to hold power to account.

In this report, we look at how citizens, journalists, and civil society organisations around the world are using data on government finances to further their civic missions. From visualisations of the Romanian budget to analyses of procurements in Ghana, we look at how civil society groups are using data on public finances, what tools they are using, and what their needs are in this area.

When this work started in early 2012, our aim was threefold:

* *To identify Civil Society organisations (CSOs) around the world who are interested in working with government financial data*, building on the existing network of contacts from the [OpenSpending.org](http://openspending.org) project

* *To connect these CSOs with each other*, with open data communities, and with other key stakeholders to exchange knowledge, experiences, and best practices in relation to spending data

* *To discover how CSOs currently work with spending data, how they would like to use it, and what they would like to achieve*, including:

  * What existing tools are being used
  * What current technical needs are unmet
  * What would be required to meet these needs and how feasible is it to tackle them

This report is the output of that research. It brings together key case studies from organisations who have done pioneering work in using technology to work with public finance data.

We have kept this report short and readable in order to make it accessible to the broadest possible audience. We believe that there are some very quick ways to make the work that CSOs do a lot easier, more thorough, and more sustainable. In this report we therefore:

  * Examine some key case studies of how organisations are using technology to do groundbreaking research,  citizen engagement, and tracking of accountability
  * Outline how data could be improved in order to make it more usable
  * Discuss the training needs for CSOs to help them better use the data available and to demand better data

At the end of the report, you will find an [appendix](../appendix) which outlines key tools of use to those investigating or working with government financial information. We hope that this is a useful resource for those building training curriculae around financial data—and would welcome any feedback if there is anything we have missed.

The team behind the report can be reached at any time on *info [at] openspending.org*. We would like to thank the Open Society Foundations for their generous support for this project's research.

**Next**: [Athens to Berlin: Video Series](../introduction/videos/)

**Up**: [Mapping the Open Spending Data Community](../)
