---
lead: true
title: Open Knowledge Foundation Greece
authors:
- Neil Ashton
---
<div class="well">Project: Tracing financial reporting from the Cl@rity program.</div>
*This project review is based on the detailed review of Thodoris
Papadopoulos, Open Knowledge Foundation Greece, Local Group.*

Open Knowledge Foundation Greece is monitoring the financial reporting systems in
Greece during the financial crisis, resulting in detailed reviews of
the rapid legal and technical changes in the Greek financial
reporting system. This has ultimately lead to several proposals for technical changes to the reporting standards.

![Diavgeia](http://farm8.staticflickr.com/7140/7548263168_74dd2d423c_z.jpg)

## About the project

In Greece, the most important piece of legislation in recent years
regarding the transparency of government action is the [Cl@rity](http://diavgeia.gov.gr/) (Diavgeia)
program, which introduced the obligation to publish all the decisions of
government and all administrative entities on the Internet.
Cl@rity aims to generate maximum
accessibility of government policy and administrative actions. Since the
programme was launched in October 2010, almost 6 million administrative
decisions have been uploaded to the Cl@rity website, with a daily
average of 14,000 decisions.

With the Cl@rity program, the enforceability of any administrative act
presupposes a previous announcement on the Internet. Furthermore,
Cl@rity provides an open data API in XML and JSON formats through which
everyone can have structured access to all decisions, along with their
metadata, ensuring openness and further dissemination of public
information.

The Cl@rity initiative has already had a quiet but significant
effect on the way authorities handle their executive power. It leaves
considerably less room for corruption and exposes it much more easily
when it takes place, since any citizen or interested party can openly
access any questionable acts. This is a scheme of “collective scrutiny”
that can be effective, since it allows citizens directly involved or
concerned with an issue to scrutinize it in depth rather than leaving
it to the traditional media, whose choice of issues often is restricted
and oriented towards “safe” topics.

## Challenges

Although Cl@rity was not designed with financial monitoring in mind, it
includes various decision types that includes financial metadata
(such as expenditure, budget, and contract data). From the onset, however,
the Cl@rity programme has suffered from issues of poor data quality, including:

*  Failure to provide a hierarchy of entities
*  Lack of validation rules for metadata fields and non-mandatory
    requirements

In reality, these issues have prevented citizens and journalists from
utilizing the full potential of the Cl@rity program as a platform for
public financial data.

## Project results

Open Knowledge Foundation Greece highlights two major achievements from their data quality review and proposals:

1.  For the Cl@rity programme, substantial improvements have been
    implemented by the end of 2012. These corrections included changes
    of significant importance to journalists and CSOs, such as improving
    the quality of transactional spending data.
2.  For a supplementary information system to support the Cl@rity
    program, several suggestions brought forward by Open Knowledge Foundation Greece have been
    admitted to the data architecture. The new system will for this
    reason be more responsive and accurate and will provide a more detailed
    data model with many more metadata fields. The new system is
    expected to be delivered by the end of 2013. The owner of the system
    the [Greek Ministry of Administrative Reform and
    e-Governance](http://www.ydmed.gov.gr/) has undertaken to provide
    the source code of the system through the [European Open Source
    Observatory and
    Repository](http://joinup.ec.europa.eu/community/osor/description) under
    a [EUPL](http://joinup.ec.europa.eu/software/page/eupl) licence.

### Links about reuse of this data

*  A [short video]((https://vimeo.com/46543472)) about researchers at the National Technical University
    of Athens and Students of WebScience and active members of OKFN
    Greece from the University of Thessaloniki
*  PublicSpending.gr (currently unavailable due to maintenance), also
    documented in [this academic
    article](http://papers.ssrn.com/sol3/papers.cfm?abstract_id=2193600)
*  [http://greekspending.com/](http://greekspending.com/)

**Next**: [EU Spending Data](../eu-spending-data/)

**Up**: [Case Studies: Spending](../)
