---
lead: true
title: 'Case Studies: Spending'
authors:
- Neil Ashton
---
![Spending data](http://i.imgur.com/eXUlwMe.png)

In contrast to budget data, spending data reports on specific expenditures of funds, covering individual transactions that have actually taken place rather than categories of planned spending.

Our research has uncovered an interestingly contradictory state of affairs. In most countries, fine-grained transactional spending data is not easily available, and over the past few years, organisations and journalists in these countries have used FOI requests and otherwise created pressure for the release of such data. In a few countries, however, such spending data has been published—and it hasn't attracted much public attention!

In the following case studies, we examine how spending data can be used to strengthen community participation in public spending as well as to increase accountability on some of the biggest spending programmes in the EU. The cases also deal with the challenges of enhancing uptake of spending data among community members and journalists in the face of the data's often intimidating complexity and scale.

* [Caring for your neighbourhood](./caring-for-my-neighbourhood/)
* [OKFN Greece](./okfn-greece/)
* [EU Spending Data](./eu-spending-data/)
* [Farmsubsidy.org](./farmsubsidy/)
* [Farm subsidies in Mexico](./farm-subsidies-mexico/)
* [India Spend](./india-spend/)
* [Supervizor](./supervizor/)

**Next**: [CaseCaring for My Neighbourhood](./caring-for-my-neighbourhood/)

**Up**: [Mapping the Open Spending Data Community](../)
