---
lead: true
title: EU Spending Data
authors:
- Neil Ashton
---
<div class="well">This segment is based on a community call organised on 18 February
2013 with
additional input from <a href="https://twitter.com/ronpatz">Ronny Patz</a>,
Transparency International, Brussels Office.</div>
European spending programmes have been undergoing increased scrutiny
among journalists and CSOs in recent years. In this section, we will examine the
access to data from the EU structural funds as well as the EU Commission
spending through the Financial Transparency System (FTS) and discuss
what actors are involved in data-driven analysis and campaigning
around this data.

## Structural funds

Following the Common Agricultural Policy, which has been covered by
[Farmsubsidy.org](../farmsubsidy/), data from the structural funds have
been considered the most important spending data by both journalists and CSOs. In 2010, the Financial Times and the Bureau of
Investigative Journalism published a project including an extensive
database [mapping the structural
funds](http://datajournalismhandbook.org/1.0/en/case_studies_1.html) across
the 2007-2013 EU budget ([more info](http://blog.okfn.org/2011/03/08/a-kafkaesque-data-trail-the-hunt-for-europes-hidden-billions/)).
The project was rightly heralded as
groundbreaking for its level of detail and dedication and its cross-border
setup. Three years later, however, it is also clear that such centrally
initiated projects have limitations, and therefore challenges
remain when thinking about Europe-wide spending transparency.

### Data issues

The FT-TBIJ structural funds investigation exposed a series of barriers
which limit the use of structural funds for CSOs and journalists:

*  Poor data quality

*  Lack of access to data in machine-readable formats; in practise, data
    is often published as PDF, since no format for spending data has
    been specified in EU regulation

*  A dispersed model of distribution across regions in Europe from
    dozens of local sites without a centralised European clearinghouse

### Community challenges

We’ve identified a few important points, which should be noted from the
project:

*  **Media outlets are unlikely to build and sustain long-term data
    projects**. Though the project provided a unique insight into
    structural funds, it was not the intention of the publishers to
    develop a long-term model for tracing and publishing  structural
    fund payments. Though non-profit media institutions do offer a few
    [important exceptions](http://projects.propublica.org/docdollars/),
    we also know that maintaining databases is costly and is widely
    considered to provide too little value for ongoing beat journalism inside
    newsrooms.
*  **CSOs have not addressed systemic needs for data**. Despite receiving
    wide recognition from CSOs regarding the importance of the FT-TBIJ
    structural funds investigation, the European CSO community has
    remained unable to address the need for continuous data flows and
    analytical capacity. Several CSOs do, however, provide extensive
    coverage of European data across topics like FOI ([AccessInfo](http://www.access-info.org)),
    lobbyism ([Corporate Europe](http://corporateeurope.org), [Alter-EU](http://www.alter-eu.org)) and the green economy
    ([Bankwatch](http://bankwatch.org), [Friends of the Earth](http://foei.org)).
*  **Improvements in access to data seem still to be largely supply-driven**. There are national governmental initiatives addressing the
    lack of access to spending data such as [Open
    Coesione](http://www.opencoesione.gov.it/) from the Italian
    government (launched summer 2012), which publishes data on Italian
    structural funds from 450,000 development projects worth € 33.4
    billion. Project Lead [Luigi Reggi](http://luigireggi.eu) is
    regularly engaging with data journalists and the wider public
    through open data events and social media.

[Luigi Reggi](http://luigireggi.eu) has also mapped the accessibility of
EU structural funds data across the EU.

![EU structural funds](http://farm6.staticflickr.com/5444/8895739707_955cb8bcac_z.jpg)

<small>Rating of the accessibility of data
from the structural funds. Red: PDF only. Dark green: machine
readable. Source: [luigireggi.eu](http://luigireggi.eu)</small>

## Future perspectives

The data from the EU structural funds is an example where CSOs and media
outlets are still falling short of the potential of covering already-available spending data in individual countries as well as across
borders.

At this moment, there seems to be no clear political momentum within the
EU for requiring data from the structural funds to be published at a
central site (eg. on the European Data Portal).

New rules will, however, mandate publishing of structural fund data
according to certain dimensions or fields, which provides a small step in
the right direction ([page
157](http://eur-lex.europa.eu/LexUriServ/LexUriServ.do?uri=COM:2012:0496:FIN:EN:PDF))

## Financial Transparency System (FTS)

Spending reported under the FTS consists of both [EU Commission spending
and grant funding](http://community.openspending.org/research/eu/) provided to
programmes such as research, education, and foreign aid. This is likely the best documented part of the EU budget, though it is not transactional spending data, as it only provides project funding data
and not actual transactions from either EU agencies nor project recipients.

An increase in the minimum threshold is under consideration,
however, which would cause a decrease in access to a substantial amount of
payments.

**Next**: [FarmSubsidy.org](../farmsubsidy/)

**Up**: [Case Studies: Spending](../)
