---
lead: true
title: OpenSpending
authors:
- Neil Ashton
---
The availability of elegant and intuitive visualisations can drive government data release at a local level. OffenerHaushalt in Germany, for example, was launched with a small note on the page saying, “If you are a local government and you are interested in producing your own visualisation site such as this, please write to us.” To date, the OffenerHaushalt team have received 70-90 requests for similar sites in Germany at different levels of government, often from government officials themselves.

Being able to cater to these different levels of government and different bodies within government was one of the prime reasons for building OpenSpending: a solution was needed that could produce something like <a href="http://wheredoesmymoneygo.org">Where Does My Money Go?</a> in less than half a day, without which scaling down to the local level simply would not be feasible.

## Local uses of OpenSpending

Since its launch, OpenSpending has had a continuous flow of requests from stakeholders at local levels. By May 2013, more than 80 cities had been added to OpenSpending from citizens, local political parties, and local administration officials. A substantial number of connections have also been made to local budgeting initiatives using technology to enhance participation.

It is our impression that local spending has a strong potential for a few reasons:

* Local spending has a clear and direct impact on the average citizen's daily life, as it is at the local level that many services are delivered. This fact seems to invite a wide group of citizens and communities to engage with the process.
* Active citizens may know where to access data in their local community more easily than national data. They might even know who to speak to in the local council if the data is not available.

## Japan

The OpenSpending community in Japan has a largely city-based focus. Yokohama initiated a <a href="http://spending.jp/">local spending site</a>  in 2012 using the Daily Bread and budget visualisations. Since then, eleven additional cities have had their budgets visualised. At Open Data Day February 2013, the group expanded the initiative with another site for the <a href="http://chiba.spending.jp/">city of Chiba</a>, which received a visit as well as positive feedback from the mayor of Chiba.

The community is characterised by strong representation of both governance experts from academia and as programmers with the technical skills to implement complex budget sites.

Since February 2013, the community has grown across Japan and spurred the development of budget visualisations for twelve additional cities.  The community is now looking to explore more detailed budget data as well as transactional spending data. A plan for including transactional data from two prefectural governments is underway.

## Other uses of OpenSpending

We have seen a number of CSOs and citizens make use of OpenSpending to serve specific visualisation needs outside the realm of pure budget and spending transparency.

* <a href="http://www.fundacjafenomen.pl/">Fundacja Normalne Miasto Fenomen</a>, Poland, used OpenSpending to visualise data on transportation spending for the <a href="http://www.google.com/url?q=http%3A%2F%2Fopenspending.org%2Flodz_2013_transport_budget&sa=D&sntz=1&usg=AFQjCNGQheo8Wg1kQ7ztn27o2k7TqcsV8Q">city of  Łódź</a> in order to advance their environmental agenda.

* The Social liberal party (D66) of Rotterdam, The Netherlands, used budget data from the city of Rotterdam to help inform elected officials and decide on local priorities within the party. The purpose was, in the first place, to help the party decide on budget priorities and secondly to advocate to the city itself to adopt the practise of visualising the budget to its citizens in a meaningful way. A similar example was seen with the budget of Uruguay for 2012 from the Uruguayan Office of Planning and Budget.

* The search interface of OpenSpending was used by Privacy International <a href="http://community.openspending.org/2012/02/how-spending-stories-fact-checks-big-brother-the-wiretappers-ball/">to do research into which companies are selling surveillance equipment had contracts with governments around the world</a>.

* OpenSpending was used to visualise the <a href="http://community.openspending.org/2013/04/visualising-urban-development-data-at-un-habitat/">UN-Habitat data on Urban Development</a>.

* In collaboration with Publish What You Fund, OpenSpending was used to provide the <a href="http://publishwhatyoufund.org/uganda/#/~/aid-and-domestic-spending-in-uganda-br----usd-">first consolidated view of the budget of Uganda</a>, including income from aid flows, which form a substantial part of the revenue flows for Uganda. Even the government of Uganda had previously not had access to this information.

**Next**: [Budget transparency for an open university](../opening-university/)

**Up**: [Case Studies: From Local to Global](../)
