---
lead: true
title: OpenBudgetOakland
authors:
- Neil Ashton
---
<div class="well">Project: <a href="http://openbudgetoakland.org/">OpenBudgetOakland</a>, launched
April 2013.</div>
Open Budget Oakland is a group of civic hackers working on budget
issues. At the beginning of 2013, they initiated the idea
of launching a budget visualization site, with the goal to increase
participation from citizens and stimulate citizen debate around the
city budget. The platform should enable citizens to explore budget
nuances, to discuss the implications of policy decisions, and to ask informed questions, and it should
facilitate information flow from experts in the field to interested citizens.

In February 2013, Open Budget Oakland connected with OpenSpending in
order to plan the launch of [OpenBudgetOakland.org](http://openbudgetoakland.org/).
From February and up until April, the small team worked to complete the
app and launch it in time for the Mayor’s annual release of the budget
proposal for 2013-2015. The team succeeded launching the visualization
of the proposed budget on the day of its release. Shortly after the
launch, the project gained recognition from the City of Oakland as it was
offered to [present the project at city
hall](https://twitter.com/openbudgetOAK/status/329667951265472512/photo/1).

<iframe width='100%' height='400' src='http://openspending.org/oakland-adopted-budget-fy-2011-13-expenditures/embed?widget=treemap&state=%7B%22drilldowns%22%3A%5B%22department%22%2C%22unit%22%2C%22child-fund%22%5D%2C%22year%22%3A2012%2C%22cuts%22%3A%7B%7D%7D&width=700&height=400' frameborder='0'></iframe>

## Technological setup and challenges

The first budget of Oakland was accessed in July 2012 as a 350-page
PDF file, which was copy-pasted into a coherent spreadsheet and an
almost-interactive pie chart at a
[one-day](http://codeforoakland.org/meet-our-2012-winning-apps) hackathon.
The process led directly to this conclusion:
>“accessing Oakland city budget data isn’t easy, and even once you have data, it isn’t
> immediately clear how it can be shared in a way that helps people.”

The small volunteer team at Open Budget Oakland built the site within a
few months of 2013 based on OpenSpending technology, adding two new
distinct features. From March 2013, OpenOakland engaged several email
conversations on the OpenSpending mailing lists and received
contributions via GitHub from OpenSpending developers:

1.  a [Disqus](http://disqus.com/) commenting module, which enables
    users to discuss each spending item and thus improve participation
2.  a browsing feature for the OpenSpending histogram view, enabling
    easier navigation in OpenSpending
3.  [D3](http://d3js.org) for visualising income and expenditure in one
    chart [budget visualisation
    developed](http://www.peterkrantz.com/2012/data-visualization-tools/) developed
    by Peter Krantz, another OpenSpending community member

Open Budget Oakland has also considered the possibility of pursuing
transactional spending data, though this is not available at the moment
from the Oakland City Council.

## Community

The community is considered key for generating a budget discussion going
forward past the initial media coverage.

Open Budget Oakland is a part of Open Oakland, which has a volunteer
team of 21 members working across the entire open government agenda. The
group organises weekly meetups for volunteers and is supported by Code
for America.

Coverage: [TechPresident](http://techpresident.com/news/23749/oakland-gets-new-data-visualization-site-its-budget) and
[Oakland Local](http://oaklandlocal.com/article/open-oakland-opening-oakland%E2%80%99s-budget-community-voices) (community
blog).

**Next**: [Centre for Budget and Governance Accountability](../cbga/)

**Up**: [Case Studies: Budgets](../)
