---
lead: true
title: Centre for Budget and Governance Accountability
authors:
- Neil Ashton
---
<div class="well">Before a tech project even gets off the ground, it needs a good source of data. On our trip to India, the Centre for Budget and Governance Accountability clearly outlined the problems they have with the data released by governments.</div>
![CBGA India](http://farm9.staticflickr.com/8446/7794135644_572bf30d0e_z.jpg)

Centre for Budget and Governance Accountability (CBGA) is a policy research and advocacy organisation based in New Delhi, India. Its work promotes transparent, participatory, and accountable governance and a people-centred perspective in government budgets.

The main questions CBGA asks are about the priorities underlying budgets, the quality of government interventions in the social sector, the responsiveness of policies and budgets to disadvantaged sections of population (e.g. religious minorities, scheduled castes, women), the progressivity of the taxation policies, and some of the structural issues in India’s fiscal federalism.

They talked about some of the problems they had had in using the data on expenditure made available by the Union Government and State Governments in India. Here are a few of their most striking points.

* The data is very aggregated. There's no geographical breakdown of the data; for example, in the Union Budget, there is no disaggregation for statewise allocations or expenditures, and likewise in a State Budget, it's not possible to see how much is spent in a particular district.
* There are particular budgetary strategies and categories for public expenditure on disadvantaged groups (viz. the "scheduled caste subplan" and "tribal subplan"), but the reporting using these categories is not very reliable. It has been found that a lot of general expenditure is reported under these heads. Suppose, for example, the government has spent some money on construction of a hospital; even though it's not meant specifically for the scheduled castes, the government may apportion around 20% of the cost for the hospital under the scheduled caste subplan. In the absence of programmes or schemes designed specifically for scheduled castes or scheduled tribes, some of the state governments have been relying on such a superficial process of reporting expenditures under "scheduled caste sub plan" and "tribal sub plan".
* It is very difficult to get the complete picture of public spending in any particular sector. In many of the Union Government schemes (e.g. the National Rural Employment Guarantee Scheme, National Rural Health Mission, etc.), the Union Budget funds do not flow through the State Budgets or the State Government Treasury System; these funds are sent directly to autonomous bank accounts of implementing agencies. As a result, the State Budget documents of any State in India do not show the complete picture of government spending in that State.
* In some of the Union Government schemes where the Union Budget funds are routed outside the State Budgets, fund advances to implementing agencies get reported as expenditures, and there is no way we can ascertain whether the money has actually been spent or is lying parked in the bank account at some level.

As regards State Budget data, CBGA gets PDFs from the websites of the State Governments in about one third of States – with the rest, they have to procure hard copies from offices of the Finance Departments of the States.

A matrix of available budget data sources for India and comments about their usability has been compiled by the CBGA team and can be found [online](http://www.cbgaindia.org/sources_for_budget_data.htm).

<em>See the full list of organisations we visited on the India trip on the <a href="http://in.okfn.org/2012/09/18/okfn-india-trip-the-roundup/">OKFN-India blog</a></em>.

**Next**: [Centre for Public Interest Advocacy](../bosnia/)

**Up**: [Case Studies: Budgets](../)
