---
title: Follow the money - An exercise in tax evasion and avoidance
---

Tax evasion and tax avoidance are constantly in the news - but what are the difference between the two and how do you start investigating them as a journalist?

This resource was originally designed as an exercise in journalistic judgement run at the first [data expedition at Mozilla Festival](http://blog.okfn.org/2012/11/14/data-expeditions-at-mozfest/) and we'll continue to build on it as we do more and more investigations into the topics.

Read the explanations of the various options below and then try out the **challenges** at the bottom of the page to find them for yourself.

## Tax evasion or tax avoidance?

The first choice you, as a journalist, face in this tax investigation is to pursue **tax avoidance** (currently legal but this legality could be challenged) or **tax evasion** (illegal non payment of tax through non disclosure or non payment).

There is no correct answer to this exercise - it simply offers a number of routes to investigating tax - all routes have a dataset so the resulting story is really a reflection of the morality and motivations of the journalist rather than available resources.

* Go down the tax avoidance route if you are looking for people breaking the law. You now choose between corporate and personal income tax avoidance.
* Go down the evasion route if you are looking for people exploiting loopholes.

Here's the flow chart of options:

[![Data expedition](http://farm9.staticflickr.com/8184/8368409648_92d093db30.jpg)](http://www.flickr.com/photos/object-group/8368409648/sizes/n/in/photostream/)

## Route 1 - Tax Avoidance

### Income Tax: The K2 and EBT tax avoidance schemes

<em>The K2 and EBT schemes are relevant for those investigating income tax.</em>

These are aggressive tax avoidance strategies that relies on there being no taxation on loans, and creating a separate organisation based in a tax haven that can receive all the profits and then give an interest free loan that is designed so that it never has to be repaid to the tax avoider.

For example an individual avoids paying tax by becoming a contractor to a company in a tax haven, the individual earns a large salary but this is paid to their agency and the individual is only paid the minimum wage on which they pay tax at the rate for the country they live in, they are then given the rest of their earnings as an interest free loan from the agency which they don't pay tax on.

In this route there are two options, to look at a) a tax avoidance scheme that some celebrities have used or b) to look at a scheme that is used for highly paid employees in well known organisations.

a) The celebrity scheme is the **K2**. The [guidance](http://www.hmrc.gov.uk/manuals/eimanual/eim45000.htm") covering this is on the revenue and customs (HMRC) website.
b) The scheme that is used for highly paid employees in well known organisations is the **<a href="http://www.hmrc.gov.uk/news/ebt-news0812.htm">Employee Benefit Trust schemes</a>** in the UK until their use was strongly discouraged.

### Other investigations: Name and Shame

If these two investigations do not satisfy your desire for a scoop there is a third option where you aim to name the people using these schemes.

This involves putting together pieces of the tax avoidance picture.

We can get some sense of how frequently these schemes are used, or how much money is saved as some countries' tax collection forms require the tax avoided by individuals (or lost from the system) as some countries require taxpayers to describe their scheme - in the UK DOTAS does this and there are stats <a href="http://www.hmrc.gov.uk/avoidance/avoidance-disclosure-statistics.htm">here</a>.

An explantation of DOTAS is <a href="http://www.rossmartin.co.uk/index.php/penalties-a-compliance/403-disclosure-of-tax-avoidance-schemes-dotas">here</a>.

This narrows down which schemes are most used. Then we can figure out which tax havens are most likely to be used as the [OECD monitors havens](http://www.oecd.org/ctp/harmfultaxpractices/listofunco-operativetaxhavens.htm) and attempts to establish transparency in tax havens.

Once you get down to a country and a tax avoidance scheme we can start looking for agencies that are set up there.

There are groups who set up schemes and there are their customers and there are the people or companies who benefit.

### Corporations: Transfer pricing

If you select the tax avoidance for corporations option you will most likely be looking at transfer pricing. This is the strategy of having smaller companies within the same corporate empire. The smaller companies can be based in tax havens and each operate in a way that is maximally tax efficient to the empire overall. This is particularly common in online retail.

An online book retailer might have a company specifically for its book sales based in Luxembourg and so pays a Luxembourg VAT rate (only 3%), but the books are bought all over the world. Look for places with low local tax rates and then see which branches of firms are located there.

Alternatively if you are interested in ways that tax avoidance may be managed they are recommended to investigate the General Anti-Abuse Rule (GAAR) that is being developed at the moment [here](http://www.hm-treasury.gov.uk/tax_avoidance_gaar.htm). The rule aims to deter abusive tax avoidance by reducing legal uncertainty around what constitutes aggressive tax evasion and what constitutes legitimate tax planning.

## Route 2: Tax evasion

If your selection was tax evasion rather than tax avoidance then you can choose the severity of the evasion; ranging from shadow market to individuals evading tax and wanted by the tax authorities.

#### Shadow market

#### Naming tax evaders

The individuals considered to be evading tax and with a warrant issued by a UK court and that are being investigated by the UK tax authority are fully described on the [official HMRC account](http://www.flickr.com/photos/hmrcgovuk/sets/72157631087785530).

[![Tax Evaders](http://farm9.staticflickr.com/8545/8652943180_7dcb6a8c84_z.jpg
)](http://www.flickr.com/photos/hmrcgovuk/sets/72157631087785530)

## What now?

So, we've described the main routes for this little exercise in tax reporting. Below, we've suggested some possible challenges for you to investigate yourselves - please let us know via the [OpenSpending mailing list](http://lists.okfn.org/mailman/listinfo/openspending) if you have any success in uncovering avoidance or evasion via these routes!

### Challenges

1. Write a piece on how the K2 scheme works, who has been shown to use it and which organisations facilitate it.
2. Show the history of the EBT scheme, who used it and how did HMRC attempt to stop the use of EBT schemes.
3. Pick one of Starbucks, Amazon or Google who were recently accused of tax avoidance and take a look at the [written evidence](http://www.publications.parliament.uk/pa/cm201213/cmselect/cmpubacc/writev/716/contents.htm) for their taxable involvement in the UK. Use this a basis for an explanation of the company's specific tax avoidance mechanism.
4. Collate and compare different estimates of the size of the shadow market in a wide range of countries. The reports with estimates we suggest are from [the European Commission](http://ec.europa.eu/europe2020/pdf/themes/06_shadow_economy.pdf) and the [IMF](http://www.imf.org/external/pubs/ft/wp/2012/wp1247.pdf) but other sources should be added. You can explore the significants of the shadow market and measures to reduce its size.
5. Classify tax evaders published on the [official HMRC account](http://www.flickr.com/photos/hmrcgovuk/sets/72157631087785530)  for example as importing goods without paying UK tax and fraudulently claiming state benefits etc. Then to put these individual costs in the context of cost estimates for these crimes in the country as a whole. For example we can get overall cost of benefit fraud [here](http://research.dwp.gov.uk/asd/asd2/index.php?page=fraud_error) and the loss of funds through importing goods without paying tax from this [HMRC report on tax gaps](http://www.hmrc.gov.uk/research/direct-tax-gaps.pdf).
